/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.jooq.Configuration;
import org.jooq.ExecuteListener;
import org.jooq.Query;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractBatch;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.SettingsEnabledPreparedStatement;
import org.jooq.impl.Tools;

final class BatchMultiple
extends AbstractBatch {
    private static final long serialVersionUID = -7337667281292354043L;
    private final Query[] queries;

    public BatchMultiple(Configuration configuration, Query ... queries) {
        super(configuration);
        this.queries = queries;
    }

    @Override
    public final int size() {
        return this.queries.length;
    }

    @Override
    public final int[] execute() {
        return BatchMultiple.execute(this.configuration, this.queries);
    }

    static int[] execute(Configuration configuration, Query[] queries) {
        DefaultExecuteContext ctx = new DefaultExecuteContext(configuration, queries);
        ExecuteListener listener = ExecuteListeners.get(ctx);
        Connection connection = ctx.connection();
        try {
            int i;
            listener.start(ctx);
            ctx.statement(new SettingsEnabledPreparedStatement(connection));
            String[] batchSQL = ctx.batchSQL();
            for (i = 0; i < queries.length; ++i) {
                ctx.sql(null);
                listener.renderStart(ctx);
                batchSQL[i] = DSL.using(configuration).renderInlined(queries[i]);
                ctx.sql(batchSQL[i]);
                listener.renderEnd(ctx);
            }
            for (i = 0; i < queries.length; ++i) {
                ctx.sql(batchSQL[i]);
                listener.prepareStart(ctx);
                ctx.statement().addBatch(batchSQL[i]);
                listener.prepareEnd(ctx);
            }
            int t = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t != 0) {
                ctx.statement().setQueryTimeout(t);
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i2 = 0; i2 < batchRows.length && i2 < result.length; ++i2) {
                batchRows[i2] = result[i2];
            }
            listener.executeEnd(ctx);
            int[] nArray = result;
            return nArray;
        }
        catch (ControlFlowSignal e) {
            throw e;
        }
        catch (RuntimeException e) {
            ctx.exception(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e) {
            ctx.sqlException(e);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }
}

