/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractMeta;

final class SchemaMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = -505810795492145873L;
    private final Configuration configuration;
    private final Schema[] schemas;

    SchemaMetaImpl(Configuration configuration, Schema[] schemas) {
        this.configuration = configuration;
        this.schemas = schemas;
    }

    @Override
    public final List<Catalog> getCatalogs() {
        LinkedHashSet<Catalog> result = new LinkedHashSet<Catalog>();
        for (Schema schema : this.schemas) {
            if (schema.getCatalog() == null) continue;
            result.add(schema.getCatalog());
        }
        return new ArrayList<Catalog>(result);
    }

    @Override
    public final List<Schema> getSchemas() {
        return Collections.unmodifiableList(Arrays.asList(this.schemas));
    }

    @Override
    public final List<Table<?>> getTables() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.schemas) {
            result.addAll(schema.getTables());
        }
        return result;
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.schemas) {
            result.addAll(schema.getSequences());
        }
        return result;
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        ArrayList result = new ArrayList();
        for (Schema schema : this.schemas) {
            for (Table<?> table : schema.getTables()) {
                if (table.getPrimaryKey() == null) continue;
                result.add(table.getPrimaryKey());
            }
        }
        return result;
    }
}

