/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jooq.AggregateFilterStep;
import org.jooq.AggregateFunction;
import org.jooq.AlterIndexFinalStep;
import org.jooq.AlterIndexStep;
import org.jooq.AlterSchemaFinalStep;
import org.jooq.AlterSchemaStep;
import org.jooq.AlterSequenceStep;
import org.jooq.AlterTableDropStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableStep;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.Block;
import org.jooq.CaseConditionStep;
import org.jooq.CaseValueStep;
import org.jooq.CaseWhenStep;
import org.jooq.Catalog;
import org.jooq.Collation;
import org.jooq.Comment;
import org.jooq.CommentOnIsStep;
import org.jooq.CommonTableExpression;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.ConstraintFinalStep;
import org.jooq.ConstraintForeignKeyOnStep;
import org.jooq.ConstraintTypeStep;
import org.jooq.CreateIndexIncludeStep;
import org.jooq.CreateIndexStep;
import org.jooq.CreateTableAsStep;
import org.jooq.CreateTableColumnStep;
import org.jooq.CreateTableCommentStep;
import org.jooq.CreateTableStorageStep;
import org.jooq.CreateTableWithDataStep;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.DatePart;
import org.jooq.Delete;
import org.jooq.DeleteReturningStep;
import org.jooq.DeleteWhereStep;
import org.jooq.DerivedColumnList;
import org.jooq.DropIndexOnStep;
import org.jooq.DropSchemaFinalStep;
import org.jooq.DropSchemaStep;
import org.jooq.DropTableFinalStep;
import org.jooq.DropTableStep;
import org.jooq.DropViewFinalStep;
import org.jooq.Field;
import org.jooq.FieldOrConstraint;
import org.jooq.FieldOrRow;
import org.jooq.GrantOnStep;
import org.jooq.GrantToStep;
import org.jooq.GrantWithGrantOptionStep;
import org.jooq.GroupConcatOrderByStep;
import org.jooq.GroupConcatSeparatorStep;
import org.jooq.Index;
import org.jooq.Insert;
import org.jooq.InsertOnConflictDoUpdateStep;
import org.jooq.InsertOnDuplicateSetMoreStep;
import org.jooq.InsertOnDuplicateStep;
import org.jooq.InsertReturningStep;
import org.jooq.InsertSetMoreStep;
import org.jooq.InsertSetStep;
import org.jooq.InsertValuesStepN;
import org.jooq.JoinType;
import org.jooq.Keyword;
import org.jooq.Merge;
import org.jooq.MergeNotMatchedStep;
import org.jooq.MergeOnConditionStep;
import org.jooq.MergeUsingStep;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.OrderedAggregateFunction;
import org.jooq.OrderedAggregateFunctionOfDeferredType;
import org.jooq.Param;
import org.jooq.Parser;
import org.jooq.Privilege;
import org.jooq.QualifiedAsterisk;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.jooq.RevokeFromStep;
import org.jooq.RevokeOnStep;
import org.jooq.Row;
import org.jooq.Row2;
import org.jooq.RowN;
import org.jooq.SQL;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Statement;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptionalOnStep;
import org.jooq.TablePartitionByStep;
import org.jooq.Truncate;
import org.jooq.TruncateCascadeStep;
import org.jooq.TruncateFinalStep;
import org.jooq.TruncateIdentityStep;
import org.jooq.Update;
import org.jooq.UpdateSetFirstStep;
import org.jooq.UpdateSetMoreStep;
import org.jooq.User;
import org.jooq.WindowBeforeOverStep;
import org.jooq.WindowDefinition;
import org.jooq.WindowFinalStep;
import org.jooq.WindowFromFirstLastStep;
import org.jooq.WindowIgnoreNullsStep;
import org.jooq.WindowOverStep;
import org.jooq.WindowSpecification;
import org.jooq.WindowSpecificationOrderByStep;
import org.jooq.WindowSpecificationRowsAndStep;
import org.jooq.WindowSpecificationRowsStep;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.conf.ParseWithMetaLookups;
import org.jooq.impl.CombineOperator;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Keywords;
import org.jooq.impl.NullStatement;
import org.jooq.impl.ParserContext;
import org.jooq.impl.ParserException;
import org.jooq.impl.QualifiedField;
import org.jooq.impl.SQLConcatenationImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SelectQueryImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.StringUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.types.DayToSecond;
import org.jooq.types.Interval;
import org.jooq.types.YearToMonth;

final class ParserImpl
implements Parser {
    private final DSLContext dsl;
    private final ParseWithMetaLookups metaLookups;
    private final Meta meta;
    private static final String[] KEYWORDS_IN_SELECT = new String[]{"CONNECT BY", "EXCEPT", "FETCH FIRST", "FETCH NEXT", "FOR UPDATE", "FROM", "GO", "GROUP BY", "HAVING", "INTERSECT", "INTO", "LIMIT", "MINUS", "OFFSET", "ORDER BY", "PARTITION BY", "RETURNING", "START WITH", "UNION", "WHERE", "WINDOW", "WITH"};
    private static final String[] KEYWORDS_IN_FROM = new String[]{"CONNECT BY", "CROSS APPLY", "CROSS JOIN", "EXCEPT", "FETCH FIRST", "FETCH NEXT", "FOR SHARE", "FOR UPDATE", "FULL JOIN", "FULL OUTER JOIN", "GO", "GROUP BY", "HAVING", "INNER JOIN", "INTERSECT", "INTO", "JOIN", "LEFT ANTI JOIN", "LEFT JOIN", "LEFT OUTER JOIN", "LEFT SEMI JOIN", "LIMIT", "MINUS", "NATURAL JOIN", "NATURAL INNER JOIN", "NATURAL LEFT JOIN", "NATURAL LEFT OUTER JOIN", "NATURAL RIGHT JOIN", "NATURAL RIGHT OUTER JOIN", "NATURAL FULL JOIN", "NATURAL FULL OUTER JOIN", "OFFSET", "ON", "ORDER BY", "OUTER APPLY", "PARTITION BY", "RETURNING", "RIGHT ANTI JOIN", "RIGHT JOIN", "RIGHT OUTER JOIN", "RIGHT SEMI JOIN", "SELECT", "START WITH", "STRAIGHT_JOIN", "UNION", "USING", "WHERE", "WINDOW", "WITH"};
    private static final String[] PIVOT_KEYWORDS = new String[]{"FOR"};
    private static final Ignore IGNORE = Reflect.on(DSL.query("/* ignored */")).as(Ignore.class);
    private static final Ignore IGNORE_NO_DELIMITER = Reflect.on(DSL.query("/* ignored */")).as(Ignore.class);

    ParserImpl(Configuration configuration) {
        this.dsl = DSL.using(configuration);
        this.metaLookups = configuration.settings().getParseWithMetaLookups();
        this.meta = this.metaLookups == ParseWithMetaLookups.IGNORE_ON_FAILURE || this.metaLookups == ParseWithMetaLookups.THROW_ON_FAILURE ? this.dsl.meta() : null;
    }

    private final ParserContext ctx(String sql, Object ... bindings) {
        ParserContext ctx = new ParserContext(this.dsl, this.meta, this.metaLookups, sql, bindings);
        ParserImpl.parseWhitespaceIf(ctx);
        return ctx;
    }

    @Override
    public final Queries parse(String sql) {
        return this.parse(sql, new Object[0]);
    }

    @Override
    public final Queries parse(String sql, Object ... bindings) {
        Query query;
        ParserContext ctx = this.ctx(sql, bindings);
        ArrayList<Query> result = new ArrayList<Query>();
        do {
            ParserImpl.parseDelimiterSpecifications(ctx);
            while (ParserImpl.parseDelimiterIf(ctx)) {
            }
            query = ParserImpl.parseQuery(ctx, false, false);
            if (query == IGNORE || query == IGNORE_NO_DELIMITER || query == null) continue;
            result.add(query);
        } while (query == IGNORE_NO_DELIMITER || ParserImpl.parseDelimiterIf(ctx));
        ctx.done("Unexpected token or missing query delimiter");
        return this.dsl.queries(result);
    }

    @Override
    public final Query parseQuery(String sql) {
        return this.parseQuery(sql, new Object[0]);
    }

    @Override
    public final Query parseQuery(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        Query result = ParserImpl.parseQuery(ctx, false, false);
        ctx.done("Unexpected clause");
        return result;
    }

    @Override
    public final ResultQuery<?> parseResultQuery(String sql) {
        return this.parseResultQuery(sql, new Object[0]);
    }

    @Override
    public final ResultQuery<?> parseResultQuery(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        ResultQuery result = (ResultQuery)ParserImpl.parseQuery(ctx, true, false);
        ctx.done("Unexpected content after end of query input");
        return result;
    }

    @Override
    public final Select<?> parseSelect(String sql) {
        return this.parseSelect(sql, new Object[0]);
    }

    @Override
    public final Select<?> parseSelect(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        Select result = (Select)ParserImpl.parseQuery(ctx, true, true);
        ctx.done("Unexpected content after end of query input");
        return result;
    }

    @Override
    public final Table<?> parseTable(String sql) {
        return this.parseTable(sql, new Object[0]);
    }

    @Override
    public final Table<?> parseTable(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        Table<?> result = ParserImpl.parseTable(ctx);
        ctx.done("Unexpected content after end of table input");
        return result;
    }

    @Override
    public final Field<?> parseField(String sql) {
        return this.parseField(sql, new Object[0]);
    }

    @Override
    public final Field<?> parseField(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        Field<?> result = ParserImpl.parseField(ctx);
        ctx.done("Unexpected content after end of field input");
        return result;
    }

    @Override
    public final Row parseRow(String sql) {
        return this.parseRow(sql, new Object[0]);
    }

    @Override
    public final Row parseRow(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        RowN result = ParserImpl.parseRow(ctx);
        ctx.done("Unexpected content after end of row input");
        return result;
    }

    @Override
    public final Condition parseCondition(String sql) {
        return this.parseCondition(sql, new Object[0]);
    }

    @Override
    public final Condition parseCondition(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        Condition result = ParserImpl.parseCondition(ctx);
        ctx.done("Unexpected content after end of condition input");
        return result;
    }

    @Override
    public final Name parseName(String sql) {
        return this.parseName(sql, new Object[0]);
    }

    @Override
    public final Name parseName(String sql, Object ... bindings) {
        ParserContext ctx = this.ctx(sql, bindings);
        Name result = ParserImpl.parseName(ctx);
        ctx.done("Unexpected content after end of name input");
        return result;
    }

    private static final void parseDelimiterSpecifications(ParserContext ctx) {
        while (ParserImpl.parseKeywordIf(ctx, "DELIMITER")) {
            ctx.delimiter(ParserImpl.parseUntilEOL(ctx).trim());
        }
    }

    private static final boolean parseDelimiterIf(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, ctx.delimiter())) {
            return true;
        }
        if (ParserImpl.peekKeyword(ctx, "GO")) {
            ctx.positionInc(2);
            String line = ParserImpl.parseUntilEOLIf(ctx);
            if (line != null && !"".equals(line.trim())) {
                throw ctx.exception("GO must be only token on line");
            }
            ParserImpl.parseWhitespaceIf(ctx);
            return true;
        }
        return false;
    }

    private static final Query parseQuery(ParserContext ctx, boolean parseResultQuery, boolean parseSelect) {
        if (ctx.done()) {
            return null;
        }
        switch (ctx.character()) {
            case 'A': 
            case 'a': {
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "ALTER")) break;
                return ParserImpl.parseAlter(ctx);
            }
            case 'B': 
            case 'b': {
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "BEGIN")) break;
                return ParserImpl.parseBlock(ctx);
            }
            case 'C': 
            case 'c': {
                if (!parseResultQuery && ParserImpl.peekKeyword(ctx, "CREATE")) {
                    return ParserImpl.parseCreate(ctx);
                }
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "COMMENT ON")) break;
                return ParserImpl.parseCommentOn(ctx);
            }
            case 'D': 
            case 'd': {
                if (!parseResultQuery && (ParserImpl.peekKeyword(ctx, "DELETE") || ParserImpl.peekKeyword(ctx, "DEL"))) {
                    return ParserImpl.parseDelete(ctx, null);
                }
                if (!parseResultQuery && ParserImpl.peekKeyword(ctx, "DROP")) {
                    return ParserImpl.parseDrop(ctx);
                }
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "DO")) break;
                return ParserImpl.parseDo(ctx);
            }
            case 'E': 
            case 'e': {
                if (!parseResultQuery && ParserImpl.peekKeyword(ctx, "EXECUTE BLOCK AS BEGIN")) {
                    return ParserImpl.parseBlock(ctx);
                }
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "EXEC")) break;
                return ParserImpl.parseExec(ctx);
            }
            case 'G': 
            case 'g': {
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "GRANT")) break;
                return ParserImpl.parseGrant(ctx);
            }
            case 'I': 
            case 'i': {
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "INSERT") && !ParserImpl.peekKeyword(ctx, "INS")) break;
                return ParserImpl.parseInsert(ctx, null);
            }
            case 'M': 
            case 'm': {
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "MERGE")) break;
                return ParserImpl.parseMerge(ctx, null);
            }
            case 'R': 
            case 'r': {
                if (!parseResultQuery && ParserImpl.peekKeyword(ctx, "RENAME")) {
                    return ParserImpl.parseRename(ctx);
                }
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "REVOKE")) break;
                return ParserImpl.parseRevoke(ctx);
            }
            case 'S': 
            case 's': {
                if (ParserImpl.peekKeyword(ctx, "SELECT") || ParserImpl.peekKeyword(ctx, "SEL")) {
                    return ParserImpl.parseSelect(ctx);
                }
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "SET")) break;
                return ParserImpl.parseSet(ctx);
            }
            case 'T': 
            case 't': {
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "TRUNCATE")) break;
                return ParserImpl.parseTruncate(ctx);
            }
            case 'U': 
            case 'u': {
                if (!parseResultQuery && (ParserImpl.peekKeyword(ctx, "UPDATE") || ParserImpl.peekKeyword(ctx, "UPD"))) {
                    return ParserImpl.parseUpdate(ctx, null);
                }
                if (parseResultQuery || !ParserImpl.peekKeyword(ctx, "USE")) break;
                return ParserImpl.parseUse(ctx);
            }
            case 'V': 
            case 'v': {
                if (!parseSelect && ParserImpl.peekKeyword(ctx, "VALUES")) {
                    return ParserImpl.parseSelect(ctx);
                }
            }
            case 'W': 
            case 'w': {
                if (!ParserImpl.peekKeyword(ctx, "WITH")) break;
                return ParserImpl.parseWith(ctx, parseSelect);
            }
            case '(': {
                if (ParserImpl.peekKeyword(ctx, "WITH", false, true, false)) {
                    return ParserImpl.parseWith(ctx, true);
                }
                return ParserImpl.parseSelect(ctx);
            }
        }
        throw ctx.exception("Unsupported query type");
    }

    private static final Query parseWith(ParserContext ctx, boolean parseSelect) {
        Query result;
        int parens = 0;
        while (ParserImpl.parseIf(ctx, '(')) {
            ++parens;
        }
        ParserImpl.parseKeyword(ctx, "WITH");
        boolean recursive = ParserImpl.parseKeywordIf(ctx, "RECURSIVE");
        ArrayList<CommonTableExpression<Record>> cte = new ArrayList<CommonTableExpression<Record>>();
        do {
            Name table = ParserImpl.parseIdentifier(ctx);
            DerivedColumnList dcl = null;
            if (ParserImpl.parseIf(ctx, '(')) {
                List<Name> columnNames = ParserImpl.parseIdentifiers(ctx);
                ParserImpl.parse(ctx, ')');
                dcl = table.fields(columnNames.toArray(Tools.EMPTY_NAME));
            }
            ParserImpl.parseKeyword(ctx, "AS");
            ParserImpl.parse(ctx, '(');
            SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
            ParserImpl.parse(ctx, ')');
            cte.add(dcl != null ? dcl.as(select) : table.as(select));
        } while (ParserImpl.parseIf(ctx, ','));
        WithImpl with = (WithImpl)new WithImpl(ctx.dsl.configuration(), recursive).with(cte.toArray(Tools.EMPTY_COMMON_TABLE_EXPRESSION));
        if (!parseSelect && (ParserImpl.peekKeyword(ctx, "DELETE") || ParserImpl.peekKeyword(ctx, "DEL"))) {
            result = ParserImpl.parseDelete(ctx, with);
        } else if (!parseSelect && (ParserImpl.peekKeyword(ctx, "INSERT") || ParserImpl.peekKeyword(ctx, "INS"))) {
            result = ParserImpl.parseInsert(ctx, with);
        } else if (!parseSelect && ParserImpl.peekKeyword(ctx, "MERGE")) {
            result = ParserImpl.parseMerge(ctx, with);
        } else if (ParserImpl.peekKeyword(ctx, "SELECT", false, true, false) || ParserImpl.peekKeyword(ctx, "SEL", false, true, false)) {
            result = ParserImpl.parseSelect(ctx, null, with);
        } else if (!parseSelect && (ParserImpl.peekKeyword(ctx, "UPDATE") || ParserImpl.peekKeyword(ctx, "UPD"))) {
            result = ParserImpl.parseUpdate(ctx, with);
        } else {
            if (!ParserImpl.parseWhitespaceIf(ctx)) {
                // empty if block
            }
            if (ctx.done()) {
                throw ctx.exception("Missing statement after WITH");
            }
            throw ctx.exception("Unsupported statement after WITH");
        }
        while (parens-- > 0) {
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    private static final SelectQueryImpl<Record> parseSelect(ParserContext ctx) {
        return ParserImpl.parseSelect(ctx, null, null);
    }

    private static final SelectQueryImpl<Record> parseSelect(ParserContext ctx, Integer degree) {
        return ParserImpl.parseSelect(ctx, degree, null);
    }

    private static final SelectQueryImpl<Record> parseSelect(ParserContext ctx, Integer degree, WithImpl with) {
        SelectQueryImpl<Record> result = ParserImpl.parseQueryExpressionBody(ctx, degree, with, null);
        List<SortField<?>> orderBy = null;
        if (ParserImpl.parseKeywordIf(ctx, "ORDER")) {
            if (ParserImpl.parseKeywordIf(ctx, "SIBLINGS BY")) {
                result.addOrderBy(ParserImpl.parseSortSpecification(ctx));
                result.setOrderBySiblings(true);
            } else if (ParserImpl.parseKeywordIf(ctx, "BY")) {
                orderBy = ParserImpl.parseSortSpecification(ctx);
                result.addOrderBy(orderBy);
            } else {
                throw ctx.expected("SIBLINGS BY", "BY");
            }
        }
        if (orderBy != null && ParserImpl.parseKeywordIf(ctx, "SEEK")) {
            List<Field<?>> seek;
            boolean before = ParserImpl.parseKeywordIf(ctx, "BEFORE");
            if (!before) {
                ParserImpl.parseKeywordIf(ctx, "AFTER");
            }
            if ((seek = ParserImpl.parseFields(ctx)).size() != orderBy.size()) {
                throw ctx.exception("ORDER BY size (" + orderBy.size() + ") and SEEK size (" + seek.size() + ") must match");
            }
            if (before) {
                result.addSeekBefore(seek);
            } else {
                result.addSeekAfter(seek);
            }
            if (!result.getLimit().isApplicable()) {
                ParserImpl.parseLimit(ctx, result, false);
            }
        } else if (!result.getLimit().isApplicable()) {
            ParserImpl.parseLimit(ctx, result, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "FOR")) {
            if (ParserImpl.parseKeywordIf(ctx, "SHARE")) {
                result.setForShare(true);
            } else if (ParserImpl.parseKeywordIf(ctx, "UPDATE")) {
                result.setForUpdate(true);
                if (ParserImpl.parseKeywordIf(ctx, "OF")) {
                    result.setForUpdateOf(ParserImpl.parseFields(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "NOWAIT")) {
                    result.setForUpdateNoWait();
                } else if (!(ParserImpl.parseKeywordIf(ctx, "WAIT") && ctx.requireProEdition() || !ParserImpl.parseKeywordIf(ctx, "SKIP LOCKED"))) {
                    result.setForUpdateSkipLocked();
                }
            } else {
                throw ctx.expected("SHARE", "UPDATE");
            }
        }
        return result;
    }

    private static final void parseLimit(ParserContext ctx, SelectQueryImpl<Record> result, boolean offset) {
        boolean offsetStandard = false;
        boolean offsetPostgres = false;
        if (offset && ParserImpl.parseKeywordIf(ctx, "OFFSET")) {
            result.addOffset(DSL.inline((int)ParserImpl.parseUnsignedInteger(ctx).longValue()));
            if (ParserImpl.parseKeywordIf(ctx, "ROWS") || ParserImpl.parseKeywordIf(ctx, "ROW")) {
                offsetStandard = true;
            } else if (ParserImpl.peekKeyword(ctx, "FETCH")) {
                offsetStandard = true;
            } else {
                offsetPostgres = true;
            }
        }
        if (!offsetStandard && ParserImpl.parseKeywordIf(ctx, "LIMIT")) {
            Param<Integer> limit = DSL.inline((int)ParserImpl.parseUnsignedInteger(ctx).longValue());
            if (offsetPostgres) {
                result.addLimit(limit);
                if (!ParserImpl.parseKeywordIf(ctx, "PERCENT") || ctx.requireProEdition()) {
                    // empty if block
                }
                if (ParserImpl.parseKeywordIf(ctx, "WITH TIES")) {
                    result.setWithTies(true);
                }
            } else if (offset && ParserImpl.parseIf(ctx, ',')) {
                result.addLimit(limit, DSL.inline((int)ParserImpl.parseUnsignedInteger(ctx).longValue()));
            } else {
                if (!ParserImpl.parseKeywordIf(ctx, "PERCENT") || ctx.requireProEdition()) {
                    // empty if block
                }
                if (ParserImpl.parseKeywordIf(ctx, "WITH TIES")) {
                    result.setWithTies(true);
                }
                if (offset && ParserImpl.parseKeywordIf(ctx, "OFFSET")) {
                    result.addLimit(DSL.inline((int)ParserImpl.parseUnsignedInteger(ctx).longValue()), limit);
                } else {
                    result.addLimit(limit);
                }
            }
        } else if (!offsetPostgres && ParserImpl.parseKeywordIf(ctx, "FETCH")) {
            ParserImpl.parseAndGetKeyword(ctx, "FIRST", "NEXT");
            result.addLimit(DSL.inline((int)StringUtils.defaultIfNull(ParserImpl.parseUnsignedIntegerIf(ctx), 1L).longValue()));
            if (!ParserImpl.parseKeywordIf(ctx, "PERCENT") || ctx.requireProEdition()) {
                // empty if block
            }
            ParserImpl.parseAndGetKeyword(ctx, "ROW", "ROWS");
            if (ParserImpl.parseKeywordIf(ctx, "WITH TIES")) {
                result.setWithTies(true);
            } else {
                ParserImpl.parseKeyword(ctx, "ONLY");
            }
        }
    }

    private static final SelectQueryImpl<Record> parseQueryExpressionBody(ParserContext ctx, Integer degree, WithImpl with, SelectQueryImpl<Record> prefix) {
        CombineOperator combine;
        SelectQueryImpl result = ParserImpl.parseQueryTerm(ctx, degree, with, prefix);
        block6: while ((combine = ParserImpl.parseCombineOperatorIf(ctx, false)) != null) {
            if (degree == null) {
                degree = result.getSelect().size();
            }
            switch (combine) {
                case UNION: {
                    result = (SelectQueryImpl)result.union(ParserImpl.parseQueryTerm(ctx, degree, null, null));
                    continue block6;
                }
                case UNION_ALL: {
                    result = (SelectQueryImpl)result.unionAll(ParserImpl.parseQueryTerm(ctx, degree, null, null));
                    continue block6;
                }
                case EXCEPT: {
                    result = (SelectQueryImpl)result.except(ParserImpl.parseQueryTerm(ctx, degree, null, null));
                    continue block6;
                }
                case EXCEPT_ALL: {
                    result = (SelectQueryImpl)result.exceptAll(ParserImpl.parseQueryTerm(ctx, degree, null, null));
                    continue block6;
                }
            }
            throw ctx.internalError();
        }
        return result;
    }

    private static final SelectQueryImpl<Record> parseQueryTerm(ParserContext ctx, Integer degree, WithImpl with, SelectQueryImpl<Record> prefix) {
        CombineOperator combine;
        SelectQueryImpl<Object> result;
        SelectQueryImpl<Object> selectQueryImpl = result = prefix != null ? prefix : ParserImpl.parseQueryPrimary(ctx, degree, with);
        block4: while ((combine = ParserImpl.parseCombineOperatorIf(ctx, true)) != null) {
            if (degree == null) {
                degree = result.getSelect().size();
            }
            switch (combine) {
                case INTERSECT: {
                    result = (SelectQueryImpl<Object>)result.intersect(ParserImpl.parseQueryPrimary(ctx, degree, null));
                    continue block4;
                }
                case INTERSECT_ALL: {
                    result = (SelectQueryImpl)result.intersectAll(ParserImpl.parseQueryPrimary(ctx, degree, null));
                    continue block4;
                }
            }
            throw ctx.internalError();
        }
        return result;
    }

    private static final SelectQueryImpl<Record> parseQueryPrimary(ParserContext ctx, Integer degree, WithImpl with) {
        List<SelectFieldOrAsterisk> select;
        boolean withTies;
        boolean percent;
        Long offset;
        Long limit;
        List<Field<?>> distinctOn;
        boolean distinct;
        String hints;
        block58: {
            if (ParserImpl.parseIf(ctx, '(')) {
                SelectQueryImpl<Record> result = ParserImpl.parseSelect(ctx, degree, with);
                ParserImpl.parse(ctx, ')');
                return result;
            }
            if (ParserImpl.peekKeyword(ctx, "VALUES")) {
                return (SelectQueryImpl)ctx.dsl.selectQuery(ParserImpl.parseTableValueConstructor(ctx));
            }
            ctx.ignoreHints(false);
            if (!ParserImpl.parseKeywordIf(ctx, "SEL")) {
                ParserImpl.parseKeyword(ctx, "SELECT");
            }
            hints = ParserImpl.parseHints(ctx);
            distinct = ParserImpl.parseKeywordIf(ctx, "DISTINCT") || ParserImpl.parseKeywordIf(ctx, "UNIQUE");
            distinctOn = null;
            if (distinct) {
                if (ParserImpl.parseKeywordIf(ctx, "ON")) {
                    ParserImpl.parse(ctx, '(');
                    distinctOn = ParserImpl.parseFields(ctx);
                    ParserImpl.parse(ctx, ')');
                }
            } else {
                ParserImpl.parseKeywordIf(ctx, "ALL");
            }
            limit = null;
            offset = null;
            percent = false;
            withTies = false;
            if (ParserImpl.parseKeywordIf(ctx, "TOP")) {
                limit = ParserImpl.parseUnsignedInteger(ctx);
                boolean bl = percent = ParserImpl.parseKeywordIf(ctx, "PERCENT") && ctx.requireProEdition();
                if (ParserImpl.parseKeywordIf(ctx, "START AT")) {
                    offset = ParserImpl.parseUnsignedInteger(ctx);
                } else if (ParserImpl.parseKeywordIf(ctx, "WITH TIES")) {
                    withTies = true;
                }
            } else if (ParserImpl.parseKeywordIf(ctx, "SKIP")) {
                offset = ParserImpl.parseUnsignedInteger(ctx);
                if (ParserImpl.parseKeywordIf(ctx, "FIRST")) {
                    limit = ParserImpl.parseUnsignedInteger(ctx);
                }
            } else if (ParserImpl.parseKeywordIf(ctx, "FIRST")) {
                limit = ParserImpl.parseUnsignedInteger(ctx);
            }
            select = ParserImpl.parseSelectList(ctx);
            if (degree != null && select.size() != degree.intValue()) {
                for (SelectFieldOrAsterisk s : select) {
                    if (s instanceof Field) continue;
                    break block58;
                }
                throw ctx.exception("Select list must contain " + degree + " columns. Got: " + select.size());
            }
        }
        Table<?> into = null;
        List<Table<?>> from = null;
        Condition startWith = null;
        Condition connectBy = null;
        boolean connectByNoCycle = false;
        Condition where = null;
        List<Object> groupBy = null;
        Condition having = null;
        List<WindowDefinition> windows = null;
        if (ParserImpl.parseKeywordIf(ctx, "INTO")) {
            into = ParserImpl.parseTableName(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "FROM")) {
            from = ParserImpl.parseTables(ctx);
        }
        if (from != null && from.size() == 1 && from.get(0).getName().equalsIgnoreCase("dual")) {
            from = null;
        }
        if (ParserImpl.parseKeywordIf(ctx, "WHERE")) {
            where = ParserImpl.parseCondition(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "START WITH")) {
            startWith = ParserImpl.parseCondition(ctx);
            ParserImpl.parseKeyword(ctx, "CONNECT BY");
            connectByNoCycle = ParserImpl.parseKeywordIf(ctx, "NOCYCLE");
            connectBy = ParserImpl.parseCondition(ctx);
        } else if (ParserImpl.parseKeywordIf(ctx, "CONNECT BY")) {
            connectByNoCycle = ParserImpl.parseKeywordIf(ctx, "NOCYCLE");
            connectBy = ParserImpl.parseCondition(ctx);
            if (ParserImpl.parseKeywordIf(ctx, "START WITH")) {
                startWith = ParserImpl.parseCondition(ctx);
            }
        }
        if (ParserImpl.parseKeywordIf(ctx, "GROUP BY")) {
            if (ParserImpl.parseIf(ctx, '(')) {
                ParserImpl.parse(ctx, ')');
                groupBy = Collections.emptyList();
            } else if (ParserImpl.parseKeywordIf(ctx, "ROLLUP")) {
                ParserImpl.parse(ctx, '(');
                groupBy = Collections.singletonList(DSL.rollup(ParserImpl.parseFields(ctx).toArray(Tools.EMPTY_FIELD)));
                ParserImpl.parse(ctx, ')');
            } else if (ParserImpl.parseKeywordIf(ctx, "CUBE")) {
                ParserImpl.parse(ctx, '(');
                groupBy = Collections.singletonList(DSL.cube(ParserImpl.parseFields(ctx).toArray(Tools.EMPTY_FIELD)));
                ParserImpl.parse(ctx, ')');
            } else if (ParserImpl.parseKeywordIf(ctx, "GROUPING SETS")) {
                ArrayList<List<Object>> fieldSets = new ArrayList<List<Object>>();
                ParserImpl.parse(ctx, '(');
                do {
                    ParserImpl.parse(ctx, '(');
                    if (ParserImpl.parseIf(ctx, ')')) {
                        fieldSets.add(Collections.emptyList());
                        continue;
                    }
                    fieldSets.add(ParserImpl.parseFields(ctx));
                    ParserImpl.parse(ctx, ')');
                } while (ParserImpl.parseIf(ctx, ','));
                ParserImpl.parse(ctx, ')');
                groupBy = Collections.singletonList(DSL.groupingSets(fieldSets.toArray(Tools.EMPTY_COLLECTION)));
            } else {
                groupBy = ParserImpl.parseFields(ctx);
                if (ParserImpl.parseKeywordIf(ctx, "WITH ROLLUP")) {
                    groupBy = Collections.singletonList(DSL.rollup(groupBy.toArray(Tools.EMPTY_FIELD)));
                }
            }
        }
        if (ParserImpl.parseKeywordIf(ctx, "HAVING")) {
            having = ParserImpl.parseCondition(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "WINDOW")) {
            windows = ParserImpl.parseWindowDefinitions(ctx);
        }
        SelectQueryImpl<Record> result = new SelectQueryImpl<Record>(ctx.dsl.configuration(), with);
        if (hints != null) {
            result.addHint(hints);
        }
        if (distinct) {
            result.setDistinct(distinct);
        }
        if (distinctOn != null) {
            result.addDistinctOn(distinctOn);
        }
        if (!select.isEmpty()) {
            result.addSelect(select);
        }
        if (into != null) {
            result.setInto(into);
        }
        if (from != null) {
            result.addFrom(from);
        }
        if (connectBy != null) {
            if (connectByNoCycle) {
                result.addConnectByNoCycle(connectBy);
            } else {
                result.addConnectBy(connectBy);
            }
        }
        if (startWith != null) {
            result.setConnectByStartWith(startWith);
        }
        if (where != null) {
            result.addConditions(where);
        }
        if (groupBy != null) {
            result.addGroupBy(groupBy);
        }
        if (having != null) {
            result.addHaving(having);
        }
        if (windows != null) {
            result.addWindow(windows);
        }
        if (limit != null) {
            if (offset != null) {
                result.addLimit(DSL.inline((int)offset.longValue()), DSL.inline((int)limit.longValue()));
            } else {
                result.addLimit(DSL.inline((int)limit.longValue()));
            }
        }
        if (percent) {
            // empty if block
        }
        if (withTies) {
            result.setWithTies(true);
        }
        return result;
    }

    private static final List<WindowDefinition> parseWindowDefinitions(ParserContext ctx) {
        ArrayList<WindowDefinition> result = new ArrayList<WindowDefinition>();
        do {
            Name name = ParserImpl.parseIdentifier(ctx);
            ParserImpl.parseKeyword(ctx, "AS");
            ParserImpl.parse(ctx, '(');
            result.add(name.as(ParserImpl.parseWindowSpecificationIf(ctx, true)));
            ParserImpl.parse(ctx, ')');
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final WindowSpecification parseWindowSpecificationIf(ParserContext ctx, boolean orderByAllowed) {
        boolean range;
        WindowSpecificationRowsStep s2;
        WindowSpecificationOrderByStep s1;
        WindowSpecificationOrderByStep windowSpecificationOrderByStep = s1 = ParserImpl.parseKeywordIf(ctx, "PARTITION BY") ? DSL.partitionBy(ParserImpl.parseFields(ctx)) : null;
        if (ParserImpl.parseKeywordIf(ctx, "ORDER BY")) {
            if (!orderByAllowed) throw ctx.exception("ORDER BY not allowed");
            s2 = s1 == null ? DSL.orderBy(ParserImpl.parseSortSpecification(ctx)) : s1.orderBy(ParserImpl.parseSortSpecification(ctx));
        } else {
            s2 = s1;
        }
        boolean rows = ParserImpl.parseKeywordIf(ctx, "ROWS");
        boolean bl = range = !rows && ParserImpl.parseKeywordIf(ctx, "RANGE");
        if ((rows || range) && !orderByAllowed) {
            throw ctx.exception("ROWS or RANGE not allowed");
        }
        if (!rows && !range) return s2;
        if (ParserImpl.parseKeywordIf(ctx, "BETWEEN")) {
            Long n;
            WindowSpecificationRowsAndStep s3;
            if (ParserImpl.parseKeywordIf(ctx, "UNBOUNDED")) {
                if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                    s3 = s2 == null ? (rows ? DSL.rowsBetweenUnboundedPreceding() : DSL.rangeBetweenUnboundedPreceding()) : (rows ? s2.rowsBetweenUnboundedPreceding() : s2.rangeBetweenUnboundedPreceding());
                } else {
                    if (!ParserImpl.parseKeywordIf(ctx, "FOLLOWING")) throw ctx.expected("FOLLOWING", "PRECEDING");
                    s3 = s2 == null ? (rows ? DSL.rowsBetweenUnboundedFollowing() : DSL.rangeBetweenUnboundedFollowing()) : (rows ? s2.rowsBetweenUnboundedFollowing() : s2.rangeBetweenUnboundedFollowing());
                }
            } else if (ParserImpl.parseKeywordIf(ctx, "CURRENT ROW")) {
                s3 = s2 == null ? (rows ? DSL.rowsBetweenCurrentRow() : DSL.rangeBetweenCurrentRow()) : (rows ? s2.rowsBetweenCurrentRow() : s2.rangeBetweenCurrentRow());
            } else {
                n = ParserImpl.parseUnsignedIntegerIf(ctx);
                if (n == null) throw ctx.expected("CURRENT ROW", "UNBOUNDED", "integer literal");
                if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                    s3 = s2 == null ? (rows ? DSL.rowsBetweenPreceding(n.intValue()) : DSL.rangeBetweenPreceding(n.intValue())) : (rows ? s2.rowsBetweenPreceding(n.intValue()) : s2.rangeBetweenPreceding(n.intValue()));
                } else {
                    if (!ParserImpl.parseKeywordIf(ctx, "FOLLOWING")) throw ctx.expected("FOLLOWING", "PRECEDING");
                    s3 = s2 == null ? (rows ? DSL.rowsBetweenFollowing(n.intValue()) : DSL.rangeBetweenFollowing(n.intValue())) : (rows ? s2.rowsBetweenFollowing(n.intValue()) : s2.rangeBetweenFollowing(n.intValue()));
                }
            }
            ParserImpl.parseKeyword(ctx, "AND");
            if (ParserImpl.parseKeywordIf(ctx, "UNBOUNDED")) {
                if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                    return s3.andUnboundedPreceding();
                }
                if (!ParserImpl.parseKeywordIf(ctx, "FOLLOWING")) throw ctx.expected("FOLLOWING", "PRECEDING");
                return s3.andUnboundedFollowing();
            }
            if (ParserImpl.parseKeywordIf(ctx, "CURRENT ROW")) {
                return s3.andCurrentRow();
            }
            n = ParserImpl.parseUnsignedInteger(ctx);
            if (n == null) throw ctx.expected("CURRENT ROW", "UNBOUNDED", "integer literal");
            if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                return s3.andPreceding(n.intValue());
            }
            if (!ParserImpl.parseKeywordIf(ctx, "FOLLOWING")) throw ctx.expected("FOLLOWING", "PRECEDING");
            return s3.andFollowing(n.intValue());
        }
        if (ParserImpl.parseKeywordIf(ctx, "UNBOUNDED")) {
            if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
                return s2 == null ? (rows ? DSL.rowsUnboundedPreceding() : DSL.rangeUnboundedPreceding()) : (rows ? s2.rowsUnboundedPreceding() : s2.rangeUnboundedPreceding());
            }
            if (!ParserImpl.parseKeywordIf(ctx, "FOLLOWING")) throw ctx.expected("FOLLOWING", "PRECEDING");
            return s2 == null ? (rows ? DSL.rowsUnboundedFollowing() : DSL.rangeUnboundedFollowing()) : (rows ? s2.rowsUnboundedFollowing() : s2.rangeUnboundedFollowing());
        }
        if (ParserImpl.parseKeywordIf(ctx, "CURRENT ROW")) {
            return s2 == null ? (rows ? DSL.rowsCurrentRow() : DSL.rangeCurrentRow()) : (rows ? s2.rowsCurrentRow() : s2.rangeCurrentRow());
        }
        Long n = ParserImpl.parseUnsignedInteger(ctx);
        if (n == null) throw ctx.expected("BETWEEN", "CURRENT ROW", "UNBOUNDED", "integer literal");
        if (ParserImpl.parseKeywordIf(ctx, "PRECEDING")) {
            return s2 == null ? (rows ? DSL.rowsPreceding(n.intValue()) : DSL.rangePreceding(n.intValue())) : (rows ? s2.rowsPreceding(n.intValue()) : s2.rangePreceding(n.intValue()));
        }
        if (!ParserImpl.parseKeywordIf(ctx, "FOLLOWING")) throw ctx.expected("FOLLOWING", "PRECEDING");
        return s2 == null ? (rows ? DSL.rowsFollowing(n.intValue()) : DSL.rangeFollowing(n.intValue())) : (rows ? s2.rowsFollowing(n.intValue()) : s2.rangeFollowing(n.intValue()));
    }

    private static final Delete<?> parseDelete(ParserContext ctx, WithImpl with) {
        DeleteWhereStep<?> s2;
        if (!ParserImpl.parseKeywordIf(ctx, "DEL")) {
            ParserImpl.parseKeyword(ctx, "DELETE");
        }
        ParserImpl.parseKeywordIf(ctx, "FROM");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        boolean where = ParserImpl.parseKeywordIf(ctx, "WHERE");
        Condition condition = where ? ParserImpl.parseCondition(ctx) : null;
        DeleteWhereStep<?> s1 = with == null ? ctx.dsl.delete(tableName) : with.delete((Table)tableName);
        DeleteReturningStep<?> deleteReturningStep = s2 = where ? s1.where(condition) : s1;
        if (ParserImpl.parseKeywordIf(ctx, "RETURNING")) {
            return s2.returning(ParserImpl.parseSelectList(ctx));
        }
        return s2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Insert<?> parseInsert(ParserContext ctx, WithImpl with) {
        void var6_22;
        InsertOnDuplicateStep<?> onDuplicate;
        if (!ParserImpl.parseKeywordIf(ctx, "INS")) {
            ParserImpl.parseKeyword(ctx, "INSERT");
        }
        ParserImpl.parseKeywordIf(ctx, "INTO");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        InsertSetStep<Object> s1 = with == null ? ctx.dsl.insertInto(tableName) : with.insertInto(tableName);
        Field<?>[] fields = null;
        if (ParserImpl.parseIf(ctx, '(')) {
            fields = Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx).toArray(Tools.EMPTY_NAME));
            ParserImpl.parse(ctx, ')');
        }
        if (ParserImpl.parseKeywordIf(ctx, "VALUES")) {
            ArrayList allValues = new ArrayList();
            do {
                ParserImpl.parse(ctx, '(');
                if (fields == null && ParserImpl.parseIf(ctx, ')')) break;
                List<Field<?>> values = ParserImpl.parseFields(ctx);
                if (fields != null && fields.length != values.size()) {
                    throw ctx.exception("Insert field size (" + fields.length + ") must match values size (" + values.size() + ")");
                }
                allValues.add(values);
                ParserImpl.parse(ctx, ')');
            } while (ParserImpl.parseIf(ctx, ','));
            if (allValues.isEmpty()) {
                onDuplicate = s1.defaultValues();
                InsertOnDuplicateStep<?> insertOnDuplicateStep = onDuplicate;
            } else {
                InsertValuesStepN<?> step2 = fields != null ? s1.columns(fields) : (InsertValuesStepN<?>)((Object)s1);
                for (List list : allValues) {
                    step2 = step2.values(list);
                }
                onDuplicate = step2;
                InsertValuesStepN<?> insertValuesStepN = onDuplicate;
            }
        } else if (ParserImpl.parseKeywordIf(ctx, "SET")) {
            Map<Field<?>, Object> map = ParserImpl.parseSetClauseList(ctx);
            onDuplicate = s1.set(map);
            InsertSetMoreStep<?> insertSetMoreStep = onDuplicate;
        } else if (ParserImpl.peekKeyword(ctx, "SELECT", false, true, false) || ParserImpl.peekKeyword(ctx, "SEL", false, true, false)) {
            SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
            onDuplicate = fields == null ? s1.select(select) : s1.columns(fields).select(select);
            InsertOnDuplicateStep<?> insertOnDuplicateStep = onDuplicate;
        } else {
            if (!ParserImpl.parseKeywordIf(ctx, "DEFAULT VALUES")) throw ctx.expected("DEFAULT VALUES", "SELECT", "SET", "VALUES");
            if (fields != null) {
                throw ctx.notImplemented("DEFAULT VALUES without INSERT field list");
            }
            onDuplicate = s1.defaultValues();
            InsertOnDuplicateStep<?> insertOnDuplicateStep = onDuplicate;
        }
        if (ParserImpl.parseKeywordIf(ctx, "ON")) {
            if (ParserImpl.parseKeywordIf(ctx, "DUPLICATE KEY UPDATE SET")) {
                InsertOnDuplicateSetMoreStep<?> insertOnDuplicateSetMoreStep = onDuplicate.onDuplicateKeyUpdate().set(ParserImpl.parseSetClauseList(ctx));
            } else if (ParserImpl.parseKeywordIf(ctx, "DUPLICATE KEY IGNORE")) {
                InsertReturningStep<?> insertReturningStep = onDuplicate.onDuplicateKeyIgnore();
            } else {
                InsertOnConflictDoUpdateStep<?> doUpdate;
                if (!ParserImpl.parseKeywordIf(ctx, "CONFLICT")) throw ctx.expected("CONFLICT", "DUPLICATE");
                if (ParserImpl.parseKeywordIf(ctx, "ON CONSTRAINT")) {
                    doUpdate = onDuplicate.onConflictOnConstraint(ParserImpl.parseName(ctx));
                } else if (ParserImpl.parseIf(ctx, '(')) {
                    doUpdate = onDuplicate.onConflict(ParserImpl.parseFieldNames(ctx));
                    ParserImpl.parse(ctx, ')');
                } else {
                    doUpdate = onDuplicate.onConflict(new Field[0]);
                }
                ParserImpl.parseKeyword(ctx, "DO");
                if (ParserImpl.parseKeywordIf(ctx, "NOTHING")) {
                    InsertReturningStep<?> insertReturningStep = doUpdate.doNothing();
                } else {
                    if (!ParserImpl.parseKeywordIf(ctx, "UPDATE SET")) throw ctx.expected("NOTHING", "UPDATE");
                    InsertOnDuplicateSetMoreStep<?> where = doUpdate.doUpdate().set(ParserImpl.parseSetClauseList(ctx));
                    if (ParserImpl.parseKeywordIf(ctx, "WHERE")) {
                        InsertReturningStep insertReturningStep = where.where(ParserImpl.parseCondition(ctx));
                    } else {
                        InsertOnDuplicateSetMoreStep<?> insertOnDuplicateSetMoreStep = where;
                    }
                }
            }
        }
        if (!ParserImpl.parseKeywordIf(ctx, "RETURNING")) return var6_22;
        return var6_22.returning(ParserImpl.parseSelectList(ctx));
    }

    private static final Update<?> parseUpdate(ParserContext ctx, WithImpl with) {
        if (!ParserImpl.parseKeywordIf(ctx, "UPD")) {
            ParserImpl.parseKeyword(ctx, "UPDATE");
        }
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        UpdateSetFirstStep<Object> s1 = with == null ? ctx.dsl.update(tableName) : with.update((Table)tableName);
        ParserImpl.parseKeyword(ctx, "SET");
        Map<Field<?>, Object> map = ParserImpl.parseSetClauseList(ctx);
        UpdateSetMoreStep s2 = s1.set(map);
        UpdateSetMoreStep s3 = ParserImpl.parseKeywordIf(ctx, "FROM") ? s2.from(ParserImpl.parseTables(ctx)) : s2;
        UpdateSetMoreStep s4 = ParserImpl.parseKeywordIf(ctx, "WHERE") ? s3.where(ParserImpl.parseCondition(ctx)) : s3;
        return ParserImpl.parseKeywordIf(ctx, "RETURNING") ? s4.returning(ParserImpl.parseSelectList(ctx)) : s4;
    }

    private static final Map<Field<?>, Object> parseSetClauseList(ParserContext ctx) {
        LinkedHashMap map = new LinkedHashMap();
        do {
            TableField<?, ?> field;
            if (map.containsKey(field = ParserImpl.parseFieldName(ctx))) {
                throw ctx.exception("Duplicate column in set clause list: " + field);
            }
            ParserImpl.parse(ctx, '=');
            Field<?> value = ParserImpl.parseField(ctx);
            map.put(field, value);
        } while (ParserImpl.parseIf(ctx, ','));
        return map;
    }

    private static final Merge<?> parseMerge(ParserContext ctx, WithImpl with) {
        MergeOnConditionStep<?> s3;
        TableLike<Object> usingTable;
        ParserImpl.parseKeyword(ctx, "MERGE");
        ParserImpl.parseKeywordIf(ctx, "INTO");
        Table<?> target = ParserImpl.parseTableName(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "AS") || !ParserImpl.peekKeyword(ctx, "USING")) {
            target = target.as(ParserImpl.parseIdentifier(ctx));
        }
        ParserImpl.parseKeyword(ctx, "USING");
        Table<?> table = null;
        SelectQueryImpl<Record> using = null;
        if (ParserImpl.parseIf(ctx, '(')) {
            using = ParserImpl.parseSelect(ctx);
            ParserImpl.parse(ctx, ')');
        } else {
            table = ParserImpl.parseTableName(ctx);
        }
        TableLike<Object> tableLike = usingTable = table != null ? table : using;
        if (ParserImpl.parseKeywordIf(ctx, "AS") || !ParserImpl.peekKeyword(ctx, "ON")) {
            usingTable = (table != null ? table : DSL.table(using)).as(ParserImpl.parseIdentifier(ctx));
        }
        ParserImpl.parseKeyword(ctx, "ON");
        Condition on = ParserImpl.parseCondition(ctx);
        boolean update = false;
        boolean insert = false;
        Field<?>[] insertColumns = null;
        List<Field<?>> insertValues = null;
        Condition insertWhere = null;
        Map<Field<?>, Object> updateSet = null;
        Condition updateWhere = null;
        while (true) {
            if (!update && (update = ParserImpl.parseKeywordIf(ctx, "WHEN MATCHED"))) {
                if (ParserImpl.parseKeywordIf(ctx, "AND")) {
                    updateWhere = ParserImpl.parseCondition(ctx);
                }
                ParserImpl.parseKeyword(ctx, "THEN UPDATE SET");
                updateSet = ParserImpl.parseSetClauseList(ctx);
                if (updateWhere != null || !ParserImpl.parseKeywordIf(ctx, "WHERE")) continue;
                updateWhere = ParserImpl.parseCondition(ctx);
                continue;
            }
            if (insert || !(insert = ParserImpl.parseKeywordIf(ctx, "WHEN NOT MATCHED"))) break;
            if (ParserImpl.parseKeywordIf(ctx, "AND")) {
                insertWhere = ParserImpl.parseCondition(ctx);
            }
            ParserImpl.parseKeyword(ctx, "THEN INSERT");
            ParserImpl.parse(ctx, '(');
            insertColumns = Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx).toArray(Tools.EMPTY_NAME));
            ParserImpl.parse(ctx, ')');
            ParserImpl.parseKeyword(ctx, "VALUES");
            ParserImpl.parse(ctx, '(');
            insertValues = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            if (insertColumns.length != insertValues.size()) {
                throw ctx.exception("Insert column size (" + insertColumns.length + ") must match values size (" + insertValues.size() + ")");
            }
            if (insertWhere != null || !ParserImpl.parseKeywordIf(ctx, "WHERE")) continue;
            insertWhere = ParserImpl.parseCondition(ctx);
        }
        if (!update && !insert) {
            throw ctx.exception("At least one of UPDATE or INSERT clauses is required");
        }
        MergeUsingStep<?> s1 = with == null ? ctx.dsl.mergeInto(target) : with.mergeInto(target);
        MergeOnConditionStep<?> s2 = s1.using(usingTable).on(on);
        MergeNotMatchedStep<Object> mergeNotMatchedStep = update ? (updateWhere != null ? s2.whenMatchedThenUpdate().set(updateSet).where(updateWhere) : s2.whenMatchedThenUpdate().set(updateSet)) : (s3 = s2);
        MergeOnConditionStep<?> s4 = insert ? (insertWhere != null ? s3.whenNotMatchedThenInsert(insertColumns).values(insertValues).where(insertWhere) : s3.whenNotMatchedThenInsert(insertColumns).values(insertValues)) : s3;
        return s4;
    }

    private static final Query parseSet(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "SET");
        if (ParserImpl.parseKeywordIf(ctx, "CATALOG")) {
            return ParserImpl.parseSetCatalog(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "CURRENT SCHEMA")) {
            return ParserImpl.parseSetSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "CURRENT SQLID")) {
            return ParserImpl.parseSetSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "GENERATOR")) {
            return ParserImpl.parseSetGenerator(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseSetSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SEARCH_PATH")) {
            return ParserImpl.parseSetSearchPath(ctx);
        }
        ParserImpl.parseUntilEOL(ctx);
        return IGNORE_NO_DELIMITER;
    }

    private static final Query parseSetCatalog(ParserContext ctx) {
        return ctx.dsl.setCatalog(ParserImpl.parseCatalogName(ctx));
    }

    private static final Query parseUse(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "USE");
        return ctx.dsl.setCatalog(ParserImpl.parseCatalogName(ctx));
    }

    private static final Query parseSetSchema(ParserContext ctx) {
        ParserImpl.parseIf(ctx, '=');
        return ctx.dsl.setSchema(ParserImpl.parseSchemaName(ctx));
    }

    private static final Query parseSetSearchPath(ParserContext ctx) {
        if (!ParserImpl.parseIf(ctx, '=')) {
            ParserImpl.parseKeyword(ctx, "TO");
        }
        Schema schema = null;
        do {
            Schema s = ParserImpl.parseSchemaName(ctx);
            if (schema != null) continue;
            schema = s;
        } while (ParserImpl.parseIf(ctx, ','));
        return ctx.dsl.setSchema(schema);
    }

    private static final DDLQuery parseCommentOn(ParserContext ctx) {
        CommentOnIsStep s1;
        ParserImpl.parseKeyword(ctx, "COMMENT ON");
        if (ParserImpl.parseKeywordIf(ctx, "COLUMN")) {
            s1 = ctx.dsl.commentOnColumn(ParserImpl.parseFieldName(ctx));
        } else if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            s1 = ctx.dsl.commentOnTable(ParserImpl.parseTableName(ctx));
        } else if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            s1 = ctx.dsl.commentOnView(ParserImpl.parseTableName(ctx));
        } else {
            if (ParserImpl.parseAndGetKeywordIf(ctx, "ACCESS METHOD", "AUDIT POLICY", "COLLATION", "CONVERSION", "DATABASE", "DOMAIN", "EDITION", "EXTENSION", "EVENT TRIGGER", "FOREIGN DATA WRAPPER", "FOREIGN TABLE", "INDEX", "INDEXTYPE", "LANGUAGE", "LARGE OBJECT", "MATERIALIZED VIEW", "MINING MODEL", "OPERATOR", "PROCEDURAL LANGUAGE", "PUBLICATION", "ROLE", "SCHEMA", "SEQUENCE", "SERVER", "STATISTICS", "SUBSCRIPTION", "TABLESPACE", "TEXT SEARCH CONFIGURATION", "TEXT SEARCH DICTIONARY", "TEXT SEARCH PARSER", "TEXT SEARCH TEMPLATE", "TYPE", "VIEW") != null) {
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "IS");
                ParserImpl.parseStringLiteral(ctx);
                return IGNORE;
            }
            if (ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) {
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "ON");
                ParserImpl.parseKeywordIf(ctx, "DOMAIN");
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "IS");
                ParserImpl.parseStringLiteral(ctx);
                return IGNORE;
            }
            if (ParserImpl.parseAndGetKeywordIf(ctx, "POLICY", "RULE", "TRIGGER") != null) {
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "ON");
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "IS");
                ParserImpl.parseStringLiteral(ctx);
                return IGNORE;
            }
            if (ParserImpl.parseKeywordIf(ctx, "TRANSFORM FOR")) {
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "LANGUAGE");
                ParserImpl.parseIdentifier(ctx);
                ParserImpl.parseKeyword(ctx, "IS");
                ParserImpl.parseStringLiteral(ctx);
                return IGNORE;
            }
            throw ctx.unsupportedClause();
        }
        ParserImpl.parseKeyword(ctx, "IS");
        return s1.is(ParserImpl.parseStringLiteral(ctx));
    }

    private static final DDLQuery parseCreate(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "CREATE");
        if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            return ParserImpl.parseCreateTable(ctx, false);
        }
        if (ParserImpl.parseKeywordIf(ctx, "TEMPORARY TABLE")) {
            return ParserImpl.parseCreateTable(ctx, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "GENERATOR")) {
            return ParserImpl.parseCreateSequence(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "GLOBAL TEMPORARY TABLE")) {
            return ParserImpl.parseCreateTable(ctx, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
            return ParserImpl.parseCreateIndex(ctx, false);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SPATIAL INDEX") && ctx.requireUnsupportedSyntax()) {
            return ParserImpl.parseCreateIndex(ctx, false);
        }
        if (ParserImpl.parseKeywordIf(ctx, "FULLTEXT INDEX") && ctx.requireUnsupportedSyntax()) {
            return ParserImpl.parseCreateIndex(ctx, false);
        }
        if (ParserImpl.parseKeywordIf(ctx, "UNIQUE INDEX")) {
            return ParserImpl.parseCreateIndex(ctx, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseCreateSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SEQUENCE")) {
            return ParserImpl.parseCreateSequence(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "OR REPLACE VIEW")) {
            return ParserImpl.parseCreateView(ctx, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "OR ALTER VIEW")) {
            return ParserImpl.parseCreateView(ctx, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            return ParserImpl.parseCreateView(ctx, false);
        }
        throw ctx.expected("GENERATOR", "GLOBAL TEMPORARY TABLE", "INDEX", "OR ALTER VIEW", "OR REPLACE VIEW", "SCHEMA", "SEQUENCE", "TABLE", "TEMPORARY TABLE", "UNIQUE INDEX", "VIEW");
    }

    private static final Query parseAlter(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "ALTER");
        if (ParserImpl.parseKeywordIf(ctx, "DOMAIN")) {
            return ParserImpl.parseAlterDomain(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
            return ParserImpl.parseAlterIndex(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseAlterSchema(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SEQUENCE")) {
            return ParserImpl.parseAlterSequence(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SESSION")) {
            return ParserImpl.parseAlterSession(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            return ParserImpl.parseAlterTable(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            return ParserImpl.parseAlterView(ctx);
        }
        throw ctx.expected("DOMAIN", "INDEX", "SCHEMA", "SEQUENCE", "SESSION", "TABLE", "VIEW");
    }

    private static final DDLQuery parseDrop(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "DROP");
        if (ParserImpl.parseKeywordIf(ctx, "TABLE")) {
            return ParserImpl.parseDropTable(ctx, false);
        }
        if (ParserImpl.parseKeywordIf(ctx, "TEMPORARY TABLE")) {
            return ParserImpl.parseDropTable(ctx, true);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
            return ParserImpl.parseDropIndex(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VIEW")) {
            return ParserImpl.parseDropView(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "GENERATOR")) {
            return ParserImpl.parseDropSequence(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SEQUENCE")) {
            return ParserImpl.parseDropSequence(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
            return ParserImpl.parseDropSchema(ctx);
        }
        throw ctx.expected("GENERATOR", "INDEX", "SCHEMA", "SEQUENCE", "TABLE", "TEMPORARY TABLE", "VIEW");
    }

    private static final Truncate<?> parseTruncate(ParserContext ctx) {
        TruncateCascadeStep<?> step2;
        ParserImpl.parseKeyword(ctx, "TRUNCATE");
        ParserImpl.parseKeyword(ctx, "TABLE");
        Table<?> table = ParserImpl.parseTableName(ctx);
        boolean continueIdentity = ParserImpl.parseKeywordIf(ctx, "CONTINUE IDENTITY");
        boolean restartIdentity = !continueIdentity && ParserImpl.parseKeywordIf(ctx, "RESTART IDENTITY");
        boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
        boolean restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
        TruncateIdentityStep<?> step1 = ctx.dsl.truncate(table);
        TruncateCascadeStep<?> truncateCascadeStep = continueIdentity ? step1.continueIdentity() : (step2 = restartIdentity ? step1.restartIdentity() : step1);
        TruncateFinalStep<?> step3 = cascade ? step2.cascade() : (restrict ? step2.restrict() : step2);
        return step3;
    }

    private static final DDLQuery parseGrant(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "GRANT");
        Privilege privilege = ParserImpl.parsePrivilege(ctx);
        ArrayList<Privilege> privileges = null;
        while (ParserImpl.parseIf(ctx, ',')) {
            if (privileges == null) {
                privileges = new ArrayList<Privilege>();
                privileges.add(privilege);
            }
            privileges.add(ParserImpl.parsePrivilege(ctx));
        }
        ParserImpl.parseKeyword(ctx, "ON");
        ParserImpl.parseKeywordIf(ctx, "TABLE");
        Table<?> table = ParserImpl.parseTableName(ctx);
        ParserImpl.parseKeyword(ctx, "TO");
        User user = ParserImpl.parseKeywordIf(ctx, "PUBLIC") ? null : ParserImpl.parseUser(ctx);
        GrantOnStep s1 = privileges == null ? ctx.dsl.grant(privilege) : ctx.dsl.grant(privileges);
        GrantToStep s2 = s1.on(table);
        GrantWithGrantOptionStep s3 = user == null ? s2.toPublic() : s2.to(user);
        return ParserImpl.parseKeywordIf(ctx, "WITH GRANT OPTION") ? s3.withGrantOption() : s3;
    }

    private static final DDLQuery parseRevoke(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "REVOKE");
        boolean grantOptionFor = ParserImpl.parseKeywordIf(ctx, "GRANT OPTION FOR");
        Privilege privilege = ParserImpl.parsePrivilege(ctx);
        ArrayList<Privilege> privileges = null;
        while (ParserImpl.parseIf(ctx, ',')) {
            if (privileges == null) {
                privileges = new ArrayList<Privilege>();
                privileges.add(privilege);
            }
            privileges.add(ParserImpl.parsePrivilege(ctx));
        }
        ParserImpl.parseKeyword(ctx, "ON");
        ParserImpl.parseKeywordIf(ctx, "TABLE");
        Table<?> table = ParserImpl.parseTableName(ctx);
        RevokeOnStep s1 = grantOptionFor ? (privileges == null ? ctx.dsl.revokeGrantOptionFor(privilege) : ctx.dsl.revokeGrantOptionFor(privileges)) : (privileges == null ? ctx.dsl.revoke(privilege) : ctx.dsl.revoke(privileges));
        ParserImpl.parseKeyword(ctx, "FROM");
        User user = ParserImpl.parseKeywordIf(ctx, "PUBLIC") ? null : ParserImpl.parseUser(ctx);
        RevokeFromStep s2 = s1.on(table);
        return user == null ? s2.fromPublic() : s2.from(user);
    }

    private static final Query parseExec(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "EXEC");
        if (ParserImpl.parseKeywordIf(ctx, "SP_RENAME")) {
            if (ParserImpl.parseKeywordIf(ctx, "@OBJNAME")) {
                ParserImpl.parse(ctx, '=');
            }
            Name oldName = ctx.dsl.parser().parseName(ParserImpl.parseStringLiteral(ctx));
            ParserImpl.parse(ctx, ',');
            if (ParserImpl.parseKeywordIf(ctx, "@NEWNAME")) {
                ParserImpl.parse(ctx, '=');
            }
            Name newName = ctx.dsl.parser().parseName(ParserImpl.parseStringLiteral(ctx));
            String objectType = "TABLE";
            if (ParserImpl.parseIf(ctx, ',')) {
                if (ParserImpl.parseKeywordIf(ctx, "@OBJTYPE")) {
                    ParserImpl.parse(ctx, '=');
                }
                if (!ParserImpl.parseKeywordIf(ctx, "NULL")) {
                    objectType = ParserImpl.parseStringLiteral(ctx);
                }
            }
            if ("TABLE".equalsIgnoreCase(objectType)) {
                return ctx.dsl.alterTable(oldName).renameTo(newName.unqualifiedName());
            }
            if ("INDEX".equalsIgnoreCase(objectType)) {
                return ctx.dsl.alterIndex(oldName).renameTo(newName.unqualifiedName());
            }
            if ("COLUMN".equalsIgnoreCase(objectType)) {
                return ctx.dsl.alterTable(oldName.qualifier()).renameColumn(oldName.unqualifiedName()).to(newName.unqualifiedName());
            }
            throw ctx.exception("Unsupported object type: " + objectType);
        }
        throw ctx.unsupportedClause();
    }

    private static final Block parseBlock(ParserContext ctx) {
        ParserImpl.parseKeywordIf(ctx, "EXECUTE BLOCK AS");
        ParserImpl.parseKeyword(ctx, "BEGIN");
        ArrayList<Statement> statements = new ArrayList<Statement>();
        do {
            Statement statement = ParserImpl.parseStatement(ctx);
            statements.add(statement);
            if (statement instanceof Block) continue;
            ParserImpl.parse(ctx, ';');
        } while (!ParserImpl.parseKeywordIf(ctx, "END"));
        ParserImpl.parse(ctx, ';');
        return ctx.dsl.begin(statements);
    }

    private static final Block parseDo(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "DO");
        String block = ParserImpl.parseStringLiteral(ctx);
        return (Block)ctx.dsl.parser().parseQuery(block);
    }

    private static final Statement parseStatement(ParserContext ctx) {
        switch (ctx.character()) {
            case 'N': 
            case 'n': {
                if (!ParserImpl.peekKeyword(ctx, "NULL")) break;
                return ParserImpl.parseNullStatement(ctx);
            }
        }
        return ParserImpl.parseQuery(ctx, false, false);
    }

    private static final Statement parseNullStatement(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "NULL");
        return new NullStatement();
    }

    private static final Privilege parsePrivilege(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "SELECT")) {
            return DSL.privilege(Keywords.K_SELECT);
        }
        if (ParserImpl.parseKeywordIf(ctx, "INSERT")) {
            return DSL.privilege(Keywords.K_INSERT);
        }
        if (ParserImpl.parseKeywordIf(ctx, "UPDATE")) {
            return DSL.privilege(Keywords.K_UPDATE);
        }
        if (ParserImpl.parseKeywordIf(ctx, "DELETE")) {
            return DSL.privilege(Keywords.K_DELETE);
        }
        throw ctx.expected("DELETE", "INSERT", "SELECT", "UPDATE");
    }

    private static final User parseUser(ParserContext ctx) {
        return DSL.user(ParserImpl.parseName(ctx));
    }

    private static final DDLQuery parseCreateView(ParserContext ctx, boolean orReplace) {
        boolean ifNotExists = !orReplace && ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Table<?> view = ParserImpl.parseTableName(ctx);
        Field<?>[] fields = Tools.EMPTY_FIELD;
        if (ParserImpl.parseIf(ctx, '(')) {
            fields = ParserImpl.parseFieldNames(ctx).toArray(fields);
            ParserImpl.parse(ctx, ')');
        }
        ParserImpl.parseKeyword(ctx, "AS");
        SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
        if (fields.length > 0 && fields.length != select.getSelect().size()) {
            throw ctx.exception("Select list size (" + select.getSelect().size() + ") must match declared field size (" + fields.length + ")");
        }
        return ifNotExists ? ctx.dsl.createViewIfNotExists(view, fields).as(select) : (orReplace ? ctx.dsl.createOrReplaceView(view, fields).as(select) : ctx.dsl.createView(view, fields).as(select));
    }

    private static final DDLQuery parseAlterView(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> oldName = ParserImpl.parseTableName(ctx);
        ParserImpl.parseKeyword(ctx, "RENAME");
        if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
            ParserImpl.parseKeyword(ctx, "TO");
        }
        Table<?> newName = ParserImpl.parseTableName(ctx);
        return ifExists ? ctx.dsl.alterViewIfExists(oldName).renameTo(newName) : ctx.dsl.alterView(oldName).renameTo(newName);
    }

    private static final DDLQuery parseDropView(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        DropViewFinalStep s1 = ifExists ? ctx.dsl.dropViewIfExists(tableName) : ctx.dsl.dropView(tableName);
        return s1;
    }

    private static final DDLQuery parseCreateSequence(ParserContext ctx) {
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Sequence<?> schemaName = ParserImpl.parseSequenceName(ctx);
        return ifNotExists ? ctx.dsl.createSequenceIfNotExists(schemaName) : ctx.dsl.createSequence(schemaName);
    }

    private static final DDLQuery parseAlterSequence(ParserContext ctx) {
        AlterSequenceStep<?> s1;
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Sequence<?> sequenceName = ParserImpl.parseSequenceName(ctx);
        AlterSequenceStep<?> alterSequenceStep = s1 = ifExists ? ctx.dsl.alterSequenceIfExists(sequenceName) : ctx.dsl.alterSequence(sequenceName);
        if (ParserImpl.parseKeywordIf(ctx, "RENAME")) {
            if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                ParserImpl.parseKeyword(ctx, "TO");
            }
            return s1.renameTo(ParserImpl.parseSequenceName(ctx));
        }
        if (ParserImpl.parseKeywordIf(ctx, "RESTART")) {
            if (ParserImpl.parseKeywordIf(ctx, "WITH")) {
                return s1.restartWith(ParserImpl.parseUnsignedInteger(ctx));
            }
            return s1.restart();
        }
        throw ctx.expected("RENAME TO", "RESTART");
    }

    private static final Query parseAlterSession(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "SET CURRENT_SCHEMA");
        ParserImpl.parse(ctx, '=');
        return ctx.dsl.setSchema(ParserImpl.parseSchemaName(ctx));
    }

    private static final DDLQuery parseSetGenerator(ParserContext ctx) {
        Sequence<?> sequenceName = ParserImpl.parseSequenceName(ctx);
        ParserImpl.parseKeyword(ctx, "TO");
        return ctx.dsl.alterSequence(sequenceName).restartWith(ParserImpl.parseUnsignedInteger(ctx));
    }

    private static final DDLQuery parseDropSequence(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Sequence<?> sequenceName = ParserImpl.parseSequenceName(ctx);
        return ifExists ? ctx.dsl.dropSequenceIfExists(sequenceName) : ctx.dsl.dropSequence(sequenceName);
    }

    private static final DDLQuery parseCreateTable(ParserContext ctx, boolean temporary) {
        CreateTableStorageStep storageStep;
        CreateTableCommentStep commentStep;
        boolean ifNotExists = !temporary && ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Table<Record> tableName = DSL.table(ParserImpl.parseTableName(ctx).getQualifiedName());
        if (ParserImpl.parseKeywordIf(ctx, "AS")) {
            Select select = (Select)ParserImpl.parseQuery(ctx, true, true);
            CreateTableAsStep<Record> s1 = ifNotExists ? ctx.dsl.createTableIfNotExists(tableName) : (temporary ? ctx.dsl.createTemporaryTable(tableName) : ctx.dsl.createTable(tableName));
            CreateTableWithDataStep s2 = s1.as(select);
            commentStep = ParserImpl.parseKeywordIf(ctx, "WITH DATA") ? s2.withData() : (ParserImpl.parseKeywordIf(ctx, "WITH NO DATA") ? s2.withNoData() : s2);
            storageStep = commentStep;
        } else {
            CreateTableColumnStep s4;
            ArrayList fields = new ArrayList();
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            ArrayList<Index> indexes = new ArrayList<Index>();
            boolean primary = false;
            ParserImpl.parse(ctx, '(');
            do {
                ConstraintTypeStep constraint = null;
                int position = ctx.position();
                if (ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) {
                    constraint = DSL.constraint(ParserImpl.parseIdentifier(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                    if (primary) {
                        throw ctx.exception("Duplicate primary key specification");
                    }
                    primary = true;
                    constraints.add(ParserImpl.parsePrimaryKeySpecification(ctx, constraint));
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                    if (!ParserImpl.parseKeywordIf(ctx, "KEY")) {
                        ParserImpl.parseKeywordIf(ctx, "INDEX");
                    }
                    constraints.add(ParserImpl.parseUniqueSpecification(ctx, constraint));
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "FOREIGN KEY")) {
                    constraints.add(ParserImpl.parseForeignKeySpecification(ctx, constraint));
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
                    constraints.add(ParserImpl.parseCheckSpecification(ctx, constraint));
                    continue;
                }
                if (constraint == null && (ParserImpl.parseKeywordIf(ctx, "KEY") || ParserImpl.parseKeywordIf(ctx, "INDEX"))) {
                    int p2 = ctx.position();
                    if (ParserImpl.parseIf(ctx, '(') || ParserImpl.parseIdentifierIf(ctx) != null && ParserImpl.parseIf(ctx, '(')) {
                        ctx.position(p2);
                        indexes.add(ParserImpl.parseIndexSpecification(ctx, tableName));
                        continue;
                    }
                    ctx.position(position);
                } else if (constraint != null) {
                    throw ctx.expected("CHECK", "CONSTRAINT", "FOREIGN KEY", "INDEX", "KEY", "PRIMARY KEY", "UNIQUE");
                }
                Name fieldName = ParserImpl.parseIdentifier(ctx);
                DataType<?> type = ParserImpl.parseDataType(ctx);
                Comment fieldComment = null;
                boolean nullable = false;
                boolean defaultValue = false;
                boolean onUpdate = false;
                boolean unique = false;
                boolean identity = type.identity();
                boolean comment = false;
                while (true) {
                    if (!nullable) {
                        if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
                            type = type.nullable(true);
                            nullable = true;
                            continue;
                        }
                        if (ParserImpl.parseKeywordIf(ctx, "NOT NULL")) {
                            type = type.nullable(false);
                            nullable = true;
                            continue;
                        }
                    }
                    if (!defaultValue) {
                        if (ParserImpl.parseKeywordIf(ctx, "IDENTITY")) {
                            if (ParserImpl.parseIf(ctx, '(')) {
                                ParserImpl.parseSignedInteger(ctx);
                                ParserImpl.parse(ctx, ',');
                                ParserImpl.parseSignedInteger(ctx);
                                ParserImpl.parse(ctx, ')');
                            }
                            type = type.identity(true);
                            defaultValue = true;
                            identity = true;
                            continue;
                        }
                        if (ParserImpl.parseKeywordIf(ctx, "DEFAULT")) {
                            ParserImpl.parseKeywordIf(ctx, "ON NULL");
                            type = type.defaultValue(ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, null)));
                            defaultValue = true;
                            identity = true;
                            continue;
                        }
                        if (ParserImpl.parseKeywordIf(ctx, "GENERATED")) {
                            if (!ParserImpl.parseKeywordIf(ctx, "ALWAYS")) {
                                ParserImpl.parseKeyword(ctx, "BY DEFAULT");
                                ParserImpl.parseKeywordIf(ctx, "ON NULL");
                            }
                            ParserImpl.parseKeyword(ctx, "AS IDENTITY");
                            if (ParserImpl.parseIf(ctx, '(')) {
                                boolean identityOption = false;
                                while (true) {
                                    if (identityOption) {
                                        ParserImpl.parseIf(ctx, ',');
                                    }
                                    if (ParserImpl.parseKeywordIf(ctx, "START WITH")) {
                                        if (!ParserImpl.parseKeywordIf(ctx, "LIMIT VALUE")) {
                                            ParserImpl.parseUnsignedInteger(ctx);
                                        }
                                        identityOption = true;
                                        continue;
                                    }
                                    if (ParserImpl.parseKeywordIf(ctx, "INCREMENT BY") || ParserImpl.parseKeywordIf(ctx, "MAXVALUE") || ParserImpl.parseKeywordIf(ctx, "MINVALUE") || ParserImpl.parseKeywordIf(ctx, "CACHE")) {
                                        ParserImpl.parseUnsignedInteger(ctx);
                                        identityOption = true;
                                        continue;
                                    }
                                    if (!ParserImpl.parseKeywordIf(ctx, "NOMAXVALUE") && !ParserImpl.parseKeywordIf(ctx, "NOMINVALUE") && !ParserImpl.parseKeywordIf(ctx, "CYCLE") && !ParserImpl.parseKeywordIf(ctx, "NOCYCLE") && !ParserImpl.parseKeywordIf(ctx, "NOCACHE") && !ParserImpl.parseKeywordIf(ctx, "ORDER") && !ParserImpl.parseKeywordIf(ctx, "NOORDER")) break;
                                    identityOption = true;
                                }
                                if (!identityOption) {
                                    throw ctx.unsupportedClause();
                                }
                                ParserImpl.parse(ctx, ')');
                            }
                            type = type.identity(true);
                            defaultValue = true;
                            identity = true;
                            continue;
                        }
                    }
                    if (!onUpdate && ParserImpl.parseKeywordIf(ctx, "ON UPDATE")) {
                        ParserImpl.parseConcat(ctx, null);
                        onUpdate = true;
                        continue;
                    }
                    if (!unique) {
                        if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                            constraints.add(DSL.primaryKey(fieldName));
                            primary = true;
                            unique = true;
                            continue;
                        }
                        if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                            if (!ParserImpl.parseKeywordIf(ctx, "KEY")) {
                                ParserImpl.parseKeywordIf(ctx, "INDEX");
                            }
                            constraints.add(DSL.unique(fieldName));
                            unique = true;
                            continue;
                        }
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
                        constraints.add(ParserImpl.parseCheckSpecification(ctx, null));
                        continue;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "REFERENCES")) {
                        constraints.add(ParserImpl.parseForeignKeyReferenceSpecification(ctx, null, new Field[]{DSL.field(fieldName)}));
                        continue;
                    }
                    if (!identity && (ParserImpl.parseKeywordIf(ctx, "AUTO_INCREMENT") || ParserImpl.parseKeywordIf(ctx, "AUTOINCREMENT"))) {
                        type = type.identity(true);
                        identity = true;
                        continue;
                    }
                    if (comment || !ParserImpl.parseKeywordIf(ctx, "COMMENT")) break;
                    fieldComment = ParserImpl.parseComment(ctx);
                }
                fields.add(DSL.field(fieldName, type, fieldComment));
            } while (ParserImpl.parseIf(ctx, ','));
            if (fields.isEmpty()) {
                throw ctx.expected("At least one column");
            }
            ParserImpl.parse(ctx, ')');
            CreateTableAsStep<Record> s1 = ifNotExists ? ctx.dsl.createTableIfNotExists(tableName) : (temporary ? ctx.dsl.createTemporaryTable(tableName) : ctx.dsl.createTable(tableName));
            CreateTableColumnStep s2 = s1.columns(fields);
            CreateTableColumnStep s3 = constraints.isEmpty() ? s2 : s2.constraints(constraints);
            CreateTableCommentStep s5 = s4 = indexes.isEmpty() ? s3 : s3.indexes(indexes);
            if (temporary && ParserImpl.parseKeywordIf(ctx, "ON COMMIT")) {
                if (ParserImpl.parseKeywordIf(ctx, "DELETE ROWS")) {
                    s5 = s4.onCommitDeleteRows();
                } else if (ParserImpl.parseKeywordIf(ctx, "DROP")) {
                    s5 = s4.onCommitDrop();
                } else if (ParserImpl.parseKeywordIf(ctx, "PRESERVE ROWS")) {
                    s5 = s4.onCommitPreserveRows();
                } else {
                    throw ctx.unsupportedClause();
                }
            }
            commentStep = s5;
            storageStep = commentStep;
        }
        ArrayList<SQL> storage = new ArrayList<SQL>();
        Comment comment = null;
        boolean first = true;
        while (true) {
            boolean optional = first || !ParserImpl.parseIf(ctx, ',');
            Keyword keyword = null;
            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "AUTO_INCREMENT");
            if (keyword != null) {
                ParserImpl.parseIf(ctx, '=');
                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE)));
            } else {
                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "AVG_ROW_LENGTH");
                if (keyword != null) {
                    ParserImpl.parseIf(ctx, '=');
                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE)));
                } else {
                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "CHARACTER SET");
                    if (keyword != null) {
                        ParserImpl.parseIf(ctx, '=');
                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseIdentifier(ctx)));
                    } else {
                        keyword = ParserImpl.parseAndGetKeywordIf(ctx, "DEFAULT CHARACTER SET");
                        if (keyword != null || (keyword = ParserImpl.parseAndGetKeywordIf(ctx, "DEFAULT CHARSET")) != null) {
                            ParserImpl.parseIf(ctx, '=');
                            storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseIdentifier(ctx)));
                        } else {
                            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "CHECKSUM");
                            if (keyword != null) {
                                ParserImpl.parseIf(ctx, '=');
                                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseZeroOne(ctx)));
                            } else {
                                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "COLLATE");
                                if (keyword != null) {
                                    ParserImpl.parseIf(ctx, '=');
                                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseIdentifier(ctx)));
                                } else {
                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "DEFAULT COLLATE");
                                    if (keyword != null) {
                                        ParserImpl.parseIf(ctx, '=');
                                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseIdentifier(ctx)));
                                    } else {
                                        keyword = ParserImpl.parseAndGetKeywordIf(ctx, "COMMENT");
                                        if (keyword != null) {
                                            ParserImpl.parseIf(ctx, '=');
                                            comment = ParserImpl.parseComment(ctx);
                                        } else {
                                            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "COMPRESSION");
                                            if (keyword != null) {
                                                ParserImpl.parseIf(ctx, '=');
                                                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseStringLiteral(ctx)));
                                            } else {
                                                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "CONNECTION");
                                                if (keyword != null) {
                                                    ParserImpl.parseIf(ctx, '=');
                                                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseStringLiteral(ctx)));
                                                } else {
                                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "DATA DIRECTORY");
                                                    if (keyword != null) {
                                                        ParserImpl.parseIf(ctx, '=');
                                                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseStringLiteral(ctx)));
                                                    } else {
                                                        keyword = ParserImpl.parseAndGetKeywordIf(ctx, "INDEX DIRECTORY");
                                                        if (keyword != null) {
                                                            ParserImpl.parseIf(ctx, '=');
                                                            storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseStringLiteral(ctx)));
                                                        } else {
                                                            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "DELAY_KEY_WRITE");
                                                            if (keyword != null) {
                                                                ParserImpl.parseIf(ctx, '=');
                                                                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseZeroOne(ctx)));
                                                            } else {
                                                                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "ENCRYPTION");
                                                                if (keyword != null) {
                                                                    ParserImpl.parseIf(ctx, '=');
                                                                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseStringLiteral(ctx)));
                                                                } else {
                                                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "ENGINE");
                                                                    if (keyword != null) {
                                                                        ParserImpl.parseIf(ctx, '=');
                                                                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseIdentifier(ctx)));
                                                                    } else {
                                                                        keyword = ParserImpl.parseAndGetKeywordIf(ctx, "INSERT_METHOD");
                                                                        if (keyword != null) {
                                                                            ParserImpl.parseIf(ctx, '=');
                                                                            storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseAndGetKeyword(ctx, "NO", "FIRST", "LAST")));
                                                                        } else {
                                                                            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "KEY_BLOCK_SIZE");
                                                                            if (keyword != null) {
                                                                                ParserImpl.parseIf(ctx, '=');
                                                                                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE)));
                                                                            } else {
                                                                                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "MAX_ROWS");
                                                                                if (keyword != null) {
                                                                                    ParserImpl.parseIf(ctx, '=');
                                                                                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE)));
                                                                                } else {
                                                                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "MIN_ROWS");
                                                                                    if (keyword != null) {
                                                                                        ParserImpl.parseIf(ctx, '=');
                                                                                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE)));
                                                                                    } else {
                                                                                        keyword = ParserImpl.parseAndGetKeywordIf(ctx, "PACK_KEYS");
                                                                                        if (keyword != null) {
                                                                                            ParserImpl.parseIf(ctx, '=');
                                                                                            storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseZeroOneDefault(ctx)));
                                                                                        } else {
                                                                                            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "PASSWORD");
                                                                                            if (keyword != null) {
                                                                                                ParserImpl.parseIf(ctx, '=');
                                                                                                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseStringLiteral(ctx)));
                                                                                            } else {
                                                                                                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "ROW_FORMAT");
                                                                                                if (keyword != null) {
                                                                                                    ParserImpl.parseIf(ctx, '=');
                                                                                                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseAndGetKeyword(ctx, "DEFAULT", "DYNAMIC", "FIXED", "COMPRESSED", "REDUNDANT", "COMPACT")));
                                                                                                } else {
                                                                                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "STATS_AUTO_RECALC");
                                                                                                    if (keyword != null) {
                                                                                                        ParserImpl.parseIf(ctx, '=');
                                                                                                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseZeroOneDefault(ctx)));
                                                                                                    } else {
                                                                                                        keyword = ParserImpl.parseAndGetKeywordIf(ctx, "STATS_PERSISTENT");
                                                                                                        if (keyword != null) {
                                                                                                            ParserImpl.parseIf(ctx, '=');
                                                                                                            storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseZeroOneDefault(ctx)));
                                                                                                        } else {
                                                                                                            keyword = ParserImpl.parseAndGetKeywordIf(ctx, "STATS_SAMPLE_PAGES");
                                                                                                            if (keyword != null) {
                                                                                                                ParserImpl.parseIf(ctx, '=');
                                                                                                                storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE)));
                                                                                                            } else {
                                                                                                                keyword = ParserImpl.parseAndGetKeywordIf(ctx, "TABLESPACE");
                                                                                                                if (keyword != null) {
                                                                                                                    storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseIdentifier(ctx)));
                                                                                                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "STORAGE");
                                                                                                                    if (keyword != null) {
                                                                                                                        storage.add(DSL.sql("{0} {1}", keyword, ParserImpl.parseAndGetKeyword(ctx, "DISK", "MEMORY", "DEFAULT")));
                                                                                                                    }
                                                                                                                } else {
                                                                                                                    keyword = ParserImpl.parseAndGetKeywordIf(ctx, "UNION");
                                                                                                                    if (keyword != null) {
                                                                                                                        ParserImpl.parseIf(ctx, '=');
                                                                                                                        ParserImpl.parse(ctx, '(');
                                                                                                                        storage.add(DSL.sql("{0} ({1})", keyword, DSL.list(ParserImpl.parseIdentifiers(ctx))));
                                                                                                                        ParserImpl.parse(ctx, ')');
                                                                                                                    } else {
                                                                                                                        if (optional) break;
                                                                                                                        throw ctx.expected("storage clause after ','");
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            first = false;
        }
        if (comment != null) {
            storageStep = commentStep.comment(comment);
        }
        if (storage.size() > 0) {
            return storageStep.storage(new SQLConcatenationImpl(storage.toArray(Tools.EMPTY_QUERYPART)));
        }
        return storageStep;
    }

    private static final Index parseIndexSpecification(ParserContext ctx, Table<?> table) {
        Name name = ParserImpl.parseIdentifierIf(ctx);
        ParserImpl.parse(ctx, '(');
        SortField<?>[] fields = ParserImpl.parseSortSpecification(ctx).toArray(Tools.EMPTY_SORTFIELD);
        ParserImpl.parse(ctx, ')');
        return Internal.createIndex(name == null ? DSL.name("") : name, table, fields, false);
    }

    private static final boolean parseConstraintStateIf(ParserContext ctx) {
        ParserImpl.parseKeywordIf(ctx, "ENABLE");
        return true;
    }

    private static final Constraint parsePrimaryKeySpecification(ParserContext ctx, ConstraintTypeStep constraint) {
        ParserImpl.parse(ctx, '(');
        Field<?>[] fieldNames = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
        ParserImpl.parse(ctx, ')');
        ConstraintFinalStep e = constraint == null ? DSL.primaryKey(fieldNames) : constraint.primaryKey(fieldNames);
        ParserImpl.parseConstraintStateIf(ctx);
        return e;
    }

    private static final Constraint parseUniqueSpecification(ParserContext ctx, ConstraintTypeStep constraint) {
        ParserImpl.parse(ctx, '(');
        Field<?>[] fieldNames = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
        ParserImpl.parse(ctx, ')');
        ConstraintFinalStep e = constraint == null ? DSL.unique(fieldNames) : constraint.unique(fieldNames);
        ParserImpl.parseConstraintStateIf(ctx);
        return e;
    }

    private static final Constraint parseCheckSpecification(ParserContext ctx, ConstraintTypeStep constraint) {
        ParserImpl.parse(ctx, '(');
        Condition condition = ParserImpl.parseCondition(ctx);
        ParserImpl.parse(ctx, ')');
        ConstraintFinalStep e = constraint == null ? DSL.check(condition) : constraint.check(condition);
        ParserImpl.parseConstraintStateIf(ctx);
        return e;
    }

    private static final Constraint parseForeignKeySpecification(ParserContext ctx, ConstraintTypeStep constraint) {
        ParserImpl.parse(ctx, '(');
        Field<?>[] referencing = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
        ParserImpl.parse(ctx, ')');
        ParserImpl.parseKeyword(ctx, "REFERENCES");
        return ParserImpl.parseForeignKeyReferenceSpecification(ctx, constraint, referencing);
    }

    private static final Constraint parseForeignKeyReferenceSpecification(ParserContext ctx, ConstraintTypeStep constraint, Field<?>[] referencing) {
        Table<?> referencedTable = ParserImpl.parseTableName(ctx);
        Field<?>[] referencedFields = Tools.EMPTY_FIELD;
        if (ParserImpl.parseIf(ctx, '(')) {
            referencedFields = ParserImpl.parseFieldNames(ctx).toArray(Tools.EMPTY_FIELD);
            ParserImpl.parse(ctx, ')');
            if (referencing.length != referencedFields.length) {
                throw ctx.exception("Number of referencing columns (" + referencing.length + ") must match number of referenced columns (" + referencedFields.length + ")");
            }
        }
        ConstraintForeignKeyOnStep e = constraint == null ? DSL.foreignKey(referencing).references(referencedTable, referencedFields) : constraint.foreignKey(referencing).references(referencedTable, referencedFields);
        boolean onDelete = false;
        boolean onUpdate = false;
        while (!(onDelete && onUpdate || !ParserImpl.parseKeywordIf(ctx, "ON"))) {
            if (!onDelete && ParserImpl.parseKeywordIf(ctx, "DELETE")) {
                onDelete = true;
                if (ParserImpl.parseKeywordIf(ctx, "CASCADE")) {
                    e = e.onDeleteCascade();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "NO ACTION")) {
                    e = e.onDeleteNoAction();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "RESTRICT")) {
                    e = e.onDeleteRestrict();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "SET DEFAULT")) {
                    e = e.onDeleteSetDefault();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "SET NULL")) {
                    e = e.onDeleteSetNull();
                    continue;
                }
                throw ctx.expected("CASCADE", "NO ACTION", "RESTRICT", "SET DEFAULT", "SET NULL");
            }
            if (!onUpdate && ParserImpl.parseKeywordIf(ctx, "UPDATE")) {
                onUpdate = true;
                if (ParserImpl.parseKeywordIf(ctx, "CASCADE")) {
                    e = e.onUpdateCascade();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "NO ACTION")) {
                    e = e.onUpdateNoAction();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "RESTRICT")) {
                    e = e.onUpdateRestrict();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "SET DEFAULT")) {
                    e = e.onUpdateSetDefault();
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "SET NULL")) {
                    e = e.onUpdateSetNull();
                    continue;
                }
                throw ctx.expected("CASCADE", "NO ACTION", "RESTRICT", "SET DEFAULT", "SET NULL");
            }
            throw ctx.expected("DELETE", "UPDATE");
        }
        ParserImpl.parseConstraintStateIf(ctx);
        return e;
    }

    private static final DDLQuery parseAlterTable(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        AlterTableStep s1 = ifExists ? ctx.dsl.alterTableIfExists(tableName) : ctx.dsl.alterTable(tableName);
        switch (ctx.character()) {
            case 'A': 
            case 'a': {
                if (ParserImpl.parseKeywordIf(ctx, "ADD")) {
                    return ParserImpl.parseAlterTableAdd(ctx, s1, tableName);
                }
                if (!ParserImpl.parseKeywordIf(ctx, "ALTER")) break;
                if (!ParserImpl.parseKeywordIf(ctx, "COLUMN")) {
                    // empty if block
                }
                return ParserImpl.parseAlterTableAlterColumn(ctx, s1);
            }
            case 'C': 
            case 'c': {
                if (!ParserImpl.parseKeywordIf(ctx, "COMMENT")) break;
                ParserImpl.parseIf(ctx, '=');
                return ctx.dsl.commentOnTable(tableName).is(ParserImpl.parseStringLiteral(ctx));
            }
            case 'D': 
            case 'd': {
                AlterTableDropStep s2;
                boolean cascade;
                if (!ParserImpl.parseKeywordIf(ctx, "DROP")) break;
                if (ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) {
                    Name constraint = ParserImpl.parseIdentifier(ctx);
                    return s1.dropConstraint(constraint);
                }
                if (ParserImpl.parseKeywordIf(ctx, "INDEX") || ParserImpl.parseKeywordIf(ctx, "KEY")) {
                    Name index = ParserImpl.parseIdentifier(ctx);
                    return ctx.dsl.dropIndex(index).on(tableName);
                }
                ParserImpl.parseKeywordIf(ctx, "COLUMN");
                boolean parens = ParserImpl.parseIf(ctx, '(');
                TableField<?, ?> field = ParserImpl.parseFieldName(ctx);
                ArrayList fields = null;
                while (ParserImpl.parseIf(ctx, ',')) {
                    if (fields == null) {
                        fields = new ArrayList();
                        fields.add(field);
                    }
                    fields.add(ParserImpl.parseFieldName(ctx));
                }
                if (parens) {
                    ParserImpl.parse(ctx, ')');
                }
                boolean restrict = !(cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE")) && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
                AlterTableDropStep alterTableDropStep = s2 = fields == null ? s1.dropColumn(field) : s1.dropColumns(fields);
                AlterTableFinalStep s3 = cascade ? s2.cascade() : (restrict ? s2.restrict() : s2);
                return s3;
            }
            case 'M': 
            case 'm': {
                if (!ParserImpl.parseKeywordIf(ctx, "MODIFY")) break;
                if (!ParserImpl.parseKeywordIf(ctx, "COLUMN")) {
                    // empty if block
                }
                return ParserImpl.parseAlterTableAlterColumn(ctx, s1);
            }
            case 'R': 
            case 'r': {
                if (!ParserImpl.parseKeywordIf(ctx, "RENAME")) break;
                if (ParserImpl.parseKeywordIf(ctx, "AS") || ParserImpl.parseKeywordIf(ctx, "TO")) {
                    Table<?> newName = ParserImpl.parseTableName(ctx);
                    return s1.renameTo(newName);
                }
                if (ParserImpl.parseKeywordIf(ctx, "COLUMN")) {
                    Name oldName = ParserImpl.parseIdentifier(ctx);
                    if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                        ParserImpl.parseKeyword(ctx, "TO");
                    }
                    Name newName = ParserImpl.parseIdentifier(ctx);
                    return s1.renameColumn(oldName).to(newName);
                }
                if (ParserImpl.parseKeywordIf(ctx, "INDEX")) {
                    Name oldName = ParserImpl.parseIdentifier(ctx);
                    if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                        ParserImpl.parseKeyword(ctx, "TO");
                    }
                    Name newName = ParserImpl.parseIdentifier(ctx);
                    return s1.renameIndex(oldName).to(newName);
                }
                if (!ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) break;
                Name oldName = ParserImpl.parseIdentifier(ctx);
                if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                    ParserImpl.parseKeyword(ctx, "TO");
                }
                Name newName = ParserImpl.parseIdentifier(ctx);
                return s1.renameConstraint(oldName).to(newName);
            }
        }
        throw ctx.expected("ADD", "ALTER", "COMMENT", "DROP", "MODIFY", "RENAME");
    }

    private static final DDLQuery parseAlterTableAdd(ParserContext ctx, AlterTableStep s1, Table<?> tableName) {
        ArrayList<FieldOrConstraint> list = new ArrayList<FieldOrConstraint>();
        if ((ParserImpl.parseKeywordIf(ctx, "SPATIAL INDEX") || ParserImpl.parseKeywordIf(ctx, "SPATIAL KEY") || ParserImpl.parseKeywordIf(ctx, "FULLTEXT INDEX") || ParserImpl.parseKeywordIf(ctx, "FULLTEXT KEY")) && ctx.requireUnsupportedSyntax() || ParserImpl.parseKeywordIf(ctx, "INDEX") || ParserImpl.parseKeywordIf(ctx, "KEY")) {
            Name name = ParserImpl.parseIdentifierIf(ctx);
            ParserImpl.parse(ctx, '(');
            List<SortField<?>> sort = ParserImpl.parseSortSpecification(ctx);
            ParserImpl.parse(ctx, ')');
            return name == null ? ctx.dsl.createIndex().on(tableName, sort) : ctx.dsl.createIndex(name).on(tableName, sort);
        }
        if (ParserImpl.parseIf(ctx, '(')) {
            do {
                list.add(ParserImpl.parseAlterTableAddFieldOrConstraint(ctx));
            } while (ParserImpl.parseIf(ctx, ','));
            ParserImpl.parse(ctx, ')');
        } else {
            list.add(ParserImpl.parseAlterTableAddFieldOrConstraint(ctx));
        }
        if (list.size() == 1) {
            if (list.get(0) instanceof Constraint) {
                return s1.add((Constraint)list.get(0));
            }
            return s1.add((Field)list.get(0));
        }
        return s1.add(list);
    }

    private static final FieldOrConstraint parseAlterTableAddFieldOrConstraint(ParserContext ctx) {
        ConstraintTypeStep constraint = null;
        if (ParserImpl.parseKeywordIf(ctx, "CONSTRAINT")) {
            constraint = DSL.constraint(ParserImpl.parseIdentifier(ctx));
        }
        if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
            return ParserImpl.parsePrimaryKeySpecification(ctx, constraint);
        }
        if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
            if (!ParserImpl.parseKeywordIf(ctx, "KEY")) {
                ParserImpl.parseKeywordIf(ctx, "INDEX");
            }
            return ParserImpl.parseUniqueSpecification(ctx, constraint);
        }
        if (ParserImpl.parseKeywordIf(ctx, "FOREIGN KEY")) {
            return ParserImpl.parseForeignKeySpecification(ctx, constraint);
        }
        if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
            return ParserImpl.parseCheckSpecification(ctx, constraint);
        }
        if (constraint != null) {
            throw ctx.expected("CHECK", "FOREIGN KEY", "PRIMARY KEY", "UNIQUE");
        }
        ParserImpl.parseKeywordIf(ctx, "COLUMN");
        Name fieldName = ParserImpl.parseIdentifier(ctx);
        DataType<?> type = ParserImpl.parseDataType(ctx);
        Comment fieldComment = null;
        boolean nullable = false;
        boolean defaultValue = false;
        boolean onUpdate = false;
        boolean unique = false;
        boolean comment = false;
        while (true) {
            if (!nullable) {
                if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
                    type = type.nullable(true);
                    nullable = true;
                    continue;
                }
                if (ParserImpl.parseKeywordIf(ctx, "NOT NULL")) {
                    type = type.nullable(false);
                    nullable = true;
                    continue;
                }
            }
            if (!defaultValue && ParserImpl.parseKeywordIf(ctx, "DEFAULT")) {
                type = type.defaultValue(ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, null)));
                defaultValue = true;
                continue;
            }
            if (!onUpdate && ParserImpl.parseKeywordIf(ctx, "ON UPDATE")) {
                ParserImpl.parseConcat(ctx, null);
                onUpdate = true;
                continue;
            }
            if (!unique) {
                if (ParserImpl.parseKeywordIf(ctx, "PRIMARY KEY")) {
                    throw ctx.notImplemented("Inline primary key specification");
                }
                if (ParserImpl.parseKeywordIf(ctx, "UNIQUE")) {
                    throw ctx.notImplemented("Inline unique key specification");
                }
            }
            if (ParserImpl.parseKeywordIf(ctx, "CHECK")) {
                throw ctx.notImplemented("Inline check constraint specification");
            }
            if (comment || !ParserImpl.parseKeywordIf(ctx, "COMMENT")) break;
            fieldComment = ParserImpl.parseComment(ctx);
        }
        return DSL.field(fieldName, type, fieldComment);
    }

    private static final DDLQuery parseAlterTableAlterColumn(ParserContext ctx, AlterTableStep s1) {
        TableField<?, ?> field = ParserImpl.parseFieldName(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "DROP NOT NULL")) {
            return s1.alter(field).dropNotNull();
        }
        if (ParserImpl.parseKeywordIf(ctx, "SET NOT NULL")) {
            return s1.alter(field).setNotNull();
        }
        if (ParserImpl.parseKeywordIf(ctx, "TO") || ParserImpl.parseKeywordIf(ctx, "RENAME TO") || ParserImpl.parseKeywordIf(ctx, "RENAME AS")) {
            return s1.renameColumn(field).to(ParserImpl.parseFieldName(ctx));
        }
        if (ParserImpl.parseKeywordIf(ctx, "TYPE") || ParserImpl.parseKeywordIf(ctx, "SET DATA TYPE")) {
            // empty if block
        }
        DataType<?> type = ParserImpl.parseDataType(ctx);
        if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
            type = type.nullable(true);
        } else if (ParserImpl.parseKeywordIf(ctx, "NOT NULL")) {
            type = type.nullable(false);
        }
        return s1.alter(field).set(type);
    }

    private static final DDLQuery parseRename(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "RENAME");
        switch (ctx.character()) {
            case 'C': 
            case 'c': {
                if (!ParserImpl.parseKeywordIf(ctx, "COLUMN")) break;
                TableField<?, ?> oldName = ParserImpl.parseFieldName(ctx);
                if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                    ParserImpl.parseKeyword(ctx, "TO");
                }
                TableField<?, ?> newName = ParserImpl.parseFieldName(ctx);
                return ctx.dsl.alterTable(oldName.getTable()).renameColumn(oldName).to(newName);
            }
            case 'I': 
            case 'i': {
                if (!ParserImpl.parseKeywordIf(ctx, "INDEX")) break;
                Name oldName = ParserImpl.parseIndexName(ctx);
                if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                    ParserImpl.parseKeyword(ctx, "TO");
                }
                Name newName = ParserImpl.parseIndexName(ctx);
                return ctx.dsl.alterIndex(oldName).renameTo(newName);
            }
            case 'S': 
            case 's': {
                if (ParserImpl.parseKeywordIf(ctx, "SCHEMA")) {
                    Schema oldName = ParserImpl.parseSchemaName(ctx);
                    if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                        ParserImpl.parseKeyword(ctx, "TO");
                    }
                    Schema newName = ParserImpl.parseSchemaName(ctx);
                    return ctx.dsl.alterSchema(oldName).renameTo(newName);
                }
                if (!ParserImpl.parseKeywordIf(ctx, "SEQUENCE")) break;
                Sequence<?> oldName = ParserImpl.parseSequenceName(ctx);
                if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                    ParserImpl.parseKeyword(ctx, "TO");
                }
                Sequence<?> newName = ParserImpl.parseSequenceName(ctx);
                return ctx.dsl.alterSequence(oldName).renameTo(newName);
            }
            case 'V': 
            case 'v': {
                if (!ParserImpl.parseKeywordIf(ctx, "VIEW")) break;
                Table<?> oldName = ParserImpl.parseTableName(ctx);
                if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                    ParserImpl.parseKeyword(ctx, "TO");
                }
                Table<?> newName = ParserImpl.parseTableName(ctx);
                return ctx.dsl.alterView(oldName).renameTo(newName);
            }
        }
        ParserImpl.parseKeywordIf(ctx, "TABLE");
        Table<?> oldName = ParserImpl.parseTableName(ctx);
        if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
            ParserImpl.parseKeyword(ctx, "TO");
        }
        Table<?> newName = ParserImpl.parseTableName(ctx);
        return ctx.dsl.alterTable(oldName).renameTo(newName);
    }

    private static final DDLQuery parseDropTable(ParserContext ctx, boolean temporary) {
        DropTableStep s1;
        boolean restrict;
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
        boolean bl = restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
        DropTableStep dropTableStep = ifExists ? ctx.dsl.dropTableIfExists(tableName) : (s1 = temporary ? ctx.dsl.dropTemporaryTable(tableName) : ctx.dsl.dropTable(tableName));
        DropTableFinalStep s2 = cascade ? s1.cascade() : (restrict ? s1.restrict() : s1);
        return s2;
    }

    private static final DDLQuery parseCreateSchema(ParserContext ctx) {
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Schema schemaName = ParserImpl.parseSchemaName(ctx);
        return ifNotExists ? ctx.dsl.createSchemaIfNotExists(schemaName) : ctx.dsl.createSchema(schemaName);
    }

    private static final DDLQuery parseAlterSchema(ParserContext ctx) {
        AlterSchemaStep s1;
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Schema schemaName = ParserImpl.parseSchemaName(ctx);
        AlterSchemaStep alterSchemaStep = s1 = ifExists ? ctx.dsl.alterSchemaIfExists(schemaName) : ctx.dsl.alterSchema(schemaName);
        if (ParserImpl.parseKeywordIf(ctx, "RENAME")) {
            if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                ParserImpl.parseKeyword(ctx, "TO");
            }
            Schema newName = ParserImpl.parseSchemaName(ctx);
            AlterSchemaFinalStep s2 = s1.renameTo(newName);
            return s2;
        }
        if (ParserImpl.parseKeywordIf(ctx, "OWNER TO")) {
            ParserImpl.parseUser(ctx);
            return IGNORE;
        }
        throw ctx.expected("OWNER TO", "RENAME TO");
    }

    private static final DDLQuery parseDropSchema(ParserContext ctx) {
        DropSchemaStep s1;
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Schema schemaName = ParserImpl.parseSchemaName(ctx);
        boolean cascade = ParserImpl.parseKeywordIf(ctx, "CASCADE");
        boolean restrict = !cascade && ParserImpl.parseKeywordIf(ctx, "RESTRICT");
        DropSchemaStep dropSchemaStep = s1 = ifExists ? ctx.dsl.dropSchemaIfExists(schemaName) : ctx.dsl.dropSchema(schemaName);
        DropSchemaFinalStep s2 = cascade ? s1.cascade() : (restrict ? s1.restrict() : s1);
        return s2;
    }

    private static final DDLQuery parseCreateIndex(ParserContext ctx, boolean unique) {
        Condition condition;
        boolean ifNotExists = ParserImpl.parseKeywordIf(ctx, "IF NOT EXISTS");
        Name indexName = ParserImpl.parseIndexNameIf(ctx);
        ParserImpl.parseKeyword(ctx, "ON");
        Table<?> tableName = ParserImpl.parseTableName(ctx);
        ParserImpl.parseKeywordIf(ctx, "USING BTREE");
        ParserImpl.parse(ctx, '(');
        SortField<?>[] fields = ParserImpl.parseSortSpecification(ctx).toArray(Tools.EMPTY_SORTFIELD);
        ParserImpl.parse(ctx, ')');
        Name[] include = null;
        if (ParserImpl.parseKeywordIf(ctx, "INCLUDE")) {
            ParserImpl.parse(ctx, '(');
            include = ParserImpl.parseIdentifiers(ctx).toArray(Tools.EMPTY_NAME);
            ParserImpl.parse(ctx, ')');
        }
        Condition condition2 = condition = ParserImpl.parseKeywordIf(ctx, "WHERE") ? ParserImpl.parseCondition(ctx) : null;
        CreateIndexStep s1 = ifNotExists ? (unique ? ctx.dsl.createUniqueIndexIfNotExists(indexName) : ctx.dsl.createIndexIfNotExists(indexName)) : (unique ? (indexName == null ? ctx.dsl.createUniqueIndex() : ctx.dsl.createUniqueIndex(indexName)) : (indexName == null ? ctx.dsl.createIndex() : ctx.dsl.createIndex(indexName)));
        CreateIndexIncludeStep s2 = s1.on(tableName, fields);
        CreateIndexIncludeStep s3 = include != null ? s2.include(include) : s2;
        CreateIndexIncludeStep s4 = condition != null ? s3.where(condition) : s3;
        return s4;
    }

    private static final DDLQuery parseAlterDomain(ParserContext ctx) {
        ParserImpl.parseIdentifier(ctx);
        if (ParserImpl.parseAndGetKeywordIf(ctx, "DROP DEFAULT", "DROP NOT NULL", "SET NOT NULL") != null) {
            return IGNORE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "SET DEFAULT")) {
            ParserImpl.parseConcat(ctx, null);
            return IGNORE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "DROP CONSTRAINT")) {
            ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
            ParserImpl.parseIdentifier(ctx);
            if (ParserImpl.parseKeywordIf(ctx, "RESTRICT") || ParserImpl.parseKeywordIf(ctx, "CASCADE")) {
                // empty if block
            }
            return IGNORE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "RENAME CONSTRAINT")) {
            ParserImpl.parseIdentifier(ctx);
            if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
                ParserImpl.parseKeyword(ctx, "TO");
            }
            ParserImpl.parseIdentifier(ctx);
            return IGNORE;
        }
        if (ParserImpl.parseAndGetKeywordIf(ctx, "OWNER TO", "RENAME TO", "SET SCHEMA", "VALIDATE CONSTRAINT") != null) {
            ParserImpl.parseIdentifier(ctx);
            return IGNORE;
        }
        throw ctx.unsupportedClause();
    }

    private static final DDLQuery parseAlterIndex(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Name indexName = ParserImpl.parseIndexName(ctx);
        ParserImpl.parseKeyword(ctx, "RENAME");
        if (!ParserImpl.parseKeywordIf(ctx, "AS")) {
            ParserImpl.parseKeyword(ctx, "TO");
        }
        Name newName = ParserImpl.parseIndexName(ctx);
        AlterIndexStep s1 = ifExists ? ctx.dsl.alterIndexIfExists(indexName) : ctx.dsl.alterIndex(indexName);
        AlterIndexFinalStep s2 = s1.renameTo(newName);
        return s2;
    }

    private static final DDLQuery parseDropIndex(ParserContext ctx) {
        boolean ifExists = ParserImpl.parseKeywordIf(ctx, "IF EXISTS");
        Name indexName = ParserImpl.parseIndexName(ctx);
        boolean on = ParserImpl.parseKeywordIf(ctx, "ON");
        Table<?> onTable = on ? ParserImpl.parseTableName(ctx) : null;
        DropIndexOnStep s1 = ifExists ? ctx.dsl.dropIndexIfExists(indexName) : ctx.dsl.dropIndex(indexName);
        DropIndexOnStep s2 = on ? s1.on(onTable) : s1;
        return s2;
    }

    private static final Condition parseCondition(ParserContext ctx) {
        return ParserImpl.toCondition(ctx, ParserImpl.parseOr(ctx));
    }

    private static final QueryPart parseOr(ParserContext ctx) {
        QueryPart condition = ParserImpl.parseAnd(ctx);
        while (ParserImpl.parseKeywordIf(ctx, "OR")) {
            condition = ParserImpl.toCondition(ctx, condition).or(ParserImpl.toCondition(ctx, ParserImpl.parseAnd(ctx)));
        }
        return condition;
    }

    private static final QueryPart parseAnd(ParserContext ctx) {
        QueryPart condition = ParserImpl.parseNot(ctx);
        while (ParserImpl.parseKeywordIf(ctx, "AND")) {
            condition = ParserImpl.toCondition(ctx, condition).and(ParserImpl.toCondition(ctx, ParserImpl.parseNot(ctx)));
        }
        return condition;
    }

    private static final QueryPart parseNot(ParserContext ctx) {
        boolean not = ParserImpl.parseKeywordIf(ctx, "NOT");
        QueryPart condition = ParserImpl.parsePredicate(ctx);
        return not ? ParserImpl.toCondition(ctx, condition).not() : condition;
    }

    private static final QueryPart parsePredicate(ParserContext ctx) {
        Comparator comp;
        TSQLOuterJoinComparator outer;
        if (ParserImpl.parseKeywordIf(ctx, "EXISTS")) {
            ParserImpl.parse(ctx, '(');
            SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.exists(select);
        }
        FieldOrRow left = ParserImpl.parseConcat(ctx, null);
        boolean not = ParserImpl.parseKeywordIf(ctx, "NOT");
        if (!not && (outer = ParserImpl.parseTSQLOuterJoinComparatorIf(ctx)) != null && ctx.requireProEdition()) {
            QueryPart result = null;
            return result;
        }
        if (!not && (comp = ParserImpl.parseComparatorIf(ctx)) != null) {
            Condition result;
            boolean any;
            boolean all = ParserImpl.parseKeywordIf(ctx, "ALL");
            boolean bl = any = !all && (ParserImpl.parseKeywordIf(ctx, "ANY") || ParserImpl.parseKeywordIf(ctx, "SOME"));
            if (all || any) {
                ParserImpl.parse(ctx, '(');
            }
            Condition condition = all ? (left instanceof Field ? ((Field)left).compare(comp, DSL.all(ParserImpl.parseSelect(ctx, 1))) : ((RowN)left).compare(comp, DSL.all(ParserImpl.parseSelect(ctx, ((RowN)left).size())))) : (any ? (left instanceof Field ? ((Field)left).compare(comp, DSL.any(ParserImpl.parseSelect(ctx, 1))) : ((RowN)left).compare(comp, DSL.any(ParserImpl.parseSelect(ctx, ((RowN)left).size())))) : (result = left instanceof Field ? ((Field)left).compare(comp, ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, null))) : ((RowN)left).compare(comp, ParserImpl.parseRow(ctx, ((RowN)left).size(), true))));
            if (all || any) {
                ParserImpl.parse(ctx, ')');
            }
            return result;
        }
        if (!not && ParserImpl.parseKeywordIf(ctx, "IS")) {
            not = ParserImpl.parseKeywordIf(ctx, "NOT");
            if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
                return not ? (left instanceof Field ? ((Field)left).isNotNull() : ((RowN)left).isNotNull()) : (left instanceof Field ? ((Field)left).isNull() : ((RowN)left).isNotNull());
            }
            ParserImpl.parseKeyword(ctx, "DISTINCT FROM");
            if (left instanceof Field) {
                Field<?> right = ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, null));
                return not ? ((Field)left).isNotDistinctFrom(right) : ((Field)left).isDistinctFrom(right);
            }
            RowN right = ParserImpl.parseRow(ctx, ((RowN)left).size(), true);
            return not ? ((RowN)left).isNotDistinctFrom(right) : ((RowN)left).isDistinctFrom(right);
        }
        if (!not && ParserImpl.parseIf(ctx, "@>")) {
            return ParserImpl.toField(ctx, left).contains(ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, null)));
        }
        if (ParserImpl.parseKeywordIf(ctx, "IN")) {
            ParserImpl.parse(ctx, '(');
            Condition result = ParserImpl.peekKeyword(ctx, "SELECT") || ParserImpl.peekKeyword(ctx, "SEL") ? (not ? (left instanceof Field ? ((Field)left).notIn(ParserImpl.parseSelect(ctx, 1)) : ((RowN)left).notIn(ParserImpl.parseSelect(ctx, ((RowN)left).size()))) : (left instanceof Field ? ((Field)left).in(ParserImpl.parseSelect(ctx, 1)) : ((RowN)left).in(ParserImpl.parseSelect(ctx, ((RowN)left).size())))) : (not ? (left instanceof Field ? ((Field)left).notIn((Collection<?>)ParserImpl.parseFields(ctx)) : ((RowN)left).notIn(ParserImpl.parseRows(ctx, ((RowN)left).size()))) : (left instanceof Field ? ((Field)left).in((Collection<?>)ParserImpl.parseFields(ctx)) : ((RowN)left).in(ParserImpl.parseRows(ctx, ((RowN)left).size()))));
            ParserImpl.parse(ctx, ')');
            return result;
        }
        if (ParserImpl.parseKeywordIf(ctx, "BETWEEN")) {
            FieldOrRow r2;
            boolean symmetric = ParserImpl.parseKeywordIf(ctx, "SYMMETRIC");
            FieldOrRow r1 = left instanceof Field ? ParserImpl.parseConcat(ctx, null) : ParserImpl.parseRow(ctx, ((RowN)left).size());
            ParserImpl.parseKeyword(ctx, "AND");
            FieldOrRow fieldOrRow = r2 = left instanceof Field ? ParserImpl.parseConcat(ctx, null) : ParserImpl.parseRow(ctx, ((RowN)left).size());
            return symmetric ? (not ? (left instanceof Field ? ((Field)left).notBetweenSymmetric((Field)r1, (Field)r2) : ((RowN)left).notBetweenSymmetric((RowN)r1, (RowN)r2)) : (left instanceof Field ? ((Field)left).betweenSymmetric((Field)r1, (Field)r2) : ((RowN)left).betweenSymmetric((RowN)r1, (RowN)r2))) : (not ? (left instanceof Field ? ((Field)left).notBetween((Field)r1, (Field)r2) : ((RowN)left).notBetween((RowN)r1, (RowN)r2)) : (left instanceof Field ? ((Field)left).between((Field)r1, (Field)r2) : ((RowN)left).between((RowN)r1, (RowN)r2)));
        }
        if (left instanceof Field && ParserImpl.parseKeywordIf(ctx, "LIKE")) {
            char character;
            Field<String> right = ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, null));
            boolean escape = ParserImpl.parseKeywordIf(ctx, "ESCAPE");
            char c = character = escape ? (char)ParserImpl.parseCharacterLiteral(ctx) : (char)' ';
            return escape ? (not ? ((Field)left).notLike(right, character) : ((Field)left).like(right, character)) : (not ? ((Field)left).notLike(right) : ((Field)left).like(right));
        }
        if (left instanceof RowN && ((RowN)left).size() == 2 && ParserImpl.parseKeywordIf(ctx, "OVERLAPS")) {
            return ((Row2)left).overlaps((Row2)((Object)ParserImpl.parseRow(ctx, 2)));
        }
        return left;
    }

    private static final List<Table<?>> parseTables(ParserContext ctx) {
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseTable(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final Table<?> parseTable(ParserContext ctx) {
        Table<?> result = ParserImpl.parseLateral(ctx);
        Table<?> joined;
        while ((joined = ParserImpl.parseJoinedTableIf(ctx, result)) != null) {
            result = joined;
        }
        return result;
    }

    private static final Table<?> parseLateral(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "LATERAL")) {
            return DSL.lateral(ParserImpl.parseTableFactor(ctx));
        }
        return ParserImpl.parseTableFactor(ctx);
    }

    private static final <R extends Record> Table<R> t(TableLike<R> table) {
        return ParserImpl.t(table, false);
    }

    private static final <R extends Record> Table<R> t(TableLike<R> table, boolean dummyAlias) {
        return table instanceof Table ? (Table<R>)table : (dummyAlias ? table.asTable("x") : table.asTable());
    }

    private static final Table<?> parseTableFactor(ParserContext ctx) {
        TableLike<Object> result = null;
        if (ParserImpl.parseFunctionNameIf(ctx, "UNNEST")) {
            ParserImpl.parse(ctx, '(');
            Field<Object> f = ParserImpl.parseField(ctx, Type.A);
            if (!f.getType().isArray()) {
                f = f.coerce(f.getDataType().getArrayDataType());
            }
            result = DSL.unnest(f);
            ParserImpl.parse(ctx, ')');
        } else if (ParserImpl.parseFunctionNameIf(ctx, "GENERATE_SERIES")) {
            ParserImpl.parse(ctx, '(');
            Field<Integer> from = ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<Integer> to = ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, Type.N));
            Field<Integer> step = ParserImpl.parseIf(ctx, ',') ? ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, Type.N)) : null;
            ParserImpl.parse(ctx, ')');
            result = step == null ? DSL.generateSeries(from, to) : DSL.generateSeries(from, to, step);
        } else if (ParserImpl.parseIf(ctx, '(')) {
            if (ParserImpl.peekKeyword(ctx, "SELECT") || ParserImpl.peekKeyword(ctx, "SEL")) {
                SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
                ParserImpl.parse(ctx, ')');
                result = ParserImpl.parseQueryExpressionBody(ctx, null, null, select);
            } else if (ParserImpl.peekKeyword(ctx, "VALUES")) {
                result = ParserImpl.parseTableValueConstructor(ctx);
                ParserImpl.parse(ctx, ')');
            } else {
                result = ParserImpl.parseJoinedTable(ctx);
                ParserImpl.parse(ctx, ')');
            }
        } else {
            result = ParserImpl.parseTableName(ctx);
        }
        if (ParserImpl.parseKeywordIf(ctx, "VERSIONS") && ctx.requireProEdition() || !ParserImpl.parseKeywordIf(ctx, "AS OF") || ctx.requireProEdition()) {
            // empty if block
        }
        if (!ParserImpl.parseKeywordIf(ctx, "PIVOT") || ctx.requireProEdition()) {
            // empty if block
        }
        Name alias = null;
        List<Name> columnAliases = null;
        if (ParserImpl.parseKeywordIf(ctx, "AS")) {
            alias = ParserImpl.parseIdentifier(ctx);
        } else if (!ParserImpl.peekKeyword(ctx, KEYWORDS_IN_FROM)) {
            alias = ParserImpl.parseIdentifierIf(ctx);
        }
        if (alias != null) {
            if (ParserImpl.parseIf(ctx, '(')) {
                columnAliases = ParserImpl.parseIdentifiers(ctx);
                ParserImpl.parse(ctx, ')');
            }
            result = columnAliases != null ? ParserImpl.t(result, true).as(alias, columnAliases.toArray(Tools.EMPTY_NAME)) : ParserImpl.t(result, true).as(alias);
        }
        if (!ParserImpl.parseKeywordIf(ctx, "WITH") || ctx.requireProEdition()) {
            // empty if block
        }
        return ParserImpl.t(result);
    }

    private static final Table<?> parseTableValueConstructor(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "VALUES");
        ArrayList<RowN> rows = new ArrayList<RowN>();
        do {
            rows.add(ParserImpl.parseTuple(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return DSL.values(rows.toArray(Tools.EMPTY_ROWN));
    }

    private static final RowN parseTuple(ParserContext ctx) {
        return ParserImpl.parseTuple(ctx, null, false);
    }

    private static final RowN parseTuple(ParserContext ctx, Integer degree) {
        return ParserImpl.parseTuple(ctx, degree, false);
    }

    private static final RowN parseTuple(ParserContext ctx, Integer degree, boolean allowDoubleParens) {
        RowN row;
        ParserImpl.parse(ctx, '(');
        List<FieldOrRow> fieldsOrRows = allowDoubleParens ? ParserImpl.parseFieldsOrRows(ctx) : ParserImpl.parseFields(ctx);
        if (fieldsOrRows.size() == 0) {
            row = DSL.row(new Field[0]);
        } else if (fieldsOrRows.get(0) instanceof Field) {
            row = DSL.row(fieldsOrRows);
        } else if (fieldsOrRows.size() == 1) {
            row = (RowN)fieldsOrRows.get(0);
        } else {
            throw ctx.exception("Unsupported row size");
        }
        if (degree != null && row.size() != degree.intValue()) {
            throw ctx.exception("Expected row of degree: " + degree + ". Got: " + row.size());
        }
        ParserImpl.parse(ctx, ')');
        return row;
    }

    private static final Table<?> parseJoinedTable(ParserContext ctx) {
        Table<?> result = ParserImpl.parseLateral(ctx);
        Table<?> joined;
        while ((joined = ParserImpl.parseJoinedTableIf(ctx, result)) != null) {
            result = joined;
        }
        return result;
    }

    private static final Table<?> parseJoinedTableIf(ParserContext ctx, Table<?> left) {
        TablePartitionByStep s1;
        JoinType joinType = ParserImpl.parseJoinTypeIf(ctx);
        if (joinType == null) {
            return null;
        }
        Table<?> right = joinType.qualified() ? ParserImpl.parseTable(ctx) : ParserImpl.parseLateral(ctx);
        TableOptionalOnStep<Record> s0 = left.join(right, joinType);
        TablePartitionByStep s2 = s1 = (TablePartitionByStep)((Object)s0);
        switch (joinType) {
            case LEFT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: {
                if (ParserImpl.parseKeywordIf(ctx, "PARTITION BY")) {
                    ctx.requireProEdition();
                }
            }
            case JOIN: 
            case STRAIGHT_JOIN: 
            case LEFT_SEMI_JOIN: 
            case LEFT_ANTI_JOIN: {
                if (ParserImpl.parseKeywordIf(ctx, "ON")) {
                    return s2.on(ParserImpl.parseCondition(ctx));
                }
                if (ParserImpl.parseKeywordIf(ctx, "USING")) {
                    ParserImpl.parse(ctx, '(');
                    Table<Record> result = s2.using(Tools.fieldsByName(ParserImpl.parseIdentifiers(ctx).toArray(Tools.EMPTY_NAME)));
                    ParserImpl.parse(ctx, ')');
                    return result;
                }
                throw ctx.expected("ON", "USING");
            }
        }
        return s0;
    }

    private static final List<SelectFieldOrAsterisk> parseSelectList(ParserContext ctx) {
        ArrayList<SelectFieldOrAsterisk> result = new ArrayList<SelectFieldOrAsterisk>();
        do {
            if (ParserImpl.peekKeyword(ctx, KEYWORDS_IN_SELECT)) {
                throw ctx.exception("Select keywords must be quoted");
            }
            if (ParserImpl.parseIf(ctx, '*')) {
                result.add(DSL.asterisk());
                continue;
            }
            QualifiedAsterisk qa = ParserImpl.parseQualifiedAsteriskIf(ctx);
            if (qa != null) {
                result.add(qa);
                continue;
            }
            Field<?> field = ParserImpl.parseField(ctx);
            Name alias = null;
            if (ParserImpl.parseKeywordIf(ctx, "AS")) {
                alias = ParserImpl.parseIdentifier(ctx, true);
            } else if (!ParserImpl.peekKeyword(ctx, KEYWORDS_IN_SELECT)) {
                alias = ParserImpl.parseIdentifierIf(ctx, true);
            }
            result.add(alias == null ? field : field.as(alias));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final List<SortField<?>> parseSortSpecification(ParserContext ctx) {
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseSortField(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final SortField<?> parseSortField(ParserContext ctx) {
        Field<?> field = ParserImpl.parseField(ctx);
        SortField<?> sort = ParserImpl.parseKeywordIf(ctx, "DESC") ? field.desc() : (ParserImpl.parseKeywordIf(ctx, "ASC") ? field.asc() : field.sortDefault());
        if (ParserImpl.parseKeywordIf(ctx, "NULLS FIRST")) {
            sort = sort.nullsFirst();
        } else if (ParserImpl.parseKeywordIf(ctx, "NULLS LAST")) {
            sort = sort.nullsLast();
        }
        return sort;
    }

    private static final List<Field<?>> parseFields(ParserContext ctx) {
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseField(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final List<FieldOrRow> parseFieldsOrRows(ParserContext ctx) {
        ArrayList<FieldOrRow> result = new ArrayList<FieldOrRow>();
        do {
            result.add(ParserImpl.parseFieldOrRow(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final Field<?> parseField(ParserContext ctx) {
        return ParserImpl.parseField(ctx, null);
    }

    private static final FieldOrRow parseFieldOrRow(ParserContext ctx) {
        return ParserImpl.parseFieldOrRow(ctx, null);
    }

    private static final RowN parseRow(ParserContext ctx) {
        return ParserImpl.parseRow(ctx, null);
    }

    private static final List<RowN> parseRows(ParserContext ctx, Integer degree) {
        ArrayList<RowN> result = new ArrayList<RowN>();
        do {
            result.add(ParserImpl.parseRow(ctx, degree));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final RowN parseRow(ParserContext ctx, Integer degree) {
        ParserImpl.parseFunctionNameIf(ctx, "ROW");
        RowN row = ParserImpl.parseTuple(ctx, degree);
        return row;
    }

    private static final RowN parseRow(ParserContext ctx, Integer degree, boolean allowDoubleParens) {
        ParserImpl.parseFunctionNameIf(ctx, "ROW");
        RowN row = ParserImpl.parseTuple(ctx, degree, allowDoubleParens);
        return row;
    }

    private static final FieldOrRow parseFieldOrRow(ParserContext ctx, Type type) {
        if (Type.B.is(type)) {
            return ParserImpl.toFieldOrRow(ctx, ParserImpl.parseOr(ctx));
        }
        return ParserImpl.parseConcat(ctx, type);
    }

    private static final Field<?> parseField(ParserContext ctx, Type type) {
        if (Type.B.is(type)) {
            return ParserImpl.toField(ctx, ParserImpl.parseOr(ctx));
        }
        return ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, type));
    }

    private static final String parseHints(ParserContext ctx) {
        StringBuilder sb = new StringBuilder();
        do {
            int i;
            int position = ctx.position();
            if (!ParserImpl.parseIf(ctx, '/', false)) continue;
            ParserImpl.parse(ctx, '*', false);
            block4: for (i = ctx.position(); i < ctx.sql.length; ++i) {
                switch (ctx.sql[i]) {
                    case '*': {
                        if (i + 1 < ctx.sql.length && ctx.sql[i + 1] == '/') break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            ctx.position(i + 2);
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(ctx.substring(position, ctx.position()));
        } while (ParserImpl.parseWhitespaceIf(ctx));
        ctx.ignoreHints(true);
        return sb.length() > 0 ? sb.toString() : null;
    }

    private static final Condition toCondition(ParserContext ctx, QueryPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof Condition) {
            return (Condition)part;
        }
        if (part instanceof Field) {
            if (((Field)part).getDataType().getType() == Boolean.class) {
                return DSL.condition((Field)part);
            }
            if (part instanceof QualifiedField) {
                return DSL.condition((Field)part);
            }
            throw ctx.expected("Boolean field");
        }
        throw ctx.expected("Condition");
    }

    private static final FieldOrRow toFieldOrRow(ParserContext ctx, QueryPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof Field) {
            return (Field)part;
        }
        if (part instanceof Condition) {
            return DSL.field((Condition)part);
        }
        if (part instanceof Row) {
            return (Row)part;
        }
        throw ctx.expected("Field or row");
    }

    private static final Field<?> toField(ParserContext ctx, QueryPart part) {
        if (part == null) {
            return null;
        }
        if (part instanceof Field) {
            return (Field)part;
        }
        if (part instanceof Condition) {
            return DSL.field((Condition)part);
        }
        throw ctx.expected("Field");
    }

    private static final FieldOrRow parseConcat(ParserContext ctx, Type type) {
        Field<String> r = ParserImpl.parseCollated(ctx, type);
        if (Type.S.is(type) && r instanceof Field) {
            while (ParserImpl.parseIf(ctx, "||")) {
                r = DSL.concat(r, ParserImpl.toField(ctx, ParserImpl.parseCollated(ctx, type)));
            }
        }
        return r;
    }

    private static final FieldOrRow parseCollated(ParserContext ctx, Type type) {
        Field<String> r = ParserImpl.parseSum(ctx, type);
        if (Type.S.is(type) && r instanceof Field && ParserImpl.parseKeywordIf(ctx, "COLLATE")) {
            r = ((Field)r).collate(ParserImpl.parseCollation(ctx));
        }
        return r;
    }

    private static final Field<?> parseFieldSumParenthesised(ParserContext ctx) {
        ParserImpl.parse(ctx, '(');
        Field<?> r = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
        ParserImpl.parse(ctx, ')');
        return r;
    }

    private static final FieldOrRow parseSum(ParserContext ctx, Type type) {
        Field r = ParserImpl.parseFactor(ctx, type);
        if (Type.N.is(type) && r instanceof Field) {
            while (true) {
                if (ParserImpl.parseIf(ctx, '+')) {
                    r = ((Field)r).add((Field)ParserImpl.parseFactor(ctx, type));
                    continue;
                }
                if (!ParserImpl.parseIf(ctx, '-')) break;
                r = ((Field)r).sub((Field)ParserImpl.parseFactor(ctx, type));
            }
        }
        return r;
    }

    private static final FieldOrRow parseFactor(ParserContext ctx, Type type) {
        Field r = ParserImpl.parseExp(ctx, type);
        if (Type.N.is(type) && r instanceof Field) {
            while (true) {
                if (!ParserImpl.peek(ctx, "*=") && ParserImpl.parseIf(ctx, '*')) {
                    r = ((Field)r).mul((Field)ParserImpl.parseExp(ctx, type));
                    continue;
                }
                if (ParserImpl.parseIf(ctx, '/')) {
                    r = ((Field)r).div((Field)ParserImpl.parseExp(ctx, type));
                    continue;
                }
                if (!ParserImpl.parseIf(ctx, '%')) break;
                r = ((Field)r).mod((Field)ParserImpl.parseExp(ctx, type));
            }
        }
        return r;
    }

    private static final FieldOrRow parseExp(ParserContext ctx, Type type) {
        Field<BigDecimal> r = ParserImpl.parseUnaryOps(ctx, type);
        if (Type.N.is(type) && r instanceof Field) {
            while (ParserImpl.parseIf(ctx, '^')) {
                r = ((Field)r).pow(ParserImpl.toField(ctx, ParserImpl.parseUnaryOps(ctx, type)));
            }
        }
        return r;
    }

    private static final FieldOrRow parseUnaryOps(ParserContext ctx, Type type) {
        Field<Number> r;
        Sign sign = ParserImpl.parseSign(ctx);
        if (sign == Sign.NONE) {
            r = ParserImpl.parseTerm(ctx, type);
        } else if (sign == Sign.PLUS) {
            r = ParserImpl.toField(ctx, ParserImpl.parseTerm(ctx, type));
        } else {
            r = ParserImpl.parseFieldUnsignedNumericLiteralIf(ctx, Sign.MINUS);
            if (r == null) {
                r = ParserImpl.toField(ctx, ParserImpl.parseTerm(ctx, type)).neg();
            }
        }
        if (!ParserImpl.parseIf(ctx, "(+)") || ctx.requireProEdition()) {
            // empty if block
        }
        if (ParserImpl.parseIf(ctx, '(')) {
            throw ctx.exception("Unknown function");
        }
        while (ParserImpl.parseIf(ctx, "::")) {
            r = DSL.cast(ParserImpl.toField(ctx, r), ParserImpl.parseDataType(ctx));
        }
        return r;
    }

    private static final Sign parseSign(ParserContext ctx) {
        Sign sign = Sign.NONE;
        while (true) {
            if (ParserImpl.parseIf(ctx, '+')) {
                sign = sign == Sign.NONE ? Sign.PLUS : sign;
                continue;
            }
            if (!ParserImpl.parseIf(ctx, '-')) break;
            sign = sign == Sign.NONE ? Sign.MINUS : sign.invert();
        }
        return sign;
    }

    private static final FieldOrRow parseTerm(ParserContext ctx, Type type) {
        Field<Object> field;
        switch (ctx.character()) {
            case ':': 
            case '?': {
                return ParserImpl.parseBindVariable(ctx);
            }
            case '\'': {
                return DSL.inline(ParserImpl.parseStringLiteral(ctx));
            }
            case 'A': 
            case 'a': {
                if (Type.N.is(type)) {
                    if (ParserImpl.parseFunctionNameIf(ctx, "ABS")) {
                        return DSL.abs(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    field = ParserImpl.parseFieldAsciiIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "ACOS")) {
                        return DSL.acos(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "ASIN")) {
                        return DSL.asin(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "ATAN")) {
                        return DSL.atan(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    field = ParserImpl.parseFieldAtan2If(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.A.is(type) || (field = ParserImpl.parseArrayValueConstructorIf(ctx)) == null) break;
                return field;
            }
            case 'B': 
            case 'b': {
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldBitLengthIf(ctx);
                if (field != null) {
                    return field;
                }
                if (ParserImpl.parseFunctionNameIf(ctx, "BIT_COUNT")) {
                    return DSL.bitCount(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                field = ParserImpl.parseFieldBitwiseFunctionIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'C': 
            case 'c': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldConcatIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_SCHEMA")) {
                        return DSL.currentSchema();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_USER")) {
                        return DSL.currentUser();
                    }
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldCharIndexIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldCharLengthIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "CEILING") || ParserImpl.parseFunctionNameIf(ctx, "CEIL")) {
                        return DSL.ceil(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "COSH")) {
                        return DSL.cosh(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "COS")) {
                        return DSL.cos(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "COTH")) {
                        return DSL.coth(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "COT")) {
                        return DSL.cot(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    field = ParserImpl.parseNextvalCurrvalIf(ctx, SequenceMethod.CURRVAL);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.D.is(type)) {
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_TIMESTAMP")) {
                        if (!ParserImpl.parseIf(ctx, '(') || !ParserImpl.parse(ctx, ')')) {
                            // empty if block
                        }
                        return DSL.currentTimestamp();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_TIME")) {
                        if (!ParserImpl.parseIf(ctx, '(') || !ParserImpl.parse(ctx, ')')) {
                            // empty if block
                        }
                        return DSL.currentTime();
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "CURRENT_DATE")) {
                        if (!ParserImpl.parseIf(ctx, '(') || !ParserImpl.parse(ctx, ')')) {
                            // empty if block
                        }
                        return DSL.currentDate();
                    }
                }
                if ((field = ParserImpl.parseFieldCaseIf(ctx)) != null) {
                    return field;
                }
                field = ParserImpl.parseFieldCastIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldCoalesceIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldCumeDistIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldConvertIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldChooseIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'D': 
            case 'd': {
                if (Type.D.is(type)) {
                    field = ParserImpl.parseFieldDateLiteralIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldDateTruncIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldDateAddIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldDenseRankIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldDayIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "DEGREES") || ParserImpl.parseFunctionNameIf(ctx, "DEGREE") || ParserImpl.parseFunctionNameIf(ctx, "DEG")) {
                        return DSL.deg(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                }
                if ((field = ParserImpl.parseFieldDecodeIf(ctx)) == null) break;
                return field;
            }
            case 'E': 
            case 'e': {
                if (Type.S.is(type) && ctx.characterNext() == '\'') {
                    return DSL.inline(ParserImpl.parseStringLiteral(ctx));
                }
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldExtractIf(ctx);
                if (field != null) {
                    return field;
                }
                if (!ParserImpl.parseFunctionNameIf(ctx, "EXP")) break;
                return DSL.exp(ParserImpl.parseFieldSumParenthesised(ctx));
            }
            case 'F': 
            case 'f': {
                if (Type.N.is(type) && ParserImpl.parseFunctionNameIf(ctx, "FLOOR")) {
                    return DSL.floor(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                field = ParserImpl.parseFieldFirstValueIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldFieldIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'G': 
            case 'g': {
                if (Type.D.is(type) && ParserImpl.parseKeywordIf(ctx, "GETDATE") && ParserImpl.parse(ctx, '(') && ParserImpl.parse(ctx, ')')) {
                    return DSL.currentTimestamp();
                }
                field = ParserImpl.parseFieldGreatestIf(ctx);
                if (field != null) {
                    return field;
                }
                if (Type.N.is(type) && (field = ParserImpl.parseFieldGroupIdIf(ctx)) != null) {
                    return field;
                }
                if (Type.N.is(type) && (field = ParserImpl.parseFieldGroupingIdIf(ctx)) != null) {
                    return field;
                }
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldGroupingIf(ctx)) == null) break;
                return field;
            }
            case 'H': 
            case 'h': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldHourIf(ctx)) == null) break;
                return field;
            }
            case 'I': 
            case 'i': {
                if (Type.D.is(type) && (field = ParserImpl.parseFieldIntervalLiteralIf(ctx)) != null) {
                    return field;
                }
                if (Type.N.is(type) && (field = ParserImpl.parseFieldInstrIf(ctx)) != null) {
                    return field;
                }
                field = ParserImpl.parseFieldIfnullIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldIsnullIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldIifIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'L': 
            case 'l': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldLowerIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldLpadIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldLtrimIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldLeftIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldLengthIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "LN")) {
                        return DSL.ln(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    field = ParserImpl.parseFieldLogIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "LEVEL")) {
                        return DSL.level();
                    }
                }
                if ((field = ParserImpl.parseFieldLeastIf(ctx)) != null) {
                    return field;
                }
                field = ParserImpl.parseFieldLeadLagIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldLastValueIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'M': 
            case 'm': {
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldModIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldMonthIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldMinuteIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.S.is(type)) break;
                field = ParserImpl.parseFieldMidIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldMd5If(ctx);
                if (field == null) break;
                return field;
            }
            case 'N': 
            case 'n': {
                field = ParserImpl.parseFieldNvl2If(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNvlIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNullifIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNtileIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldNthValueIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseNextValueIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseNextvalCurrvalIf(ctx, SequenceMethod.NEXTVAL);
                if (field != null) {
                    return field;
                }
                if (!ParserImpl.parseFunctionNameIf(ctx, "NOW") || !ParserImpl.parse(ctx, '(') || !ParserImpl.parse(ctx, ')')) break;
                return DSL.now();
            }
            case 'O': 
            case 'o': {
                if (Type.S.is(type) && (field = ParserImpl.parseFieldReplaceIf(ctx)) != null) {
                    return field;
                }
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldOctetLengthIf(ctx)) == null) break;
                return field;
            }
            case 'P': 
            case 'p': {
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldPositionIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldPercentRankIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldPowerIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "PI") && ParserImpl.parse(ctx, '(') && ParserImpl.parse(ctx, ')')) {
                        return DSL.pi();
                    }
                }
                if (!ParserImpl.parseKeywordIf(ctx, "PRIOR")) break;
                return DSL.prior(ParserImpl.toField(ctx, ParserImpl.parseConcat(ctx, type)));
            }
            case 'Q': 
            case 'q': {
                if (Type.S.is(type) && ctx.characterNext() == '\'') {
                    return DSL.inline(ParserImpl.parseStringLiteral(ctx));
                }
            }
            case 'R': 
            case 'r': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldReplaceIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRepeatIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldReverseIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRpadIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRtrimIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRightIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.N.is(type)) {
                    field = ParserImpl.parseFieldRowNumberIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRankIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldRoundIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    if (ParserImpl.parseKeywordIf(ctx, "ROWNUM")) {
                        return DSL.rownum();
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "RADIANS") || ParserImpl.parseFunctionNameIf(ctx, "RADIAN") || ParserImpl.parseFunctionNameIf(ctx, "RAD")) {
                        return DSL.rad(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                }
                if (!ParserImpl.parseFunctionNameIf(ctx, "ROW")) break;
                return ParserImpl.parseTuple(ctx);
            }
            case 'S': 
            case 's': {
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldSubstringIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldSpaceIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldReplaceIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.N.is(type)) break;
                field = ParserImpl.parseFieldSecondIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldSignIf(ctx);
                if (field != null) {
                    return field;
                }
                if (ParserImpl.parseFunctionNameIf(ctx, "SQRT") || ParserImpl.parseFunctionNameIf(ctx, "SQR")) {
                    return DSL.sqrt(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                if (ParserImpl.parseFunctionNameIf(ctx, "SINH")) {
                    return DSL.sinh(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                if (ParserImpl.parseFunctionNameIf(ctx, "SIN")) {
                    return DSL.sin(ParserImpl.parseFieldSumParenthesised(ctx));
                }
                field = ParserImpl.parseFieldShlIf(ctx);
                if (field != null) {
                    return field;
                }
                field = ParserImpl.parseFieldShrIf(ctx);
                if (field == null) break;
                return field;
            }
            case 'T': 
            case 't': {
                if (Type.B.is(type) && (field = ParserImpl.parseBooleanValueExpressionIf(ctx)) != null) {
                    return field;
                }
                if (Type.S.is(type)) {
                    field = ParserImpl.parseFieldTrimIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldTranslateIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldToCharIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.N.is(type)) {
                    if (ParserImpl.parseFunctionNameIf(ctx, "TANH")) {
                        return DSL.tanh(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    if (ParserImpl.parseFunctionNameIf(ctx, "TAN")) {
                        return DSL.tan(ParserImpl.parseFieldSumParenthesised(ctx));
                    }
                    field = ParserImpl.parseFieldToNumberIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (Type.D.is(type)) {
                    field = ParserImpl.parseFieldTimestampLiteralIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldTimeLiteralIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldToDateIf(ctx);
                    if (field != null) {
                        return field;
                    }
                    field = ParserImpl.parseFieldToTimestampIf(ctx);
                    if (field != null) {
                        return field;
                    }
                }
                if (!Type.N.is(type) && !Type.D.is(type) || (field = ParserImpl.parseFieldTruncIf(ctx)) == null) break;
                return field;
            }
            case 'U': 
            case 'u': {
                if (!Type.S.is(type) || (field = ParserImpl.parseFieldUpperIf(ctx)) == null) break;
                return field;
            }
            case 'W': 
            case 'w': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldWidthBucketIf(ctx)) == null) break;
                return field;
            }
            case 'X': 
            case 'x': {
                byte[] value;
                if (!Type.X.is(type) || (value = ParserImpl.parseBinaryLiteralIf(ctx)) == null) break;
                return DSL.inline(value);
            }
            case 'Y': 
            case 'y': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldYearIf(ctx)) == null) break;
                return field;
            }
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (!Type.N.is(type) || (field = ParserImpl.parseFieldUnsignedNumericLiteralIf(ctx, Sign.NONE)) == null) break;
                return field;
            }
            case '{': {
                FieldOrRow field2;
                ParserImpl.parse(ctx, '{', false);
                switch (ctx.character()) {
                    case 'D': 
                    case 'd': {
                        ParserImpl.parseKeyword(ctx, "D");
                        field2 = DSL.inline(ParserImpl.parseDateLiteral(ctx));
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        ParserImpl.parseKeyword(ctx, "FN");
                        field2 = ParserImpl.parseTerm(ctx, type);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        if (ParserImpl.parseKeywordIf(ctx, "TS")) {
                            field2 = DSL.inline(ParserImpl.parseTimestampLiteral(ctx));
                            break;
                        }
                        ParserImpl.parseKeyword(ctx, "T");
                        field2 = DSL.inline(ParserImpl.parseTimeLiteral(ctx));
                        break;
                    }
                    default: {
                        throw ctx.exception("Unsupported JDBC escape literal");
                    }
                }
                ParserImpl.parse(ctx, '}');
                return field2;
            }
            case '(': {
                int position = ctx.position();
                try {
                    if (ParserImpl.peekKeyword(ctx, "SELECT", false, true, false) || ParserImpl.peekKeyword(ctx, "SEL", false, true, false)) {
                        SelectQueryImpl<Record> select = ParserImpl.parseSelect(ctx);
                        if (select.getSelect().size() > 1) {
                            throw ctx.exception("Select list must contain at most one column");
                        }
                        Field field3 = DSL.field(select);
                        return field3;
                    }
                }
                catch (ParserException e) {
                    if (e.getMessage().contains("Token ')' expected")) {
                        ctx.position(position);
                    }
                    throw e;
                }
                ParserImpl.parse(ctx, '(');
                FieldOrRow r = ParserImpl.parseFieldOrRow(ctx, type);
                ArrayList list = null;
                if (r instanceof Field) {
                    while (ParserImpl.parseIf(ctx, ',')) {
                        if (list == null) {
                            list = new ArrayList();
                            list.add((Field)r);
                        }
                        list.add(ParserImpl.parseField(ctx, type));
                    }
                }
                ParserImpl.parse(ctx, ')');
                return list != null ? DSL.row(list) : r;
            }
        }
        field = ParserImpl.parseAggregateFunctionIf(ctx);
        if (field != null) {
            return field;
        }
        field = ParserImpl.parseBooleanValueExpressionIf(ctx);
        if (field != null) {
            return field;
        }
        return ParserImpl.parseFieldNameOrSequenceExpression(ctx);
    }

    private static final Field<?> parseFieldShlIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "SHL") || ParserImpl.parseKeywordIf(ctx, "SHIFTLEFT")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.shl(x, y);
        }
        return null;
    }

    private static final Field<?> parseFieldShrIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "SHR") || ParserImpl.parseKeywordIf(ctx, "SHIFTRIGHT")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.shr(x, y);
        }
        return null;
    }

    private static final Field<?> parseFieldBitwiseFunctionIf(ParserContext ctx) {
        int position = ctx.position();
        char c1 = ctx.character(position + 1);
        char c2 = ctx.character(position + 2);
        if (c1 != 'I' && c1 != 'i') {
            return null;
        }
        if (c2 != 'T' && c2 != 't' && c2 != 'N' && c2 != 'n') {
            return null;
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_AND") || ParserImpl.parseKeywordIf(ctx, "BITAND") || ParserImpl.parseKeywordIf(ctx, "BIN_AND")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitAnd(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_NAND") || ParserImpl.parseKeywordIf(ctx, "BITNAND") || ParserImpl.parseKeywordIf(ctx, "BIN_NAND")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitNand(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_OR") || ParserImpl.parseKeywordIf(ctx, "BITOR") || ParserImpl.parseKeywordIf(ctx, "BIN_OR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitOr(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_NOR") || ParserImpl.parseKeywordIf(ctx, "BITNOR") || ParserImpl.parseKeywordIf(ctx, "BIN_NOR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitNor(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_XOR") || ParserImpl.parseKeywordIf(ctx, "BITXOR") || ParserImpl.parseKeywordIf(ctx, "BIN_XOR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitXor(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_XNOR") || ParserImpl.parseKeywordIf(ctx, "BITXNOR") || ParserImpl.parseKeywordIf(ctx, "BIN_XNOR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitXNor(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIT_NOT") || ParserImpl.parseKeywordIf(ctx, "BITNOT") || ParserImpl.parseKeywordIf(ctx, "BIN_NOT")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.bitNot(x);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIN_SHL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.shl(x, y);
        }
        if (ParserImpl.parseKeywordIf(ctx, "BIN_SHR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.shr(x, y);
        }
        return null;
    }

    private static final Field<?> parseNextValueIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "NEXT VALUE FOR")) {
            return DSL.sequence(ParserImpl.parseName(ctx)).nextval();
        }
        return null;
    }

    private static final Field<?> parseNextvalCurrvalIf(ParserContext ctx, SequenceMethod method) {
        if (ParserImpl.parseFunctionNameIf(ctx, method.name())) {
            ParserImpl.parse(ctx, '(');
            Name name = ParserImpl.parseNameIf(ctx);
            Sequence<BigInteger> s = name != null ? DSL.sequence(name) : DSL.sequence(ctx.dsl.parser().parseName(ParserImpl.parseStringLiteral(ctx)));
            ParserImpl.parse(ctx, ')');
            if (method == SequenceMethod.NEXTVAL) {
                return s.nextval();
            }
            if (method == SequenceMethod.CURRVAL) {
                return s.currval();
            }
            throw ctx.exception("Only NEXTVAL and CURRVAL methods supported");
        }
        return null;
    }

    private static final Field<?> parseArrayValueConstructorIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ARRAY")) {
            List<Object> fields;
            ParserImpl.parse(ctx, '[');
            if (ParserImpl.parseIf(ctx, ']')) {
                fields = Collections.emptyList();
            } else {
                fields = ParserImpl.parseFields(ctx);
                ParserImpl.parse(ctx, ']');
            }
            return DSL.array(fields);
        }
        return null;
    }

    private static final Field<?> parseFieldAtan2If(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "ATN2") || ParserImpl.parseFunctionNameIf(ctx, "ATAN2")) {
            ParserImpl.parse(ctx, '(');
            Field<?> x = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> y = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.atan2(x, y);
        }
        return null;
    }

    private static final Field<?> parseFieldLogIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LOG")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg1 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            long arg2 = ParserImpl.parseUnsignedInteger(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.log(arg1, (int)arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldTruncIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TRUNC")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            String part = ParserImpl.parseStringLiteralIf(ctx);
            if (part != null) {
                DatePart p;
                if ("YY".equals(part = part.toUpperCase()) || "YYYY".equals(part) || "YEAR".equals(part)) {
                    p = DatePart.YEAR;
                } else if ("MM".equals(part) || "MONTH".equals(part)) {
                    p = DatePart.MONTH;
                } else if ("DD".equals(part)) {
                    p = DatePart.DAY;
                } else if ("HH".equals(part)) {
                    p = DatePart.HOUR;
                } else if ("MI".equals(part)) {
                    p = DatePart.MINUTE;
                } else if ("SS".equals(part)) {
                    p = DatePart.SECOND;
                } else {
                    throw ctx.exception("Unsupported date part");
                }
                ParserImpl.parse(ctx, ')');
                return DSL.trunc(arg1, p);
            }
            Field<Integer> arg2 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.trunc(arg1, arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldRoundIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "ROUND")) {
            Field<?> arg1 = null;
            Integer arg2 = null;
            ParserImpl.parse(ctx, '(');
            arg1 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            if (ParserImpl.parseIf(ctx, ',')) {
                arg2 = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            }
            ParserImpl.parse(ctx, ')');
            return arg2 == null ? DSL.round(arg1) : DSL.round(arg1, (int)arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldPowerIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "POWER") || ParserImpl.parseFunctionNameIf(ctx, "POW")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg1 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ',');
            Field<?> arg2 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            ParserImpl.parse(ctx, ')');
            return DSL.power(arg1, arg2);
        }
        return null;
    }

    private static final Field<?> parseFieldModIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "MOD")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return f1.mod(f2);
        }
        return null;
    }

    private static final Field<?> parseFieldWidthBucketIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "WIDTH_BUCKET")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> f3 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<Integer> f4 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.widthBucket(f1, f2, f3, f4);
        }
        return null;
    }

    private static final Field<?> parseFieldLeastIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LEAST")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.least(fields.get(0), fields.size() > 1 ? fields.subList(1, fields.size()).toArray(Tools.EMPTY_FIELD) : Tools.EMPTY_FIELD);
        }
        return null;
    }

    private static final Field<?> parseFieldGreatestIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "GREATEST")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.greatest(fields.get(0), fields.size() > 1 ? fields.subList(1, fields.size()).toArray(Tools.EMPTY_FIELD) : Tools.EMPTY_FIELD);
        }
        return null;
    }

    private static final Field<?> parseFieldGroupingIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "GROUPING")) {
            ParserImpl.parse(ctx, '(');
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.grouping(field);
        }
        return null;
    }

    private static final Field<?> parseFieldGroupIdIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "GROUP_ID")) {
            ctx.requireProEdition();
        }
        return null;
    }

    private static final Field<?> parseFieldGroupingIdIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "GROUPING_ID")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.groupingId(fields.toArray(Tools.EMPTY_FIELD));
        }
        return null;
    }

    private static final Field<?> parseFieldTimestampLiteralIf(ParserContext ctx) {
        int position = ctx.position();
        if (ParserImpl.parseKeywordIf(ctx, "TIMESTAMP")) {
            if (ParserImpl.parseKeywordIf(ctx, "WITHOUT TIME ZONE")) {
                return DSL.inline(ParserImpl.parseTimestampLiteral(ctx));
            }
            if (ParserImpl.parseIf(ctx, '(')) {
                Field<?> f = ParserImpl.parseField(ctx, Type.S);
                ParserImpl.parse(ctx, ')');
                return DSL.timestamp(f);
            }
            if (ParserImpl.peek(ctx, '\'')) {
                return DSL.inline(ParserImpl.parseTimestampLiteral(ctx));
            }
            ctx.position(position);
            return DSL.field(ParserImpl.parseIdentifier(ctx));
        }
        return null;
    }

    private static final Timestamp parseTimestampLiteral(ParserContext ctx) {
        try {
            return Timestamp.valueOf(ParserImpl.parseStringLiteral(ctx));
        }
        catch (IllegalArgumentException e) {
            throw ctx.exception("Illegal timestamp literal");
        }
    }

    private static final Field<?> parseFieldTimeLiteralIf(ParserContext ctx) {
        int position = ctx.position();
        if (ParserImpl.parseKeywordIf(ctx, "TIME")) {
            if (ParserImpl.parseKeywordIf(ctx, "WITHOUT TIME ZONE")) {
                return DSL.inline(ParserImpl.parseTimeLiteral(ctx));
            }
            if (ParserImpl.parseIf(ctx, '(')) {
                Field<?> f = ParserImpl.parseField(ctx, Type.S);
                ParserImpl.parse(ctx, ')');
                return DSL.time(f);
            }
            if (ParserImpl.peek(ctx, '\'')) {
                return DSL.inline(ParserImpl.parseTimeLiteral(ctx));
            }
            ctx.position(position);
            return DSL.field(ParserImpl.parseIdentifier(ctx));
        }
        return null;
    }

    private static final Time parseTimeLiteral(ParserContext ctx) {
        try {
            return Time.valueOf(ParserImpl.parseStringLiteral(ctx));
        }
        catch (IllegalArgumentException e) {
            throw ctx.exception("Illegal time literal");
        }
    }

    private static final Field<?> parseFieldIntervalLiteralIf(ParserContext ctx) {
        int position = ctx.position();
        if (ParserImpl.parseKeywordIf(ctx, "INTERVAL")) {
            if (ParserImpl.peek(ctx, '\'')) {
                return DSL.inline(ParserImpl.parseIntervalLiteral(ctx));
            }
            ctx.position(position);
            return DSL.field(ParserImpl.parseIdentifier(ctx));
        }
        return null;
    }

    private static final Interval parseIntervalLiteral(ParserContext ctx) {
        String string = ParserImpl.parseStringLiteral(ctx);
        DayToSecond ds = DayToSecond.valueOf(string);
        if (ds != null) {
            return ds;
        }
        YearToMonth ym = YearToMonth.valueOf(string);
        if (ym != null) {
            return ym;
        }
        throw ctx.exception("Illegal interval literal");
    }

    private static final Field<?> parseFieldDateLiteralIf(ParserContext ctx) {
        int position = ctx.position();
        if (ParserImpl.parseKeywordIf(ctx, "DATE")) {
            if (ParserImpl.parseIf(ctx, '(')) {
                Field<?> f = ParserImpl.parseField(ctx, Type.S);
                ParserImpl.parse(ctx, ')');
                return DSL.date(f);
            }
            if (ParserImpl.peek(ctx, '\'')) {
                return DSL.inline(ParserImpl.parseDateLiteral(ctx));
            }
            ctx.position(position);
            return DSL.field(ParserImpl.parseIdentifier(ctx));
        }
        return null;
    }

    private static final Field<?> parseFieldDateTruncIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "DATE_TRUNC")) {
            ParserImpl.parse(ctx, '(');
            DatePart part = DatePart.valueOf(ParserImpl.parseStringLiteral(ctx).toUpperCase());
            ParserImpl.parse(ctx, ',');
            Field<?> field = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.trunc(field, part);
        }
        return null;
    }

    private static final Field<?> parseFieldDateAddIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "DATEADD")) {
            ParserImpl.parse(ctx, '(');
            DatePart part = ParserImpl.parseDatePart2(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> interval = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<Date> date = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.dateAdd(date, interval, part);
        }
        return null;
    }

    private static final Date parseDateLiteral(ParserContext ctx) {
        try {
            return Date.valueOf(ParserImpl.parseStringLiteral(ctx));
        }
        catch (IllegalArgumentException e) {
            throw ctx.exception("Illegal date literal");
        }
    }

    private static final Field<?> parseFieldExtractIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "EXTRACT")) {
            ParserImpl.parse(ctx, '(');
            DatePart part = ParserImpl.parseDatePart(ctx);
            ParserImpl.parseKeyword(ctx, "FROM");
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.extract(field, part);
        }
        return null;
    }

    private static final DatePart parseDatePart(ParserContext ctx) {
        for (DatePart part : DatePart.values()) {
            if (!ParserImpl.parseKeywordIf(ctx, part.name())) continue;
            return part;
        }
        throw ctx.exception("Unsupported date part");
    }

    private static final DatePart parseDatePart2(ParserContext ctx) {
        char character = ctx.character();
        switch (character) {
            case 'D': 
            case 'd': {
                if (ParserImpl.parseKeywordIf(ctx, "DAYOFYEAR") || ParserImpl.parseKeywordIf(ctx, "DY")) {
                    return DatePart.DAY_OF_YEAR;
                }
                if (ParserImpl.parseKeywordIf(ctx, "DAY") || ParserImpl.parseKeywordIf(ctx, "DD") || ParserImpl.parseKeywordIf(ctx, "D")) {
                    return DatePart.DAY;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "DW")) break;
                return DatePart.DAY_OF_WEEK;
            }
            case 'H': 
            case 'h': {
                if (!ParserImpl.parseKeywordIf(ctx, "HOUR") && !ParserImpl.parseKeywordIf(ctx, "HH")) break;
                return DatePart.HOUR;
            }
            case 'M': 
            case 'm': {
                if (ParserImpl.parseKeywordIf(ctx, "MINUTE") || ParserImpl.parseKeywordIf(ctx, "MI")) {
                    return DatePart.MINUTE;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "MONTH") && !ParserImpl.parseKeywordIf(ctx, "MM") && !ParserImpl.parseKeywordIf(ctx, "M")) break;
                return DatePart.MONTH;
            }
            case 'N': 
            case 'n': {
                if (!ParserImpl.parseKeywordIf(ctx, "N")) break;
                return DatePart.MINUTE;
            }
            case 'Q': 
            case 'q': {
                if (!ParserImpl.parseKeywordIf(ctx, "QUARTER") && !ParserImpl.parseKeywordIf(ctx, "QQ") && !ParserImpl.parseKeywordIf(ctx, "Q")) break;
                return DatePart.QUARTER;
            }
            case 'S': 
            case 's': {
                if (!ParserImpl.parseKeywordIf(ctx, "SECOND") && !ParserImpl.parseKeywordIf(ctx, "SS") && !ParserImpl.parseKeywordIf(ctx, "S")) break;
                return DatePart.SECOND;
            }
            case 'W': 
            case 'w': {
                if (ParserImpl.parseKeywordIf(ctx, "WEEK") || ParserImpl.parseKeywordIf(ctx, "WK") || ParserImpl.parseKeywordIf(ctx, "WW")) {
                    return DatePart.WEEK;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "WEEKDAY") && !ParserImpl.parseKeywordIf(ctx, "W")) break;
                return DatePart.DAY_OF_WEEK;
            }
            case 'Y': 
            case 'y': {
                if (ParserImpl.parseKeywordIf(ctx, "YEAR") || ParserImpl.parseKeywordIf(ctx, "YYYY") || ParserImpl.parseKeywordIf(ctx, "YY")) {
                    return DatePart.YEAR;
                }
                if (!ParserImpl.parseKeywordIf(ctx, "Y")) break;
                return DatePart.DAY_OF_YEAR;
            }
        }
        throw ctx.expected("DatePart");
    }

    private static final Field<?> parseFieldAsciiIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "ASCII")) {
            ParserImpl.parse(ctx, '(');
            Field<String> arg = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.ascii(arg);
        }
        return null;
    }

    private static final Field<?> parseFieldConcatIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CONCAT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> result = DSL.concat(ParserImpl.parseFields(ctx).toArray(Tools.EMPTY_FIELD));
            ParserImpl.parse(ctx, ')');
            return result;
        }
        return null;
    }

    private static final Field<?> parseFieldInstrIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "INSTR")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.position(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldCharIndexIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CHARINDEX")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.position(f2, f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLpadIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LPAD")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            Field<String> f3 = ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseField(ctx, Type.S) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.lpad(f1, f2) : DSL.lpad(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldRpadIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "RPAD")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            Field<String> f3 = ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseField(ctx, Type.S) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.rpad(f1, f2) : DSL.rpad(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldPositionIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "POSITION")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parseKeyword(ctx, "IN");
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.position(f2, f1);
        }
        return null;
    }

    private static final Field<?> parseFieldRepeatIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "REPEAT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> field = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> count = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.repeat(field, count);
        }
        return null;
    }

    private static final Field<?> parseFieldReplaceIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "REPLACE") || ParserImpl.parseFunctionNameIf(ctx, "OREPLACE") || ParserImpl.parseFunctionNameIf(ctx, "STR_REPLACE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            Field<String> f3 = ParserImpl.parseIf(ctx, ',') ? ParserImpl.parseField(ctx, Type.S) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.replace(f1, f2) : DSL.replace(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldReverseIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "REVERSE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.reverse(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSpaceIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "SPACE")) {
            ParserImpl.parse(ctx, '(');
            Field<Integer> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.space(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSubstringIf(ParserContext ctx) {
        boolean substr;
        boolean substring = ParserImpl.parseFunctionNameIf(ctx, "SUBSTRING");
        boolean bl = substr = !substring && ParserImpl.parseFunctionNameIf(ctx, "SUBSTR");
        if (substring || substr) {
            boolean keywords = !substr;
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            if (substr || !(keywords = ParserImpl.parseKeywordIf(ctx, "FROM"))) {
                ParserImpl.parse(ctx, ',');
            }
            Field<?> f2 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
            Field<?> f3 = keywords && ParserImpl.parseKeywordIf(ctx, "FOR") || !keywords && ParserImpl.parseIf(ctx, ',') ? ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N)) : null;
            ParserImpl.parse(ctx, ')');
            return f3 == null ? DSL.substring(f1, f2) : DSL.substring(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldTrimIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TRIM")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.trim(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldTranslateIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TRANSLATE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f3 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.translate(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldToCharIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TO_CHAR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.cast(f1, SQLDataType.VARCHAR);
        }
        return null;
    }

    private static final Field<?> parseFieldToNumberIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TO_NUMBER")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.cast(f1, SQLDataType.NUMERIC);
        }
        return null;
    }

    private static final Field<?> parseFieldToDateIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TO_DATE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.toDate(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldToTimestampIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "TO_TIMESTAMP")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<String> f2 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.toTimestamp(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldRtrimIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "RTRIM")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.rtrim(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLtrimIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LTRIM")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.ltrim(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldMidIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "MID")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            Field<?> f3 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.mid(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldLeftIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LEFT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.left(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldRightIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "RIGHT")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.right(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldMd5If(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "MD5")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.md5(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLengthIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LENGTH") || ParserImpl.parseFunctionNameIf(ctx, "LEN")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.length(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldCharLengthIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CHAR_LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.charLength(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldBitLengthIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "BIT_LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.bitLength(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldOctetLengthIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "OCTET_LENGTH")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.octetLength(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldLowerIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LOWER") || ParserImpl.parseFunctionNameIf(ctx, "LCASE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.lower(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldUpperIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "UPPER") || ParserImpl.parseFunctionNameIf(ctx, "UCASE")) {
            ParserImpl.parse(ctx, '(');
            Field<String> f1 = ParserImpl.parseField(ctx, Type.S);
            ParserImpl.parse(ctx, ')');
            return DSL.upper(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldDecodeIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "DECODE")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            int size = fields.size();
            if (size < 3) {
                throw ctx.expected("At least three arguments to DECODE()");
            }
            ParserImpl.parse(ctx, ')');
            return DSL.decode(fields.get(0), fields.get(1), fields.get(2), size == 3 ? Tools.EMPTY_FIELD : fields.subList(3, size).toArray(Tools.EMPTY_FIELD));
        }
        return null;
    }

    private static final Field<?> parseFieldChooseIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CHOOSE")) {
            ParserImpl.parse(ctx, '(');
            Field<Integer> index = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ',');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.choose(index, fields.toArray(Tools.EMPTY_FIELD));
        }
        return null;
    }

    private static final Field<?> parseFieldYearIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "YEAR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.year(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldMonthIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "MONTH")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.month(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldDayIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "DAY")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.day(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldHourIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "HOUR")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.hour(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldMinuteIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "MINUTE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.minute(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSecondIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "SECOND")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.D);
            ParserImpl.parse(ctx, ')');
            return DSL.second(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldSignIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "SIGN")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx, Type.N);
            ParserImpl.parse(ctx, ')');
            return DSL.sign(f1);
        }
        return null;
    }

    private static final Field<?> parseFieldIfnullIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "IFNULL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.ifnull(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldIsnullIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "ISNULL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.isnull(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldIifIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "IIF")) {
            ParserImpl.parse(ctx, '(');
            Condition c = ParserImpl.parseCondition(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.iif(c, f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldNvlIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "NVL")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.nvl(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldNvl2If(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "NVL2")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f3 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.nvl2(f1, f2, f3);
        }
        return null;
    }

    private static final Field<?> parseFieldNullifIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "NULLIF")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> f2 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.nullif(f1, f2);
        }
        return null;
    }

    private static final Field<?> parseFieldCoalesceIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "COALESCE")) {
            ParserImpl.parse(ctx, '(');
            List<Field<?>> fields = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            Field<?>[] a = Tools.EMPTY_FIELD;
            return DSL.coalesce(fields.get(0), fields.size() == 1 ? a : fields.subList(1, fields.size()).toArray(a));
        }
        return null;
    }

    private static final <T, Z> Field<?> parseFieldFieldIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "FIELD")) {
            ParserImpl.parse(ctx, '(');
            ArrayList<Field<Object>> args = new ArrayList<Field<Object>>();
            args.add(ParserImpl.parseField(ctx));
            ParserImpl.parse(ctx, ',');
            int i = 1;
            do {
                args.add(ParserImpl.parseField(ctx));
                args.add(DSL.inline(i++));
            } while (ParserImpl.parseIf(ctx, ','));
            args.add(DSL.inline(0));
            ParserImpl.parse(ctx, ')');
            return DSL.decode((Field)args.get(0), (Field)args.get(1), (Field)args.get(2), args.subList(3, args.size()).toArray(Tools.EMPTY_FIELD));
        }
        return null;
    }

    private static final Field<?> parseFieldCaseIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CASE")) {
            if (ParserImpl.parseKeywordIf(ctx, "WHEN")) {
                CaseConditionStep<?> step = null;
                do {
                    Condition condition = ParserImpl.parseCondition(ctx);
                    ParserImpl.parseKeyword(ctx, "THEN");
                    Field<?> value = ParserImpl.parseField(ctx);
                    CaseConditionStep<?> caseConditionStep = step = step == null ? DSL.when(condition, value) : step.when(condition, value);
                } while (ParserImpl.parseKeywordIf(ctx, "WHEN"));
                Field<?> result = ParserImpl.parseKeywordIf(ctx, "ELSE") ? step.otherwise(ParserImpl.parseField(ctx)) : step;
                ParserImpl.parseKeyword(ctx, "END");
                return result;
            }
            CaseValueStep<?> init = DSL.choose(ParserImpl.parseField(ctx));
            CaseWhenStep<?, ?> step = null;
            ParserImpl.parseKeyword(ctx, "WHEN");
            do {
                Field<?> when = ParserImpl.parseField(ctx);
                ParserImpl.parseKeyword(ctx, "THEN");
                Field<?> then = ParserImpl.parseField(ctx);
                CaseWhenStep<?, ?> caseWhenStep = step = step == null ? init.when(when, then) : step.when(when, then);
            } while (ParserImpl.parseKeywordIf(ctx, "WHEN"));
            Field<Object> result = ParserImpl.parseKeywordIf(ctx, "ELSE") ? step.otherwise(ParserImpl.parseField(ctx)) : step;
            ParserImpl.parseKeyword(ctx, "END");
            return result;
        }
        return null;
    }

    private static final Field<?> parseFieldCastIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CAST")) {
            ParserImpl.parse(ctx, '(');
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parseKeyword(ctx, "AS");
            DataType<?> type = ParserImpl.parseCastDataType(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.cast(field, type);
        }
        return null;
    }

    private static final Field<?> parseFieldConvertIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CONVERT")) {
            ParserImpl.parse(ctx, '(');
            DataType<?> type = ParserImpl.parseDataType(ctx);
            ParserImpl.parse(ctx, ',');
            Field<?> field = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.cast(field, type);
        }
        return null;
    }

    private static final Field<Boolean> parseBooleanValueExpressionIf(ParserContext ctx) {
        TruthValue truth = ParserImpl.parseTruthValueIf(ctx);
        if (truth != null) {
            switch (truth) {
                case TRUE: {
                    return DSL.inline(true);
                }
                case FALSE: {
                    return DSL.inline(false);
                }
                case NULL: {
                    return DSL.inline((Boolean)null);
                }
            }
            throw ctx.exception("Truth value not supported: " + (Object)((Object)truth));
        }
        return null;
    }

    private static final Field<?> parseAggregateFunctionIf(ParserContext ctx) {
        return ParserImpl.parseAggregateFunctionIf(ctx, false);
    }

    private static final Field<?> parseAggregateFunctionIf(ParserContext ctx, boolean basic) {
        AggregateFunction<?> agg = null;
        AggregateFilterStep<?> filter = null;
        WindowBeforeOverStep<?> over = null;
        AggregateFunction<?> keep = null;
        Field<Object> result = null;
        Condition condition = null;
        agg = ParserImpl.parseCountIf(ctx);
        filter = agg;
        over = agg;
        keep = agg;
        if (filter == null) {
            agg = ParserImpl.parseGeneralSetFunctionIf(ctx);
            filter = agg;
            over = agg;
            keep = agg;
        }
        if (filter == null && !basic) {
            agg = ParserImpl.parseBinarySetFunctionIf(ctx);
            filter = agg;
            over = agg;
        }
        if (filter == null && !basic) {
            filter = ParserImpl.parseOrderedSetFunctionIf(ctx);
            over = filter;
        }
        if (filter == null && !basic) {
            filter = ParserImpl.parseArrayAggFunctionIf(ctx);
            over = filter;
        }
        if (filter == null && over == null) {
            if (!basic) {
                return ParserImpl.parseSpecialAggregateFunctionIf(ctx);
            }
            return null;
        }
        if (keep != null && filter != null && !basic && ParserImpl.parseKeywordIf(ctx, "KEEP")) {
            ctx.requireProEdition();
        } else if (filter != null && !basic && ParserImpl.parseKeywordIf(ctx, "FILTER")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parseKeyword(ctx, "WHERE");
            condition = ParserImpl.parseCondition(ctx);
            ParserImpl.parse(ctx, ')');
            result = over = filter.filterWhere(condition);
        } else {
            result = filter != null ? filter : over;
        }
        if (!basic && ParserImpl.parseKeywordIf(ctx, "OVER")) {
            Object nameOrSpecification = ParserImpl.parseWindowNameOrSpecification(ctx, filter != null);
            result = nameOrSpecification instanceof Name ? over.over((Name)nameOrSpecification) : (nameOrSpecification instanceof WindowSpecification ? over.over((WindowSpecification)nameOrSpecification) : over.over());
        }
        return result;
    }

    private static final Field<?> parseSpecialAggregateFunctionIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "GROUP_CONCAT")) {
            ParserImpl.parse(ctx, '(');
            GroupConcatOrderByStep s1 = ParserImpl.parseKeywordIf(ctx, "DISTINCT") ? DSL.groupConcatDistinct(ParserImpl.parseField(ctx)) : DSL.groupConcat(ParserImpl.parseField(ctx));
            GroupConcatSeparatorStep s2 = ParserImpl.parseKeywordIf(ctx, "ORDER BY") ? s1.orderBy(ParserImpl.parseSortSpecification(ctx)) : s1;
            AggregateFunction<String> s3 = ParserImpl.parseKeywordIf(ctx, "SEPARATOR") ? s2.separator(ParserImpl.parseStringLiteral(ctx)) : s2;
            ParserImpl.parse(ctx, ')');
            return s3;
        }
        return null;
    }

    private static final Object parseWindowNameOrSpecification(ParserContext ctx, boolean orderByAllowed) {
        QueryPart result;
        if (ParserImpl.parseIf(ctx, '(')) {
            result = ParserImpl.parseWindowSpecificationIf(ctx, orderByAllowed);
            if (result == null) {
                result = ParserImpl.parseIdentifierIf(ctx);
            }
            ParserImpl.parse(ctx, ')');
        } else {
            result = ParserImpl.parseIdentifier(ctx);
        }
        return result;
    }

    private static final Field<?> parseFieldRankIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "RANK")) {
            ParserImpl.parse(ctx, '(');
            if (ParserImpl.parseIf(ctx, ')')) {
                return ParserImpl.parseWindowFunction(ctx, null, null, DSL.rank());
            }
            List<Field<?>> args = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.rank(args).withinGroupOrderBy(ParserImpl.parseWithinGroupN(ctx));
        }
        return null;
    }

    private static final Field<?> parseFieldDenseRankIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "DENSE_RANK")) {
            ParserImpl.parse(ctx, '(');
            if (ParserImpl.parseIf(ctx, ')')) {
                return ParserImpl.parseWindowFunction(ctx, null, null, DSL.denseRank());
            }
            List<Field<?>> args = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.denseRank(args).withinGroupOrderBy(ParserImpl.parseWithinGroupN(ctx));
        }
        return null;
    }

    private static final Field<?> parseFieldPercentRankIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "PERCENT_RANK")) {
            ParserImpl.parse(ctx, '(');
            if (ParserImpl.parseIf(ctx, ')')) {
                return ParserImpl.parseWindowFunction(ctx, null, null, DSL.percentRank());
            }
            List<Field<?>> args = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.percentRank(args).withinGroupOrderBy(ParserImpl.parseWithinGroupN(ctx));
        }
        return null;
    }

    private static final Field<?> parseFieldCumeDistIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "CUME_DIST")) {
            ParserImpl.parse(ctx, '(');
            if (ParserImpl.parseIf(ctx, ')')) {
                return ParserImpl.parseWindowFunction(ctx, null, null, DSL.cumeDist());
            }
            List<Field<?>> args = ParserImpl.parseFields(ctx);
            ParserImpl.parse(ctx, ')');
            return DSL.cumeDist(args).withinGroupOrderBy(ParserImpl.parseWithinGroupN(ctx));
        }
        return null;
    }

    private static final Field<?> parseFieldRowNumberIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "ROW_NUMBER")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, null, DSL.rowNumber());
        }
        return null;
    }

    private static final Field<?> parseFieldNtileIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "NTILE")) {
            ParserImpl.parse(ctx, '(');
            int number = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, null, DSL.ntile(number));
        }
        return null;
    }

    private static final Field<?> parseFieldLeadLagIf(ParserContext ctx) {
        boolean lag;
        boolean lead = ParserImpl.parseFunctionNameIf(ctx, "LEAD");
        boolean bl = lag = !lead && ParserImpl.parseFunctionNameIf(ctx, "LAG");
        if (lead || lag) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            Integer f2 = null;
            Field<?> f3 = null;
            if (ParserImpl.parseIf(ctx, ',')) {
                f2 = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
                if (ParserImpl.parseIf(ctx, ',')) {
                    f3 = ParserImpl.parseField(ctx);
                }
            }
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, lead ? (f2 == null ? DSL.lead(f1) : (f3 == null ? DSL.lead(f1, f2) : DSL.lead(f1, (int)f2, f3))) : (f2 == null ? DSL.lag(f1) : (f3 == null ? DSL.lag(f1, f2) : DSL.lag(f1, (int)f2, f3))), null);
        }
        return null;
    }

    private static final Field<?> parseFieldFirstValueIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "FIRST_VALUE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.firstValue(arg), null);
        }
        return null;
    }

    private static final Field<?> parseFieldLastValueIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "LAST_VALUE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> arg = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, null, DSL.lastValue(arg), null);
        }
        return null;
    }

    private static final Field<?> parseFieldNthValueIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "NTH_VALUE")) {
            ParserImpl.parse(ctx, '(');
            Field<?> f1 = ParserImpl.parseField(ctx);
            ParserImpl.parse(ctx, ',');
            int f2 = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            ParserImpl.parse(ctx, ')');
            return ParserImpl.parseWindowFunction(ctx, DSL.nthValue(f1, f2), null, null);
        }
        return null;
    }

    private static final Field<?> parseWindowFunction(ParserContext ctx, WindowFromFirstLastStep s1, WindowIgnoreNullsStep s2, WindowOverStep<?> s3) {
        if (!(s1 == null || ParserImpl.parseKeywordIf(ctx, "FROM FIRST") && ctx.requireProEdition() || ParserImpl.parseKeywordIf(ctx, "FROM LAST") && ctx.requireProEdition())) {
            s2 = s1;
        }
        if (!(s2 == null || ParserImpl.parseKeywordIf(ctx, "RESPECT NULLS") && ctx.requireProEdition() || ParserImpl.parseKeywordIf(ctx, "IGNORE NULLS") && ctx.requireProEdition())) {
            s3 = s2;
        }
        ParserImpl.parseKeyword(ctx, "OVER");
        Object nameOrSpecification = ParserImpl.parseWindowNameOrSpecification(ctx, true);
        WindowFinalStep result = nameOrSpecification instanceof Name ? s3.over((Name)nameOrSpecification) : (nameOrSpecification instanceof WindowSpecification ? s3.over((WindowSpecification)nameOrSpecification) : s3.over());
        return result;
    }

    private static final AggregateFunction<?> parseBinarySetFunctionIf(ParserContext ctx) {
        BinarySetFunctionType type = ParserImpl.parseBinarySetFunctionTypeIf(ctx);
        if (type == null) {
            return null;
        }
        ParserImpl.parse(ctx, '(');
        Field<?> arg1 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
        ParserImpl.parse(ctx, ',');
        Field<?> arg2 = ParserImpl.toField(ctx, ParserImpl.parseSum(ctx, Type.N));
        ParserImpl.parse(ctx, ')');
        switch (type) {
            case REGR_AVGX: {
                return DSL.regrAvgX(arg1, arg2);
            }
            case REGR_AVGY: {
                return DSL.regrAvgY(arg1, arg2);
            }
            case REGR_COUNT: {
                return DSL.regrCount(arg1, arg2);
            }
            case REGR_INTERCEPT: {
                return DSL.regrIntercept(arg1, arg2);
            }
            case REGR_R2: {
                return DSL.regrR2(arg1, arg2);
            }
            case REGR_SLOPE: {
                return DSL.regrSlope(arg1, arg2);
            }
            case REGR_SXX: {
                return DSL.regrSXX(arg1, arg2);
            }
            case REGR_SXY: {
                return DSL.regrSXY(arg1, arg2);
            }
            case REGR_SYY: {
                return DSL.regrSYY(arg1, arg2);
            }
        }
        throw ctx.exception("Binary set function not supported: " + (Object)((Object)type));
    }

    private static final AggregateFilterStep<?> parseOrderedSetFunctionIf(ParserContext ctx) {
        OrderedAggregateFunction<Object> orderedN = ParserImpl.parseHypotheticalSetFunctionIf(ctx);
        if (orderedN == null) {
            orderedN = ParserImpl.parseInverseDistributionFunctionIf(ctx);
        }
        if (orderedN == null) {
            orderedN = ParserImpl.parseListaggFunctionIf(ctx);
        }
        if (orderedN != null) {
            return orderedN.withinGroupOrderBy(ParserImpl.parseWithinGroupN(ctx));
        }
        OrderedAggregateFunctionOfDeferredType ordered1 = ParserImpl.parseModeIf(ctx);
        if (ordered1 != null) {
            return ordered1.withinGroupOrderBy(ParserImpl.parseWithinGroup1(ctx));
        }
        return null;
    }

    private static final AggregateFilterStep<?> parseArrayAggFunctionIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "ARRAY_AGG")) {
            ParserImpl.parse(ctx, '(');
            boolean distinct = ParserImpl.parseKeywordIf(ctx, "DISTINCT");
            Field<?> a1 = ParserImpl.parseField(ctx);
            List<SortField<?>> sort = null;
            if (ParserImpl.parseKeywordIf(ctx, "ORDER BY")) {
                sort = ParserImpl.parseSortSpecification(ctx);
            }
            ParserImpl.parse(ctx, ')');
            ArrayAggOrderByStep<?[]> s1 = distinct ? DSL.arrayAggDistinct(a1) : DSL.arrayAgg(a1);
            return sort == null ? s1 : s1.orderBy(sort);
        }
        return null;
    }

    private static final List<SortField<?>> parseWithinGroupN(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "WITHIN GROUP");
        ParserImpl.parse(ctx, '(');
        ParserImpl.parseKeyword(ctx, "ORDER BY");
        List<SortField<?>> result = ParserImpl.parseSortSpecification(ctx);
        ParserImpl.parse(ctx, ')');
        return result;
    }

    private static final SortField<?> parseWithinGroup1(ParserContext ctx) {
        ParserImpl.parseKeyword(ctx, "WITHIN GROUP");
        ParserImpl.parse(ctx, '(');
        ParserImpl.parseKeyword(ctx, "ORDER BY");
        SortField<?> result = ParserImpl.parseSortField(ctx);
        ParserImpl.parse(ctx, ')');
        return result;
    }

    private static final OrderedAggregateFunction<?> parseHypotheticalSetFunctionIf(ParserContext ctx) {
        OrderedAggregateFunction<Number> ordered;
        if (ParserImpl.parseFunctionNameIf(ctx, "RANK")) {
            ParserImpl.parse(ctx, '(');
            ordered = DSL.rank(ParserImpl.parseFields(ctx));
            ParserImpl.parse(ctx, ')');
        } else if (ParserImpl.parseFunctionNameIf(ctx, "DENSE_RANK")) {
            ParserImpl.parse(ctx, '(');
            ordered = DSL.denseRank(ParserImpl.parseFields(ctx));
            ParserImpl.parse(ctx, ')');
        } else if (ParserImpl.parseFunctionNameIf(ctx, "PERCENT_RANK")) {
            ParserImpl.parse(ctx, '(');
            ordered = DSL.percentRank(ParserImpl.parseFields(ctx));
            ParserImpl.parse(ctx, ')');
        } else if (ParserImpl.parseFunctionNameIf(ctx, "CUME_DIST")) {
            ParserImpl.parse(ctx, '(');
            ordered = DSL.cumeDist(ParserImpl.parseFields(ctx));
            ParserImpl.parse(ctx, ')');
        } else {
            ordered = null;
        }
        return ordered;
    }

    private static final OrderedAggregateFunction<BigDecimal> parseInverseDistributionFunctionIf(ParserContext ctx) {
        OrderedAggregateFunction<BigDecimal> ordered;
        if (ParserImpl.parseFunctionNameIf(ctx, "PERCENTILE_CONT")) {
            ParserImpl.parse(ctx, '(');
            ordered = DSL.percentileCont(ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE));
            ParserImpl.parse(ctx, ')');
        } else if (ParserImpl.parseFunctionNameIf(ctx, "PERCENTILE_DISC")) {
            ParserImpl.parse(ctx, '(');
            ordered = DSL.percentileDisc(ParserImpl.parseFieldUnsignedNumericLiteral(ctx, Sign.NONE));
            ParserImpl.parse(ctx, ')');
        } else {
            ordered = null;
        }
        return ordered;
    }

    private static final OrderedAggregateFunction<String> parseListaggFunctionIf(ParserContext ctx) {
        OrderedAggregateFunction<String> ordered;
        if (ParserImpl.parseFunctionNameIf(ctx, "LISTAGG")) {
            ParserImpl.parse(ctx, '(');
            Field<?> field = ParserImpl.parseField(ctx);
            ordered = ParserImpl.parseIf(ctx, ',') ? DSL.listAgg(field, ParserImpl.parseStringLiteral(ctx)) : DSL.listAgg(field);
            ParserImpl.parse(ctx, ')');
        } else {
            ordered = null;
        }
        return ordered;
    }

    private static final OrderedAggregateFunctionOfDeferredType parseModeIf(ParserContext ctx) {
        OrderedAggregateFunctionOfDeferredType ordered;
        if (ParserImpl.parseFunctionNameIf(ctx, "MODE")) {
            ParserImpl.parse(ctx, '(');
            ParserImpl.parse(ctx, ')');
            ordered = DSL.mode();
        } else {
            ordered = null;
        }
        return ordered;
    }

    private static final AggregateFunction<?> parseGeneralSetFunctionIf(ParserContext ctx) {
        boolean distinct;
        ComputationalOperation operation = ParserImpl.parseComputationalOperationIf(ctx);
        if (operation == null) {
            return null;
        }
        ParserImpl.parse(ctx, '(');
        switch (operation) {
            case AVG: 
            case MAX: 
            case MIN: 
            case SUM: {
                distinct = ParserImpl.parseSetQuantifier(ctx);
                break;
            }
            default: {
                distinct = false;
            }
        }
        Field<Boolean> arg = ParserImpl.parseField(ctx);
        ParserImpl.parse(ctx, ')');
        switch (operation) {
            case AVG: {
                return distinct ? DSL.avgDistinct(arg) : DSL.avg(arg);
            }
            case MAX: {
                return distinct ? DSL.maxDistinct(arg) : DSL.max(arg);
            }
            case MIN: {
                return distinct ? DSL.minDistinct(arg) : DSL.min(arg);
            }
            case SUM: {
                return distinct ? DSL.sumDistinct(arg) : DSL.sum(arg);
            }
            case MEDIAN: {
                return DSL.median(arg);
            }
            case EVERY: {
                return DSL.every(arg);
            }
            case ANY: {
                return DSL.boolOr(arg);
            }
            case STDDEV_POP: {
                return DSL.stddevPop(arg);
            }
            case STDDEV_SAMP: {
                return DSL.stddevSamp(arg);
            }
            case VAR_POP: {
                return DSL.varPop(arg);
            }
            case VAR_SAMP: {
                return DSL.varSamp(arg);
            }
        }
        throw ctx.exception("Unsupported computational operation");
    }

    private static final AggregateFunction<?> parseCountIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "COUNT")) {
            ParserImpl.parse(ctx, '(');
            boolean distinct = ParserImpl.parseSetQuantifier(ctx);
            if (ParserImpl.parseIf(ctx, '*') && ParserImpl.parse(ctx, ')')) {
                if (distinct) {
                    return DSL.countDistinct(new Field[0]);
                }
                return DSL.count();
            }
            QualifiedAsterisk asterisk = ParserImpl.parseQualifiedAsteriskIf(ctx);
            List<Field<?>> fields = asterisk == null ? (distinct ? ParserImpl.parseFields(ctx) : Collections.singletonList(ParserImpl.parseField(ctx))) : null;
            ParserImpl.parse(ctx, ')');
            if (distinct) {
                if (fields == null) {
                    return DSL.countDistinct(asterisk);
                }
                if (fields.size() > 0) {
                    return DSL.countDistinct(fields.toArray(Tools.EMPTY_FIELD));
                }
                return DSL.countDistinct(fields.get(0));
            }
            if (fields == null) {
                return DSL.count(asterisk);
            }
            return DSL.count(fields.get(0));
        }
        return null;
    }

    private static final boolean parseSetQuantifier(ParserContext ctx) {
        boolean distinct = ParserImpl.parseKeywordIf(ctx, "DISTINCT");
        if (!distinct) {
            ParserImpl.parseKeywordIf(ctx, "ALL");
        }
        return distinct;
    }

    private static final Catalog parseCatalogName(ParserContext ctx) {
        return DSL.catalog(ParserImpl.parseName(ctx));
    }

    private static final Schema parseSchemaName(ParserContext ctx) {
        return DSL.schema(ParserImpl.parseName(ctx));
    }

    private static final Table<?> parseTableName(ParserContext ctx) {
        return DSL.table(ParserImpl.parseName(ctx));
    }

    private static final Field<?> parseFieldNameOrSequenceExpression(ParserContext ctx) {
        Name name = ParserImpl.parseName(ctx);
        if (name.qualified()) {
            String last = name.last();
            if ("NEXTVAL".equalsIgnoreCase(last)) {
                return DSL.sequence(name.qualifier()).nextval();
            }
            if ("CURRVAL".equalsIgnoreCase(last)) {
                return DSL.sequence(name.qualifier()).currval();
            }
        }
        if (ctx.dsl.settings().getParseUnknownFunctions() == ParseUnknownFunctions.IGNORE && ParserImpl.parseIf(ctx, '(')) {
            ArrayList arguments = new ArrayList();
            if (!ParserImpl.parseIf(ctx, ')')) {
                do {
                    arguments.add(ParserImpl.parseField(ctx));
                } while (ParserImpl.parseIf(ctx, ','));
                ParserImpl.parse(ctx, ')');
            }
            return DSL.function(name, Object.class, arguments.toArray(Tools.EMPTY_FIELD));
        }
        return DSL.field(name);
    }

    private static final TableField<?, ?> parseFieldName(ParserContext ctx) {
        return (TableField)DSL.field(ParserImpl.parseName(ctx));
    }

    private static final List<Field<?>> parseFieldNames(ParserContext ctx) {
        ArrayList result = new ArrayList();
        do {
            result.add(ParserImpl.parseFieldName(ctx));
        } while (ParserImpl.parseIf(ctx, ','));
        return result;
    }

    private static final Sequence<?> parseSequenceName(ParserContext ctx) {
        return DSL.sequence(ParserImpl.parseName(ctx));
    }

    private static final Name parseIndexName(ParserContext ctx) {
        Name result = ParserImpl.parseNameIf(ctx);
        if (result == null) {
            throw ctx.expected("Identifier");
        }
        return result;
    }

    private static final Name parseIndexNameIf(ParserContext ctx) {
        if (!ParserImpl.peekKeyword(ctx, "ON")) {
            return ParserImpl.parseNameIf(ctx);
        }
        return null;
    }

    private static final Collation parseCollation(ParserContext ctx) {
        return DSL.collation(ParserImpl.parseName(ctx));
    }

    private static final Name parseName(ParserContext ctx) {
        Name result = ParserImpl.parseNameIf(ctx);
        if (result == null) {
            throw ctx.expected("Identifier");
        }
        return result;
    }

    private static final Name parseNameIf(ParserContext ctx) {
        Name identifier = ParserImpl.parseIdentifierIf(ctx);
        if (identifier == null) {
            return null;
        }
        if (ParserImpl.parseIf(ctx, '.')) {
            ArrayList<Name> result = new ArrayList<Name>();
            result.add(identifier);
            do {
                result.add(ParserImpl.parseIdentifier(ctx));
            } while (ParserImpl.parseIf(ctx, '.'));
            return DSL.name(result.toArray(Tools.EMPTY_NAME));
        }
        return identifier;
    }

    private static final QualifiedAsterisk parseQualifiedAsteriskIf(ParserContext ctx) {
        int position = ctx.position();
        Name i1 = ParserImpl.parseIdentifierIf(ctx);
        if (i1 == null) {
            return null;
        }
        if (ParserImpl.parseIf(ctx, '.')) {
            ArrayList<Name> result = null;
            do {
                Name i2;
                if ((i2 = ParserImpl.parseIdentifierIf(ctx)) != null) {
                    if (result == null) {
                        result = new ArrayList<Name>();
                        result.add(i1);
                    }
                } else {
                    ParserImpl.parse(ctx, '*');
                    return DSL.table(result == null ? i1 : DSL.name(result.toArray(Tools.EMPTY_NAME))).asterisk();
                }
                result.add(i2);
            } while (ParserImpl.parseIf(ctx, '.'));
        }
        ctx.position(position);
        return null;
    }

    private static final List<Name> parseIdentifiers(ParserContext ctx) {
        LinkedHashSet<Name> result = new LinkedHashSet<Name>();
        do {
            if (result.add(ParserImpl.parseIdentifier(ctx))) continue;
            throw ctx.exception("Duplicate identifier encountered");
        } while (ParserImpl.parseIf(ctx, ','));
        return new ArrayList<Name>(result);
    }

    private static final Name parseIdentifier(ParserContext ctx) {
        return ParserImpl.parseIdentifier(ctx, false);
    }

    private static final Name parseIdentifier(ParserContext ctx, boolean allowAposQuotes) {
        Name result = ParserImpl.parseIdentifierIf(ctx, allowAposQuotes);
        if (result == null) {
            throw ctx.expected("Identifier");
        }
        return result;
    }

    private static final Name parseIdentifierIf(ParserContext ctx) {
        return ParserImpl.parseIdentifierIf(ctx, false);
    }

    private static final Name parseIdentifierIf(ParserContext ctx, boolean allowAposQuotes) {
        char quoteEnd = ParserImpl.parseQuote(ctx, allowAposQuotes);
        int start = ctx.position();
        if (quoteEnd != '\u0000') {
            while (ctx.character() != quoteEnd && ctx.hasMore()) {
                ctx.positionInc();
            }
        } else {
            while (ctx.isIdentifierPart() && ctx.hasMore()) {
                ctx.positionInc();
            }
        }
        if (ctx.position() == start) {
            return null;
        }
        String result = ctx.substring(start, ctx.position());
        if (quoteEnd != '\u0000') {
            if (ctx.character() != quoteEnd) {
                throw ctx.exception("Quoted identifier must terminate in " + quoteEnd);
            }
            ctx.positionInc();
            ParserImpl.parseWhitespaceIf(ctx);
            return DSL.quotedName(result);
        }
        ParserImpl.parseWhitespaceIf(ctx);
        return DSL.unquotedName(result);
    }

    private static final char parseQuote(ParserContext ctx, boolean allowAposQuotes) {
        return (char)(ParserImpl.parseIf(ctx, '\"', false) ? 34 : (ParserImpl.parseIf(ctx, '`', false) ? 96 : (ParserImpl.parseIf(ctx, '[', false) ? 93 : (allowAposQuotes && ParserImpl.parseIf(ctx, '\'', false) ? 39 : 0))));
    }

    private static final DataType<?> parseCastDataType(ParserContext ctx) {
        char character = ctx.character();
        switch (character) {
            case 'S': 
            case 's': {
                if (!ParserImpl.parseKeywordIf(ctx, "SIGNED")) break;
                if (!ParserImpl.parseKeywordIf(ctx, "INTEGER")) {
                    // empty if block
                }
                return SQLDataType.BIGINT;
            }
            case 'U': 
            case 'u': {
                if (!ParserImpl.parseKeywordIf(ctx, "UNSIGNED")) break;
                if (!ParserImpl.parseKeywordIf(ctx, "INTEGER")) {
                    // empty if block
                }
                return SQLDataType.BIGINTUNSIGNED;
            }
        }
        return ParserImpl.parseDataType(ctx);
    }

    private static final DataType<?> parseDataType(ParserContext ctx) {
        DataType<Object> result = ParserImpl.parseDataTypePrefix(ctx);
        boolean array = false;
        if (ParserImpl.parseKeywordIf(ctx, "ARRAY")) {
            array = true;
        }
        if (ParserImpl.parseIf(ctx, '[')) {
            ParserImpl.parseUnsignedIntegerIf(ctx);
            ParserImpl.parse(ctx, ']');
            array = true;
        }
        if (array) {
            result = result.getArrayDataType();
        }
        return result;
    }

    private static final DataType<?> parseDataTypePrefix(ParserContext ctx) {
        char character = ctx.character();
        if (character == '[' || character == '\"' || character == '`') {
            character = ctx.characterNext();
        }
        switch (character) {
            case 'A': 
            case 'a': {
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "ARRAY")) break;
                return SQLDataType.OTHER.getArrayDataType();
            }
            case 'B': 
            case 'b': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "BIGINT")) {
                    return ParserImpl.parseUnsigned(ctx, ParserImpl.parseAndIgnoreDataTypeLength(ctx, SQLDataType.BIGINT));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "BIGSERIAL")) {
                    return SQLDataType.BIGINT.identity(true);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "BINARY")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.BINARY);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "BIT")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.BIT);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "BLOB")) {
                    return ParserImpl.parseDataTypeLength(ctx, SQLDataType.BLOB);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "BOOLEAN")) {
                    return SQLDataType.BOOLEAN;
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "BYTEA")) break;
                return SQLDataType.BLOB;
            }
            case 'C': 
            case 'c': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "CHARACTER VARYING")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.VARCHAR));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "CHAR") || ParserImpl.parseKeywordOrIdentifierIf(ctx, "CHARACTER")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.CHAR));
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "CLOB")) break;
                return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.CLOB));
            }
            case 'D': 
            case 'd': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "DATE")) {
                    return SQLDataType.DATE;
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "DATETIME")) {
                    return ParserImpl.parseDataTypePrecision(ctx, SQLDataType.TIMESTAMP);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "DECIMAL")) {
                    return ParserImpl.parseDataTypePrecisionScale(ctx, SQLDataType.DECIMAL);
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "DOUBLE PRECISION") && !ParserImpl.parseKeywordOrIdentifierIf(ctx, "DOUBLE")) break;
                return ParserImpl.parseAndIgnoreDataTypePrecisionScale(ctx, SQLDataType.DOUBLE);
            }
            case 'E': 
            case 'e': {
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "ENUM")) break;
                return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeEnum(ctx));
            }
            case 'F': 
            case 'f': {
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "FLOAT")) break;
                return ParserImpl.parseAndIgnoreDataTypePrecisionScale(ctx, SQLDataType.FLOAT);
            }
            case 'I': 
            case 'i': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "INTEGER") || ParserImpl.parseKeywordOrIdentifierIf(ctx, "INT") || ParserImpl.parseKeywordOrIdentifierIf(ctx, "INT4")) {
                    return ParserImpl.parseUnsigned(ctx, ParserImpl.parseAndIgnoreDataTypeLength(ctx, SQLDataType.INTEGER));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "INT2")) {
                    return SQLDataType.SMALLINT;
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "INT8")) break;
                return SQLDataType.BIGINT;
            }
            case 'L': 
            case 'l': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "LONGBLOB")) {
                    return SQLDataType.BLOB;
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "LONGTEXT")) {
                    return ParserImpl.parseDataTypeCollation(ctx, SQLDataType.CLOB);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "LONG NVARCHAR")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.LONGNVARCHAR));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "LONG VARBINARY")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.LONGVARBINARY));
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "LONG VARCHAR")) break;
                return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.LONGVARCHAR));
            }
            case 'M': 
            case 'm': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "MEDIUMBLOB")) {
                    return SQLDataType.BLOB;
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "MEDIUMINT")) {
                    return ParserImpl.parseUnsigned(ctx, ParserImpl.parseAndIgnoreDataTypeLength(ctx, SQLDataType.INTEGER));
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "MEDIUMTEXT")) break;
                return ParserImpl.parseDataTypeCollation(ctx, SQLDataType.CLOB);
            }
            case 'N': 
            case 'n': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "NCHAR")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.NCHAR));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "NCLOB")) {
                    return ParserImpl.parseDataTypeCollation(ctx, SQLDataType.NCLOB);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "NUMBER") || ParserImpl.parseKeywordOrIdentifierIf(ctx, "NUMERIC")) {
                    return ParserImpl.parseDataTypePrecisionScale(ctx, SQLDataType.NUMERIC);
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "NVARCHAR")) break;
                return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.NVARCHAR));
            }
            case 'O': 
            case 'o': {
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "OTHER")) break;
                return SQLDataType.OTHER;
            }
            case 'R': 
            case 'r': {
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "REAL")) break;
                return ParserImpl.parseAndIgnoreDataTypePrecisionScale(ctx, SQLDataType.REAL);
            }
            case 'S': 
            case 's': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "SERIAL4") || ParserImpl.parseKeywordOrIdentifierIf(ctx, "SERIAL")) {
                    return SQLDataType.INTEGER.identity(true);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "SERIAL8")) {
                    return SQLDataType.BIGINT.identity(true);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "SET")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeEnum(ctx));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "SMALLINT")) {
                    return ParserImpl.parseUnsigned(ctx, ParserImpl.parseAndIgnoreDataTypeLength(ctx, SQLDataType.SMALLINT));
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "SMALLSERIAL") && !ParserImpl.parseKeywordOrIdentifierIf(ctx, "SERIAL2")) break;
                return SQLDataType.SMALLINT.identity(true);
            }
            case 'T': 
            case 't': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TEXT")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseAndIgnoreDataTypeLength(ctx, SQLDataType.CLOB));
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TIMESTAMPTZ")) {
                    return ParserImpl.parseDataTypePrecision(ctx, SQLDataType.TIMESTAMPWITHTIMEZONE);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TIMESTAMP")) {
                    Integer precision = ParserImpl.parseDataTypePrecision(ctx);
                    if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "WITH TIME ZONE")) {
                        return precision == null ? SQLDataType.TIMESTAMPWITHTIMEZONE : SQLDataType.TIMESTAMPWITHTIMEZONE(precision);
                    }
                    if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "WITHOUT TIME ZONE")) {
                        // empty if block
                    }
                    return precision == null ? SQLDataType.TIMESTAMP : SQLDataType.TIMESTAMP(precision);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TIMETZ")) {
                    return ParserImpl.parseDataTypePrecision(ctx, SQLDataType.TIMEWITHTIMEZONE);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TIME")) {
                    Integer precision = ParserImpl.parseDataTypePrecision(ctx);
                    if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "WITH TIME ZONE")) {
                        return precision == null ? SQLDataType.TIMEWITHTIMEZONE : SQLDataType.TIMEWITHTIMEZONE(precision);
                    }
                    if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "WITHOUT TIME ZONE")) {
                        // empty if block
                    }
                    return precision == null ? SQLDataType.TIME : SQLDataType.TIME(precision);
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TINYBLOB")) {
                    return SQLDataType.BLOB;
                }
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "TINYINT")) {
                    return ParserImpl.parseUnsigned(ctx, ParserImpl.parseAndIgnoreDataTypeLength(ctx, SQLDataType.TINYINT));
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "TINYTEXT")) break;
                return ParserImpl.parseDataTypeCollation(ctx, SQLDataType.CLOB);
            }
            case 'U': 
            case 'u': {
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "UUID")) break;
                return SQLDataType.UUID;
            }
            case 'V': 
            case 'v': {
                if (ParserImpl.parseKeywordOrIdentifierIf(ctx, "VARCHAR") || ParserImpl.parseKeywordOrIdentifierIf(ctx, "VARCHAR2")) {
                    return ParserImpl.parseDataTypeCollation(ctx, ParserImpl.parseDataTypeLength(ctx, SQLDataType.VARCHAR));
                }
                if (!ParserImpl.parseKeywordOrIdentifierIf(ctx, "VARBINARY")) break;
                return ParserImpl.parseDataTypeLength(ctx, SQLDataType.VARBINARY);
            }
        }
        throw ctx.exception("Unknown data type");
    }

    private static final boolean parseKeywordOrIdentifierIf(ParserContext ctx, String keyword) {
        int position = ctx.position();
        char quoteEnd = ParserImpl.parseQuote(ctx, false);
        boolean result = ParserImpl.parseKeywordIf(ctx, keyword);
        if (!result) {
            ctx.position(position);
        } else if (quoteEnd != '\u0000') {
            ParserImpl.parse(ctx, quoteEnd);
        }
        return result;
    }

    private static final DataType<?> parseUnsigned(ParserContext ctx, DataType result) {
        if (ParserImpl.parseKeywordIf(ctx, "UNSIGNED")) {
            if (result == SQLDataType.TINYINT) {
                return SQLDataType.TINYINTUNSIGNED;
            }
            if (result == SQLDataType.SMALLINT) {
                return SQLDataType.SMALLINTUNSIGNED;
            }
            if (result == SQLDataType.INTEGER) {
                return SQLDataType.INTEGERUNSIGNED;
            }
            if (result == SQLDataType.BIGINT) {
                return SQLDataType.BIGINTUNSIGNED;
            }
        }
        return result;
    }

    private static final DataType<?> parseAndIgnoreDataTypeLength(ParserContext ctx, DataType<?> result) {
        if (ParserImpl.parseIf(ctx, '(')) {
            ParserImpl.parseUnsignedInteger(ctx);
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    private static final DataType<?> parseDataTypeLength(ParserContext ctx, DataType<?> in) {
        DataType<?> result = in;
        if (ParserImpl.parseIf(ctx, '(')) {
            if (!ParserImpl.parseKeywordIf(ctx, "MAX")) {
                result = result.length((int)ParserImpl.parseUnsignedInteger(ctx).longValue());
            }
            if (!(in != SQLDataType.VARCHAR && in != SQLDataType.CHAR || ParserImpl.parseKeywordIf(ctx, "BYTE"))) {
                ParserImpl.parseKeywordIf(ctx, "CHAR");
            }
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    private static final DataType<?> parseDataTypeCollation(ParserContext ctx, DataType<?> result) {
        if (ParserImpl.parseKeywordIf(ctx, "COLLATE")) {
            result = result.collation(ParserImpl.parseCollation(ctx));
        }
        return result;
    }

    private static final DataType<?> parseAndIgnoreDataTypePrecisionScale(ParserContext ctx, DataType<?> result) {
        if (ParserImpl.parseIf(ctx, '(')) {
            ParserImpl.parseUnsignedInteger(ctx);
            if (ParserImpl.parseIf(ctx, ',')) {
                ParserImpl.parseUnsignedInteger(ctx);
            }
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    private static final Integer parseDataTypePrecision(ParserContext ctx) {
        Integer precision = null;
        if (ParserImpl.parseIf(ctx, '(')) {
            precision = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            ParserImpl.parse(ctx, ')');
        }
        return precision;
    }

    private static final DataType<?> parseDataTypePrecision(ParserContext ctx, DataType<?> result) {
        if (ParserImpl.parseIf(ctx, '(')) {
            int precision = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            result = result.precision(precision);
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    private static final DataType<?> parseDataTypePrecisionScale(ParserContext ctx, DataType<?> result) {
        if (ParserImpl.parseIf(ctx, '(')) {
            int precision = (int)ParserImpl.parseUnsignedInteger(ctx).longValue();
            result = ParserImpl.parseIf(ctx, ',') ? result.precision(precision, (int)ParserImpl.parseUnsignedInteger(ctx).longValue()) : result.precision(precision);
            ParserImpl.parse(ctx, ')');
        }
        return result;
    }

    private static final DataType<?> parseDataTypeEnum(ParserContext ctx) {
        ParserImpl.parse(ctx, '(');
        ArrayList<String> literals = new ArrayList<String>();
        int length = 0;
        do {
            String literal;
            if ((literal = ParserImpl.parseStringLiteral(ctx)) != null) {
                length = Math.max(length, literal.length());
            }
            literals.add(literal);
        } while (ParserImpl.parseIf(ctx, ','));
        ParserImpl.parse(ctx, ')');
        String className = "GeneratedEnum" + (literals.hashCode() & 0x7FFFFFF);
        return SQLDataType.VARCHAR(length).asEnumDataType((Class)Reflect.compile("org.jooq.impl." + className, "package org.jooq.impl;\nenum " + className + " implements org.jooq.EnumType {\n  " + String.join((CharSequence)", ", literals) + ";\n  @Override\n  public String getName() {\n    return getClass().getName();\n  }\n  @Override\n  public String getLiteral() {\n    return name();  }\n}").get());
    }

    private static final char parseCharacterLiteral(ParserContext ctx) {
        ParserImpl.parse(ctx, '\'', false);
        char c = ctx.character();
        if (c == '\'') {
            ParserImpl.parse(ctx, '\'', false);
        }
        ctx.positionInc();
        ParserImpl.parse(ctx, '\'');
        return c;
    }

    private static final Field<?> parseBindVariable(ParserContext ctx) {
        switch (ctx.character()) {
            case '?': {
                ParserImpl.parse(ctx, '?');
                return DSL.val(ctx.nextBinding(), Object.class);
            }
            case ':': {
                ParserImpl.parse(ctx, ':', false);
                return DSL.param(ParserImpl.parseIdentifier(ctx).last(), ctx.nextBinding());
            }
        }
        throw ctx.exception("Illegal bind variable character");
    }

    private static final Comment parseComment(ParserContext ctx) {
        return DSL.comment(ParserImpl.parseStringLiteral(ctx));
    }

    private static final String parseStringLiteral(ParserContext ctx) {
        String result = ParserImpl.parseStringLiteralIf(ctx);
        if (result == null) {
            throw ctx.expected("String literal");
        }
        return result;
    }

    private static final String parseStringLiteralIf(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, 'q', '\'', false) || ParserImpl.parseIf(ctx, 'Q', '\'', false)) {
            return ParserImpl.parseOracleQuotedStringLiteral(ctx);
        }
        if (ParserImpl.parseIf(ctx, 'e', '\'', false) || ParserImpl.parseIf(ctx, 'E', '\'', false)) {
            return ParserImpl.parseUnquotedStringLiteral(ctx, true);
        }
        if (ParserImpl.peek(ctx, '\'')) {
            return ParserImpl.parseUnquotedStringLiteral(ctx, false);
        }
        return null;
    }

    private static final byte[] parseBinaryLiteralIf(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, "X'", false) || ParserImpl.parseIf(ctx, "x'", false)) {
            if (ParserImpl.parseIf(ctx, '\'')) {
                return Tools.EMPTY_BYTE;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            char c1 = '\u0000';
            char c2 = '\u0000';
            while (true) {
                if (ctx.hasMore() && (c1 = ctx.character()) == ' ') {
                    ctx.positionInc();
                    continue;
                }
                c2 = ctx.characterNext();
                if (c1 == '\'') break;
                if (c2 == '\'') {
                    throw ctx.exception("Unexpected token: \"'\"");
                }
                try {
                    buffer.write(Integer.parseInt("" + c1 + c2, 16));
                }
                catch (NumberFormatException e) {
                    throw ctx.exception("Illegal character for binary literal");
                }
                ctx.positionInc(2);
                if (!ctx.hasMore()) break;
            }
            if (c1 == '\'') {
                ctx.positionInc();
                ParserImpl.parseWhitespaceIf(ctx);
                return buffer.toByteArray();
            }
            throw ctx.exception("Binary literal not terminated");
        }
        return null;
    }

    private static final String parseOracleQuotedStringLiteral(ParserContext ctx) {
        char end;
        ParserImpl.parse(ctx, '\'', false);
        char start = ctx.character();
        switch (start) {
            case '[': {
                end = ']';
                ctx.positionInc();
                break;
            }
            case '{': {
                end = '}';
                ctx.positionInc();
                break;
            }
            case '(': {
                end = ')';
                ctx.positionInc();
                break;
            }
            case '<': {
                end = '>';
                ctx.positionInc();
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                throw ctx.exception("Illegal quote string character");
            }
            default: {
                end = start;
                ctx.positionInc();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i = ctx.position(); i < ctx.sql.length; ++i) {
            char c = ctx.character(i);
            if (c == end) {
                if (ctx.character(i + 1) == '\'') {
                    ctx.position(i + 2);
                    ParserImpl.parseWhitespaceIf(ctx);
                    return sb.toString();
                }
                ++i;
            }
            sb.append(c);
        }
        throw ctx.exception("Quoted string literal not terminated");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String parseUnquotedStringLiteral(ParserContext ctx, boolean postgresEscaping) {
        ParserImpl.parse(ctx, '\'', false);
        StringBuilder sb = new StringBuilder();
        int i = ctx.position();
        while (true) {
            block22: {
                if (i >= ctx.sql.length) {
                    throw ctx.exception("String literal not terminated");
                }
                int c1 = ctx.character(i);
                switch (c1) {
                    case 92: {
                        if (!postgresEscaping) break;
                        char c2 = ctx.character(++i);
                        switch (c2) {
                            case 'b': {
                                c1 = 8;
                                break;
                            }
                            case 'n': {
                                c1 = 10;
                                break;
                            }
                            case 't': {
                                c1 = 9;
                                break;
                            }
                            case 'r': {
                                c1 = 13;
                                break;
                            }
                            case 'f': {
                                c1 = 12;
                                break;
                            }
                            case 'x': {
                                char c3 = ctx.character(i + 1);
                                char c4 = ctx.character(i + 2);
                                int d3 = Character.digit(c3, 16);
                                if (d3 == -1) {
                                    throw ctx.exception("Illegal hexadecimal byte value");
                                }
                                ++i;
                                int d4 = Character.digit(c4, 16);
                                if (d4 != -1) {
                                    c1 = (char)(16 * d3 + d4);
                                    ++i;
                                    break;
                                }
                                c1 = (char)d3;
                                break;
                            }
                            case 'u': {
                                c1 = (char)Integer.parseInt(new String(ctx.sql, i + 1, 4), 16);
                                i += 4;
                                break;
                            }
                            case 'U': {
                                sb.appendCodePoint(Integer.parseInt(new String(ctx.sql, i + 1, 8), 16));
                                i += 8;
                                break block22;
                            }
                            default: {
                                char c4;
                                char c3;
                                if (Character.digit(c2, 8) != -1) {
                                    c3 = ctx.character(i + 1);
                                    if (Character.digit(c3, 8) != -1) {
                                        if (Character.digit(c4 = ctx.character(++i + 1), 8) != -1) {
                                            ++i;
                                            c1 = (char)Integer.parseInt("" + c2 + c3 + c4, 8);
                                            break;
                                        }
                                        c1 = (char)Integer.parseInt("" + c2 + c3, 8);
                                        break;
                                    }
                                    c1 = (char)Integer.parseInt("" + c2, 8);
                                    break;
                                }
                                c1 = c2;
                                break;
                            }
                        }
                        break;
                    }
                    case 39: {
                        if (ctx.character(i + 1) != '\'') {
                            ctx.position(i + 1);
                            ParserImpl.parseWhitespaceIf(ctx);
                            return sb.toString();
                        }
                        ++i;
                    }
                }
                sb.append((char)c1);
            }
            ++i;
        }
    }

    private static final Field<Number> parseFieldUnsignedNumericLiteral(ParserContext ctx, Sign sign) {
        Field<Number> result = ParserImpl.parseFieldUnsignedNumericLiteralIf(ctx, sign);
        if (result == null) {
            throw ctx.expected("Unsigned numeric literal");
        }
        return result;
    }

    private static final Field<Number> parseFieldUnsignedNumericLiteralIf(ParserContext ctx, Sign sign) {
        Number r = ParserImpl.parseUnsignedNumericLiteralIf(ctx, sign);
        return r == null ? null : DSL.inline(r);
    }

    private static final Number parseUnsignedNumericLiteralIf(ParserContext ctx, Sign sign) {
        char c;
        int position = ctx.position();
        while ((c = ctx.character()) >= '0' && c <= '9') {
            ctx.positionInc();
        }
        if (c == '.') {
            ctx.positionInc();
        } else {
            if (position == ctx.position()) {
                return null;
            }
            String s = ctx.substring(position, ctx.position());
            ParserImpl.parseWhitespaceIf(ctx);
            try {
                return sign == Sign.MINUS ? -Long.valueOf(s).longValue() : Long.valueOf(s);
            }
            catch (Exception e1) {
                return sign == Sign.MINUS ? new BigInteger(s).negate() : new BigInteger(s);
            }
        }
        while ((c = ctx.character()) >= '0' && c <= '9') {
            ctx.positionInc();
        }
        if (position == ctx.position()) {
            return null;
        }
        String s = ctx.substring(position, ctx.position());
        ParserImpl.parseWhitespaceIf(ctx);
        return sign == Sign.MINUS ? new BigDecimal(s).negate() : new BigDecimal(s);
    }

    private static final Field<Integer> parseZeroOne(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, '0')) {
            return DSL.zero();
        }
        if (ParserImpl.parseIf(ctx, '1')) {
            return DSL.one();
        }
        throw ctx.expected("0 or 1");
    }

    private static final Field<Integer> parseZeroOneDefault(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, '0')) {
            return DSL.zero();
        }
        if (ParserImpl.parseIf(ctx, '1')) {
            return DSL.one();
        }
        if (ParserImpl.parseKeywordIf(ctx, "DEFAULT")) {
            return DSL.defaultValue(SQLDataType.INTEGER);
        }
        throw ctx.expected("0 or 1");
    }

    private static final Long parseSignedInteger(ParserContext ctx) {
        Long result = ParserImpl.parseSignedIntegerIf(ctx);
        if (result == null) {
            throw ctx.expected("Signed integer");
        }
        return result;
    }

    private static final Long parseSignedIntegerIf(ParserContext ctx) {
        Sign sign = ParserImpl.parseSign(ctx);
        Long unsigned = sign == Sign.MINUS ? ParserImpl.parseUnsignedInteger(ctx) : ParserImpl.parseUnsignedIntegerIf(ctx);
        return unsigned == null ? null : Long.valueOf(sign == Sign.MINUS ? -unsigned.longValue() : unsigned);
    }

    private static final Long parseUnsignedInteger(ParserContext ctx) {
        Long result = ParserImpl.parseUnsignedIntegerIf(ctx);
        if (result == null) {
            throw ctx.expected("Unsigned integer");
        }
        return result;
    }

    private static final Long parseUnsignedIntegerIf(ParserContext ctx) {
        char c;
        int position = ctx.position();
        while ((c = ctx.character()) >= '0' && c <= '9') {
            ctx.positionInc();
        }
        if (position == ctx.position()) {
            return null;
        }
        String s = ctx.substring(position, ctx.position());
        ParserImpl.parseWhitespaceIf(ctx);
        return Long.valueOf(s);
    }

    private static final JoinType parseJoinTypeIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "CROSS JOIN")) {
            return JoinType.CROSS_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "CROSS APPLY")) {
            return JoinType.CROSS_APPLY;
        }
        if (ParserImpl.parseKeywordIf(ctx, "CROSS JOIN")) {
            return JoinType.CROSS_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "INNER")) {
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "JOIN")) {
            return JoinType.JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "LEFT")) {
            if (ParserImpl.parseKeywordIf(ctx, "SEMI")) {
                ParserImpl.parseKeyword(ctx, "JOIN");
                return JoinType.LEFT_SEMI_JOIN;
            }
            if (ParserImpl.parseKeywordIf(ctx, "ANTI")) {
                ParserImpl.parseKeyword(ctx, "JOIN");
                return JoinType.LEFT_ANTI_JOIN;
            }
            ParserImpl.parseKeywordIf(ctx, "OUTER");
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "RIGHT")) {
            ParserImpl.parseKeywordIf(ctx, "OUTER");
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.RIGHT_OUTER_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "FULL")) {
            ParserImpl.parseKeywordIf(ctx, "OUTER");
            ParserImpl.parseKeyword(ctx, "JOIN");
            return JoinType.FULL_OUTER_JOIN;
        }
        if (ParserImpl.parseKeywordIf(ctx, "OUTER APPLY")) {
            return JoinType.OUTER_APPLY;
        }
        if (ParserImpl.parseKeywordIf(ctx, "NATURAL")) {
            if (ParserImpl.parseKeywordIf(ctx, "LEFT")) {
                ParserImpl.parseKeywordIf(ctx, "OUTER");
                ParserImpl.parseKeyword(ctx, "JOIN");
                return JoinType.NATURAL_LEFT_OUTER_JOIN;
            }
            if (ParserImpl.parseKeywordIf(ctx, "RIGHT")) {
                ParserImpl.parseKeywordIf(ctx, "OUTER");
                ParserImpl.parseKeyword(ctx, "JOIN");
                return JoinType.NATURAL_RIGHT_OUTER_JOIN;
            }
            if (ParserImpl.parseKeywordIf(ctx, "JOIN")) {
                return JoinType.NATURAL_JOIN;
            }
        } else if (ParserImpl.parseKeywordIf(ctx, "STRAIGHT_JOIN")) {
            return JoinType.STRAIGHT_JOIN;
        }
        return null;
    }

    private static final TruthValue parseTruthValueIf(ParserContext ctx) {
        if (ParserImpl.parseKeywordIf(ctx, "TRUE")) {
            return TruthValue.TRUE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "FALSE")) {
            return TruthValue.FALSE;
        }
        if (ParserImpl.parseKeywordIf(ctx, "NULL")) {
            return TruthValue.NULL;
        }
        return null;
    }

    private static final CombineOperator parseCombineOperatorIf(ParserContext ctx, boolean intersectOnly) {
        if (!intersectOnly && ParserImpl.parseKeywordIf(ctx, "UNION")) {
            if (ParserImpl.parseKeywordIf(ctx, "ALL")) {
                return CombineOperator.UNION_ALL;
            }
            if (ParserImpl.parseKeywordIf(ctx, "DISTINCT")) {
                return CombineOperator.UNION;
            }
            return CombineOperator.UNION;
        }
        if (!intersectOnly && (ParserImpl.parseKeywordIf(ctx, "EXCEPT") || ParserImpl.parseKeywordIf(ctx, "MINUS"))) {
            if (ParserImpl.parseKeywordIf(ctx, "ALL")) {
                return CombineOperator.EXCEPT_ALL;
            }
            if (ParserImpl.parseKeywordIf(ctx, "DISTINCT")) {
                return CombineOperator.EXCEPT;
            }
            return CombineOperator.EXCEPT;
        }
        if (intersectOnly && ParserImpl.parseKeywordIf(ctx, "INTERSECT")) {
            if (ParserImpl.parseKeywordIf(ctx, "ALL")) {
                return CombineOperator.INTERSECT_ALL;
            }
            if (ParserImpl.parseKeywordIf(ctx, "DISTINCT")) {
                return CombineOperator.INTERSECT;
            }
            return CombineOperator.INTERSECT;
        }
        return null;
    }

    private static final ComputationalOperation parseComputationalOperationIf(ParserContext ctx) {
        if (ParserImpl.parseFunctionNameIf(ctx, "AVG")) {
            return ComputationalOperation.AVG;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "MAX")) {
            return ComputationalOperation.MAX;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "MIN")) {
            return ComputationalOperation.MIN;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "SUM")) {
            return ComputationalOperation.SUM;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "MEDIAN")) {
            return ComputationalOperation.MEDIAN;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "EVERY") || ParserImpl.parseFunctionNameIf(ctx, "BOOL_AND")) {
            return ComputationalOperation.EVERY;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "ANY") || ParserImpl.parseFunctionNameIf(ctx, "SOME") || ParserImpl.parseFunctionNameIf(ctx, "BOOL_OR")) {
            return ComputationalOperation.ANY;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "STDDEV_POP")) {
            return ComputationalOperation.STDDEV_POP;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "STDDEV_SAMP")) {
            return ComputationalOperation.STDDEV_SAMP;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "VAR_POP")) {
            return ComputationalOperation.VAR_POP;
        }
        if (ParserImpl.parseFunctionNameIf(ctx, "VAR_SAMP")) {
            return ComputationalOperation.VAR_SAMP;
        }
        return null;
    }

    private static final BinarySetFunctionType parseBinarySetFunctionTypeIf(ParserContext ctx) {
        for (BinarySetFunctionType type : BinarySetFunctionType.values()) {
            if (!ParserImpl.parseFunctionNameIf(ctx, type.name())) continue;
            return type;
        }
        return null;
    }

    private static final Comparator parseComparatorIf(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, "=")) {
            return Comparator.EQUALS;
        }
        if (ParserImpl.parseIf(ctx, "!=") || ParserImpl.parseIf(ctx, "<>")) {
            return Comparator.NOT_EQUALS;
        }
        if (ParserImpl.parseIf(ctx, ">=")) {
            return Comparator.GREATER_OR_EQUAL;
        }
        if (ParserImpl.parseIf(ctx, ">")) {
            return Comparator.GREATER;
        }
        if (ParserImpl.parseIf(ctx, "<=>")) {
            return Comparator.IS_NOT_DISTINCT_FROM;
        }
        if (ParserImpl.parseIf(ctx, "<=")) {
            return Comparator.LESS_OR_EQUAL;
        }
        if (ParserImpl.parseIf(ctx, "<")) {
            return Comparator.LESS;
        }
        return null;
    }

    private static final TSQLOuterJoinComparator parseTSQLOuterJoinComparatorIf(ParserContext ctx) {
        if (ParserImpl.parseIf(ctx, "*=")) {
            return TSQLOuterJoinComparator.LEFT;
        }
        if (ParserImpl.parseIf(ctx, "=*")) {
            return TSQLOuterJoinComparator.RIGHT;
        }
        return null;
    }

    private static final String parseUntilEOL(ParserContext ctx) {
        String result = ParserImpl.parseUntilEOLIf(ctx);
        if (result == null) {
            throw ctx.expected("Content before EOL");
        }
        return result;
    }

    private static final String parseUntilEOLIf(ParserContext ctx) {
        int start;
        int stop;
        for (stop = start = ctx.position(); stop < ctx.sql.length; ++stop) {
            char c = ctx.character(stop);
            if (c == '\r') {
                if (ctx.character(stop + 1) != '\n') break;
                ++stop;
                break;
            }
            if (c == '\n') break;
        }
        if (start == stop) {
            return null;
        }
        ctx.position(stop);
        ParserImpl.parseWhitespaceIf(ctx);
        return ctx.substring(start, stop);
    }

    private static final boolean parseIf(ParserContext ctx, String string) {
        return ParserImpl.parseIf(ctx, string, true);
    }

    private static final boolean parseIf(ParserContext ctx, String string, boolean skipAfterWhitespace) {
        boolean result = ParserImpl.peek(ctx, string);
        if (result) {
            ctx.positionInc(string.length());
            if (skipAfterWhitespace) {
                ParserImpl.parseWhitespaceIf(ctx);
            }
        }
        return result;
    }

    private static final boolean parse(ParserContext ctx, char c) {
        return ParserImpl.parse(ctx, c, true);
    }

    private static final boolean parse(ParserContext ctx, char c, boolean skipAfterWhitespace) {
        if (!ParserImpl.parseIf(ctx, c, skipAfterWhitespace)) {
            throw ctx.expected("Token '" + c + "'");
        }
        return true;
    }

    private static final boolean parseIf(ParserContext ctx, char c) {
        return ParserImpl.parseIf(ctx, c, true);
    }

    private static final boolean parseIf(ParserContext ctx, char c, boolean skipAfterWhitespace) {
        boolean result = ParserImpl.peek(ctx, c);
        if (result) {
            ctx.positionInc();
            if (skipAfterWhitespace) {
                ParserImpl.parseWhitespaceIf(ctx);
            }
        }
        return result;
    }

    private static final boolean parseIf(ParserContext ctx, char c, char peek, boolean skipAfterWhitespace) {
        if (ctx.character() != c) {
            return false;
        }
        if (ctx.characterNext() != peek) {
            return false;
        }
        ctx.positionInc();
        if (skipAfterWhitespace) {
            ParserImpl.parseWhitespaceIf(ctx);
        }
        return true;
    }

    private static final boolean parseFunctionNameIf(ParserContext ctx, String string) {
        return ParserImpl.peekKeyword(ctx, string, true, false, true);
    }

    private static final void parseKeyword(ParserContext ctx, String keyword) {
        if (!ParserImpl.parseKeywordIf(ctx, keyword)) {
            throw ctx.expected("Keyword '" + keyword + "'");
        }
    }

    private static final boolean parseKeywordIf(ParserContext ctx, String keyword) {
        return ParserImpl.peekKeyword(ctx, keyword, true, false, false);
    }

    private static final Keyword parseAndGetKeyword(ParserContext ctx, String ... keywords) {
        Keyword result = ParserImpl.parseAndGetKeywordIf(ctx, keywords);
        if (result == null) {
            throw ctx.expected(keywords);
        }
        return result;
    }

    private static final Keyword parseAndGetKeywordIf(ParserContext ctx, String ... keywords) {
        for (String keyword : keywords) {
            if (!ParserImpl.parseKeywordIf(ctx, keyword)) continue;
            return DSL.keyword(keyword.toLowerCase());
        }
        return null;
    }

    private static final Keyword parseAndGetKeywordIf(ParserContext ctx, String keyword) {
        if (ParserImpl.parseKeywordIf(ctx, keyword)) {
            return DSL.keyword(keyword.toLowerCase());
        }
        return null;
    }

    private static final boolean peek(ParserContext ctx, char c) {
        return ctx.character() == c;
    }

    private static final boolean peek(ParserContext ctx, String string) {
        int length = string.length();
        if (ctx.sql.length < ctx.position() + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (ctx.sql[ctx.position() + i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static final boolean peekKeyword(ParserContext ctx, String ... keywords) {
        for (String keyword : keywords) {
            if (!ParserImpl.peekKeyword(ctx, keyword)) continue;
            return true;
        }
        return false;
    }

    private static final boolean peekKeyword(ParserContext ctx, String keyword) {
        return ParserImpl.peekKeyword(ctx, keyword, false, false, false);
    }

    private static final boolean peekKeyword(ParserContext ctx, String keyword, boolean updatePosition, boolean peekIntoParens, boolean requireFunction) {
        int length = keyword.length();
        int position = ctx.position();
        if (ctx.sql.length < position + length) {
            return false;
        }
        int skip = 0;
        block7: while (position + skip < ctx.sql.length) {
            char c = ctx.sql[position + skip];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '(': {
                    if (!peekIntoParens) break block7;
                    break;
                }
                default: {
                    break block7;
                }
            }
            ++skip;
        }
        block8: for (int i = 0; i < length; ++i) {
            char c = keyword.charAt(i);
            int p = position + i + skip;
            switch (c) {
                case ' ': {
                    skip += ParserImpl.afterWhitespace(ctx, p) - p - 1;
                    continue block8;
                }
                default: {
                    if (ParserImpl.upper(ctx.sql[p]) == c) continue block8;
                    return false;
                }
            }
        }
        if (ctx.isIdentifierPart(position + length + skip)) {
            return false;
        }
        if (requireFunction && ctx.character(ParserImpl.afterWhitespace(ctx, position + length + skip)) != '(') {
            return false;
        }
        if (updatePosition) {
            ctx.positionInc(length + skip);
            ParserImpl.parseWhitespaceIf(ctx);
        }
        return true;
    }

    private static final boolean parseWhitespaceIf(ParserContext ctx) {
        int position = ctx.position();
        ctx.position(ParserImpl.afterWhitespace(ctx, position));
        return position != ctx.position();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final int afterWhitespace(ParserContext ctx, int position) {
        int i = position;
        while (i < ctx.sql.length) {
            block0 : switch (ctx.sql[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    position = i + 1;
                    break;
                }
                case '/': {
                    if (i + 1 >= ctx.sql.length) return position;
                    if (ctx.sql[i + 1] != '*') return position;
                    i += 2;
                    while (i < ctx.sql.length) {
                        switch (ctx.sql[i]) {
                            case '+': {
                                if (ctx.ignoreHints() || i + 1 >= ctx.sql.length) break;
                                if (ctx.sql[i + 1] >= 'A') {
                                    if (ctx.sql[i + 1] <= 'Z') return position;
                                }
                                if (ctx.sql[i + 1] < 'a' || ctx.sql[i + 1] > 'z') break;
                                return position;
                            }
                            case '*': {
                                if (i + 1 >= ctx.sql.length || ctx.sql[i + 1] != '/') break;
                                position = ++i + 1;
                                break block0;
                            }
                        }
                        ++i;
                    }
                    break block12;
                    return position;
                }
                case '-': {
                    if (i + 1 >= ctx.sql.length) return position;
                    if (ctx.sql[i + 1] != '-') return position;
                    i += 2;
                    while (true) {
                        if (i >= ctx.sql.length) {
                            return i;
                        }
                        switch (ctx.sql[i]) {
                            case '\n': 
                            case '\r': {
                                position = i;
                                break block0;
                            }
                        }
                        ++i;
                    }
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return position;
    }

    private static final char upper(char c) {
        return c >= 'a' && c <= 'z' ? (char)(c - 32) : c;
    }

    private static interface Ignore
    extends DDLQuery,
    ResultQuery<Record>,
    QueryPartInternal {
    }

    private static enum BinarySetFunctionType {
        REGR_SLOPE,
        REGR_INTERCEPT,
        REGR_COUNT,
        REGR_R2,
        REGR_AVGX,
        REGR_AVGY,
        REGR_SXX,
        REGR_SYY,
        REGR_SXY;

    }

    private static enum ComputationalOperation {
        AVG,
        MAX,
        MIN,
        SUM,
        EVERY,
        ANY,
        SOME,
        COUNT,
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_SAMP,
        VAR_POP,
        MEDIAN;

    }

    private static enum TruthValue {
        TRUE,
        FALSE,
        NULL;

    }

    private static enum TSQLOuterJoinComparator {
        LEFT,
        RIGHT;

    }

    private static enum SequenceMethod {
        NEXTVAL,
        CURRVAL;

    }

    private static enum Sign {
        NONE,
        PLUS,
        MINUS;


        final Sign invert() {
            if (this == PLUS) {
                return MINUS;
            }
            if (this == MINUS) {
                return PLUS;
            }
            return NONE;
        }
    }

    static enum Type {
        A("array"),
        D("date"),
        S("string"),
        N("numeric"),
        B("boolean"),
        X("binary");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        boolean is(Type type) {
            return type == null || type == this;
        }

        String getName() {
            return this.name;
        }
    }
}

