/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.DSLContext;
import org.jooq.Meta;
import org.jooq.conf.ParseUnsupportedSyntax;
import org.jooq.conf.ParseWithMetaLookups;
import org.jooq.impl.ParserException;

final class ParserContext {
    private static final boolean PRO_EDITION = false;
    final DSLContext dsl;
    final Meta meta;
    final ParseWithMetaLookups metaLookups;
    final String sqlString;
    final char[] sql;
    private int position = 0;
    private boolean ignoreHints = true;
    private final Object[] bindings;
    private int bindIndex = 0;
    private String delimiter = ";";

    ParserContext(DSLContext dsl, Meta meta, ParseWithMetaLookups metaLookups, String sqlString, Object[] bindings) {
        this.dsl = dsl;
        this.meta = meta;
        this.metaLookups = metaLookups;
        this.sqlString = sqlString;
        this.sql = sqlString.toCharArray();
        this.bindings = bindings;
    }

    boolean requireProEdition() {
        throw this.exception("Feature only supported in pro edition");
    }

    boolean requireUnsupportedSyntax() {
        if (this.dsl.configuration().settings().getParseUnsupportedSyntax() == ParseUnsupportedSyntax.FAIL) {
            throw this.exception("Syntax not supported");
        }
        return true;
    }

    String substring(int startPosition, int endPosition) {
        return new String(this.sql, startPosition, endPosition - startPosition);
    }

    ParserException internalError() {
        return this.exception("Internal Error");
    }

    ParserException expected(String object) {
        return this.init(new ParserException(this.mark(), object + " expected"));
    }

    ParserException expected(String ... objects) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i == 0) {
                sb.append(objects[i]);
                continue;
            }
            if (i == objects.length - 1) {
                sb.append(", or ").append(objects[i]);
                continue;
            }
            sb.append(", ").append(objects[i]);
        }
        return this.init(new ParserException(this.mark(), sb.toString() + " expected"));
    }

    ParserException notImplemented(String feature) {
        return this.init(new ParserException(this.mark(), feature + " not yet implemented"));
    }

    ParserException unsupportedClause() {
        return this.init(new ParserException(this.mark(), "Unsupported clause"));
    }

    ParserException exception(String message) {
        return this.init(new ParserException(this.mark(), message));
    }

    ParserException init(ParserException e) {
        int[] line = this.line();
        return e.position(this.position).line(line[0]).column(line[1]);
    }

    Object nextBinding() {
        if (this.bindIndex < this.bindings.length) {
            return this.bindings[this.bindIndex++];
        }
        if (this.bindings.length == 0) {
            return null;
        }
        throw this.exception("No binding provided for bind index " + (this.bindIndex + 1));
    }

    int[] line() {
        int line = 1;
        int column = 1;
        for (int i = 0; i < this.position; ++i) {
            if (this.sql[i] == '\r') {
                ++line;
                column = 1;
                if (i + 1 >= this.sql.length || this.sql[i + 1] != '\n') continue;
                ++i;
                continue;
            }
            if (this.sql[i] == '\n') {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        return new int[]{line, column};
    }

    char character() {
        return this.character(this.position);
    }

    char character(int pos) {
        return pos >= 0 && pos < this.sql.length ? this.sql[pos] : (char)' ';
    }

    char characterNext() {
        return this.character(this.position + 1);
    }

    int position() {
        return this.position;
    }

    void position(int newPosition) {
        this.position = newPosition;
    }

    void positionInc() {
        this.positionInc(1);
    }

    void positionInc(int inc) {
        this.position(this.position + inc);
    }

    String delimiter() {
        return this.delimiter;
    }

    void delimiter(String newDelimiter) {
        this.delimiter = newDelimiter;
    }

    boolean ignoreHints() {
        return this.ignoreHints;
    }

    void ignoreHints(boolean newIgnoreHints) {
        this.ignoreHints = newIgnoreHints;
    }

    boolean isWhitespace() {
        return Character.isWhitespace(this.character());
    }

    boolean isWhitespace(int pos) {
        return Character.isWhitespace(this.character(pos));
    }

    boolean isIdentifierPart() {
        return this.isIdentifierPart(this.character());
    }

    boolean isIdentifierPart(int pos) {
        return this.isIdentifierPart(this.character(pos));
    }

    boolean isIdentifierPart(char character) {
        return Character.isJavaIdentifierPart(character) || (character == '@' || character == '#') && character != this.delimiter.charAt(0);
    }

    boolean hasMore() {
        return this.position < this.sql.length;
    }

    boolean done() {
        return this.position >= this.sql.length && (this.bindings.length == 0 || this.bindings.length == this.bindIndex);
    }

    boolean done(String message) {
        if (this.done()) {
            return true;
        }
        throw this.exception(message);
    }

    String mark() {
        int[] line = this.line();
        return "[" + line[0] + ":" + line[1] + "] " + (this.position > 50 ? "..." : "") + this.sqlString.substring(Math.max(0, this.position - 50), this.position) + "[*]" + this.sqlString.substring(this.position, Math.min(this.sqlString.length(), this.position + 80)) + (this.sqlString.length() > this.position + 80 ? "..." : "");
    }

    public String toString() {
        return this.mark();
    }
}

