/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.EnumSet;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.CommentOnFinalStep;
import org.jooq.CommentOnIsStep;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

class CommentOnImpl
extends AbstractQuery
implements CommentOnIsStep,
CommentOnFinalStep {
    private static final long serialVersionUID = 2665659331902435568L;
    private static final EnumSet<SQLDialect> SUPPORTS_COMMENT_ON_VIEW = EnumSet.of(SQLDialect.POSTGRES);
    private final Table<?> table;
    private final boolean isView;
    private final Field<?> field;
    private Comment comment;

    CommentOnImpl(Configuration configuration, Table<?> table, boolean isView) {
        super(configuration);
        this.table = table;
        this.isView = isView;
        this.field = null;
    }

    CommentOnImpl(Configuration configuration, Field<?> field) {
        super(configuration);
        this.table = null;
        this.isView = false;
        this.field = field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                if (this.table != null) {
                    this.acceptMySQL(ctx);
                    break;
                }
                this.acceptDefault(ctx);
                break;
            }
            default: {
                this.acceptDefault(ctx);
            }
        }
    }

    private final void acceptMySQL(Context<?> ctx) {
        ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.table).sql(' ').visit(Keywords.K_COMMENT).sql(" = ").visit(this.comment);
    }

    private final void acceptDefault(Context<?> ctx) {
        ctx.visit(Keywords.K_COMMENT).sql(' ').visit(Keywords.K_ON).sql(' ');
        if (this.table != null) {
            ctx.visit(this.isView && SUPPORTS_COMMENT_ON_VIEW.contains((Object)ctx.family()) ? Keywords.K_VIEW : Keywords.K_TABLE).sql(' ').visit(this.table);
        } else if (this.field != null) {
            ctx.visit(Keywords.K_COLUMN).sql(' ').visit(this.field);
        } else {
            throw new IllegalStateException();
        }
        ctx.sql(' ').visit(Keywords.K_IS).sql(' ').visit(this.comment);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final CommentOnImpl is(String c) {
        return this.is(DSL.comment(c));
    }

    @Override
    public final CommentOnImpl is(Comment c) {
        this.comment = c;
        return this;
    }
}

