/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.AbstractMeta;

final class TableMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = 2910000827304539796L;
    private final Configuration configuration;
    private final Table<?>[] tables;

    TableMetaImpl(Configuration configuration, Table<?>[] tables) {
        this.configuration = configuration;
        this.tables = tables;
    }

    @Override
    public final List<Catalog> getCatalogs() {
        LinkedHashSet<Catalog> result = new LinkedHashSet<Catalog>();
        for (Table<?> table : this.tables) {
            if (table.getSchema() == null || table.getSchema().getCatalog() == null) continue;
            result.add(table.getSchema().getCatalog());
        }
        return new ArrayList<Catalog>(result);
    }

    @Override
    public final List<Schema> getSchemas() {
        LinkedHashSet<Schema> result = new LinkedHashSet<Schema>();
        for (Table<?> table : this.tables) {
            if (table.getSchema() == null) continue;
            result.add(table.getSchema());
        }
        return new ArrayList<Schema>(result);
    }

    @Override
    public final List<Table<?>> getTables() {
        return Collections.unmodifiableList(Arrays.asList(this.tables));
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        return Collections.emptyList();
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.tables) {
            if (table.getPrimaryKey() == null) continue;
            result.add(table.getPrimaryKey());
        }
        return result;
    }
}

