/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteType;
import org.jooq.Insert;
import org.jooq.Merge;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Routine;
import org.jooq.SQLDialect;
import org.jooq.Update;
import org.jooq.conf.Settings;
import org.jooq.impl.DataMap;
import org.jooq.impl.ProviderEnabledConnection;
import org.jooq.impl.SettingsEnabledConnection;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;

class DefaultExecuteContext
implements ExecuteContext {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultExecuteContext.class);
    private final Configuration originalConfiguration;
    private final Configuration derivedConfiguration;
    private final Map<Object, Object> data;
    private final Query query;
    private final Routine<?> routine;
    private String sql;
    private final boolean batch;
    private final Query[] batchQueries;
    private final String[] batchSQL;
    private final int[] batchRows;
    transient ConnectionProvider connectionProvider;
    private transient Connection connection;
    private transient SettingsEnabledConnection wrappedConnection;
    private transient PreparedStatement statement;
    private transient int statementExecutionCount;
    private transient ResultSet resultSet;
    private transient Record record;
    private transient Result<?> result;
    private transient int rows = -1;
    private transient RuntimeException exception;
    private transient SQLException sqlException;
    private transient SQLWarning sqlWarning;
    private transient String[] serverOutput;
    private static final ThreadLocal<List<Blob>> BLOBS = new ThreadLocal();
    private static final ThreadLocal<List<Clob>> CLOBS = new ThreadLocal();
    private static final ThreadLocal<List<SQLXML>> SQLXMLS = new ThreadLocal();
    private static final ThreadLocal<List<Array>> ARRAYS = new ThreadLocal();
    private static final ThreadLocal<Configuration> LOCAL_CONFIGURATION = new ThreadLocal();
    private static final ThreadLocal<Map<Object, Object>> LOCAL_DATA = new ThreadLocal();
    private static final ThreadLocal<Connection> LOCAL_CONNECTION = new ThreadLocal();
    private static int maxUnwrappedConnections = 256;
    private static int maxUnwrappedStatements = 256;

    static final void clean() {
        List<Blob> blobs = BLOBS.get();
        List<Clob> clobs = CLOBS.get();
        List<SQLXML> xmls = SQLXMLS.get();
        List<Array> arrays = ARRAYS.get();
        if (blobs != null) {
            for (Blob blob : blobs) {
                JDBCUtils.safeFree(blob);
            }
            BLOBS.remove();
        }
        if (clobs != null) {
            for (Clob clob : clobs) {
                JDBCUtils.safeFree(clob);
            }
            CLOBS.remove();
        }
        if (xmls != null) {
            for (SQLXML xml : xmls) {
                JDBCUtils.safeFree(xml);
            }
            SQLXMLS.remove();
        }
        if (arrays != null) {
            for (Array array : arrays) {
                JDBCUtils.safeFree(array);
            }
            ARRAYS.remove();
        }
        LOCAL_CONFIGURATION.remove();
        LOCAL_DATA.remove();
        LOCAL_CONNECTION.remove();
    }

    static final void register(Blob blob) {
        List<Blob> list = BLOBS.get();
        if (list == null) {
            list = new ArrayList<Blob>();
            BLOBS.set(list);
        }
        list.add(blob);
    }

    static final void register(Clob clob) {
        List<Clob> list = CLOBS.get();
        if (list == null) {
            list = new ArrayList<Clob>();
            CLOBS.set(list);
        }
        list.add(clob);
    }

    static final void register(SQLXML xml) {
        List<SQLXML> list = SQLXMLS.get();
        if (list == null) {
            list = new ArrayList<SQLXML>();
            SQLXMLS.set(list);
        }
        list.add(xml);
    }

    static final void register(Array array) {
        List<Array> list = ARRAYS.get();
        if (list == null) {
            list = new ArrayList<Array>();
            ARRAYS.set(list);
        }
        list.add(array);
    }

    static final Configuration localConfiguration() {
        return LOCAL_CONFIGURATION.get();
    }

    static final Map<Object, Object> localData() {
        return LOCAL_DATA.get();
    }

    static final Connection localConnection() {
        return LOCAL_CONNECTION.get();
    }

    static final Connection localTargetConnection() {
        Connection result = DefaultExecuteContext.localConnection();
        for (int i = 0; i < maxUnwrappedConnections; ++i) {
            Connection r2;
            try {
                r2 = (Connection)Reflect.on(result).call("getTargetConnection").get();
                if (result != r2 && r2 != null) {
                    result = r2;
                    continue;
                }
            }
            catch (ReflectException r2) {
                // empty catch block
            }
            try {
                r2 = (Connection)Reflect.on(result).call("getDelegate").get();
                if (result == r2 || r2 == null) break;
                result = r2;
                continue;
            }
            catch (ReflectException reflectException) {
                break;
            }
        }
        return result;
    }

    static final PreparedStatement targetPreparedStatement(PreparedStatement stmt) {
        PreparedStatement result = stmt;
        for (int i = 0; i < maxUnwrappedStatements; ++i) {
            try {
                PreparedStatement r = (PreparedStatement)Reflect.on(result).call("getDelegate").get();
                if (result == r || r == null) break;
                result = r;
                continue;
            }
            catch (ReflectException reflectException) {
                break;
            }
        }
        return result;
    }

    DefaultExecuteContext(Configuration configuration) {
        this(configuration, null, null, null);
    }

    DefaultExecuteContext(Configuration configuration, Query[] batchQueries) {
        this(configuration, null, batchQueries, null);
    }

    DefaultExecuteContext(Configuration configuration, Query query) {
        this(configuration, query, null, null);
    }

    DefaultExecuteContext(Configuration configuration, Routine<?> routine) {
        this(configuration, null, null, routine);
    }

    private DefaultExecuteContext(Configuration configuration, Query query, Query[] batchQueries, Routine<?> routine) {
        this.connectionProvider = configuration.connectionProvider();
        this.originalConfiguration = configuration;
        this.derivedConfiguration = configuration.derive(new ExecuteContextConnectionProvider());
        this.data = new DataMap();
        this.query = query;
        this.routine = routine;
        if (routine != null) {
            this.batch = false;
            this.batchQueries = null;
            this.batchRows = null;
            this.batchSQL = null;
        } else if (batchQueries != null) {
            this.batch = true;
            this.batchQueries = batchQueries;
            this.batchRows = new int[batchQueries.length];
            this.batchSQL = new String[batchQueries.length];
            Arrays.fill(this.batchRows, -1);
        } else if (query == null) {
            this.batch = false;
            this.batchQueries = null;
            this.batchRows = null;
            this.batchSQL = null;
        } else {
            this.batch = false;
            this.batchQueries = null;
            this.batchRows = null;
            this.batchSQL = null;
        }
        DefaultExecuteContext.clean();
        LOCAL_CONFIGURATION.set(configuration);
        LOCAL_DATA.set(this.data);
    }

    @Override
    public final Map<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    public final ExecuteType type() {
        if (this.routine != null) {
            return ExecuteType.ROUTINE;
        }
        if (this.batch) {
            return ExecuteType.BATCH;
        }
        if (this.query != null) {
            if (this.query instanceof ResultQuery) {
                return ExecuteType.READ;
            }
            if (this.query instanceof Insert || this.query instanceof Update || this.query instanceof Delete || this.query instanceof Merge) {
                return ExecuteType.WRITE;
            }
            if (this.query instanceof DDLQuery) {
                return ExecuteType.DDL;
            }
            String s = this.query.getSQL().toLowerCase();
            if (s.matches("^(with\\b.*?\\bselect|select|explain)\\b.*?")) {
                return ExecuteType.READ;
            }
            if (s.matches("^(insert|update|delete|merge|replace|upsert|lock)\\b.*?")) {
                return ExecuteType.WRITE;
            }
            if (s.matches("^(create|alter|drop|truncate|grant|revoke|analyze|comment|flashback|enable|disable)\\b.*?")) {
                return ExecuteType.DDL;
            }
            if (s.matches("^\\s*\\{\\s*(\\?\\s*=\\s*)call.*?")) {
                return ExecuteType.ROUTINE;
            }
            if (s.matches("^(call|begin|declare)\\b.*?")) {
                return ExecuteType.ROUTINE;
            }
        } else if (this.resultSet != null) {
            return ExecuteType.READ;
        }
        return ExecuteType.OTHER;
    }

    @Override
    public final Query query() {
        return this.query;
    }

    @Override
    public final Query[] batchQueries() {
        Query[] queryArray;
        if (this.batch) {
            queryArray = this.batchQueries;
        } else if (this.query != null) {
            Query[] queryArray2 = new Query[1];
            queryArray = queryArray2;
            queryArray2[0] = this.query;
        } else {
            queryArray = Tools.EMPTY_QUERY;
        }
        return queryArray;
    }

    @Override
    public final Routine<?> routine() {
        return this.routine;
    }

    @Override
    public final void sql(String s) {
        this.sql = s;
        if (this.batchSQL != null && this.batchSQL.length == 1) {
            this.batchSQL[0] = s;
        }
    }

    @Override
    public final String sql() {
        return this.sql;
    }

    @Override
    public final String[] batchSQL() {
        String[] stringArray;
        if (this.batch) {
            stringArray = this.batchSQL;
        } else if (this.routine != null || this.query != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.sql;
        } else {
            stringArray = Tools.EMPTY_STRING;
        }
        return stringArray;
    }

    @Override
    public final void statement(PreparedStatement s) {
        this.statement = s;
    }

    @Override
    public final PreparedStatement statement() {
        return this.statement;
    }

    @Override
    public final int statementExecutionCount() {
        return this.statementExecutionCount;
    }

    @Override
    public final void resultSet(ResultSet rs) {
        this.resultSet = rs;
    }

    @Override
    public final ResultSet resultSet() {
        return this.resultSet;
    }

    @Override
    public final Configuration configuration() {
        return this.derivedConfiguration;
    }

    final Configuration originalConfiguration() {
        return this.originalConfiguration;
    }

    @Override
    public final DSLContext dsl() {
        return this.configuration().dsl();
    }

    @Override
    public final Settings settings() {
        return Tools.settings(this.configuration());
    }

    @Override
    public final SQLDialect dialect() {
        return Tools.configuration(this.configuration()).dialect();
    }

    @Override
    public final SQLDialect family() {
        return this.dialect().family();
    }

    @Override
    public final void connectionProvider(ConnectionProvider provider) {
        this.connectionProvider = provider;
    }

    @Override
    public final Connection connection() {
        if (this.wrappedConnection == null && this.connectionProvider != null) {
            this.connection(this.connectionProvider, this.connectionProvider.acquire());
        }
        return this.wrappedConnection;
    }

    final void connection(ConnectionProvider provider, Connection c) {
        if (c != null) {
            LOCAL_CONNECTION.set(c);
            this.connection = c;
            this.wrappedConnection = this.wrapConnection(provider, c);
        }
    }

    private final SettingsEnabledConnection wrapConnection(ConnectionProvider provider, Connection c) {
        return new SettingsEnabledConnection(new ProviderEnabledConnection(provider, c), this.derivedConfiguration.settings());
    }

    final void incrementStatementExecutionCount() {
        ++this.statementExecutionCount;
    }

    final DefaultExecuteContext withStatementExecutionCount(int count) {
        this.statementExecutionCount = count;
        return this;
    }

    @Override
    public final void record(Record r) {
        this.record = r;
    }

    @Override
    public final Record record() {
        return this.record;
    }

    @Override
    public final int rows() {
        return this.rows;
    }

    @Override
    public final void rows(int r) {
        this.rows = r;
        if (this.batchRows != null && this.batchRows.length == 1) {
            this.batchRows[0] = r;
        }
    }

    @Override
    public final int[] batchRows() {
        int[] nArray;
        if (this.batch) {
            nArray = this.batchRows;
        } else if (this.routine != null || this.query != null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.rows;
        } else {
            nArray = Tools.EMPTY_INT;
        }
        return nArray;
    }

    @Override
    public final void result(Result<?> r) {
        this.result = r;
    }

    @Override
    public final Result<?> result() {
        return this.result;
    }

    @Override
    public final RuntimeException exception() {
        return this.exception;
    }

    @Override
    public final void exception(RuntimeException e) {
        StackTraceElement[] oldStack;
        this.exception = e;
        if (Boolean.TRUE.equals(this.settings().isDebugInfoOnStackTrace()) && (oldStack = e.getStackTrace()) != null) {
            StackTraceElement[] newStack = new StackTraceElement[oldStack.length + 1];
            System.arraycopy(oldStack, 0, newStack, 1, oldStack.length);
            newStack[0] = new StackTraceElement("org.jooq_3.11.5." + (Object)((Object)this.dialect()), "debug", null, -1);
            e.setStackTrace(newStack);
        }
    }

    @Override
    public final SQLException sqlException() {
        return this.sqlException;
    }

    @Override
    public final void sqlException(SQLException e) {
        this.sqlException = e;
        this.exception(Tools.translate(this.sql(), e));
    }

    @Override
    public final SQLWarning sqlWarning() {
        return this.sqlWarning;
    }

    @Override
    public final void sqlWarning(SQLWarning e) {
        this.sqlWarning = e;
    }

    @Override
    public final String[] serverOutput() {
        return this.serverOutput == null ? Tools.EMPTY_STRING : this.serverOutput;
    }

    @Override
    public final void serverOutput(String[] output) {
        this.serverOutput = output;
    }

    private final class ExecuteContextConnectionProvider
    implements ConnectionProvider {
        private ExecuteContextConnectionProvider() {
        }

        @Override
        public final Connection acquire() {
            if (DefaultExecuteContext.this.connection == null) {
                DefaultExecuteContext.this.connection();
            }
            return DefaultExecuteContext.this.wrapConnection(this, DefaultExecuteContext.this.connection);
        }

        @Override
        public final void release(Connection c) {
        }
    }
}

