/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.jooq.AlterTableAlterStep;
import org.jooq.AlterTableDropStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableRenameColumnToStep;
import org.jooq.AlterTableRenameConstraintToStep;
import org.jooq.AlterTableRenameIndexToStep;
import org.jooq.AlterTableStep;
import org.jooq.AlterTableUsingIndexStep;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.FieldOrConstraint;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Nullability;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.Tools;

final class AlterTableImpl
extends AbstractQuery
implements AlterTableStep,
AlterTableDropStep,
AlterTableAlterStep,
AlterTableUsingIndexStep,
AlterTableRenameColumnToStep,
AlterTableRenameIndexToStep,
AlterTableRenameConstraintToStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_TABLE};
    private static final EnumSet<SQLDialect> NO_SUPPORT_IF_EXISTS = EnumSet.of(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    private static final EnumSet<SQLDialect> NO_SUPPORT_IF_EXISTS_COLUMN = EnumSet.of(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final EnumSet<SQLDialect> SUPPORT_RENAME_TABLE = EnumSet.of(SQLDialect.DERBY);
    private static final EnumSet<SQLDialect> NO_SUPPORT_ALTER_TYPE_AND_NULL = EnumSet.of(SQLDialect.POSTGRES);
    private static final EnumSet<SQLDialect> REQUIRE_REPEAT_ADD_ON_MULTI_ALTER = EnumSet.of(SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final EnumSet<SQLDialect> REQUIRE_REPEAT_DROP_ON_MULTI_ALTER = EnumSet.of(SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Table<?> table;
    private final boolean ifExists;
    private boolean ifExistsColumn;
    private boolean ifNotExistsColumn;
    private Comment comment;
    private Table<?> renameTo;
    private Field<?> renameColumn;
    private Field<?> renameColumnTo;
    private Index renameIndex;
    private Index renameIndexTo;
    private Constraint renameConstraint;
    private Constraint renameConstraintTo;
    private QueryPartList<FieldOrConstraint> add;
    private Field<?> addColumn;
    private DataType<?> addColumnType;
    private Constraint addConstraint;
    private Field<?> alterColumn;
    private Nullability alterColumnNullability;
    private DataType<?> alterColumnType;
    private Field<?> alterColumnDefault;
    private QueryPartList<Field<?>> dropColumns;
    private boolean dropColumnCascade;
    private Constraint dropConstraint;

    AlterTableImpl(Configuration configuration, Table<?> table) {
        this(configuration, table, false);
    }

    AlterTableImpl(Configuration configuration, Table<?> table, boolean ifExists) {
        super(configuration);
        this.table = table;
        this.ifExists = ifExists;
    }

    @Override
    public final AlterTableImpl comment(String c) {
        return this.comment(DSL.comment(c));
    }

    @Override
    public final AlterTableImpl comment(Comment c) {
        this.comment = c;
        return this;
    }

    @Override
    public final AlterTableImpl renameTo(Table<?> newName) {
        this.renameTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl renameTo(Name newName) {
        return this.renameTo((Table)DSL.table(newName));
    }

    @Override
    public final AlterTableImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    @Override
    public final AlterTableImpl renameColumn(Field<?> oldName) {
        this.renameColumn = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameColumn(Name oldName) {
        return this.renameColumn((Field)DSL.field(oldName));
    }

    @Override
    public final AlterTableImpl renameColumn(String oldName) {
        return this.renameColumn(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl renameConstraint(Constraint oldName) {
        this.renameConstraint = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameIndex(String oldName) {
        return this.renameIndex(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl renameIndex(Name oldName) {
        return this.renameIndex(DSL.index(oldName));
    }

    @Override
    public final AlterTableImpl renameIndex(Index oldName) {
        this.renameIndex = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameConstraint(Name oldName) {
        return this.renameConstraint(DSL.constraint(oldName));
    }

    @Override
    public final AlterTableImpl renameConstraint(String oldName) {
        return this.renameConstraint(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl to(String newName) {
        return this.to(DSL.name(newName));
    }

    @Override
    public final AlterTableImpl to(Name newName) {
        if (this.renameColumn != null) {
            return this.to((Field)DSL.field(newName));
        }
        if (this.renameConstraint != null) {
            return this.to(DSL.constraint(newName));
        }
        if (this.renameIndex != null) {
            return this.to(DSL.index(newName));
        }
        throw new IllegalStateException();
    }

    @Override
    public final AlterTableImpl to(Field<?> newName) {
        if (this.renameColumn == null) {
            throw new IllegalStateException();
        }
        this.renameColumnTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl to(Constraint newName) {
        if (this.renameConstraint == null) {
            throw new IllegalStateException();
        }
        this.renameConstraintTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl to(Index newName) {
        if (this.renameIndex == null) {
            throw new IllegalStateException();
        }
        this.renameIndexTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl add(Field<?> field) {
        return this.addColumn((Field)field);
    }

    @Override
    public final AlterTableImpl add(FieldOrConstraint ... fields) {
        return this.add(Arrays.asList(fields));
    }

    @Override
    public final AlterTableImpl add(Collection<? extends FieldOrConstraint> fields) {
        this.add = new QueryPartList<FieldOrConstraint>(fields);
        return this;
    }

    @Override
    public final <T> AlterTableImpl add(Field<T> field, DataType<T> type) {
        return this.addColumn((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(Name field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(String field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addIfNotExists(Field<?> field) {
        return this.addColumnIfNotExists((Field)field);
    }

    @Override
    public final <T> AlterTableImpl addIfNotExists(Field<T> field, DataType<T> type) {
        return this.addColumnIfNotExists((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addIfNotExists(Name field, DataType<?> type) {
        return this.addColumnIfNotExists(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addIfNotExists(String field, DataType<?> type) {
        return this.addColumnIfNotExists(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(String field, DataType<?> type) {
        return this.addColumn(DSL.name(field), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(Name field, DataType<?> type) {
        return this.addColumn((Field)DSL.field(field, type), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(Field<?> field) {
        return this.addColumn((Field)field, (DataType)field.getDataType());
    }

    @Override
    public final <T> AlterTableImpl addColumn(Field<T> field, DataType<T> type) {
        this.addColumn = field;
        this.addColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl addColumnIfNotExists(String field, DataType<?> type) {
        return this.addColumnIfNotExists(DSL.name(field), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumnIfNotExists(Name field, DataType<?> type) {
        return this.addColumnIfNotExists((Field)DSL.field(field, type), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumnIfNotExists(Field<?> field) {
        return this.addColumnIfNotExists((Field)field, (DataType)field.getDataType());
    }

    @Override
    public final <T> AlterTableImpl addColumnIfNotExists(Field<T> field, DataType<T> type) {
        this.ifNotExistsColumn = true;
        return this.addColumn((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(Constraint constraint) {
        this.addConstraint = constraint;
        return this;
    }

    public final <T> AlterTableImpl alter(Field<T> field) {
        return this.alterColumn((Field)field);
    }

    public final AlterTableImpl alter(Name field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alter(String field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alterColumn(Name field) {
        return this.alterColumn((Field)DSL.field(field));
    }

    public final AlterTableImpl alterColumn(String field) {
        return this.alterColumn(DSL.name(field));
    }

    public final <T> AlterTableImpl alterColumn(Field<T> field) {
        this.alterColumn = field;
        return this;
    }

    public final AlterTableImpl set(DataType type) {
        this.alterColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl setNotNull() {
        this.alterColumnNullability = Nullability.NOT_NULL;
        return this;
    }

    @Override
    public final AlterTableImpl dropNotNull() {
        this.alterColumnNullability = Nullability.NULL;
        return this;
    }

    public final AlterTableImpl defaultValue(Object literal) {
        return this.defaultValue((Field)Tools.field(literal));
    }

    public final AlterTableImpl defaultValue(Field expression) {
        this.alterColumnDefault = expression;
        return this;
    }

    @Override
    public final AlterTableImpl drop(Field<?> field) {
        return this.dropColumn((Field)field);
    }

    @Override
    public final AlterTableImpl drop(Name field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl drop(String field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl dropIfExists(Field<?> field) {
        return this.dropColumnIfExists((Field)field);
    }

    @Override
    public final AlterTableImpl dropIfExists(Name field) {
        return this.dropColumnIfExists(field);
    }

    @Override
    public final AlterTableImpl dropIfExists(String field) {
        return this.dropColumnIfExists(field);
    }

    @Override
    public final AlterTableImpl dropColumn(Name field) {
        return this.dropColumn((Field)DSL.field(field));
    }

    @Override
    public final AlterTableImpl dropColumn(String field) {
        return this.dropColumn(DSL.name(field));
    }

    @Override
    public final AlterTableImpl dropColumn(Field<?> field) {
        return this.dropColumns(new Field[]{field});
    }

    @Override
    public final AlterTableImpl dropColumnIfExists(Name field) {
        return this.dropColumnIfExists((Field)DSL.field(field));
    }

    @Override
    public final AlterTableImpl dropColumnIfExists(String field) {
        return this.dropColumnIfExists(DSL.name(field));
    }

    @Override
    public final AlterTableImpl dropColumnIfExists(Field<?> field) {
        this.ifExistsColumn = true;
        return this.dropColumn((Field)field);
    }

    @Override
    public final AlterTableImpl drop(Field<?> ... fields) {
        return this.dropColumns((Field[])fields);
    }

    @Override
    public final AlterTableImpl drop(Name ... fields) {
        return this.dropColumns(fields);
    }

    @Override
    public final AlterTableImpl drop(String ... fields) {
        return this.dropColumns(fields);
    }

    @Override
    public final AlterTableImpl dropColumns(Field<?> ... fields) {
        return this.dropColumns(Arrays.asList(fields));
    }

    @Override
    public final AlterTableImpl dropColumns(Name ... fields) {
        return this.dropColumns((Field[])Tools.fieldsByName(fields));
    }

    @Override
    public final AlterTableImpl dropColumns(String ... fields) {
        return this.dropColumns((Field[])Tools.fieldsByName(fields));
    }

    @Override
    public final AlterTableImpl drop(Collection<? extends Field<?>> fields) {
        return this.dropColumns((Collection)fields);
    }

    @Override
    public final AlterTableImpl dropColumns(Collection<? extends Field<?>> fields) {
        this.dropColumns = new QueryPartList(fields);
        return this;
    }

    @Override
    public final AlterTableImpl drop(Constraint constraint) {
        this.dropConstraint = constraint;
        return this;
    }

    @Override
    public final AlterTableImpl dropConstraint(Name constraint) {
        return this.drop(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropConstraint(String constraint) {
        return this.drop(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableFinalStep cascade() {
        this.dropColumnCascade = true;
        return this;
    }

    @Override
    public final AlterTableFinalStep restrict() {
        this.dropColumnCascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.family());
    }

    private final boolean supportsIfExistsColumn(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS_COLUMN.contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx) || (this.ifExistsColumn || this.ifNotExistsColumn) && !this.supportsIfExistsColumn(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.ALTER_TABLE, this.ifExists ? Boolean.TRUE : null, this.ifExistsColumn ? Boolean.TRUE : (this.ifNotExistsColumn ? Boolean.FALSE : null));
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.ALTER_TABLE, this.ifExists ? Boolean.TRUE : null, this.ifExistsColumn ? Boolean.TRUE : (this.ifNotExistsColumn ? Boolean.FALSE : null));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (this.comment != null) {
            switch (family) {
                case MARIADB: 
                case MYSQL: {
                    break;
                }
                default: {
                    ctx.visit(DSL.commentOnTable(this.table).is(this.comment));
                    return;
                }
            }
        }
        if (this.renameIndexTo != null) {
            switch (family) {
                case MYSQL: {
                    break;
                }
                default: {
                    ctx.visit(DSL.alterIndex(this.renameIndex).renameTo(this.renameIndexTo));
                    return;
                }
            }
        }
        if (this.alterColumnType != null && this.alterColumnType.nullability() != Nullability.DEFAULT) {
            switch (family) {
                case POSTGRES: {
                    this.alterColumnTypeAndNullabilityInBlock(ctx);
                    return;
                }
            }
        }
        if (this.dropColumns != null && this.dropColumns.size() > 1) {
            switch (family) {
                case POSTGRES: {
                    this.dropColumnsInBlock(ctx);
                    return;
                }
            }
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        boolean renameTable;
        SQLDialect family = ctx.family();
        boolean omitAlterTable = this.renameConstraint != null && family == SQLDialect.HSQLDB || this.renameColumn != null && family == SQLDialect.DERBY;
        boolean bl = renameTable = this.renameTo != null && SUPPORT_RENAME_TABLE.contains((Object)family);
        if (this.renameTo != null) {
            // empty if block
        }
        boolean renameObject = false;
        if (!omitAlterTable) {
            ctx.start(Clause.ALTER_TABLE_TABLE).visit(renameObject ? Keywords.K_RENAME_OBJECT : (renameTable ? Keywords.K_RENAME_TABLE : Keywords.K_ALTER_TABLE));
            if (this.ifExists && this.supportsIfExists(ctx)) {
                ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
            }
            ctx.sql(' ').visit(this.table).end(Clause.ALTER_TABLE_TABLE).formatIndentStart().formatSeparator();
        }
        if (this.comment != null) {
            ctx.visit(Keywords.K_COMMENT).sql(' ').visit(this.comment);
        } else if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME).qualify(false).visit(renameObject || renameTable ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify).end(Clause.ALTER_TABLE_RENAME);
        } else if (this.renameColumn != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_COLUMN);
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Keywords.K_RENAME_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').qualify(false).visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                case H2: 
                case HSQLDB: {
                    ctx.qualify(false).visit(Keywords.K_ALTER_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                case FIREBIRD: {
                    ctx.qualify(false).visit(Keywords.K_ALTER_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                default: {
                    ctx.qualify(false).visit(Keywords.K_RENAME_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                }
            }
            ctx.end(Clause.ALTER_TABLE_RENAME_COLUMN);
        } else if (this.renameIndex != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_INDEX).qualify(false).visit(Keywords.K_RENAME_INDEX).sql(' ').visit(this.renameIndex).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameIndexTo).qualify(qualify).end(Clause.ALTER_TABLE_RENAME_INDEX);
        } else if (this.renameConstraint != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_CONSTRAINT);
            ctx.data((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE, true);
            if (family == SQLDialect.HSQLDB) {
                ctx.qualify(false).visit(Keywords.K_ALTER_CONSTRAINT).sql(' ').visit(this.renameConstraint).formatSeparator().visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameConstraintTo).qualify(qualify);
            } else {
                ctx.qualify(false).visit(Keywords.K_RENAME_CONSTRAINT).sql(' ').visit(this.renameConstraint).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameConstraintTo).qualify(qualify);
            }
            ctx.data().remove((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE);
            ctx.end(Clause.ALTER_TABLE_RENAME_CONSTRAINT);
        } else if (this.add != null) {
            boolean indent;
            boolean qualify = ctx.qualify();
            boolean multiAdd = REQUIRE_REPEAT_ADD_ON_MULTI_ALTER.contains((Object)ctx.family());
            boolean parens = !multiAdd;
            ctx.start(Clause.ALTER_TABLE_ADD).visit(Keywords.K_ADD).qualify(false).sql(' ');
            if (parens) {
                ctx.sql('(');
            }
            boolean bl2 = indent = !multiAdd && this.add.size() > 1;
            if (indent) {
                ctx.formatIndentStart().formatNewLine();
            }
            for (int i = 0; i < this.add.size(); ++i) {
                if (i > 0) {
                    if (multiAdd) {
                        ctx.sql(',').formatSeparator().visit(Keywords.K_ADD).sql(' ');
                    } else {
                        ctx.sql(',').formatSeparator();
                    }
                }
                FieldOrConstraint part = (FieldOrConstraint)this.add.get(i);
                ctx.visit(part);
                if (!(part instanceof Field)) continue;
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclarationForAddition(ctx, ((Field)part).getDataType());
            }
            if (indent) {
                ctx.formatIndentEnd().formatNewLine();
            }
            if (parens) {
                ctx.sql(')');
            }
            ctx.qualify(qualify).end(Clause.ALTER_TABLE_ADD);
        } else if (this.addColumn != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_ADD).visit(Keywords.K_ADD).sql(' ');
            if (this.ifNotExistsColumn) {
                switch (ctx.family()) {
                    default: 
                }
                ctx.visit(Keywords.K_IF_NOT_EXISTS).sql(' ');
            }
            ctx.qualify(false).visit(this.addColumn).sql(' ').qualify(qualify);
            Tools.toSQLDDLTypeDeclarationForAddition(ctx, this.addColumnType);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.addConstraint != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_ADD);
            ctx.visit(Keywords.K_ADD).sql(' ').qualify(false).visit(this.addConstraint).qualify(qualify);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.alterColumn != null) {
            ctx.start(Clause.ALTER_TABLE_ALTER);
            switch (family) {
                case MARIADB: 
                case MYSQL: 
                case CUBRID: {
                    if (this.alterColumnDefault == null) {
                        ctx.visit(Keywords.K_CHANGE_COLUMN).sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
                        break;
                    }
                    ctx.visit(Keywords.K_ALTER_COLUMN);
                    break;
                }
                default: {
                    ctx.visit(Keywords.K_ALTER);
                }
            }
            ctx.sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
            if (this.alterColumnType != null) {
                switch (family) {
                    case DERBY: {
                        ctx.sql(' ').visit(Keywords.K_SET_DATA_TYPE);
                        break;
                    }
                    case POSTGRES: 
                    case FIREBIRD: {
                        ctx.sql(' ').visit(Keywords.K_TYPE);
                    }
                }
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclaration(ctx, this.alterColumnType);
                Tools.toSQLDDLTypeDeclarationIdentityBeforeNull(ctx, this.alterColumnType);
                if (!NO_SUPPORT_ALTER_TYPE_AND_NULL.contains((Object)family)) {
                    switch (this.alterColumnType.nullability()) {
                        case NULL: {
                            ctx.sql(' ').visit(Keywords.K_NULL);
                            break;
                        }
                        case NOT_NULL: {
                            ctx.sql(' ').visit(Keywords.K_NOT_NULL);
                            break;
                        }
                    }
                }
                Tools.toSQLDDLTypeDeclarationIdentityAfterNull(ctx, this.alterColumnType);
            } else if (this.alterColumnDefault != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_DEFAULT);
                switch (family) {
                    default: 
                }
                ctx.sql(' ').visit(Keywords.K_SET_DEFAULT);
                ctx.sql(' ').visit(this.alterColumnDefault).end(Clause.ALTER_TABLE_ALTER_DEFAULT);
            } else if (this.alterColumnNullability != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_NULL).sql(' ').visit(this.alterColumnNullability.nullable() ? Keywords.K_DROP_NOT_NULL : Keywords.K_SET_NOT_NULL).end(Clause.ALTER_TABLE_ALTER_NULL);
            }
            ctx.end(Clause.ALTER_TABLE_ALTER);
        } else if (this.dropColumns != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            if (REQUIRE_REPEAT_DROP_ON_MULTI_ALTER.contains((Object)family)) {
                String separator = "";
                for (Field<?> dropColumn : this.dropColumns) {
                    ctx.sql(separator).qualify(false);
                    this.acceptDropColumn(ctx);
                    this.acceptIfExistsColumn(ctx);
                    ctx.sql(' ').visit(dropColumn).qualify(true);
                    separator = ", ";
                }
            } else {
                this.acceptDropColumn(ctx);
                this.acceptIfExistsColumn(ctx);
                ctx.sql(' ');
                ctx.qualify(false).visit(this.dropColumns).qualify(true);
                if (this.dropColumnCascade) {
                    ctx.sql(' ').visit(Keywords.K_CASCADE);
                }
            }
            ctx.end(Clause.ALTER_TABLE_DROP);
        } else if (this.dropConstraint != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            ctx.data((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE, true);
            ctx.visit(Keywords.K_DROP_CONSTRAINT).sql(' ').visit(this.dropConstraint);
            ctx.data().remove((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE);
            ctx.end(Clause.ALTER_TABLE_DROP);
        }
        if (!omitAlterTable) {
            ctx.formatIndentEnd();
        }
    }

    private final void acceptDropColumn(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(Keywords.K_DROP);
    }

    private final void acceptIfExistsColumn(Context<?> ctx) {
        if (this.ifExistsColumn) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
    }

    private final void dropColumnsInBlock(Context<?> ctx) {
        Tools.begin(ctx);
        for (int i = 0; i < this.dropColumns.size(); ++i) {
            Field f = (Field)this.dropColumns.get(i);
            if (i > 0) {
                ctx.formatSeparator();
            }
            ctx.visit(DSL.alterTable(this.table).dropColumn(f)).sql(';');
        }
        Tools.end(ctx);
    }

    private final void alterColumnTypeAndNullabilityInBlock(Context<?> ctx) {
        Tools.begin(ctx);
        this.accept1(ctx);
        ctx.sql(';').formatSeparator();
        switch (ctx.family()) {
            case POSTGRES: {
                AlterTableAlterStep<?> step = ctx.dsl().alterTable(this.table).alterColumn(this.alterColumn);
                ctx.visit(this.alterColumnType.nullable() ? step.dropNotNull() : step.setNotNull());
                break;
            }
        }
        Tools.end(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

