/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Asterisk;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.QualifiedAsterisk;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.conf.ExecuteWithoutWhere;
import org.jooq.conf.RenderNameStyle;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.sqlite.SQLiteDSL;

abstract class AbstractDMLQuery<R extends Record>
extends AbstractQuery {
    private static final long serialVersionUID = -7438014075226919192L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    final WithImpl with;
    final Table<R> table;
    final SelectFieldList<SelectFieldOrAsterisk> returning;
    final List<Field<?>> returningResolvedAsterisks;
    Result<Record> returnedResult;
    Result<R> returned;

    AbstractDMLQuery(Configuration configuration, WithImpl with, Table<R> table) {
        super(configuration);
        this.with = with;
        this.table = table;
        this.returning = new SelectFieldList();
        this.returningResolvedAsterisks = new ArrayList();
    }

    public final void setReturning() {
        this.setReturning(this.table.fields());
    }

    public final void setReturning(Identity<R, ?> identity) {
        if (identity != null) {
            this.setReturning(identity.getField());
        }
    }

    public final void setReturning(SelectFieldOrAsterisk ... fields) {
        this.setReturning(Arrays.asList(fields));
    }

    public final void setReturning(Collection<? extends SelectFieldOrAsterisk> fields) {
        this.returning.clear();
        this.returning.addAll(fields);
        this.returningResolvedAsterisks.clear();
        for (SelectFieldOrAsterisk selectFieldOrAsterisk : fields) {
            if (selectFieldOrAsterisk instanceof Field) {
                this.returningResolvedAsterisks.add((Field)selectFieldOrAsterisk);
                continue;
            }
            if (selectFieldOrAsterisk instanceof QualifiedAsterisk) {
                this.returningResolvedAsterisks.addAll(Arrays.asList(((QualifiedAsterisk)selectFieldOrAsterisk).qualifier().fields()));
                continue;
            }
            if (selectFieldOrAsterisk instanceof Asterisk) {
                this.returningResolvedAsterisks.addAll(Arrays.asList(this.table.fields()));
                continue;
            }
            throw new AssertionError((Object)("Type not supported: " + selectFieldOrAsterisk));
        }
    }

    public final R getReturnedRecord() {
        if (this.getReturnedRecords().isEmpty()) {
            return null;
        }
        return (R)((Record)this.getReturnedRecords().get(0));
    }

    public final Result<R> getReturnedRecords() {
        if (this.returned == null) {
            if (this.table.fields().length > 0) {
                this.warnOnAPIMisuse();
                this.returned = this.getResult().into(this.table);
            } else {
                this.returned = this.getResult();
            }
        }
        return this.returned;
    }

    private final void warnOnAPIMisuse() {
        for (Field<?> field : this.getResult().fields()) {
            if (this.table.field(field) != null) continue;
            log.warn((Object)"API misuse", "Column " + field + " has been requested through the returning() clause, which is not present in table " + this.table + ". Use StoreQuery.getResult() or the returningResult() clause instead.");
        }
    }

    public final Result<?> getResult() {
        if (this.returnedResult == null) {
            this.returnedResult = new ResultImpl<Record>(this.configuration(), this.returningResolvedAsterisks);
        }
        return this.returnedResult;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.with != null) {
            ctx.visit(this.with).formatSeparator();
        }
        boolean previousDeclareFields = ctx.declareFields();
        this.accept0(ctx);
    }

    abstract int estimatedRowCount();

    abstract void accept0(Context<?> var1);

    void executeWithoutWhere(String message, ExecuteWithoutWhere executeWithoutWhere) {
        switch (executeWithoutWhere) {
            case IGNORE: {
                break;
            }
            case LOG_DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_INFO: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_WARN: {
                log.warn((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case THROW: {
                throw new DataAccessException("A statement is executed without WHERE clause");
            }
        }
    }

    final void toSQLReturning(Context<?> ctx) {
        if (!this.returning.isEmpty()) {
            switch (ctx.family()) {
                case FIREBIRD: 
                case POSTGRES: {
                    boolean previous = ctx.declareFields();
                    ctx.formatSeparator().visit(Keywords.K_RETURNING).sql(' ').declareFields(true).visit(this.returning).declareFields(previous);
                    break;
                }
            }
        }
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        Connection connection = ctx.connection();
        if (this.returning.isEmpty()) {
            super.prepare(ctx);
            return;
        }
        switch (ctx.family()) {
            case FIREBIRD: 
            case POSTGRES: 
            case SQLITE: 
            case CUBRID: {
                super.prepare(ctx);
                return;
            }
            case DERBY: 
            case H2: 
            case MARIADB: 
            case MYSQL: {
                ctx.statement(connection.prepareStatement(ctx.sql(), 1));
                return;
            }
        }
        String[] names = new String[this.returningResolvedAsterisks.size()];
        RenderNameStyle style = this.configuration().settings().getRenderNameStyle();
        for (int i = 0; i < names.length; ++i) {
            names[i] = style == RenderNameStyle.UPPER ? this.returningResolvedAsterisks.get(i).getName().toUpperCase() : (style == RenderNameStyle.LOWER ? this.returningResolvedAsterisks.get(i).getName().toLowerCase() : this.returningResolvedAsterisks.get(i).getName());
        }
        ctx.statement(connection.prepareStatement(ctx.sql(), names));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        ResultSet rs;
        this.returned = null;
        this.returnedResult = null;
        if (this.returning.isEmpty()) {
            return super.execute(ctx, listener);
        }
        int result = 1;
        switch (ctx.family()) {
            case SQLITE: {
                listener.executeStart(ctx);
                result = ctx.statement().executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                DSLContext create = ctx.dsl();
                this.returnedResult = create.select(this.returning).from((TableLike<?>)this.table).where(SQLiteDSL.rowid().equal(SQLiteDSL.rowid().getDataType().convert((Object)create.lastID()))).fetch();
                this.returnedResult.attach(((DefaultExecuteContext)ctx).originalConfiguration());
                return result;
            }
            case CUBRID: {
                listener.executeStart(ctx);
                result = ctx.statement().executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), ctx.dsl().lastID());
                return result;
            }
            case DERBY: 
            case H2: 
            case MARIADB: 
            case MYSQL: {
                listener.executeStart(ctx);
                result = ctx.statement().executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                ResultSet rs2 = ctx.statement().getGeneratedKeys();
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (rs2 != null) {
                        while (rs2.next()) {
                            list.add(rs2.getObject(1));
                        }
                    }
                    this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), list.toArray());
                    int n = result;
                    return n;
                }
                finally {
                    JDBCUtils.safeClose(rs2);
                }
            }
            case FIREBIRD: 
            case POSTGRES: {
                listener.executeStart(ctx);
                rs = ctx.statement().executeQuery();
                listener.executeEnd(ctx);
                break;
            }
            default: {
                listener.executeStart(ctx);
                result = ctx.statement().executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                rs = ctx.statement().getGeneratedKeys();
            }
        }
        DefaultExecuteContext ctx2 = new DefaultExecuteContext(ctx.configuration());
        ExecuteListener listener2 = ExecuteListeners.get(ctx2);
        ctx2.resultSet(rs);
        this.returnedResult = new CursorImpl(ctx2, listener2, this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD), null, false, true).fetch();
        if (!this.returnedResult.isEmpty() || ctx.family() != SQLDialect.HSQLDB) {
            result = this.returnedResult.size();
            ctx.rows(result);
        }
        return result;
    }

    private final void selectReturning(Configuration originalConfiguration, Configuration derivedConfiguration, Object ... values) {
        if (values != null && values.length > 0 && this.table.getIdentity() != null) {
            final TableField<R, ?> field = this.table.getIdentity().getField();
            Object[] ids = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                ids[i] = field.getDataType().convert(values[i]);
            }
            if (this.returningResolvedAsterisks.size() == 1 && new Fields(this.returningResolvedAsterisks).field(field) != null) {
                for (final Object id : ids) {
                    this.getResult().add(Tools.newRecord(true, this.table, originalConfiguration).operate(new RecordOperation<R, RuntimeException>(){

                        @Override
                        public R operate(R record) throws RuntimeException {
                            int index = record.fieldsRow().indexOf(field);
                            ((AbstractRecord)record).values[index] = id;
                            ((AbstractRecord)record).originals[index] = id;
                            return record;
                        }
                    }));
                }
            } else {
                this.returnedResult = derivedConfiguration.dsl().select(this.returning).from((TableLike<?>)this.table).where(field.in(ids)).fetch();
                this.returnedResult.attach(originalConfiguration);
            }
        }
    }
}

