/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Constructor;
import jodd.petite.BeanData;
import jodd.petite.DestroyMethodPoint;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.WiringMode;
import jodd.petite.meta.PetiteBean;
import jodd.petite.scope.Scope;
import jodd.typeconverter.Convert;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetiteUtil {
    public static <T> T newInstance(Class<T> type, PetiteContainer petiteContainer) throws Exception {
        T t = null;
        try {
            Constructor<T> ctor = type.getConstructor(PetiteContainer.class);
            t = ctor.newInstance(petiteContainer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (t == null) {
            return type.newInstance();
        }
        return t;
    }

    public static void callDestroyMethods(BeanData beanData) {
        DestroyMethodPoint[] dmp;
        for (DestroyMethodPoint destroyMethodPoint : dmp = beanData.getBeanDefinition().getDestroyMethodPoints()) {
            try {
                destroyMethodPoint.method.invoke(beanData.getBean(), new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid destroy method: " + destroyMethodPoint.method, ex);
            }
        }
    }

    public static String[][] convertAnnValueToReferences(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        String[] refNames = Convert.toStringArray((Object)value);
        String[][] references = new String[refNames.length][];
        for (int i = 0; i < refNames.length; ++i) {
            references[i] = new String[]{refNames[i].trim()};
        }
        return references;
    }

    public static String[][] convertRefToReferences(String[] references) {
        if (references == null) {
            return null;
        }
        String[][] ref = new String[references.length][];
        for (int i = 0; i < references.length; ++i) {
            ref[i] = new String[]{references[i]};
        }
        return ref;
    }

    public static WiringMode resolveBeanWiringMode(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        return petiteBean != null ? petiteBean.wiring() : WiringMode.DEFAULT;
    }

    public static Class<? extends Scope> resolveBeanScopeType(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        return petiteBean != null ? petiteBean.scope() : null;
    }

    public static String resolveBeanName(Class type, boolean useLongTypeName) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        String name = null;
        if (petiteBean != null) {
            name = petiteBean.value().trim();
        }
        if (name == null || name.length() == 0) {
            name = useLongTypeName ? type.getName() : StringUtil.uncapitalize((String)type.getSimpleName());
        }
        return name;
    }
}

