/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Out;
import jodd.madvoc.result.ActionResult;

public class ListMadvocConfig {
    @In(scope=ScopeType.CONTEXT)
    @Out
    protected MadvocConfig madvocConfig;
    @In(scope=ScopeType.CONTEXT)
    protected ActionsManager actionsManager;
    @In(scope=ScopeType.CONTEXT)
    protected FiltersManager filtersManager;
    @In(scope=ScopeType.CONTEXT)
    protected InterceptorsManager interceptorsManager;
    @In(scope=ScopeType.CONTEXT)
    protected ResultsManager resultsManager;
    @Out
    protected List<ActionConfig> actions;
    @Out
    protected List<ActionResult> results;
    @Out
    protected List<ActionInterceptor> interceptors;
    @Out
    protected List<ActionFilter> filters;

    protected void collectActionInterceptors() {
        Set<ActionInterceptor> interceptorValues = this.interceptorsManager.getAllInterceptors();
        this.interceptors = new ArrayList<ActionInterceptor>();
        this.interceptors.addAll(interceptorValues);
        Collections.sort(this.interceptors, new Comparator<ActionInterceptor>(){

            @Override
            public int compare(ActionInterceptor a1, ActionInterceptor a2) {
                return a1.getClass().getSimpleName().compareTo(a2.getClass().getSimpleName());
            }
        });
    }

    protected void collectActionFilters() {
        Set<ActionFilter> filterValues = this.filtersManager.getAllFilters();
        this.filters = new ArrayList<ActionFilter>();
        this.filters.addAll(filterValues);
        Collections.sort(this.filters, new Comparator<ActionFilter>(){

            @Override
            public int compare(ActionFilter a1, ActionFilter a2) {
                return a1.getClass().getSimpleName().compareTo(a2.getClass().getSimpleName());
            }
        });
    }

    protected void collectActionResults() {
        Set<ActionResult> resultsValues = this.resultsManager.getAllActionResults();
        this.results = new ArrayList<ActionResult>();
        this.results.addAll(resultsValues);
        Collections.sort(this.results, new Comparator<ActionResult>(){

            @Override
            public int compare(ActionResult a1, ActionResult a2) {
                return a1.getClass().getSimpleName().compareTo(a2.getClass().getSimpleName());
            }
        });
    }

    protected void collectActionConfigs() {
        this.actions = this.actionsManager.getAllActionConfigurations();
        Collections.sort(this.actions, new Comparator<ActionConfig>(){

            @Override
            public int compare(ActionConfig a1, ActionConfig a2) {
                return a1.actionPath.compareTo(a2.actionPath);
            }
        });
    }
}

