/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import java.time.LocalDateTime;
import jodd.bean.JoddBean;
import jodd.typeconverter.impl.LocalDateTimeConverter;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.constraint.TimeBefore;

public class TimeBeforeConstraint
implements ValidationConstraint<TimeBefore> {
    protected LocalDateTime time;

    public TimeBeforeConstraint() {
    }

    public TimeBeforeConstraint(LocalDateTime time) {
        this.time = time;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public void setTime(LocalDateTime time) {
        this.time = time;
    }

    @Override
    public void configure(TimeBefore annotation) {
        this.time = LocalDateTime.parse(annotation.value());
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return TimeBeforeConstraint.validate(value, this.time);
    }

    public static boolean validate(Object value, LocalDateTime then) {
        if (value == null) {
            return true;
        }
        LocalDateTimeConverter ldtc = (LocalDateTimeConverter)JoddBean.defaults().getTypeConverterManager().lookup(LocalDateTime.class);
        LocalDateTime now = ldtc.convert(value);
        return now.isBefore(then);
    }
}

