/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Time;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.JulianDate;
import jodd.util.StringUtil;
import jodd.util.TimeUtil;

public class SqlTimeConverter
implements TypeConverter<Time> {
    @Override
    public Time convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Calendar) {
            return new Time(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Date) {
            return new Time(((Date)value).getTime());
        }
        if (value instanceof JulianDate) {
            return new Time(((JulianDate)value).toMilliseconds());
        }
        if (value instanceof Number) {
            return new Time(((Number)value).longValue());
        }
        if (value instanceof LocalDateTime) {
            return new Time(TimeUtil.toMilliseconds((LocalDateTime)value));
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            try {
                return Time.valueOf(stringValue);
            }
            catch (IllegalArgumentException iaex) {
                throw new TypeConversionException(value, (Throwable)iaex);
            }
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Time(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

