/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;
import jodd.util.TimeUtil;

public class LocalDateTimeConverter
implements TypeConverter<LocalDateTime> {
    @Override
    public LocalDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)value, LocalTime.MIDNIGHT);
        }
        if (value instanceof Calendar) {
            return TimeUtil.fromCalendar((Calendar)value);
        }
        if (value instanceof Timestamp) {
            return TimeUtil.fromMilliseconds(((Timestamp)value).getTime());
        }
        if (value instanceof Date) {
            return TimeUtil.fromDate((Date)value);
        }
        if (value instanceof Number) {
            return TimeUtil.fromMilliseconds(((Number)value).longValue());
        }
        if (value instanceof LocalTime) {
            throw new TypeConversionException("Can't convert to date just from time: " + value);
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            return LocalDateTime.parse(stringValue);
        }
        try {
            return TimeUtil.fromMilliseconds(Long.parseLong(stringValue));
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

