/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import jodd.core.JoddCore;
import jodd.io.FileNameUtil;
import jodd.io.StreamUtil;
import jodd.io.upload.FileUpload;
import jodd.servlet.upload.MultipartRequest;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.util.Base64;
import jodd.util.StringUtil;
import jodd.util.net.MimeTypes;
import jodd.util.net.URLCoder;

public class ServletUtil {
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String JAVAX_SERVLET_ERROR_EXCEPTION = "javax.servlet.error.exception";
    private static final String SCOPE_APPLICATION = "application";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_PAGE = "page";
    public static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    private static boolean isVersion2_5;

    public static boolean isMultipartRequest(HttpServletRequest request) {
        String type = request.getHeader(HEADER_CONTENT_TYPE);
        return type != null && type.startsWith(TYPE_MULTIPART_FORM_DATA);
    }

    public static boolean isGzipSupported(HttpServletRequest request) {
        String browserEncodings = request.getHeader(HEADER_ACCEPT_ENCODING);
        return browserEncodings != null && browserEncodings.contains("gzip");
    }

    public static String resolveAuthUsername(HttpServletRequest request) {
        String header = request.getHeader(HEADER_AUTHORIZATION);
        if (header == null) {
            return null;
        }
        String encoded = header.substring(header.indexOf(32) + 1);
        String decoded = new String(Base64.decode(encoded));
        return decoded.substring(0, decoded.indexOf(58));
    }

    public static String resolveAuthPassword(HttpServletRequest request) {
        String header = request.getHeader(HEADER_AUTHORIZATION);
        if (header == null) {
            return null;
        }
        String encoded = header.substring(header.indexOf(32) + 1);
        String decoded = new String(Base64.decode(encoded));
        return decoded.substring(decoded.indexOf(58) + 1);
    }

    public static void requireAuthentication(HttpServletResponse resp, String realm) throws IOException {
        resp.setHeader(WWW_AUTHENTICATE, "Basic realm=\"" + realm + '\"');
        resp.sendError(401);
    }

    public static void prepareDownload(HttpServletResponse response, File file) {
        ServletUtil.prepareDownload(response, file, null);
    }

    public static void prepareDownload(HttpServletResponse response, File file, String mimeType) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file);
        }
        if (file.length() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big: " + file);
        }
        ServletUtil.prepareResponse(response, file.getAbsolutePath(), mimeType, (int)file.length());
    }

    public static void prepareResponse(HttpServletResponse response, String fileName, String mimeType, int fileSize) {
        if (mimeType == null && fileName != null) {
            String extension = FileNameUtil.getExtension(fileName);
            mimeType = MimeTypes.getMimeType(extension);
        }
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        if (fileSize >= 0) {
            response.setContentLength(fileSize);
        }
        if (fileName != null) {
            String name = FileNameUtil.getName(fileName);
            String encodedFileName = URLCoder.encode(name);
            response.setHeader(CONTENT_DISPOSITION, "attachment;filename=\"" + name + "\";filename*=utf8''" + encodedFileName);
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Cookie[] getAllCookies(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.length);
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            list.add(cookie);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Cookie[list.size()]);
    }

    public static String readRequestBodyFromReader(HttpServletRequest request) throws IOException {
        BufferedReader buff = request.getReader();
        StringWriter out = new StringWriter();
        StreamUtil.copy((Reader)buff, out);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readRequestBodyFromStream(HttpServletRequest request) throws IOException {
        BufferedReader bufferedReader;
        CharArrayWriter charArrayWriter;
        block4: {
            String string;
            String charEncoding = request.getCharacterEncoding();
            if (charEncoding == null) {
                charEncoding = JoddCore.defaults().getEncoding();
            }
            charArrayWriter = new CharArrayWriter();
            bufferedReader = null;
            try {
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, charEncoding));
                    StreamUtil.copy((Reader)bufferedReader, charArrayWriter);
                    break block4;
                }
                string = "";
            }
            catch (Throwable throwable) {
                StreamUtil.close(bufferedReader);
                throw throwable;
            }
            StreamUtil.close(bufferedReader);
            return string;
        }
        StreamUtil.close(bufferedReader);
        return charArrayWriter.toString();
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String getContextPath(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath;
    }

    public static String getContextPath(PageContext pageContext) {
        return ServletUtil.getContextPath(pageContext.getServletContext());
    }

    public static void storeContextPath(PageContext pageContext, String contextPathVariableName) {
        String ctxPath = ServletUtil.getContextPath(pageContext);
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        request.setAttribute(contextPathVariableName, (Object)ctxPath);
        ServletContext servletContext = pageContext.getServletContext();
        servletContext.setAttribute(contextPathVariableName, (Object)ctxPath);
    }

    public static void storeContextPath(ServletContext servletContext, String contextPathVariableName) {
        String ctxPath = ServletUtil.getContextPath(servletContext);
        servletContext.setAttribute(contextPathVariableName, (Object)ctxPath);
    }

    public static Object attribute(PageContext pageContext, String name) {
        Object value = pageContext.getAttribute(name);
        if (value != null) {
            return value;
        }
        return ServletUtil.attribute((HttpServletRequest)pageContext.getRequest(), name);
    }

    public static Object attribute(HttpServletRequest request, String name) {
        Object value = request.getAttribute(name);
        if (value != null) {
            return value;
        }
        value = request.getSession().getAttribute(name);
        if (value != null) {
            return value;
        }
        return request.getSession().getServletContext().getAttribute(name);
    }

    public static Object value(PageContext pageContext, String name) {
        Object value = pageContext.getAttribute(name);
        if (value != null) {
            return value;
        }
        return ServletUtil.value((HttpServletRequest)pageContext.getRequest(), name);
    }

    public static Object value(HttpServletRequest request, String name) {
        Object value = request.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (ServletUtil.isMultipartRequest(request)) {
            try {
                MultipartRequest multipartRequest = MultipartRequest.getInstance(request);
                value = multipartRequest.getParameter(name);
            }
            catch (IOException multipartRequest) {}
        } else {
            String[] params = request.getParameterValues(name);
            if (params != null) {
                value = params.length == 1 ? params[0] : params;
            }
        }
        if (value != null) {
            return value;
        }
        value = request.getSession().getAttribute(name);
        if (value != null) {
            return value;
        }
        return request.getSession().getServletContext().getAttribute(name);
    }

    public static void setScopeAttribute(String name, Object value, String scope, PageContext pageContext) {
        String scopeValue;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String string = scopeValue = scope != null ? scope.toLowerCase() : SCOPE_PAGE;
        if (scopeValue.equals(SCOPE_PAGE)) {
            pageContext.setAttribute(name, value);
        } else if (scopeValue.equals(SCOPE_REQUEST)) {
            request.setAttribute(name, value);
        } else if (scopeValue.equals(SCOPE_SESSION)) {
            request.getSession().setAttribute(name, value);
        } else if (scopeValue.equals(SCOPE_APPLICATION)) {
            request.getSession().getServletContext().setAttribute(name, value);
        } else {
            throw new IllegalArgumentException("Invalid scope: " + scope);
        }
    }

    public static void removeScopeAttribute(String name, String scope, PageContext pageContext) {
        String scopeValue;
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        String string = scopeValue = scope != null ? scope.toLowerCase() : SCOPE_PAGE;
        if (scopeValue.equals(SCOPE_PAGE)) {
            pageContext.removeAttribute(name);
        } else if (scopeValue.equals(SCOPE_REQUEST)) {
            request.removeAttribute(name);
        } else if (scopeValue.equals(SCOPE_SESSION)) {
            request.getSession().removeAttribute(name);
        } else if (scopeValue.equals(SCOPE_APPLICATION)) {
            request.getSession().getServletContext().removeAttribute(name);
        } else {
            throw new IllegalArgumentException("Invalid scope: " + scope);
        }
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(58);
        if (colonPos == -1) {
            return false;
        }
        for (int i = 0; i < colonPos; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSessionId(String url) {
        int sessionStart;
        StringBuilder u = new StringBuilder(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            int sessionEnd = u.toString().indexOf(59, sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf(63, sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }

    public static String resolveUrl(String url, HttpServletRequest request) {
        if (ServletUtil.isAbsoluteUrl(url)) {
            return url;
        }
        if (url.startsWith("/")) {
            return ServletUtil.getContextPath(request) + url;
        }
        return url;
    }

    public static String resolveUrl(String url, String context) {
        if (ServletUtil.isAbsoluteUrl(url)) {
            return url;
        }
        if (!context.startsWith("/") || !url.startsWith("/")) {
            throw new IllegalArgumentException("Values of both 'context' and 'url' must start with '/'.");
        }
        if (context.equals("/")) {
            return url;
        }
        return context + url;
    }

    public static Object getRequestParameter(ServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    public boolean isGetParameter(HttpServletRequest request, String name) {
        String[] nameValuePairs;
        name = URLCoder.encodeQueryParam(name) + '=';
        String query = request.getQueryString();
        for (String nameValuePair : nameValuePairs = StringUtil.splitc(query, '&')) {
            if (!nameValuePair.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    public static String[] prepareParameters(String[] paramValues, boolean treatEmptyParamsAsNull, boolean ignoreEmptyRequestParams) {
        if (treatEmptyParamsAsNull || ignoreEmptyRequestParams) {
            int emptyCount = 0;
            int total = paramValues.length;
            for (int i = 0; i < paramValues.length; ++i) {
                String paramValue = paramValues[i];
                if (paramValue == null) {
                    ++emptyCount;
                    continue;
                }
                if (paramValue.length() == 0) {
                    ++emptyCount;
                    if (treatEmptyParamsAsNull) {
                        paramValue = null;
                    }
                }
                paramValues[i] = paramValue;
            }
            if (ignoreEmptyRequestParams && emptyCount == total) {
                return null;
            }
        }
        return paramValues;
    }

    public static void copyParamsToAttributes(HttpServletRequest servletRequest, boolean treatEmptyParamsAsNull, boolean ignoreEmptyRequestParams) {
        Enumeration<String> paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            String[] paramValues = servletRequest.getParameterValues(paramName);
            if ((paramValues = ServletUtil.prepareParameters(paramValues, treatEmptyParamsAsNull, ignoreEmptyRequestParams)) == null) continue;
            servletRequest.setAttribute(paramName, paramValues.length == 1 ? paramValues[0] : paramValues);
        }
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            FileUpload[] paramValues = multipartRequest.getFiles(paramName);
            servletRequest.setAttribute(paramName, paramValues.length == 1 ? paramValues[0] : paramValues);
        }
    }

    public static boolean isServletsVersion2_5() {
        return isVersion2_5;
    }

    public static Throwable getServletError(ServletRequest request) {
        return (Throwable)request.getAttribute(JAVAX_SERVLET_ERROR_EXCEPTION);
    }

    public static void setServletError(ServletRequest request, Throwable throwable) {
        request.setAttribute(JAVAX_SERVLET_ERROR_EXCEPTION, (Object)throwable);
    }

    public static String debug(HttpServletRequest request) {
        return ServletUtil.debug(request, null);
    }

    public static String debug(PageContext pageContext) {
        return ServletUtil.debug((HttpServletRequest)pageContext.getRequest(), pageContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String debug(HttpServletRequest request, PageContext pageContext) {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("\nPARAMETERS\n----------\n");
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] value = request.getParameterValues(name);
            result.append(name).append('=');
            if (value == null) {
                result.append("<null>");
                continue;
            }
            if (value.length == 1) {
                result.append((Object)value[0]).append('\n');
                continue;
            }
            result.append('[');
            int valueLength = value.length;
            for (i = 0; i < valueLength; ++i) {
                if (i == 0) {
                    result.append(',');
                }
                result.append((Object)value[i]);
            }
            result.append("]\n");
        }
        HttpSession session = request.getSession();
        ServletContext context = session.getServletContext();
        i = 0;
        while (i < 4) {
            switch (i) {
                case 0: {
                    result.append("\nREQUEST\n-------\n");
                    enumeration = request.getAttributeNames();
                    break;
                }
                case 1: {
                    result.append("\nSESSION\n-------\n");
                    enumeration = session.getAttributeNames();
                    break;
                }
                case 2: {
                    result.append("\nAPPLICATION\n-----------\n");
                    enumeration = context.getAttributeNames();
                    break;
                }
                case 3: {
                    if (pageContext == null) {
                        return result.toString();
                    }
                    result.append("\nPAGE\n----\n");
                    enumeration = pageContext.getAttributeNamesInScope(1);
                }
            }
            while (enumeration.hasMoreElements()) {
                String stringValue;
                String name = (String)enumeration.nextElement();
                Object value = null;
                switch (i) {
                    case 0: {
                        value = request.getAttribute(name);
                        break;
                    }
                    case 1: {
                        value = session.getAttribute(name);
                        break;
                    }
                    case 2: {
                        value = context.getAttribute(name);
                        break;
                    }
                    case 3: {
                        value = pageContext.getAttribute(name);
                        break;
                    }
                }
                result.append(name).append('=');
                if (value == null) {
                    result.append("<null>\n");
                    continue;
                }
                try {
                    stringValue = value.toString();
                }
                catch (Exception ignore) {
                    stringValue = "<" + value.getClass() + ">\n";
                }
                result.append(stringValue).append('\n');
            }
            ++i;
        }
        return result.toString();
    }

    public static void preventCaching(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=0, must-revalidate, no-cache, no-store, private, post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    static {
        try {
            ServletContext.class.getMethod("getContextPath", new Class[0]);
            isVersion2_5 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

