/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.lang.reflect.Field;
import jodd.proxetta.JoddProxetta;
import jodd.proxetta.ProxettaException;

public class ProxettaUtil {
    public static Class getTargetClass(Class proxy) {
        String name = proxy.getName();
        if (name.endsWith(JoddProxetta.defaults().getProxyClassNameSuffix())) {
            return proxy.getSuperclass();
        }
        if (name.endsWith(JoddProxetta.defaults().getWrapperClassNameSuffix())) {
            return ProxettaUtil.getTargetWrapperType(proxy);
        }
        return proxy;
    }

    public static void injectTargetIntoWrapper(Object target, Object wrapper, String targetFieldName) {
        try {
            Field field = wrapper.getClass().getField(targetFieldName);
            field.setAccessible(true);
            field.set(wrapper, target);
        }
        catch (Exception ex) {
            throw new ProxettaException(ex);
        }
    }

    public static void injectTargetIntoWrapper(Object target, Object wrapper) {
        ProxettaUtil.injectTargetIntoWrapper(target, wrapper, JoddProxetta.defaults().getWrapperTargetFieldName());
    }

    public static Class getTargetWrapperType(Class wrapperClass) {
        Field field;
        try {
            field = wrapperClass.getField(JoddProxetta.defaults().getWrapperTargetFieldName());
        }
        catch (NoSuchFieldException nsfex) {
            throw new ProxettaException(nsfex);
        }
        return field.getType();
    }
}

