/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.scope;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jodd.petite.BeanData;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteException;
import jodd.petite.scope.ProtoScope;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SessionScope;
import jodd.petite.scope.SingletonScope;
import jodd.servlet.RequestContextListener;

public class RequestScope
implements Scope {
    protected static final String ATTR_NAME = RequestScope.class.getName() + ".MAP.";

    protected Map<String, TransientBeanData> getRequestMap(HttpServletRequest servletRequest) {
        return (Map)servletRequest.getAttribute(ATTR_NAME);
    }

    protected void removeRequestMap(HttpServletRequest servletRequest) {
        servletRequest.removeAttribute(ATTR_NAME);
    }

    protected Map<String, TransientBeanData> createRequestMap(HttpServletRequest servletRequest) {
        HashMap<String, TransientBeanData> map = new HashMap<String, TransientBeanData>();
        servletRequest.setAttribute(ATTR_NAME, map);
        return map;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public Object lookup(String name) {
        HttpServletRequest servletRequest = this.getCurrentHttpRequest();
        Map<String, TransientBeanData> map = this.getRequestMap(servletRequest);
        if (map == null) {
            return null;
        }
        BeanData beanData = map.get(name).get();
        if (beanData == null) {
            return null;
        }
        return beanData.instance();
    }

    @Override
    public void register(BeanDefinition beanDefinition, Object bean) {
        HttpServletRequest servletRequest = this.getCurrentHttpRequest();
        Map<String, TransientBeanData> map = this.getRequestMap(servletRequest);
        if (map == null) {
            map = this.createRequestMap(servletRequest);
        }
        BeanData beanData = new BeanData(beanDefinition, bean);
        map.put(beanDefinition.name(), new TransientBeanData(beanData));
    }

    @Override
    public void remove(String name) {
        HttpServletRequest servletRequest = this.getCurrentHttpRequest();
        Map<String, TransientBeanData> map = this.getRequestMap(servletRequest);
        if (map != null) {
            map.remove(name);
        }
    }

    @Override
    public boolean accept(Scope referenceScope) {
        Class<?> refScopeType = referenceScope.getClass();
        if (refScopeType == ProtoScope.class) {
            return true;
        }
        if (refScopeType == SingletonScope.class) {
            return true;
        }
        if (refScopeType == SessionScope.class) {
            return true;
        }
        return refScopeType == RequestScope.class;
    }

    protected HttpServletRequest getCurrentHttpRequest() {
        HttpServletRequest request = RequestContextListener.getRequest();
        if (request == null) {
            throw new PetiteException("No HTTP request bound to the current thread. Is RequestContextListener registered?");
        }
        return request;
    }

    private class TransientBeanData {
        private final transient BeanData beanData;

        private TransientBeanData(BeanData beanData) {
            this.beanData = beanData;
        }

        public BeanData get() {
            return this.beanData;
        }
    }
}

