/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Constructor;
import jodd.bean.JoddBean;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.CtorDescriptor;
import jodd.petite.PetiteException;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.CtorInjectionPoint;
import jodd.petite.resolver.ReferencesResolver;

public class CtorResolver {
    protected final ReferencesResolver referencesResolver;

    public CtorResolver(ReferencesResolver referencesResolver) {
        this.referencesResolver = referencesResolver;
    }

    public CtorInjectionPoint resolve(Class type, boolean useAnnotation) {
        ClassDescriptor cd = JoddBean.defaults().getClassIntrospector().lookup(type);
        CtorDescriptor[] allCtors = cd.getAllCtorDescriptors();
        Constructor foundedCtor = null;
        Constructor defaultCtor = null;
        BeanReferences[] references = null;
        for (CtorDescriptor ctorDescriptor : allCtors) {
            BeanReferences[] ctorReferences;
            Constructor ctor = ctorDescriptor.getConstructor();
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length == 0) {
                defaultCtor = ctor;
            }
            if (!useAnnotation || (ctorReferences = this.referencesResolver.readAllReferencesFromAnnotation(ctor)) == null) continue;
            if (foundedCtor != null) {
                throw new PetiteException("Two or more constructors are annotated as injection points in the bean: " + type.getName());
            }
            foundedCtor = ctor;
            references = ctorReferences;
        }
        if (foundedCtor == null && (references = this.referencesResolver.readAllReferencesFromAnnotation(foundedCtor = allCtors.length == 1 ? allCtors[0].getConstructor() : defaultCtor)) == null) {
            references = new BeanReferences[]{};
        }
        if (foundedCtor == null) {
            throw new PetiteException("No constructor (annotated, single or default) founded as injection point for: " + type.getName());
        }
        return new CtorInjectionPoint(foundedCtor, references);
    }
}

