/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import jodd.mail.SmtpServer;

public class SmtpSslServer
extends SmtpServer<SmtpSslServer> {
    public static final String MAIL_SMTP_STARTTLS_REQUIRED = "mail.smtp.starttls.required";
    public static final String MAIL_SMTP_STARTTLS_ENABLE = "mail.smtp.starttls.enable";
    public static final String MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port";
    public static final String MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class";
    public static final String MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 465;
    protected boolean startTlsRequired = false;
    protected boolean plaintextOverTLS = false;

    public SmtpSslServer(String host, int port, Authenticator authenticator) {
        super(host, port == -1 ? 465 : port, authenticator);
    }

    public SmtpSslServer startTlsRequired(boolean startTlsRequired) {
        this.startTlsRequired = startTlsRequired;
        return this;
    }

    public SmtpSslServer plaintextOverTLS(boolean plaintextOverTLS) {
        this.plaintextOverTLS = plaintextOverTLS;
        return this;
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty(MAIL_SMTP_STARTTLS_REQUIRED, this.startTlsRequired ? "true" : "false");
        props.setProperty(MAIL_SMTP_STARTTLS_ENABLE, "true");
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_PORT, String.valueOf(this.getPort()));
        props.setProperty("mail.smtp.port", String.valueOf(this.getPort()));
        if (!this.plaintextOverTLS) {
            props.setProperty(MAIL_SMTP_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        }
        props.setProperty(MAIL_SMTP_SOCKET_FACTORY_FALLBACK, "false");
        props.setProperty("mail.host", this.getHost());
        return props;
    }
}

