/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import com.sun.mail.pop3.POP3SSLStore;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.URLName;
import jodd.mail.Pop3Server;
import jodd.mail.SimpleAuthenticator;

public class Pop3SslServer
extends Pop3Server {
    protected static final String MAIL_POP3_SOCKET_FACTORY_PORT = "mail.pop3.socketFactory.port";
    protected static final String MAIL_POP3_SOCKET_FACTORY_CLASS = "mail.pop3.socketFactory.class";
    protected static final String MAIL_POP3_SOCKET_FACTORY_FALLBACK = "mail.pop3.socketFactory.fallback";
    protected static final int DEFAULT_SSL_PORT = 995;

    public Pop3SslServer(String host, int port, Authenticator authenticator) {
        super(host, port == -1 ? 995 : port, authenticator);
    }

    @Override
    protected Properties createSessionProperties() {
        Properties props = super.createSessionProperties();
        props.setProperty(MAIL_POP3_SOCKET_FACTORY_PORT, String.valueOf(this.getPort()));
        props.setProperty(MAIL_POP3_SOCKET_FACTORY_CLASS, "javax.net.ssl.SSLSocketFactory");
        props.setProperty(MAIL_POP3_SOCKET_FACTORY_FALLBACK, "false");
        return props;
    }

    protected POP3SSLStore getStore(Session session) {
        URLName url;
        SimpleAuthenticator simpleAuthenticator = (SimpleAuthenticator)this.getAuthenticator();
        if (simpleAuthenticator == null) {
            url = new URLName("pop3", this.getHost(), this.getPort(), "", null, null);
        } else {
            PasswordAuthentication pa = simpleAuthenticator.getPasswordAuthentication();
            url = new URLName("pop3", this.getHost(), this.getPort(), "", pa.getUserName(), pa.getPassword());
        }
        return new POP3SSLStore(session, url);
    }
}

