/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.config.ResultPath;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Scope;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.PathResult;
import jodd.util.StringUtil;

public abstract class AbstractTemplateViewActionResult<T extends PathResult>
implements ActionResult<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTemplateViewActionResult.class);
    protected HashMap<String, String> targetCache = new HashMap(256);
    @In
    @Scope(value=ScopeType.CONTEXT)
    protected ResultMapper resultMapper;

    @Override
    public void render(ActionRequest actionRequest, T resultValue) throws Exception {
        String resultBasePath = actionRequest.getActionRuntime().getResultBasePath();
        String path = resultValue != null ? ((PathResult)resultValue).path() : "";
        String actionAndResultPath = resultBasePath + (resultValue != null ? ':' + path : "");
        String target = this.targetCache.get(actionAndResultPath);
        if (target == null) {
            if (log.isDebugEnabled()) {
                log.debug("new target: " + actionAndResultPath);
            }
            if ((target = this.resolveTarget(actionRequest, path)) == null) {
                this.targetNotFound(actionRequest, actionAndResultPath);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("target found: " + target);
            }
            this.targetCache.put(actionAndResultPath, target);
        }
        this.renderView(actionRequest, target);
    }

    protected String resolveTarget(ActionRequest actionRequest, String resultValue) {
        String target;
        String actionPath;
        String resultBasePath = actionRequest.getActionRuntime().getResultBasePath();
        ResultPath resultPath = this.resultMapper.resolveResultPath(resultBasePath, resultValue);
        String path = actionPath = resultPath.path();
        String value = resultPath.value();
        if (StringUtil.isEmpty(value)) {
            value = null;
        }
        while (true) {
            if (value != null) {
                int lastSlashNdx;
                target = path == null ? ((lastSlashNdx = actionPath.lastIndexOf(47)) != -1 ? actionPath.substring(0, lastSlashNdx + 1) + value : '/' + value) : path + '.' + value;
                target = this.locateTarget(actionRequest, target);
                if (target != null) break;
            }
            if (path != null && (target = this.locateTarget(actionRequest, path)) != null) break;
            if (path == null) {
                return null;
            }
            int dotNdx = MadvocUtil.lastIndexOfDotAfterSlash(path);
            if (dotNdx == -1) {
                path = null;
                continue;
            }
            path = path.substring(0, dotNdx);
        }
        return target;
    }

    protected abstract String locateTarget(ActionRequest var1, String var2);

    protected abstract void renderView(ActionRequest var1, String var2) throws Exception;

    protected void targetNotFound(ActionRequest actionRequest, String actionAndResultPath) throws IOException {
        HttpServletResponse response = actionRequest.getHttpServletResponse();
        response.sendError(404, "Result not found: " + actionAndResultPath);
    }
}

