/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jodd.madvoc.MadvocException;
import jodd.madvoc.ScopeType;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.MethodParam;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.injector.Target;
import jodd.madvoc.meta.Out;
import jodd.util.ClassUtil;

public class Targets {
    final Target[] targets;
    final ScopeData[][] scopes;

    public Targets(Target target, ScopeData[] scopeData) {
        this.targets = new Target[]{target};
        if (scopeData == null) {
            this.scopes = new ScopeData[ScopeType.values().length][1];
        } else {
            this.scopes = new ScopeData[scopeData.length][1];
            for (ScopeData this.scopes[i][0] : scopeData) {
            }
        }
    }

    public Targets(ActionRuntime actionRuntime, Object action) {
        this.targets = this.makeTargets(actionRuntime, action);
        this.scopes = actionRuntime.getScopeData();
    }

    public boolean usesScope(ScopeType scopeType) {
        ScopeData[] scopeData = this.scopes[scopeType.value()];
        return scopeData != null;
    }

    public void forEachTarget(Consumer<Target> targetConsumer) {
        for (Target target : this.targets) {
            targetConsumer.accept(target);
        }
    }

    public void forEachTargetAndInScopes(ScopeType scopeType, BiConsumer<Target, ScopeData.In> biConsumer) {
        ScopeData[] scopeData = this.scopes[scopeType.value()];
        if (scopeData == null) {
            return;
        }
        for (int i = 0; i < this.targets.length; ++i) {
            ScopeData.In[] ins;
            if (scopeData[i] == null || (ins = scopeData[i].in) == null) continue;
            for (ScopeData.In in : ins) {
                biConsumer.accept(this.targets[i], in);
            }
        }
    }

    public void forEachTargetAndOutScopes(ScopeType scopeType, BiConsumer<Target, ScopeData.Out> biConsumer) {
        ScopeData[] scopeData = this.scopes[scopeType.value()];
        if (scopeData == null) {
            return;
        }
        for (int i = 0; i < this.targets.length; ++i) {
            ScopeData.Out[] outs;
            if (scopeData[i] == null || (outs = scopeData[i].out) == null) continue;
            for (ScopeData.Out out : outs) {
                biConsumer.accept(this.targets[i], out);
            }
        }
    }

    public Object[] extractParametersValues() {
        Object[] values = new Object[this.targets.length - 1];
        for (int i = 1; i < this.targets.length; ++i) {
            values[i - 1] = this.targets[i].getValue();
        }
        return values;
    }

    protected Target[] makeTargets(ActionRuntime actionRuntime, final Object action) {
        if (!actionRuntime.hasArguments()) {
            return new Target[]{new Target(action)};
        }
        MethodParam[] methodParams = actionRuntime.getMethodParams();
        Target[] target = new Target[methodParams.length + 1];
        target[0] = new Target(action);
        for (int i = 0; i < methodParams.length; ++i) {
            MethodParam mp = methodParams[i];
            Class type = mp.type();
            Target t = mp.annotationType() == null ? new Target(this.createActionMethodArgument(type, action)) : (mp.annotationType() == Out.class ? new Target(this.createActionMethodArgument(type, action), type) : new Target(type){

                @Override
                protected void createValueInstance() {
                    this.value = Targets.this.createActionMethodArgument(this.type, action);
                }
            });
            target[i + 1] = t;
        }
        return target;
    }

    protected Object createActionMethodArgument(Class type, Object action) {
        try {
            if (type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers())) {
                return ClassUtil.newInstance(type);
            }
            Constructor ctor = type.getDeclaredConstructor(type.getDeclaringClass());
            ctor.setAccessible(true);
            return ctor.newInstance(action);
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
    }
}

