/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionHandler;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.MadvocException;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ActionMethodParamNameResolver;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.config.ActionDefinition;
import jodd.madvoc.config.ActionNames;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.MethodParam;
import jodd.madvoc.config.RootPackages;
import jodd.madvoc.config.ScopeData;
import jodd.madvoc.filter.ActionFilter;
import jodd.madvoc.injector.Target;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.ActionAnnotation;
import jodd.madvoc.meta.ActionAnnotationData;
import jodd.madvoc.meta.Async;
import jodd.madvoc.meta.DELETE;
import jodd.madvoc.meta.FilteredBy;
import jodd.madvoc.meta.GET;
import jodd.madvoc.meta.HEAD;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.madvoc.meta.OPTIONS;
import jodd.madvoc.meta.PATCH;
import jodd.madvoc.meta.POST;
import jodd.madvoc.meta.PUT;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.meta.TRACE;
import jodd.madvoc.path.ActionNamingStrategy;
import jodd.madvoc.result.ActionResult;
import jodd.madvoc.result.NoneActionResult;
import jodd.petite.meta.PetiteInject;
import jodd.util.ArraysUtil;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;
import jodd.util.annotation.AnnotationData;

public class ActionMethodParser {
    private static final Class<? extends Annotation>[] METHOD_ANNOTATIONS = new Class[]{DELETE.class, GET.class, HEAD.class, POST.class, PUT.class, OPTIONS.class, TRACE.class, PATCH.class};
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected InterceptorsManager interceptorsManager;
    @PetiteInject
    protected FiltersManager filtersManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    @PetiteInject
    protected ScopeDataResolver scopeDataResolver;
    @PetiteInject
    protected ActionMethodParamNameResolver actionMethodParamNameResolver;

    public ActionDefinition parseActionDefinition(Class<?> actionClass, Method actionMethod) {
        ActionNamingStrategy namingStrategy;
        ActionAnnotationData annotationData = this.detectActionAnnotationData(actionMethod);
        ActionConfig actionConfig = this.resolveActionConfig(annotationData);
        String[] packageActionNames = this.readPackageActionPath(actionClass);
        String[] classActionNames = this.readClassActionPath(actionClass);
        String[] methodActionNames = this.readMethodActionPath(actionMethod.getName(), annotationData, actionConfig);
        String method = this.readMethodHttpMethod(actionMethod);
        ActionNames actionNames = new ActionNames(packageActionNames, classActionNames, methodActionNames, method);
        try {
            namingStrategy = ClassUtil.newInstance(actionConfig.getNamingStrategy());
            this.contextInjectorComponent.injectContext(new Target(namingStrategy));
        }
        catch (Exception ex) {
            throw new MadvocException(ex);
        }
        return namingStrategy.buildActionDef(actionClass, actionMethod, actionNames);
    }

    public ActionRuntime parse(Class<?> actionClass, Method actionMethod, ActionDefinition actionDefinition) {
        ActionAnnotationData annotationData = this.detectActionAnnotationData(actionMethod);
        ActionConfig actionConfig = this.resolveActionConfig(annotationData);
        ActionInterceptor[] actionInterceptors = this.parseActionInterceptors(actionClass, actionMethod, actionConfig);
        ActionFilter[] actionFilters = this.parseActionFilters(actionClass, actionMethod, actionConfig);
        if (actionDefinition == null) {
            actionDefinition = this.parseActionDefinition(actionClass, actionMethod);
        }
        this.detectAndRegisterAlias(annotationData, actionDefinition);
        boolean async = this.parseMethodAsyncFlag(actionMethod);
        Class<? extends ActionResult> actionResult = this.parseActionResult(actionMethod);
        return this.createActionRuntime(null, actionClass, actionMethod, actionResult, actionFilters, actionInterceptors, actionDefinition, async, actionConfig);
    }

    protected ActionConfig resolveActionConfig(ActionAnnotationData annotationData) {
        return this.madvocConfig.lookupActionConfig(annotationData);
    }

    protected ActionAnnotationData detectActionAnnotationData(Method actionMethod) {
        ActionAnnotation<?> actionAnnotation;
        AnnotationData annotationData = null;
        ActionAnnotation<?>[] actionAnnotationArray = this.madvocConfig.getActionAnnotationInstances();
        int n = actionAnnotationArray.length;
        for (int i = 0; i < n && (annotationData = (actionAnnotation = actionAnnotationArray[i]).readAnnotatedElement(actionMethod)) == null; ++i) {
        }
        return annotationData;
    }

    protected void detectAndRegisterAlias(ActionAnnotationData annotationData, ActionDefinition actionDefinition) {
        String alias = this.parseMethodAlias(annotationData);
        if (alias != null) {
            String aliasPath = StringUtil.cutToIndexOf(actionDefinition.actionPath(), "#");
            this.actionsManager.registerPathAlias(alias, aliasPath);
        }
    }

    protected Class<? extends ActionResult> parseActionResult(Method actionMethod) {
        RenderWith renderWith = actionMethod.getAnnotation(RenderWith.class);
        if (renderWith != null) {
            return renderWith.value();
        }
        return null;
    }

    protected ActionInterceptor[] parseActionInterceptors(Class<?> actionClass, Method actionMethod, ActionConfig actionConfig) {
        Class[] interceptorClasses = this.readActionInterceptors(actionMethod);
        if (interceptorClasses == null) {
            interceptorClasses = this.readActionInterceptors(actionClass);
        }
        if (interceptorClasses == null) {
            interceptorClasses = actionConfig.getInterceptors();
        }
        return (ActionInterceptor[])this.interceptorsManager.resolveAll(actionConfig, interceptorClasses);
    }

    protected ActionFilter[] parseActionFilters(Class<?> actionClass, Method actionMethod, ActionConfig actionConfig) {
        Class[] filterClasses = this.readActionFilters(actionMethod);
        if (filterClasses == null) {
            filterClasses = this.readActionFilters(actionClass);
        }
        if (filterClasses == null) {
            filterClasses = actionConfig.getFilters();
        }
        return (ActionFilter[])this.filtersManager.resolveAll(actionConfig, filterClasses);
    }

    protected Class<? extends ActionInterceptor>[] readActionInterceptors(AnnotatedElement actionClassOrMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClassOrMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionFilter>[] readActionFilters(AnnotatedElement actionClassOrMethod) {
        Class<? extends ActionFilter>[] result = null;
        FilteredBy filteredBy = actionClassOrMethod.getAnnotation(FilteredBy.class);
        if (filteredBy != null && (result = filteredBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected String[] readPackageActionPath(Class actionClass) {
        RootPackages rootPackages;
        String actionPackageName;
        block5: {
            String packageActionPathFromAnnotation;
            Package actionPackage = actionClass.getPackage();
            actionPackageName = actionPackage.getName();
            rootPackages = this.madvocConfig.getRootPackages();
            block0: while (true) {
                MadvocAction madvocActionAnnotation;
                String string = packageActionPathFromAnnotation = (madvocActionAnnotation = actionPackage.getAnnotation(MadvocAction.class)) != null ? madvocActionAnnotation.value().trim() : null;
                if (StringUtil.isEmpty(packageActionPathFromAnnotation)) {
                    packageActionPathFromAnnotation = null;
                }
                if (packageActionPathFromAnnotation != null) break;
                String newPackage = actionPackage.getName();
                actionPackage = null;
                while (true) {
                    if (actionPackage != null) continue block0;
                    int ndx = newPackage.lastIndexOf(46);
                    if (ndx != -1) {
                        newPackage = newPackage.substring(0, ndx);
                        actionPackage = Package.getPackage(newPackage);
                        continue;
                    }
                    break block5;
                    break;
                }
                break;
            }
            rootPackages.addRootPackage(actionPackage.getName(), packageActionPathFromAnnotation);
        }
        String packagePath = rootPackages.findPackagePathForActionPackage(actionPackageName);
        if (packagePath == null) {
            return ArraysUtil.array(null, null);
        }
        return ArraysUtil.array(StringUtil.stripChar(packagePath, '/'), StringUtil.surround(packagePath, "/"));
    }

    protected String[] readClassActionPath(Class actionClass) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty(classActionPath)) {
            classActionPath = null;
        }
        String actionClassName = actionClass.getSimpleName();
        actionClassName = StringUtil.uncapitalize(actionClassName);
        actionClassName = MadvocUtil.stripLastCamelWord(actionClassName);
        if (classActionPath == null) {
            classActionPath = actionClassName;
        }
        return ArraysUtil.array(actionClassName, classActionPath);
    }

    protected String[] readMethodActionPath(String methodName, ActionAnnotationData annotationData, ActionConfig actionConfig) {
        String methodActionPath;
        String string = methodActionPath = annotationData != null ? annotationData.value() : null;
        if (methodActionPath == null) {
            methodActionPath = methodName;
        } else if (methodActionPath.equals("#")) {
            return ArraysUtil.array(null, null);
        }
        for (String path : actionConfig.getActionMethodNames()) {
            if (!methodActionPath.equals(path)) continue;
            methodActionPath = null;
            break;
        }
        return ArraysUtil.array(methodName, methodActionPath);
    }

    protected String parseMethodAlias(ActionAnnotationData annotationData) {
        String alias = null;
        if (annotationData != null) {
            alias = annotationData.alias();
        }
        return alias;
    }

    private String readMethodHttpMethod(Method actionMethod) {
        for (Class<? extends Annotation> methodAnnotation : METHOD_ANNOTATIONS) {
            if (actionMethod.getAnnotation(methodAnnotation) == null) continue;
            return methodAnnotation.getSimpleName();
        }
        return null;
    }

    private boolean parseMethodAsyncFlag(Method actionMethod) {
        return actionMethod.getAnnotation(Async.class) != null;
    }

    public ActionRuntime createActionRuntime(ActionHandler actionHandler, Class actionClass, Method actionClassMethod, Class<? extends ActionResult> actionResult, ActionFilter[] filters, ActionInterceptor[] interceptors, ActionDefinition actionDefinition, boolean async, ActionConfig actionConfig) {
        if (actionHandler != null) {
            return new ActionRuntime(actionHandler, actionClass, actionClassMethod, filters, interceptors, actionDefinition, NoneActionResult.class, async, null, null, actionConfig);
        }
        Class<?>[] paramTypes = actionClassMethod.getParameterTypes();
        MethodParam[] params = new MethodParam[paramTypes.length];
        Annotation[][] paramAnns = actionClassMethod.getParameterAnnotations();
        String[] methodParamNames = null;
        Class[] types = ArraysUtil.insert(paramTypes, actionClass, 0);
        ScopeData[][] allScopeData = new ScopeData[ScopeType.values().length][];
        for (int i = 0; i < types.length; ++i) {
            Class type = types[i];
            ScopeData[] scopeData = null;
            if (i > 0) {
                if (methodParamNames == null) {
                    methodParamNames = this.actionMethodParamNameResolver.resolveParamNames(actionClassMethod);
                }
                int paramIndex = i - 1;
                String paramName = methodParamNames[paramIndex];
                scopeData = this.scopeDataResolver.resolveScopeData(paramName, type, paramAnns[paramIndex]);
                params[paramIndex] = new MethodParam(paramTypes[paramIndex], paramName, this.scopeDataResolver.detectAnnotationType(paramAnns[paramIndex]));
            }
            if (scopeData == null) {
                scopeData = this.scopeDataResolver.resolveScopeData(type);
            }
            if (scopeData == null) continue;
            for (int j = 0; j < ScopeType.values().length; ++j) {
                if (allScopeData[j] == null) {
                    allScopeData[j] = new ScopeData[types.length];
                }
                allScopeData[j][i] = scopeData[j];
            }
        }
        return new ActionRuntime(null, actionClass, actionClassMethod, filters, interceptors, actionDefinition, actionResult, async, allScopeData, params, actionConfig);
    }
}

