/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.Map;
import jodd.http.HttpMultiMap;
import jodd.util.StringBand;
import jodd.util.net.URLCoder;
import jodd.util.net.URLDecoder;

public class HttpUtil {
    public static String buildQuery(HttpMultiMap<?> queryMap, String encoding) {
        if (queryMap.isEmpty()) {
            return "";
        }
        int queryMapSize = queryMap.size();
        StringBand query = new StringBand(queryMapSize * 4);
        int count = 0;
        for (Map.Entry<String, ?> entry : queryMap) {
            String key = entry.getKey();
            key = URLCoder.encodeQueryParam(key, encoding);
            Object value = entry.getValue();
            if (value == null) {
                if (count != 0) {
                    query.append('&');
                }
                query.append(key);
                ++count;
                continue;
            }
            if (count != 0) {
                query.append('&');
            }
            query.append(key);
            ++count;
            query.append('=');
            String valueString = URLCoder.encodeQueryParam(value.toString(), encoding);
            query.append(valueString);
        }
        return query.toString();
    }

    public static HttpMultiMap<String> parseQuery(String query, boolean decode) {
        HttpMultiMap<String> queryMap = HttpMultiMap.newCaseInsensitiveMap();
        int ndx2 = 0;
        while (true) {
            int ndx;
            if ((ndx = query.indexOf(61, ndx2)) == -1) {
                if (ndx2 >= query.length()) break;
                queryMap.add(query.substring(ndx2), null);
                break;
            }
            String name = query.substring(ndx2, ndx);
            if (decode) {
                name = URLDecoder.decodeQuery(name);
            }
            if ((ndx = query.indexOf(38, ndx2 = ndx + 1)) == -1) {
                ndx = query.length();
            }
            String value = query.substring(ndx2, ndx);
            if (decode) {
                value = URLDecoder.decodeQuery(value);
            }
            queryMap.add(name, value);
            ndx2 = ndx + 1;
        }
        return queryMap;
    }

    public static String prepareHeaderParameterName(String headerName) {
        if (headerName.equals("etag")) {
            return "ETag";
        }
        if (headerName.equals("www-authenticate")) {
            return "WWW-Authenticate";
        }
        char[] name = headerName.toCharArray();
        boolean capitalize = true;
        for (int i = 0; i < name.length; ++i) {
            char c = name[i];
            if (c == '-') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                name[i] = Character.toUpperCase(c);
                capitalize = false;
                continue;
            }
            name[i] = Character.toLowerCase(c);
        }
        return new String(name);
    }

    public static String extractMediaType(String contentType) {
        int index = contentType.indexOf(59);
        if (index == -1) {
            return contentType;
        }
        return contentType.substring(0, index);
    }

    public static String extractContentTypeCharset(String contentType) {
        return HttpUtil.extractHeaderParameter(contentType, "charset", ';');
    }

    public static String extractKeepAliveTimeout(String keepAlive) {
        return HttpUtil.extractHeaderParameter(keepAlive, "timeout", ',');
    }

    public static String extractKeepAliveMax(String keepAlive) {
        return HttpUtil.extractHeaderParameter(keepAlive, "max", ',');
    }

    public static String extractHeaderParameter(String header, String parameter, char separator) {
        int eqNdx;
        int index = 0;
        while (true) {
            if ((index = header.indexOf(separator, index)) == -1) {
                return null;
            }
            ++index;
            while (index < header.length() && header.charAt(index) == ' ') {
                ++index;
            }
            eqNdx = header.indexOf(61, index);
            if (eqNdx == -1) {
                return null;
            }
            String paramName = header.substring(index, eqNdx);
            ++eqNdx;
            if (paramName.equalsIgnoreCase(parameter)) break;
            index = eqNdx;
        }
        int endIndex = header.indexOf(59, eqNdx);
        if (endIndex == -1) {
            return header.substring(eqNdx);
        }
        return header.substring(eqNdx, endIndex);
    }
}

