/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.bean.BeanUtil;
import jodd.bean.JoddBean;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.Getter;
import jodd.introspector.Setter;
import jodd.typeconverter.TypeConverterManager;
import jodd.util.ClassUtil;

abstract class BeanUtilUtil
implements BeanUtil {
    protected boolean isDeclared = false;
    protected boolean isForced = false;
    protected boolean isSilent = false;
    protected ClassIntrospector introspector = JoddBean.defaults().getClassIntrospector();
    protected TypeConverterManager typeConverterManager = JoddBean.defaults().getTypeConverterManager();

    BeanUtilUtil() {
    }

    public void setIntrospector(ClassIntrospector introspector) {
        this.introspector = introspector;
    }

    public ClassIntrospector getIntrospector() {
        return this.introspector;
    }

    public void setTypeConverterManager(TypeConverterManager typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    public TypeConverterManager getTypeConverterManager() {
        return this.typeConverterManager;
    }

    protected Object convertType(Object value, Class type) {
        return this.typeConverterManager.convertType(value, type);
    }

    protected Object convertToCollection(Object value, Class destinationType, Class componentType) {
        return this.typeConverterManager.convertToCollection(value, destinationType, componentType);
    }

    protected Object invokeSetter(Setter setter, BeanProperty bp, Object value) {
        try {
            Class type = setter.getSetterRawType();
            if (ClassUtil.isTypeOf(type, Collection.class)) {
                Class componentType = setter.getSetterRawComponentType();
                value = this.convertToCollection(value, type, componentType);
            } else {
                value = this.convertType(value, type);
            }
            setter.invokeSetter(bp.bean, value);
        }
        catch (Exception ex) {
            if (this.isSilent) {
                return null;
            }
            throw new BeanException("Setter failed: " + setter, ex);
        }
        return value;
    }

    protected Object arrayForcedGet(BeanProperty bp, Object array, int index) {
        Object value;
        Class<?> componentType = array.getClass().getComponentType();
        if (!bp.last) {
            array = this.ensureArraySize(bp, array, componentType, index);
        }
        if ((value = Array.get(array, index)) == null) {
            try {
                value = ClassUtil.newInstance(componentType);
            }
            catch (Exception ex) {
                if (this.isSilent) {
                    return null;
                }
                throw new BeanException("Invalid array element: " + bp.name + '[' + index + ']', bp, ex);
            }
            Array.set(array, index, value);
        }
        return value;
    }

    protected void arrayForcedSet(BeanProperty bp, Object array, int index, Object value) {
        Class<?> componentType = array.getClass().getComponentType();
        array = this.ensureArraySize(bp, array, componentType, index);
        value = this.convertType(value, componentType);
        Array.set(array, index, value);
    }

    protected Object ensureArraySize(BeanProperty bp, Object array, Class componentType, int index) {
        int len = Array.getLength(array);
        if (index >= len) {
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(array, 0, newArray, 0, len);
            Setter setter = bp.getSetter(true);
            if (setter == null) {
                throw new BeanException("Setter or field not found: " + bp.name, bp);
            }
            array = newArray = this.invokeSetter(setter, bp, newArray);
        }
        return array;
    }

    protected void ensureListSize(List list, int size) {
        for (int len = list.size(); size >= len; ++len) {
            list.add(null);
        }
    }

    protected int indexOfDot(String name) {
        int len = name.length();
        boolean insideBracket = false;
        for (int ndx = 0; ndx < len; ++ndx) {
            char c = name.charAt(ndx);
            if (insideBracket) {
                if (c != ']') continue;
                insideBracket = false;
                continue;
            }
            if (c == '.') {
                return ndx;
            }
            if (c != '[') continue;
            insideBracket = true;
        }
        return -1;
    }

    protected String extractIndex(BeanProperty bp) {
        int leftBracketNdx;
        bp.index = null;
        String name = bp.name;
        int lastNdx = name.length() - 1;
        if (lastNdx < 0) {
            return null;
        }
        if (name.charAt(lastNdx) == ']' && (leftBracketNdx = name.lastIndexOf(91)) != -1) {
            bp.setName(name.substring(0, leftBracketNdx));
            bp.index = name.substring(leftBracketNdx + 1, lastNdx);
            return bp.index;
        }
        return null;
    }

    protected int parseInt(String indexString, BeanProperty bp) {
        try {
            return Integer.parseInt(indexString);
        }
        catch (NumberFormatException nfex) {
            throw new BeanException("Invalid index: " + indexString, bp, nfex);
        }
    }

    protected Object createBeanProperty(BeanProperty bp) {
        Object newInstance;
        Setter setter = bp.getSetter(true);
        if (setter == null) {
            return null;
        }
        Class type = setter.getSetterRawType();
        try {
            newInstance = ClassUtil.newInstance(type);
        }
        catch (Exception ex) {
            if (this.isSilent) {
                return null;
            }
            throw new BeanException("Invalid property: " + bp.name, bp, ex);
        }
        newInstance = this.invokeSetter(setter, bp, newInstance);
        return newInstance;
    }

    protected Class extractGenericComponentType(Getter getter) {
        Class<Object> componentType = null;
        if (getter != null) {
            componentType = getter.getGetterRawComponentType();
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        return componentType;
    }

    protected Object convertIndexToMapKey(Getter getter, Object index) {
        Class<Object> indexType = null;
        if (getter != null) {
            indexType = getter.getGetterRawKeyComponentType();
        }
        if (indexType == null) {
            indexType = Object.class;
        }
        if (indexType == Object.class) {
            return index;
        }
        try {
            return this.convertType(index, indexType);
        }
        catch (Exception ignore) {
            return index;
        }
    }

    protected Class extractType(BeanProperty bp) {
        Getter getter = bp.getGetter(this.isDeclared);
        if (getter != null) {
            if (bp.index != null) {
                Class type = getter.getGetterRawComponentType();
                return type == null ? Object.class : type;
            }
            return getter.getGetterRawType();
        }
        return null;
    }
}

