/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GzipResponseStream
extends ServletOutputStream {
    protected int compressionThreshold;
    protected byte[] buffer;
    protected int bufferCount;
    protected GZIPOutputStream gzipstream;
    protected boolean closed = false;
    protected int length = -1;
    protected HttpServletResponse response;
    protected ServletOutputStream output;

    public GzipResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
    }

    protected void setBuffer(int threshold) {
        this.compressionThreshold = threshold;
        this.buffer = new byte[this.compressionThreshold];
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.gzipstream != null) {
            this.flushToGZip();
            this.gzipstream.close();
            this.gzipstream = null;
        } else if (this.bufferCount > 0) {
            this.output.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.gzipstream != null) {
            this.gzipstream.flush();
        }
    }

    public void flushToGZip() throws IOException {
        if (this.bufferCount > 0) {
            this.writeToGZip(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushToGZip();
        }
        this.buffer[this.bufferCount++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.flushToGZip();
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.writeToGZip(b, off, len);
    }

    public void writeToGZip(byte[] b, int off, int len) throws IOException {
        if (this.gzipstream == null) {
            this.gzipstream = new GZIPOutputStream((OutputStream)this.output);
            this.response.addHeader("Content-Encoding", "gzip");
        }
        this.gzipstream.write(b, off, len);
    }

    public boolean closed() {
        return this.closed;
    }
}

