/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import jodd.JoddDefault;
import jodd.servlet.PageContextThreadLocal;
import jodd.servlet.ServletUtil;
import jodd.servlet.URLBuilder;

public class URLCoder {
    protected static final char[][] URL_CHARS = new char[256][];
    protected static final char[][] URI_CHARS = new char[128][];
    private static final char[] HEX_DIGITS;

    public static String url1(String value) {
        return URLCoder.url(value, PageContextThreadLocal.get());
    }

    public static String url(String value, PageContext pageContext) {
        return URLCoder.url(value, JoddDefault.encoding, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
    }

    public static String url(String value, String encoding, PageContext pageContext) {
        return URLCoder.url(value, encoding, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
    }

    public static String url(String value, HttpServletRequest request, HttpServletResponse response) {
        return URLCoder.url(value, JoddDefault.encoding, request, response);
    }

    public static String url(String value, String encoding, HttpServletRequest request, HttpServletResponse response) {
        String result = ServletUtil.resolveUrl(URLCoder.url(value, encoding), request);
        if (!ServletUtil.isAbsoluteUrl(result)) {
            result = response.encodeURL(result);
        }
        return result;
    }

    public static String url(String url) {
        return URLCoder.url(url, JoddDefault.encoding);
    }

    public static String url(String url, String encoding) {
        int paramNdx = url.indexOf(63);
        if (paramNdx == -1) {
            return URLCoder.encodePath(url);
        }
        StringBuilder result = new StringBuilder(url.length() >> 1);
        URLCoder.appendPath(result, url.substring(0, paramNdx));
        result.append('?');
        ++paramNdx;
        while (true) {
            int ampNdx;
            String q;
            int eqNdx;
            if ((eqNdx = (q = (ampNdx = url.indexOf(38, paramNdx)) == -1 ? url.substring(paramNdx) : url.substring(paramNdx, ampNdx)).indexOf(61)) == -1) {
                result.append(q);
            } else {
                String name = q.substring(0, eqNdx);
                URLCoder.appendQuery(result, name, encoding);
                result.append('=');
                String value = q.substring(eqNdx + 1);
                if (value.length() > 0) {
                    URLCoder.appendQuery(result, value, encoding);
                }
            }
            if (ampNdx == -1) break;
            result.append('&');
            paramNdx = ampNdx + 1;
        }
        return result.toString();
    }

    protected static void appendQuery(StringBuilder result, String value, String encoding) {
        byte[] bytes;
        try {
            bytes = value.getBytes(encoding);
        }
        catch (UnsupportedEncodingException ueex) {
            throw new IllegalArgumentException(ueex.toString());
        }
        for (byte b : bytes) {
            int i = b & 0xFF;
            result.append(URL_CHARS[i]);
        }
    }

    public static String encodeQuery(String value, String encoding) {
        StringBuilder sb = new StringBuilder(value.length());
        URLCoder.appendQuery(sb, value, encoding);
        return sb.toString();
    }

    public static String encodeQuery(String value) {
        return URLCoder.encodeQuery(value, JoddDefault.encoding);
    }

    protected static void appendPath(StringBuilder result, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c < '\u0080') {
                result.append(URI_CHARS[c]);
                continue;
            }
            URLCoder.quoteNon7bit(result, c);
        }
    }

    public static String encodePath(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        URLCoder.appendPath(sb, value);
        return sb.toString();
    }

    public static URLBuilder build() {
        return new URLBuilder(null, null, JoddDefault.encoding);
    }

    public static URLBuilder build(String path) {
        return URLCoder.build().path(path);
    }

    public static URLBuilder build(PageContext pageContext) {
        return new URLBuilder((HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse(), JoddDefault.encoding);
    }

    public static URLBuilder build(HttpServletRequest request, HttpServletResponse response) {
        return new URLBuilder(request, response, JoddDefault.encoding);
    }

    private static void quoteNon7bit(StringBuilder dest, char c) {
        if (Character.isSpaceChar(c) || Character.isISOControl(c)) {
            URLCoder.appendEncoded(dest, c);
        } else {
            dest.append(c);
        }
    }

    private static void appendEncoded(StringBuilder sb, char c) {
        byte[] bytes;
        try {
            bytes = String.valueOf(c).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            return;
        }
        for (byte b : bytes) {
            int i = b & 0xFF;
            if (i >= 128) {
                sb.append('%');
                sb.append(HEX_DIGITS[i >> 4]);
                sb.append(HEX_DIGITS[i & 0xF]);
                continue;
            }
            sb.append((char)i);
        }
    }

    static {
        for (char c = '\u0000'; c < URL_CHARS.length; c = (char)(c + '\u0001')) {
            try {
                URLCoder.URL_CHARS[c] = URLEncoder.encode(String.valueOf(c), "ISO-8859-1").toCharArray();
            }
            catch (UnsupportedEncodingException ueex) {
                ueex.printStackTrace();
            }
            if (c >= URI_CHARS.length) continue;
            try {
                URI uri = new URI("a", "", '/' + String.valueOf(c), null, null);
                URLCoder.URI_CHARS[c] = uri.toString().substring(5).toCharArray();
                continue;
            }
            catch (URISyntaxException usex) {
                usex.printStackTrace();
            }
        }
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }
}

