/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import jodd.JoddDefault;

public class UnicodeInputStream
extends InputStream {
    public static final int MAX_BOM_SIZE = 4;
    private PushbackInputStream internalInputStream;
    private boolean initialized;
    private int BOMSize = -1;
    private String encoding;
    private String defaultEncoding;

    public UnicodeInputStream(InputStream in) {
        this(in, JoddDefault.encoding);
    }

    public UnicodeInputStream(InputStream in, String defaultEncoding) {
        this.internalInputStream = new PushbackInputStream(in, 4);
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException ioex) {
                throw new IllegalStateException(ioex);
            }
        }
        return this.encoding;
    }

    protected void init() throws IOException {
        int unread;
        if (this.initialized) {
            return;
        }
        byte[] bom = new byte[4];
        int n = this.internalInputStream.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.encoding = "UTF-32LE";
            unread = n - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.encoding = "UTF-16LE";
            unread = n - 2;
        } else {
            this.encoding = this.defaultEncoding;
            unread = n;
        }
        this.BOMSize = 4 - unread;
        if (unread > 0) {
            this.internalInputStream.unread(bom, n - unread, unread);
        }
        this.initialized = true;
    }

    public void close() throws IOException {
        this.internalInputStream.close();
    }

    public int read() throws IOException {
        this.init();
        return this.internalInputStream.read();
    }

    public int getBOMSize() {
        return this.BOMSize;
    }
}

