/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.util.Iterator;
import java.util.Map;
import jodd.cache.Cache;
import jodd.cache.CacheValuesIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheMap<K, V>
implements Cache<K, V> {
    protected Map<K, CacheObject<K, V>> cacheMap;
    protected final Object cacheLock = new Object();
    protected int cacheSize;
    protected long timeout;
    protected boolean existCustomTimeout;

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getCacheTimeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        Object object2 = this.cacheLock;
        synchronized (object2) {
            CacheObject<K, V> co = new CacheObject<K, V>(key, object, timeout);
            if (timeout != 0L) {
                this.existCustomTimeout = true;
            }
            if (this.isFull()) {
                this.pruneCache();
            }
            this.cacheMap.put(key, co);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Object object = this.cacheLock;
        synchronized (object) {
            CacheObject<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                return null;
            }
            if (co.isExpired()) {
                this.remove(key);
                return null;
            }
            return co.getObject();
        }
    }

    @Override
    public Iterator<V> iterator() {
        return new CacheValuesIterator(this);
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.pruneCache();
        }
    }

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheMap.clear();
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheObject<K2, V2> {
        final K2 key;
        final V2 cachedObject;
        long lastAccess;
        long accessCount;
        long ttl;

        CacheObject(K2 key, V2 object, long ttl) {
            this.key = key;
            this.cachedObject = object;
            this.ttl = ttl;
            this.lastAccess = System.currentTimeMillis();
        }

        boolean isExpired() {
            if (this.ttl == 0L) {
                return false;
            }
            return this.lastAccess + this.ttl < System.currentTimeMillis();
        }

        V2 getObject() {
            this.lastAccess = System.currentTimeMillis();
            ++this.accessCount;
            return this.cachedObject;
        }
    }
}

