/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.util.ReflectUtil;

class BeanUtilUtil {
    protected TypeConverterManagerBean typeConverterManager = TypeConverterManager.getDefaultTypeConverterManager();

    BeanUtilUtil() {
    }

    public void setTypeConverterManager(TypeConverterManagerBean typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    protected Object convertType(Object value, Class type) {
        value = this.typeConverterManager.convertType(value, type);
        return value;
    }

    protected void invokeSetter(Object bean, Method m, Object value) {
        try {
            Class<?>[] paramTypes = m.getParameterTypes();
            value = this.convertType(value, paramTypes[0]);
            m.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to invoke setter: " + bean.getClass().getSimpleName() + '#' + m.getName() + "()", ex);
        }
    }

    protected Object invokeGetter(Object bean, Method m) {
        try {
            return m.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to invoke getter: " + bean.getClass().getSimpleName() + '#' + m.getName() + "()", ex);
        }
    }

    protected void setField(Object bean, Field f, Object value) {
        try {
            Class<?> type = f.getType();
            value = this.convertType(value, type);
            f.set(bean, value);
        }
        catch (Exception iaex) {
            throw new BeanException("Unable to set field: " + bean.getClass().getSimpleName() + '#' + f.getName(), iaex);
        }
    }

    protected Object getField(Object bean, Field f) {
        try {
            return f.get(bean);
        }
        catch (Exception iaex) {
            throw new BeanException("Unable to get field " + bean.getClass().getSimpleName() + '#' + f.getName(), iaex);
        }
    }

    protected Object arrayForcedGet(BeanProperty bp, Object array, int index) {
        Object value;
        Class<?> componentType = array.getClass().getComponentType();
        if (!bp.last) {
            array = this.ensureArraySize(bp, array, componentType, index);
        }
        if ((value = Array.get(array, index)) == null) {
            try {
                value = ReflectUtil.newInstance(componentType);
            }
            catch (Exception ex) {
                throw new BeanException("Unable to create array element: " + bp.name + '[' + index + ']', bp, ex);
            }
            Array.set(array, index, value);
        }
        return value;
    }

    protected void arrayForcedSet(BeanProperty bp, Object array, int index, Object value) {
        Class<?> componentType = array.getClass().getComponentType();
        array = this.ensureArraySize(bp, array, componentType, index);
        value = this.convertType(value, componentType);
        Array.set(array, index, value);
    }

    protected Object ensureArraySize(BeanProperty bp, Object array, Class componentType, int index) {
        int len = Array.getLength(array);
        if (index >= len) {
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(array, 0, newArray, 0, len);
            Method setter = bp.cd.getBeanSetter(bp.name, true);
            if (setter != null) {
                this.invokeSetter(bp.bean, setter, newArray);
            } else {
                Field field = bp.cd.getField(bp.name, true);
                if (field == null) {
                    throw new BeanException("Unable to find setter or field named as: " + bp.name, bp);
                }
                this.setField(bp.bean, field, newArray);
            }
            array = newArray;
        }
        return array;
    }

    protected void ensureListSize(List list, int size) {
        for (int len = list.size(); size >= len; ++len) {
            list.add(null);
        }
    }

    protected int indexOfDot(String name) {
        int ndx = 0;
        while (true) {
            if ((ndx = name.indexOf(46, ndx)) == -1) {
                return -1;
            }
            int rightNdx = name.indexOf(93);
            if (rightNdx <= ndx || name.lastIndexOf(91, rightNdx) >= ndx) break;
            ndx = rightNdx + 1;
        }
        return ndx;
    }

    protected String extractIndex(BeanProperty bp) {
        int leftBracketNdx;
        bp.index = null;
        String name = bp.name;
        int lastNdx = name.length() - 1;
        if (name.charAt(lastNdx) == ']' && (leftBracketNdx = name.lastIndexOf(91)) != -1) {
            bp.name = name.substring(0, leftBracketNdx);
            bp.index = name.substring(leftBracketNdx + 1, lastNdx);
            return bp.index;
        }
        return null;
    }

    protected int parseInt(String indexString, BeanProperty bp) {
        try {
            return Integer.parseInt(indexString);
        }
        catch (NumberFormatException nfex) {
            throw new BeanException("Invalid index: " + indexString, bp, nfex);
        }
    }

    protected Object createBeanProperty(BeanProperty bp) {
        Object newInstance;
        Class<?> type;
        Method setter = bp.cd.getBeanSetter(bp.name, true);
        Field field = null;
        if (setter != null) {
            type = setter.getParameterTypes()[0];
        } else {
            field = bp.cd.getField(bp.name, true);
            if (field == null) {
                return null;
            }
            type = field.getType();
        }
        try {
            newInstance = ReflectUtil.newInstance(type);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to create '" + bp.name + "' property.", bp, ex);
        }
        if (setter != null) {
            this.invokeSetter(bp.bean, setter, newInstance);
        } else {
            this.setField(bp.bean, field, newInstance);
        }
        return newInstance;
    }

    protected Class extracticGenericType(BeanProperty bp, int index) {
        Type type;
        if (bp.field != null) {
            type = bp.field.getGenericType();
        } else if (bp.method != null) {
            type = bp.method.getGenericReturnType();
        } else {
            return null;
        }
        return ReflectUtil.getComponentType(type, index);
    }

    protected Class extractType(BeanProperty bp) {
        Class<?> type = null;
        if (bp.field != null) {
            if (bp.index != null && (type = ReflectUtil.getComponentType(bp.field.getGenericType())) == null) {
                return Object.class;
            }
            if (type == null) {
                type = bp.field.getType();
            }
        } else if (bp.method != null) {
            if (bp.index != null && (type = ReflectUtil.getComponentType(bp.method.getGenericReturnType())) == null) {
                return Object.class;
            }
            if (type == null) {
                type = bp.method.getReturnType();
            }
        }
        return type;
    }
}

