/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jodd.bean.BeanException;
import jodd.bean.BeanLoaderManager;
import jodd.bean.BeanUtil;
import jodd.bean.loader.BeanLoader;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.util.PrettyStringBuilder;

public class BeanTool {
    public static void copy(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.doCopy(source, destination, true, suppressSecurity);
    }

    public static void apply(Object source, Object destination, boolean suppressSecurity) {
        BeanTool.doCopy(source, destination, false, suppressSecurity);
    }

    public static void copy(Object source, Object destination) {
        BeanTool.doCopy(source, destination, true, false);
    }

    public static void apply(Object source, Object destination) {
        BeanTool.doCopy(source, destination, false, false);
    }

    private static void doCopy(Object source, Object destination, boolean copyNulls, boolean suppressSecurity) {
        String[] properties;
        for (String name : properties = BeanTool.resolveProperties(source, suppressSecurity)) {
            Object value = BeanUtil.getProperty(source, name);
            if (!copyNulls && value == null) continue;
            BeanUtil.setPropertySilent(destination, name, value);
        }
    }

    public static String[] resolveProperties(Object bean, boolean suppressSecurity) {
        String[] properties;
        if (bean instanceof Map) {
            Set key = ((Map)bean).keySet();
            String[] mdata = new String[key.size()];
            int ndx = 0;
            for (Object o : key) {
                mdata[ndx] = o.toString();
                ++ndx;
            }
            properties = mdata;
        } else {
            ClassDescriptor cdSrc = ClassIntrospector.lookup(bean.getClass());
            properties = cdSrc.getAllBeanGetterNames(suppressSecurity);
        }
        return properties;
    }

    public static void load(Object bean, Object source) {
        BeanLoader loader = BeanLoaderManager.lookup(source);
        if (loader == null) {
            throw new BeanException("No BeanLoader for: " + source.getClass().getName());
        }
        loader.load(bean, source);
    }

    public static void load(Object bean, Object source, Class type) {
        BeanLoader loader = BeanLoaderManager.lookup(type);
        if (loader == null) {
            throw new BeanException("No BeanLoader for: " + type.getName());
        }
        loader.load(bean, source);
    }

    public static String attributesToString(Object bean) {
        Field[] fields;
        PrettyStringBuilder prettyString = new PrettyStringBuilder();
        if (bean == null) {
            return prettyString.toString(bean);
        }
        TreeSet<String> ts = new TreeSet<String>();
        ClassDescriptor cd = ClassIntrospector.lookup(bean.getClass());
        for (Field field : fields = cd.getAllFields(true)) {
            StringBuilder s = new StringBuilder();
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                s.append('+');
            } else if (Modifier.isProtected(modifiers)) {
                s.append('#');
            } else if (Modifier.isPrivate(modifiers)) {
                s.append('-');
            } else {
                s.append(' ');
            }
            s.append(field.getName()).append(':');
            try {
                Object value = field.get(bean);
                s.append(prettyString.toString(value));
            }
            catch (IllegalAccessException ignore) {
                s.append("N/A");
            }
            s.append('\n');
            ts.add(s.toString());
        }
        StringBuilder s = new StringBuilder();
        for (String s1 : ts) {
            s.append(s1);
        }
        return s.toString();
    }
}

