/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayConverter
implements TypeConverter<long[]> {
    protected final ConvertBean convertBean;

    public LongArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public long[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray(value.toString());
                return this.convertArray(values);
            }
            return new long[]{this.convertBean.toLongValue(value)};
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == long[].class) {
                return (long[])value;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (long)values[i];
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == float[].class) {
                float[] values = (float[])value;
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (long)values[i];
                }
                return results;
            }
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] ? 1L : 0L;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                long[] results = new long[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected long[] convertArray(Object[] values) {
        long[] results = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this.convertBean.toLongValue(values[i]);
        }
        return results;
    }
}

