/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet.filter;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.servlet.filter.GzipResponseWrapper;

public class GzipFilter
implements Filter {
    private FilterConfig config;
    protected String uriMatch;
    protected String uriExclude;
    private int minThreshold = 128;
    protected int threshold;
    private String[] extensions;
    private String[] excludes;

    protected FilterConfig getFilterConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (this.threshold == 0 || !this.isGzipSupported(req) || !this.isGzipEligible(req)) {
            chain.doFilter(request, response);
            return;
        }
        GzipResponseWrapper wrappedResponse = new GzipResponseWrapper(res);
        wrappedResponse.setCompressionThreshold(this.threshold);
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            wrappedResponse.finishResponse();
        }
    }

    public void init(FilterConfig config) throws ServletException {
        StringTokenizer st;
        int i;
        this.config = config;
        this.extensions = null;
        try {
            this.threshold = Integer.parseInt(config.getInitParameter("threshold"));
        }
        catch (NumberFormatException nfe) {
            this.threshold = 0;
        }
        if (this.threshold < this.minThreshold) {
            this.threshold = 0;
        }
        this.uriMatch = config.getInitParameter("match");
        if (this.uriMatch != null && !this.uriMatch.equals("*") && (i = (st = new StringTokenizer(this.uriMatch, ",")).countTokens()) >= 1) {
            this.extensions = new String[i];
            i = 0;
            while (st.hasMoreTokens()) {
                this.extensions[i] = st.nextToken().trim();
                ++i;
            }
        }
        this.uriExclude = config.getInitParameter("exclude");
        if (this.uriExclude != null && (i = (st = new StringTokenizer(this.uriExclude, ",")).countTokens()) >= 1) {
            this.excludes = new String[i];
            i = 0;
            while (st.hasMoreTokens()) {
                this.excludes[i] = st.nextToken().trim();
                ++i;
            }
        }
    }

    public void destroy() {
        this.config = null;
        this.extensions = null;
        this.excludes = null;
    }

    private boolean isGzipSupported(HttpServletRequest req) {
        String browserEncodings = req.getHeader("Accept-Encoding");
        return browserEncodings != null && browserEncodings.indexOf("gzip") != -1;
    }

    private boolean isGzipEligible(HttpServletRequest req) {
        String uri = req.getRequestURI();
        if (uri == null) {
            return false;
        }
        boolean result = false;
        if (this.extensions == null) {
            result = true;
        } else {
            for (String extension : this.extensions) {
                if (uri.indexOf(extension) == -1) continue;
                result = true;
                break;
            }
        }
        if (result && this.excludes != null) {
            for (String exclude : this.excludes) {
                if (uri.indexOf(exclude) == -1) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

