/*
 * Decompiled with CFR 0.152.
 */
package jodd.datetime;

import jodd.datetime.DateTimeStamp;
import jodd.datetime.JulianDateStamp;

public class TimeUtil {
    public static final long MILLIS_IN_DAY = 86400000L;
    private static final int[] MONTH_LENGTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEAP_MONTH_LENGTH = new int[]{0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static int dayOfYear(int year, int month, int day) {
        int day_of_year = TimeUtil.isLeapYear(year) ? 275 * month / 9 - (month + 9) / 12 + day - 30 : 275 * month / 9 - ((month + 9) / 12 << 1) + day - 30;
        return day_of_year;
    }

    public static boolean isLeapYear(int y) {
        boolean result = false;
        if (y % 4 == 0 && (y < 1582 || y % 100 != 0 || y % 400 == 0)) {
            result = true;
        }
        return result;
    }

    public static int getMonthLength(int year, int m) {
        if (m < 1 || m > 12) {
            return -1;
        }
        if (TimeUtil.isLeapYear(year)) {
            return LEAP_MONTH_LENGTH[m];
        }
        return MONTH_LENGTH[m];
    }

    public static boolean isValidDate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            return false;
        }
        int ml = TimeUtil.getMonthLength(year, month);
        return day >= 1 && day <= ml;
    }

    public static boolean isValidTime(int hour, int minute, int second, int millisecond) {
        if (hour < 0 || hour >= 24) {
            return false;
        }
        if (minute < 0 || minute >= 60) {
            return false;
        }
        if (second < 0 || second >= 60) {
            return false;
        }
        return millisecond >= 0 && millisecond < 1000;
    }

    public static boolean isValidDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return TimeUtil.isValidDate(year, month, day) && TimeUtil.isValidTime(hour, minute, second, millisecond);
    }

    public static boolean isValidDateTime(DateTimeStamp dts) {
        return TimeUtil.isValidDate(dts.year, dts.month, dts.day) && TimeUtil.isValidTime(dts.hour, dts.minute, dts.second, dts.millisecond);
    }

    public static JulianDateStamp toJulianDate(DateTimeStamp time) {
        return TimeUtil.toJulianDate(time.year, time.month, time.day, time.hour, time.minute, time.second, time.millisecond);
    }

    public static JulianDateStamp toJulianDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        int im0;
        int iy0;
        double frac;
        if (month > 12 || month < -12) {
            int delta = --month / 12;
            year += delta;
            month -= delta * 12;
            ++month;
        }
        if (month < 0) {
            --year;
            month += 12;
        }
        if ((frac = (double)hour / 24.0 + (double)minute / 1440.0 + (double)second / 86400.0 + (double)millisecond / 8.64E7) < 0.0) {
            int delta = (int)(-frac) + 1;
            frac += (double)delta;
            day -= delta;
        }
        double gyr = (double)year + 0.01 * (double)month + 1.0E-4 * ((double)day + frac) + 1.0E-9;
        if (month <= 2) {
            iy0 = year - 1;
            im0 = month + 12;
        } else {
            iy0 = year;
            im0 = month;
        }
        int ia = iy0 / 100;
        int ib = 2 - ia + (ia >> 2);
        int jd = year <= 0 ? (int)(365.25 * (double)iy0 - 0.75) + (int)(30.6001 * (double)(im0 + 1)) + day + 1720994 : (int)(365.25 * (double)iy0) + (int)(30.6001 * (double)(im0 + 1)) + day + 1720994;
        if (gyr >= 1582.1015) {
            jd += ib;
        }
        return new JulianDateStamp(jd, frac + 0.5);
    }

    public static DateTimeStamp fromJulianDate(double JD) {
        return TimeUtil.fromJulianDate(new JulianDateStamp(JD));
    }

    public static DateTimeStamp fromJulianDate(JulianDateStamp jds) {
        DateTimeStamp time = new DateTimeStamp();
        int ka = (int)(jds.fraction + 0.5);
        int jd = jds.integer + ka;
        double frac = jds.fraction + 0.5 - (double)ka + 1.0E-10;
        ka = jd;
        if (jd >= 2299161) {
            int ialp = (int)(((double)jd - 1867216.25) / 36524.25);
            ka = jd + 1 + ialp - (ialp >> 2);
        }
        int kb = ka + 1524;
        int kc = (int)(((double)kb - 122.1) / 365.25);
        int kd = (int)((double)kc * 365.25);
        int ke = (int)((double)(kb - kd) / 30.6001);
        int day = kb - kd - (int)((double)ke * 30.6001);
        int month = ke > 13 ? ke - 13 : ke - 1;
        if (month == 2 && day > 28) {
            day = 29;
        }
        int year = month == 2 && day == 29 && ke == 3 ? kc - 4716 : (month > 2 ? kc - 4716 : kc - 4715);
        time.year = year;
        time.month = month;
        time.day = day;
        double d_hour = frac * 24.0;
        time.hour = (int)d_hour;
        double d_minute = (d_hour - (double)time.hour) * 60.0;
        time.minute = (int)d_minute;
        double d_second = (d_minute - (double)time.minute) * 60.0;
        time.second = (int)d_second;
        double d_millis = (d_second - (double)time.second) * 1000.0;
        time.millisecond = (int)((d_millis * 10.0 + 0.5) / 10.0);
        return time;
    }

    public static int toCalendarMonth(int month) {
        return month - 1;
    }

    public static int toCalendarDayOfWeek(int dayOfWeek) {
        return dayOfWeek % 7 + 1;
    }
}

