/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean.loader;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import jodd.bean.loader.BaseBeanLoader;
import jodd.util.StringUtil;

public class ServletContextBeanLoader
extends BaseBeanLoader {
    protected final String prefix;

    public ServletContextBeanLoader() {
        this.prefix = null;
    }

    public ServletContextBeanLoader(String prefix) {
        this.prefix = prefix;
    }

    public void load(Object bean, Object source) {
        if (source instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)source;
            Enumeration attributeNames = servletContext.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object value = servletContext.getAttribute(attributeName);
                if (this.prefix != null) {
                    attributeName = this.prefix + StringUtil.capitalize(attributeName);
                }
                this.beanUtilBean.setPropertyForcedSilent(bean, attributeName, value);
            }
        }
    }
}

