/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean.loader;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.StringTokenizer;
import jodd.bean.loader.BaseBeanLoader;
import jodd.util.StringUtil;

public class ResultSetBeanLoader
extends BaseBeanLoader {
    public void load(Object bean, Object source) {
        if (source instanceof ResultSet) {
            try {
                ResultSet resultSet = (ResultSet)source;
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                for (int i = 1; i <= numberOfColumns; ++i) {
                    StringTokenizer st = new StringTokenizer(rsmd.getColumnName(i), "_");
                    StringBuilder columnName = new StringBuilder();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken().toLowerCase();
                        columnName.append(StringUtil.capitalize(token));
                    }
                    this.beanUtilBean.setPropertyForcedSilent(bean, columnName.toString(), resultSet.getObject(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

