/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean.loader;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import jodd.bean.loader.BaseBeanLoader;

public class RequestParamBeanLoader
extends BaseBeanLoader {
    protected final boolean trim;

    public RequestParamBeanLoader() {
        this.trim = false;
    }

    public RequestParamBeanLoader(boolean trim) {
        this.trim = trim;
    }

    public void load(Object bean, Object source) {
        if (source instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)source;
            Enumeration paramNames = httpServletRequest.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String[] paramValues = httpServletRequest.getParameterValues(paramName);
                if (paramValues == null || paramValues.length == 0) continue;
                if (this.trim) {
                    for (int i = 0; i < paramValues.length; ++i) {
                        paramValues[i] = paramValues[i].trim();
                    }
                }
                if (paramValues.length == 1) {
                    this.beanUtilBean.setPropertyForcedSilent(bean, paramName, paramValues[0]);
                    continue;
                }
                this.beanUtilBean.setPropertyForcedSilent(bean, paramName, paramValues);
            }
        }
    }
}

