/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.NamedThreadFactory;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.SuspendableThreadPoolExecutor;
import org.jodconverter.core.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfficeManagerPoolEntry
implements OfficeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPoolEntry.class);
    private static final long DEFAULT_TASK_EXECUTION_TIMEOUT = 120000L;
    private final long taskExecutionTimeout;
    private final SuspendableThreadPoolExecutor taskExecutor;
    private Future<?> currentFuture;

    public AbstractOfficeManagerPoolEntry(@Nullable Long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout == null ? 120000L : taskExecutionTimeout;
        this.taskExecutor = new SuspendableThreadPoolExecutor(new NamedThreadFactory("jodconverter-poolentry"));
    }

    @Override
    public final void execute(@NonNull OfficeTask task) throws OfficeException {
        this.currentFuture = this.taskExecutor.submit(() -> {
            this.doExecute(task);
            return null;
        });
        try {
            LOGGER.debug("Waiting for task to complete: {}", (Object)task);
            this.currentFuture.get(this.taskExecutionTimeout, TimeUnit.MILLISECONDS);
            LOGGER.debug("Task executed successfully: {}", (Object)task);
        }
        catch (TimeoutException timeoutEx) {
            this.handleExecuteTimeoutException(timeoutEx);
            throw new OfficeException("Task did not complete within timeout: " + task, timeoutEx);
        }
        catch (ExecutionException executionEx) {
            if (executionEx.getCause() instanceof OfficeException) {
                throw (OfficeException)executionEx.getCause();
            }
            throw new OfficeException("Task failed: " + task, executionEx.getCause());
        }
        catch (Exception ex) {
            throw new OfficeException("Task failed: " + task, ex);
        }
        finally {
            this.currentFuture = null;
        }
    }

    protected abstract void doExecute(@NonNull OfficeTask var1) throws Exception;

    protected void handleExecuteTimeoutException(@NonNull TimeoutException timeoutEx) {
        LOGGER.debug("Handling task execution timeout.", (Throwable)timeoutEx);
    }

    @Override
    public boolean isRunning() {
        return !this.taskExecutor.isShutdown();
    }

    @Override
    public final void start() throws OfficeException {
        if (this.taskExecutor.isShutdown()) {
            throw new IllegalStateException("This office manager (pool entry) has been shutdown.");
        }
        this.doStart();
    }

    protected abstract void doStart() throws OfficeException;

    @Override
    public final void stop() throws OfficeException {
        this.taskExecutor.setAvailable(false);
        this.taskExecutor.shutdownNow();
        this.doStop();
    }

    protected abstract void doStop() throws OfficeException;

    protected void cancelTask() {
        if (this.currentFuture != null) {
            this.currentFuture.cancel(true);
        }
    }

    protected void setAvailable(boolean available) {
        this.taskExecutor.setAvailable(available);
    }
}

