/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.TemporaryFileMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfficeManager
implements OfficeManager,
TemporaryFileMaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManager.class);
    private final File workingDir;
    private final AtomicLong tempFileCounter;
    private File tempDir;

    protected static @NonNull File makeTempDir(@NonNull File workingDir) {
        File tempDir = new File(workingDir, "jodconverter_" + UUID.randomUUID().toString());
        tempDir.mkdirs();
        if (!tempDir.isDirectory()) {
            throw new IllegalStateException(String.format("Cannot create temp directory: %s", tempDir));
        }
        return tempDir;
    }

    protected AbstractOfficeManager(@NonNull File workingDir) {
        this.workingDir = workingDir;
        this.tempFileCounter = new AtomicLong(0L);
    }

    @Override
    public @NonNull File makeTemporaryFile() {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement());
    }

    @Override
    public @NonNull File makeTemporaryFile(@NonNull String extension) {
        return new File(this.tempDir, "tempfile_" + this.tempFileCounter.getAndIncrement() + "." + extension);
    }

    protected void makeTempDir() {
        this.deleteTempDir();
        this.tempDir = AbstractOfficeManager.makeTempDir(this.workingDir);
    }

    protected void deleteTempDir() {
        if (this.tempDir != null) {
            LOGGER.debug("Deleting temporary directory '{}'", (Object)this.tempDir);
            try {
                FileUtils.deleteDirectory((File)this.tempDir);
            }
            catch (IOException ioEx) {
                LOGGER.error("Could not delete temporary profileDir: {}", (Object)ioEx.getMessage());
            }
        }
    }

    public static abstract class AbstractOfficeManagerBuilder<B extends AbstractOfficeManagerBuilder<B>> {
        protected boolean install;
        protected File workingDir;

        protected AbstractOfficeManagerBuilder() {
        }

        protected abstract @NonNull AbstractOfficeManager build();

        public @NonNull B install() {
            this.install = true;
            return (B)this;
        }

        public @NonNull B workingDir(@Nullable File workingDir) {
            this.workingDir = workingDir;
            return (B)this;
        }

        public @NonNull B workingDir(@Nullable String workingDir) {
            return (B)(StringUtils.isBlank((CharSequence)workingDir) ? this : this.workingDir(new File(workingDir)));
        }
    }
}

