/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.DocumentSpecsIOException;
import org.jodconverter.core.job.TargetDocumentSpecs;
import org.jodconverter.core.office.TemporaryFileMaker;

public class TargetDocumentSpecsFromOutputStream
extends AbstractTargetDocumentSpecs
implements TargetDocumentSpecs {
    private final OutputStream outputStream;
    private final boolean closeStream;
    private final TemporaryFileMaker fileMaker;

    public TargetDocumentSpecsFromOutputStream(@NonNull OutputStream outputStream, @NonNull TemporaryFileMaker fileMaker, boolean closeStream) {
        super(fileMaker.makeTemporaryFile());
        Validate.notNull((Object)outputStream, (String)"outputStream must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)fileMaker, (String)"fileMaker must not be null", (Object[])new Object[0]);
        this.outputStream = outputStream;
        this.closeStream = closeStream;
        this.fileMaker = fileMaker;
    }

    @Override
    public @NonNull File getFile() {
        return Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(super.getFile());
    }

    @Override
    public void onComplete(@NonNull File tempFile) {
        try {
            FileUtils.copyFile((File)tempFile, (OutputStream)this.outputStream);
            if (this.closeStream) {
                this.outputStream.close();
            }
        }
        catch (IOException ex) {
            throw new DocumentSpecsIOException("Could not write file '" + tempFile + "' to stream", ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    @Override
    public void onFailure(@NonNull File tempFile, @NonNull Exception exception) {
        FileUtils.deleteQuietly((File)tempFile);
    }
}

