/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.DocumentSpecsIOException;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.office.TemporaryFileMaker;

public class SourceDocumentSpecsFromInputStream
extends AbstractSourceDocumentSpecs
implements SourceDocumentSpecs {
    private final InputStream inputStream;
    private final TemporaryFileMaker fileMaker;
    private final boolean closeStream;

    public SourceDocumentSpecsFromInputStream(@NonNull InputStream inputStream, @NonNull TemporaryFileMaker fileMaker, boolean closeStream) {
        super(fileMaker.makeTemporaryFile());
        Validate.notNull((Object)inputStream, (String)"inputStream must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)fileMaker, (String)"fileMaker must not be null", (Object[])new Object[0]);
        this.inputStream = inputStream;
        this.fileMaker = fileMaker;
        this.closeStream = closeStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull File getFile() {
        File file;
        File tempFile = Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(super.getFile());
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        outputStream.getChannel().lock();
        try {
            IOUtils.copy((InputStream)this.inputStream, (OutputStream)outputStream);
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new DocumentSpecsIOException("Could not write stream to file " + tempFile, ex);
            }
        }
        outputStream.close();
        return file;
    }

    @Override
    public void onConsumed(@NonNull File tempFile) {
        FileUtils.deleteQuietly((File)tempFile);
        if (this.closeStream) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                throw new DocumentSpecsIOException("Could not close input stream", ex);
            }
        }
    }
}

