/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.job;

import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.ConversionJob;
import org.jodconverter.core.job.ConversionJobWithOptionalTargetFormatUnspecified;
import org.jodconverter.core.office.OfficeException;

public abstract class AbstractConversionJob
implements ConversionJobWithOptionalTargetFormatUnspecified {
    protected final AbstractSourceDocumentSpecs source;
    protected final AbstractTargetDocumentSpecs target;

    protected AbstractConversionJob(@NonNull AbstractSourceDocumentSpecs source, @NonNull AbstractTargetDocumentSpecs target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public @NonNull ConversionJob as(@NonNull DocumentFormat format) {
        this.target.setDocumentFormat(format);
        return this;
    }

    @Override
    public final void execute() throws OfficeException {
        Validate.notNull((Object)this.target.getFormat(), (String)"The target format is missing or not supported", (Object[])new Object[0]);
        this.doExecute();
    }

    protected abstract void doExecute() throws OfficeException;
}

