/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;

public class SimpleDocumentFormatRegistry
implements DocumentFormatRegistry {
    private final Map<String, DocumentFormat> fmtsByExtension = new HashMap<String, DocumentFormat>();
    private final Map<String, DocumentFormat> fmtsByMediaType = new HashMap<String, DocumentFormat>();

    public void addFormat(@NonNull DocumentFormat documentFormat) {
        documentFormat.getExtensions().stream().map(StringUtils::lowerCase).forEach(ext -> this.fmtsByExtension.put((String)ext, documentFormat));
        this.fmtsByMediaType.put(StringUtils.lowerCase((String)documentFormat.getMediaType()), documentFormat);
    }

    @Override
    public @Nullable DocumentFormat getFormatByExtension(@NonNull String extension) {
        Validate.notNull((Object)extension, (String)"extension must not be null", (Object[])new Object[0]);
        return this.fmtsByExtension.get(StringUtils.lowerCase((String)extension));
    }

    @Override
    public @Nullable DocumentFormat getFormatByMediaType(@NonNull String mediaType) {
        Validate.notNull((Object)mediaType, (String)"mediaType must not be null", (Object[])new Object[0]);
        return this.fmtsByMediaType.get(StringUtils.lowerCase((String)mediaType));
    }

    @Override
    public @NonNull Set<@NonNull DocumentFormat> getOutputFormats(@NonNull DocumentFamily documentFamily) {
        Validate.notNull((Object)((Object)documentFamily), (String)"documentFamily must not be null", (Object[])new Object[0]);
        return this.fmtsByMediaType.values().stream().filter(format -> format.getStoreProperties(documentFamily) != null).collect(Collectors.toSet());
    }
}

