/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DocumentFamily;

public class DocumentFormat {
    private final String name;
    private final List<String> extensions;
    private final String mediaType;
    private final DocumentFamily inputFamily;
    private final Map<String, Object> loadProperties;
    private final Map<DocumentFamily, Map<String, Object>> storeProperties;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull DocumentFormat copy(@NonNull DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat).unmodifiable(false).build();
    }

    public static @NonNull DocumentFormat unmodifiableCopy(@NonNull DocumentFormat sourceFormat) {
        return new Builder().from(sourceFormat).unmodifiable(true).build();
    }

    private DocumentFormat(String name, Collection<String> extensions, String mediaType, DocumentFamily inputFamily, Map<String, Object> loadProperties, Map<DocumentFamily, Map<String, Object>> storeProperties, boolean unmodifiable) {
        Validate.notBlank((CharSequence)name, (String)"name must not be null nor blank", (Object[])new Object[0]);
        Validate.notNull(extensions, (String)"extensions must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mediaType, (String)"mediaType must not be null nor blank", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)inputFamily), (String)"inputFamily must not be null", (Object[])new Object[0]);
        this.name = name;
        this.extensions = new ArrayList<String>(extensions);
        this.mediaType = mediaType;
        this.inputFamily = inputFamily;
        if (loadProperties == null) {
            this.loadProperties = null;
        } else {
            Map<String, Object> map = this.loadProperties = unmodifiable ? Collections.unmodifiableMap(new HashMap<String, Object>(loadProperties)) : new HashMap<String, Object>(loadProperties);
        }
        if (storeProperties == null) {
            this.storeProperties = null;
        } else {
            EnumMap familyMap = new EnumMap(DocumentFamily.class);
            storeProperties.forEach((family, props) -> {
                Map cfr_ignored_0 = familyMap.put((DocumentFamily)((Object)family), unmodifiable ? Collections.unmodifiableMap(new HashMap(props)) : new HashMap(props));
            });
            this.storeProperties = unmodifiable ? Collections.unmodifiableMap(familyMap) : familyMap;
        }
    }

    public @NonNull String getExtension() {
        return this.extensions.get(0);
    }

    public @NonNull List<@NonNull String> getExtensions() {
        return this.extensions;
    }

    public @NonNull DocumentFamily getInputFamily() {
        return this.inputFamily;
    }

    public @Nullable Map<@NonNull String, @NonNull Object> getLoadProperties() {
        return this.loadProperties;
    }

    public @NonNull String getMediaType() {
        return this.mediaType;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @Nullable Map<@NonNull DocumentFamily, @NonNull Map<@NonNull String, @NonNull Object>> getStoreProperties() {
        return this.storeProperties;
    }

    public @Nullable Map<@NonNull String, @NonNull Object> getStoreProperties(@NonNull DocumentFamily family) {
        return this.storeProperties == null ? null : this.storeProperties.get((Object)family);
    }

    public @NonNull String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static final class Builder {
        private String name;
        private Set<String> extensions;
        private String mediaType;
        private DocumentFamily inputFamily;
        private Map<String, Object> loadProperties;
        private Map<DocumentFamily, Map<String, Object>> storeProperties;
        private boolean unmodifiable = true;

        private Builder() {
        }

        public @NonNull DocumentFormat build() {
            return new DocumentFormat(this.name, this.extensions, this.mediaType, this.inputFamily, this.loadProperties, this.storeProperties, this.unmodifiable);
        }

        public @NonNull Builder from(@NonNull DocumentFormat sourceFormat) {
            Validate.notNull((Object)sourceFormat, (String)"sourceFormat must not be null", (Object[])new Object[0]);
            this.name = sourceFormat.getName();
            this.extensions = new LinkedHashSet<String>(sourceFormat.getExtensions());
            this.mediaType = sourceFormat.getMediaType();
            this.inputFamily = sourceFormat.getInputFamily();
            HashMap<String, Object> hashMap = this.loadProperties = sourceFormat.getLoadProperties() == null ? null : new HashMap<String, Object>(sourceFormat.getLoadProperties());
            if (sourceFormat.getStoreProperties() != null) {
                this.storeProperties = new EnumMap<DocumentFamily, Map<String, Object>>(DocumentFamily.class);
                sourceFormat.getStoreProperties().forEach((family, propMap) -> {
                    Map cfr_ignored_0 = this.storeProperties.put((DocumentFamily)((Object)family), new HashMap(propMap));
                });
            }
            return this;
        }

        public @NonNull Builder extension(@NonNull String extension) {
            Validate.notBlank((CharSequence)extension, (String)"extension must not be null nor blank", (Object[])new Object[0]);
            if (this.extensions == null) {
                this.extensions = new LinkedHashSet<String>();
            }
            this.extensions.add(extension);
            return this;
        }

        public @NonNull Builder inputFamily(@NonNull DocumentFamily inputFamily) {
            Validate.notNull((Object)((Object)inputFamily), (String)"inputFamily must not be null", (Object[])new Object[0]);
            this.inputFamily = inputFamily;
            return this;
        }

        public @NonNull Builder loadProperty(@NonNull String name, @Nullable Object value) {
            Validate.notBlank((CharSequence)name, (String)"name must not be null nor blank", (Object[])new Object[0]);
            if (value == null) {
                if (this.loadProperties != null) {
                    this.loadProperties.remove(name);
                    if (this.loadProperties.isEmpty()) {
                        this.loadProperties = null;
                    }
                }
            } else {
                if (this.loadProperties == null) {
                    this.loadProperties = new HashMap<String, Object>();
                }
                this.loadProperties.put(name, value);
            }
            return this;
        }

        public @NonNull Builder mediaType(@NonNull String mediaType) {
            Validate.notBlank((CharSequence)mediaType, (String)"mediaType must not be null nor blank", (Object[])new Object[0]);
            this.mediaType = mediaType;
            return this;
        }

        public @NonNull Builder name(@NonNull String name) {
            Validate.notBlank((CharSequence)name, (String)"name must not be null nor blank", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public @NonNull Builder unmodifiable(boolean unmodifiable) {
            this.unmodifiable = unmodifiable;
            return this;
        }

        public @NonNull Builder storeProperty(@NonNull DocumentFamily documentFamily, @NonNull String name, @Nullable Object value) {
            Validate.notNull((Object)((Object)documentFamily), (String)"documentFamily must not be null", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)name, (String)"name must not be null nor blank", (Object[])new Object[0]);
            if (value == null) {
                Map<String, Object> props;
                if (this.storeProperties != null && (props = this.storeProperties.get((Object)documentFamily)) != null) {
                    props.remove(name);
                    if (props.isEmpty()) {
                        this.storeProperties.remove((Object)documentFamily);
                    }
                    if (this.storeProperties.isEmpty()) {
                        this.storeProperties = null;
                    }
                }
            } else {
                if (this.storeProperties == null) {
                    this.storeProperties = new EnumMap<DocumentFamily, Map<String, Object>>(DocumentFamily.class);
                }
                this.storeProperties.computeIfAbsent(documentFamily, key -> new HashMap()).put(name, value);
            }
            return this;
        }
    }
}

