/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Command;
import zmq.Ctx;
import zmq.IEngine;
import zmq.IOThread;
import zmq.Own;
import zmq.Pipe;
import zmq.SessionBase;
import zmq.SocketBase;

public abstract class ZObject {
    private final Ctx ctx;
    private final int tid;

    protected ZObject(Ctx ctx, int tid) {
        this.ctx = ctx;
        this.tid = tid;
    }

    protected ZObject(ZObject parent_) {
        this(parent_.ctx, parent_.tid);
    }

    protected int get_tid() {
        return this.tid;
    }

    protected Ctx get_ctx() {
        return this.ctx;
    }

    protected void process_command(Command cmd_) {
        switch (cmd_.type()) {
            case activate_read: {
                this.process_activate_read();
                break;
            }
            case activate_write: {
                this.process_activate_write((Long)cmd_.arg);
                break;
            }
            case stop: {
                this.process_stop();
                break;
            }
            case plug: {
                this.process_plug();
                this.process_seqnum();
                break;
            }
            case own: {
                this.process_own((Own)cmd_.arg);
                this.process_seqnum();
                break;
            }
            case attach: {
                this.process_attach((IEngine)cmd_.arg);
                this.process_seqnum();
                break;
            }
            case bind: {
                this.process_bind((Pipe)cmd_.arg);
                this.process_seqnum();
                break;
            }
            case hiccup: {
                this.process_hiccup(cmd_.arg);
                break;
            }
            case pipe_term: {
                this.process_pipe_term();
                break;
            }
            case pipe_term_ack: {
                this.process_pipe_term_ack();
                break;
            }
            case term_req: {
                this.process_term_req((Own)cmd_.arg);
                break;
            }
            case term: {
                this.process_term((Integer)cmd_.arg);
                break;
            }
            case term_ack: {
                this.process_term_ack();
                break;
            }
            case reap: {
                this.process_reap((SocketBase)cmd_.arg);
                break;
            }
            case reaped: {
                this.process_reaped();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected boolean register_endpoint(String addr_, Ctx.Endpoint endpoint_) {
        return this.ctx.register_endpoint(addr_, endpoint_);
    }

    protected void unregister_endpoints(SocketBase socket_) {
        this.ctx.unregister_endpoints(socket_);
    }

    protected Ctx.Endpoint find_endpoint(String addr_) {
        return this.ctx.find_endpoint(addr_);
    }

    protected void destroy_socket(SocketBase socket_) {
        this.ctx.destroy_socket(socket_);
    }

    protected IOThread choose_io_thread(long affinity_) {
        return this.ctx.choose_io_thread(affinity_);
    }

    protected void send_stop() {
        Command cmd = new Command(this, Command.Type.stop);
        this.ctx.send_command(this.tid, cmd);
    }

    protected void send_plug(Own destination_) {
        this.send_plug(destination_, true);
    }

    protected void send_plug(Own destination_, boolean inc_seqnum_) {
        if (inc_seqnum_) {
            destination_.inc_seqnum();
        }
        Command cmd = new Command(destination_, Command.Type.plug);
        this.send_command(cmd);
    }

    protected void send_own(Own destination_, Own object_) {
        destination_.inc_seqnum();
        Command cmd = new Command(destination_, Command.Type.own, object_);
        this.send_command(cmd);
    }

    protected void send_attach(SessionBase destination_, IEngine engine_) {
        this.send_attach(destination_, engine_, true);
    }

    protected void send_attach(SessionBase destination_, IEngine engine_, boolean inc_seqnum_) {
        if (inc_seqnum_) {
            destination_.inc_seqnum();
        }
        Command cmd = new Command(destination_, Command.Type.attach, engine_);
        this.send_command(cmd);
    }

    protected void send_bind(Own destination_, Pipe pipe_) {
        this.send_bind(destination_, pipe_, true);
    }

    protected void send_bind(Own destination_, Pipe pipe_, boolean inc_seqnum_) {
        if (inc_seqnum_) {
            destination_.inc_seqnum();
        }
        Command cmd = new Command(destination_, Command.Type.bind, pipe_);
        this.send_command(cmd);
    }

    protected void send_activate_read(Pipe destination_) {
        Command cmd = new Command(destination_, Command.Type.activate_read);
        this.send_command(cmd);
    }

    protected void send_activate_write(Pipe destination_, long msgs_read_) {
        Command cmd = new Command(destination_, Command.Type.activate_write, msgs_read_);
        this.send_command(cmd);
    }

    protected void send_hiccup(Pipe destination_, Object pipe_) {
        Command cmd = new Command(destination_, Command.Type.hiccup, pipe_);
        this.send_command(cmd);
    }

    protected void send_pipe_term(Pipe destination_) {
        Command cmd = new Command(destination_, Command.Type.pipe_term);
        this.send_command(cmd);
    }

    protected void send_pipe_term_ack(Pipe destination_) {
        Command cmd = new Command(destination_, Command.Type.pipe_term_ack);
        this.send_command(cmd);
    }

    protected void send_term_req(Own destination_, Own object_) {
        Command cmd = new Command(destination_, Command.Type.term_req, object_);
        this.send_command(cmd);
    }

    protected void send_term(Own destination_, int linger_) {
        Command cmd = new Command(destination_, Command.Type.term, linger_);
        this.send_command(cmd);
    }

    protected void send_term_ack(Own destination_) {
        Command cmd = new Command(destination_, Command.Type.term_ack);
        this.send_command(cmd);
    }

    protected void send_reap(SocketBase socket_) {
        Command cmd = new Command(this.ctx.get_reaper(), Command.Type.reap, socket_);
        this.send_command(cmd);
    }

    protected void send_reaped() {
        Command cmd = new Command(this.ctx.get_reaper(), Command.Type.reaped);
        this.send_command(cmd);
    }

    protected void send_done() {
        Command cmd = new Command(null, Command.Type.done);
        this.ctx.send_command(0, cmd);
    }

    protected void process_stop() {
        throw new UnsupportedOperationException();
    }

    protected void process_plug() {
        throw new UnsupportedOperationException();
    }

    protected void process_own(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void process_attach(IEngine engine) {
        throw new UnsupportedOperationException();
    }

    protected void process_bind(Pipe pipe) {
        throw new UnsupportedOperationException();
    }

    protected void process_activate_read() {
        throw new UnsupportedOperationException();
    }

    protected void process_activate_write(long msgs_read_) {
        throw new UnsupportedOperationException();
    }

    protected void process_hiccup(Object hiccup_pipe) {
        throw new UnsupportedOperationException();
    }

    protected void process_pipe_term() {
        throw new UnsupportedOperationException();
    }

    protected void process_pipe_term_ack() {
        throw new UnsupportedOperationException();
    }

    protected void process_term_req(Own object) {
        throw new UnsupportedOperationException();
    }

    protected void process_term(int linger) {
        throw new UnsupportedOperationException();
    }

    protected void process_term_ack() {
        throw new UnsupportedOperationException();
    }

    protected void process_reap(SocketBase socket) {
        throw new UnsupportedOperationException();
    }

    protected void process_reaped() {
        throw new UnsupportedOperationException();
    }

    protected void process_seqnum() {
        throw new UnsupportedOperationException();
    }

    private void send_command(Command cmd_) {
        this.ctx.send_command(cmd_.destination().get_tid(), cmd_);
    }
}

