/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.HashSet;
import java.util.Set;
import zmq.Address;
import zmq.Dealer;
import zmq.IEngine;
import zmq.IMsgSink;
import zmq.IMsgSource;
import zmq.IOObject;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.IpcConnecter;
import zmq.Msg;
import zmq.Options;
import zmq.Own;
import zmq.Pair;
import zmq.Pipe;
import zmq.Pub;
import zmq.Pull;
import zmq.Push;
import zmq.Rep;
import zmq.Req;
import zmq.Router;
import zmq.SocketBase;
import zmq.Sub;
import zmq.TcpConnecter;
import zmq.XPub;
import zmq.XSub;
import zmq.ZError;
import zmq.ZObject;

public class SessionBase
extends Own
implements Pipe.IPipeEvents,
IPollEvents,
IMsgSink,
IMsgSource {
    private boolean connect;
    private Pipe pipe;
    private final Set<Pipe> terminating_pipes;
    private boolean incomplete_in;
    private boolean pending;
    private IEngine engine;
    private SocketBase socket;
    private IOThread io_thread;
    private static int linger_timer_id = 32;
    private boolean has_linger_timer;
    private boolean identity_sent;
    private boolean identity_received;
    private final Address addr;
    private IOObject io_object;

    public static SessionBase create(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
        SessionBase s = null;
        switch (options_.type) {
            case 3: {
                s = new Req.ReqSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 5: {
                s = new Dealer.DealerSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 4: {
                s = new Rep.RepSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 6: {
                s = new Router.RouterSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 1: {
                s = new Pub.PubSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 9: {
                s = new XPub.XPubSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 2: {
                s = new Sub.SubSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 10: {
                s = new XSub.XSubSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 8: {
                s = new Push.PushSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 7: {
                s = new Pull.PullSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            case 0: {
                s = new Pair.PairSession(io_thread_, connect_, socket_, options_, addr_);
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + options_.type);
            }
        }
        return s;
    }

    public SessionBase(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
        super(io_thread_, options_);
        this.io_object = new IOObject(io_thread_);
        this.connect = connect_;
        this.pipe = null;
        this.incomplete_in = false;
        this.pending = false;
        this.engine = null;
        this.socket = socket_;
        this.io_thread = io_thread_;
        this.has_linger_timer = false;
        this.identity_sent = false;
        this.identity_received = false;
        this.addr = addr_;
        this.terminating_pipes = new HashSet<Pipe>();
    }

    public void destroy() {
        assert (this.pipe == null);
        if (this.has_linger_timer) {
            this.io_object.cancel_timer(linger_timer_id);
            this.has_linger_timer = false;
        }
        if (this.engine != null) {
            this.engine.terminate();
        }
    }

    public void attach_pipe(Pipe pipe_) {
        assert (!this.is_terminating());
        assert (this.pipe == null);
        assert (pipe_ != null);
        this.pipe = pipe_;
        this.pipe.set_event_sink(this);
    }

    public Msg pull_msg() {
        Msg msg_ = null;
        if (!this.identity_sent) {
            msg_ = new Msg(this.options.identity_size);
            msg_.put(this.options.identity, 0, this.options.identity_size);
            this.identity_sent = true;
            this.incomplete_in = false;
            return msg_;
        }
        if (this.pipe == null || (msg_ = this.pipe.read()) == null) {
            return null;
        }
        this.incomplete_in = msg_.has_more();
        return msg_;
    }

    public boolean push_msg(Msg msg_) {
        if (!this.identity_received) {
            msg_.set_flags(64);
            this.identity_received = true;
            if (!this.options.recv_identity) {
                return true;
            }
        }
        if (this.pipe != null && this.pipe.write(msg_)) {
            return true;
        }
        ZError.errno(35);
        return false;
    }

    protected void reset() {
        this.identity_sent = false;
        this.identity_received = false;
    }

    public void flush() {
        if (this.pipe != null) {
            this.pipe.flush();
        }
    }

    private void clean_pipes() {
        if (this.pipe != null) {
            this.pipe.rollback();
            this.pipe.flush();
            while (this.incomplete_in) {
                Msg msg = this.pull_msg();
                if (msg == null) {
                    assert (!this.incomplete_in);
                    break;
                }
                msg.close();
            }
        }
    }

    public void terminated(Pipe pipe_) {
        assert (this.pipe == pipe_ || this.terminating_pipes.contains(pipe_));
        if (this.pipe == pipe_) {
            this.pipe = null;
        } else {
            this.terminating_pipes.remove(pipe_);
        }
        if (this.pending && this.pipe == null && this.terminating_pipes.size() == 0) {
            this.proceed_with_term();
        }
    }

    public void read_activated(Pipe pipe_) {
        if (this.pipe != pipe_) {
            assert (this.terminating_pipes.contains(pipe_));
            return;
        }
        if (this.engine != null) {
            this.engine.activate_out();
        } else {
            this.pipe.check_read();
        }
    }

    public void write_activated(Pipe pipe_) {
        if (this.pipe != pipe_) {
            assert (this.terminating_pipes.contains(pipe_));
            return;
        }
        if (this.engine != null) {
            this.engine.activate_in();
        }
    }

    public void hiccuped(Pipe pipe_) {
        throw new UnsupportedOperationException("Must Override");
    }

    public SocketBase get_soket() {
        return this.socket;
    }

    protected void process_plug() {
        this.io_object.set_handler(this);
        if (this.connect) {
            this.start_connecting(false);
        }
    }

    protected void process_attach(IEngine engine_) {
        assert (engine_ != null);
        if (this.pipe == null && !this.is_terminating()) {
            ZObject[] parents = new ZObject[]{this, this.socket};
            Pipe[] pipes = new Pipe[]{null, null};
            int[] hwms = new int[]{this.options.rcvhwm, this.options.sndhwm};
            boolean[] delays = new boolean[]{this.options.delay_on_close, this.options.delay_on_disconnect};
            Pipe.pipepair(parents, pipes, hwms, delays);
            pipes[0].set_event_sink(this);
            assert (this.pipe == null);
            this.pipe = pipes[0];
            this.send_bind(this.socket, pipes[1]);
        }
        assert (this.engine == null);
        this.engine = engine_;
        this.engine.plug(this.io_thread, this);
    }

    public void detach() {
        this.engine = null;
        this.clean_pipes();
        this.detached();
        if (this.pipe != null) {
            this.pipe.check_read();
        }
    }

    protected void process_term(int linger_) {
        assert (!this.pending);
        if (this.pipe == null) {
            this.proceed_with_term();
            return;
        }
        this.pending = true;
        if (linger_ > 0) {
            assert (!this.has_linger_timer);
            this.io_object.add_timer(linger_, linger_timer_id);
            this.has_linger_timer = true;
        }
        this.pipe.terminate(linger_ != 0);
        this.pipe.check_read();
    }

    private void proceed_with_term() {
        this.pending = false;
        super.process_term(0);
    }

    public void timer_event(int id_) {
        assert (id_ == linger_timer_id);
        this.has_linger_timer = false;
        assert (this.pipe != null);
        this.pipe.terminate(false);
    }

    private void detached() {
        if (!this.connect) {
            this.terminate();
            return;
        }
        if (this.pipe != null && this.options.delay_attach_on_connect == 1 && this.addr.protocol() != "pgm" && this.addr.protocol() != "epgm") {
            this.pipe.hiccup();
            this.pipe.terminate(false);
            this.terminating_pipes.add(this.pipe);
            this.pipe = null;
        }
        this.reset();
        if (this.options.reconnect_ivl != -1) {
            this.start_connecting(true);
        }
        if (this.pipe != null && (this.options.type == 2 || this.options.type == 10)) {
            this.pipe.hiccup();
        }
    }

    private void start_connecting(boolean wait_) {
        assert (this.connect);
        IOThread io_thread = this.choose_io_thread(this.options.affinity);
        assert (io_thread != null);
        if (this.addr.protocol().equals("tcp")) {
            TcpConnecter connecter = new TcpConnecter(io_thread, this, this.options, this.addr, wait_);
            this.launch_child(connecter);
            return;
        }
        if (this.addr.protocol().equals("ipc")) {
            IpcConnecter connecter = new IpcConnecter(io_thread, this, this.options, this.addr, wait_);
            this.launch_child(connecter);
            return;
        }
        assert (false);
    }

    public String toString() {
        return super.toString() + "[" + this.options.socket_id + "]";
    }

    public void in_event() {
        throw new UnsupportedOperationException();
    }

    public void out_event() {
        throw new UnsupportedOperationException();
    }

    public void connect_event() {
        throw new UnsupportedOperationException();
    }

    public void accept_event() {
        throw new UnsupportedOperationException();
    }
}

