/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.Clock;
import zmq.IPollEvents;
import zmq.MultiMap;

public abstract class PollerBase {
    private final AtomicInteger load = new AtomicInteger(0);
    private final Map<Long, TimerInfo> timers = new MultiMap<Long, TimerInfo>();

    protected PollerBase() {
    }

    public final int get_load() {
        return this.load.get();
    }

    protected void adjust_load(int amount_) {
        this.load.addAndGet(amount_);
    }

    public void add_timer(long timeout_, IPollEvents sink_, int id_) {
        long expiration = Clock.now_ms() + timeout_;
        TimerInfo info = new TimerInfo(sink_, id_);
        this.timers.put(expiration, info);
    }

    public void cancel_timer(IPollEvents sink_, int id_) {
        Iterator<Map.Entry<Long, TimerInfo>> it = this.timers.entrySet().iterator();
        while (it.hasNext()) {
            TimerInfo v = it.next().getValue();
            if (v.sink != sink_ || v.id != id_) continue;
            it.remove();
            return;
        }
        assert (false);
    }

    protected long execute_timers() {
        if (this.timers.isEmpty()) {
            return 0L;
        }
        long current = Clock.now_ms();
        Iterator<Map.Entry<Long, TimerInfo>> it = this.timers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, TimerInfo> o = it.next();
            if (o.getKey() > current) {
                return o.getKey() - current;
            }
            o.getValue().sink.timer_event(o.getValue().id);
            it.remove();
        }
        return 0L;
    }

    private final class TimerInfo {
        IPollEvents sink;
        int id;

        public TimerInfo(IPollEvents sink_, int id_) {
            this.sink = sink_;
            this.id = id_;
        }
    }
}

