/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.SelectableChannel;
import zmq.IOThread;
import zmq.IPollEvents;
import zmq.Poller;

public class IOObject
implements IPollEvents {
    private Poller poller;
    private IPollEvents handler;

    public IOObject(IOThread io_thread_) {
        if (io_thread_ != null) {
            this.plug(io_thread_);
        }
    }

    public void plug(IOThread io_thread_) {
        assert (io_thread_ != null);
        assert (this.poller == null);
        this.poller = io_thread_.get_poller();
    }

    public void unplug() {
        assert (this.poller != null);
        this.poller = null;
        this.handler = null;
    }

    public final void add_fd(SelectableChannel fd_) {
        this.poller.add_fd(fd_, this);
    }

    public final void rm_fd(SelectableChannel handle) {
        this.poller.rm_fd(handle);
    }

    public final void set_pollin(SelectableChannel handle_) {
        this.poller.set_pollin(handle_);
    }

    public final void set_pollout(SelectableChannel handle_) {
        this.poller.set_pollout(handle_);
    }

    public final void set_pollconnect(SelectableChannel handle) {
        this.poller.set_pollconnect(handle);
    }

    public final void set_pollaccept(SelectableChannel handle) {
        this.poller.set_pollaccept(handle);
    }

    public final void reset_pollin(SelectableChannel handle) {
        this.poller.reset_pollin(handle);
    }

    public final void reset_pollout(SelectableChannel handle) {
        this.poller.reset_pollout(handle);
    }

    public final void in_event() {
        this.handler.in_event();
    }

    public final void out_event() {
        this.handler.out_event();
    }

    public final void connect_event() {
        this.handler.connect_event();
    }

    public final void accept_event() {
        this.handler.accept_event();
    }

    public final void timer_event(int id_) {
        this.handler.timer_event(id_);
    }

    public final void add_timer(long timeout_, int id_) {
        this.poller.add_timer(timeout_, this, id_);
    }

    public final void set_handler(IPollEvents handler) {
        this.handler = handler;
    }

    public void cancel_timer(int id_) {
        this.poller.cancel_timer(this, id_);
    }
}

