/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.IEncoder;
import zmq.Msg;
import zmq.Transfer;

public abstract class EncoderBase
implements IEncoder {
    private ByteBuffer write_buf;
    private byte[] write_array;
    private int write_pos;
    private int next;
    private boolean beginning;
    private int to_write;
    private ByteBuffer buf;
    private int buffersize;
    private boolean error;

    protected EncoderBase(int bufsize_) {
        this.buffersize = bufsize_;
        this.buf = ByteBuffer.allocateDirect(bufsize_);
        this.error = false;
    }

    public Transfer get_data(ByteBuffer buffer) {
        if (buffer == null) {
            buffer = this.buf;
        }
        buffer.clear();
        while (buffer.hasRemaining() && (this.to_write != 0 || this.next())) {
            if (this.buf.position() == 0 && this.to_write >= this.buffersize) {
                Transfer.ByteBufferTransfer t;
                if (this.write_array != null) {
                    ByteBuffer b = ByteBuffer.wrap(this.write_array);
                    b.position(this.write_pos);
                    t = new Transfer.ByteBufferTransfer(b);
                } else {
                    t = new Transfer.ByteBufferTransfer(this.write_buf);
                }
                this.write_pos = 0;
                this.to_write = 0;
                return t;
            }
            int to_copy = Math.min(this.to_write, buffer.remaining());
            if (to_copy <= 0) continue;
            if (this.write_array != null) {
                buffer.put(this.write_array, this.write_pos, to_copy);
            } else {
                buffer.put(this.write_buf.array(), this.write_buf.arrayOffset() + this.write_pos, to_copy);
                this.write_buf.position(this.write_pos + to_copy);
            }
            this.write_pos += to_copy;
            this.to_write -= to_copy;
        }
        buffer.flip();
        return new Transfer.ByteBufferTransfer(buffer);
    }

    protected int state() {
        return this.next;
    }

    protected void state(int state_) {
        this.next = state_;
    }

    protected void encoding_error() {
        this.error = true;
    }

    public final boolean is_error() {
        return this.error;
    }

    protected abstract boolean next();

    protected void next_step(Msg msg_, int state_, boolean beginning_) {
        if (msg_ == null) {
            this.next_step((ByteBuffer)null, 0, state_, beginning_);
        } else {
            this.next_step(msg_.data(), msg_.size(), state_, beginning_);
        }
    }

    protected void next_step(ByteBuffer buf_, int to_write_, int next_, boolean beginning_) {
        this.write_buf = buf_;
        this.write_array = null;
        this.write_pos = 0;
        this.to_write = to_write_;
        this.next = next_;
        this.beginning = beginning_;
    }

    protected void next_step(byte[] buf_, int to_write_, int next_, boolean beginning_) {
        this.write_buf = null;
        this.write_array = buf_;
        this.write_pos = 0;
        this.to_write = to_write_;
        this.next = next_;
        this.beginning = beginning_;
    }
}

