/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Command;
import zmq.IOThread;
import zmq.Mailbox;
import zmq.Options;
import zmq.Reaper;
import zmq.SocketBase;
import zmq.ZError;
import zmq.ZObject;

public class Ctx {
    private int tag = -1414673666;
    private final List<SocketBase> sockets;
    private final Deque<Integer> empty_slots;
    private volatile boolean starting = true;
    private boolean terminating = false;
    private final Lock slot_sync = new ReentrantLock();
    private Reaper reaper = null;
    private final List<IOThread> io_threads;
    private int slot_count = 0;
    private Mailbox[] slots = null;
    private final Mailbox term_mailbox;
    private final Map<String, Endpoint> endpoints;
    private final Lock endpoints_sync = new ReentrantLock();
    private static AtomicInteger max_socket_id = new AtomicInteger(0);
    private int max_sockets = 1024;
    private int io_thread_count = 1;
    private final Lock opt_sync = new ReentrantLock();
    public static final int term_tid = 0;
    public static final int reaper_tid = 1;

    public Ctx() {
        this.term_mailbox = new Mailbox("terminater");
        this.empty_slots = new ArrayDeque<Integer>();
        this.io_threads = new ArrayList<IOThread>();
        this.sockets = new ArrayList<SocketBase>();
        this.endpoints = new HashMap<String, Endpoint>();
    }

    protected void destroy() {
        for (IOThread it : this.io_threads) {
            it.stop();
        }
        for (IOThread it : this.io_threads) {
            it.destroy();
        }
        if (this.reaper != null) {
            this.reaper.destroy();
        }
        this.term_mailbox.close();
        this.tag = -559038737;
    }

    public boolean check_tag() {
        return this.tag == -1414673666;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.tag = -559038737;
        this.slot_sync.lock();
        if (!this.starting) {
            Command cmd;
            boolean restarted = this.terminating;
            this.terminating = true;
            this.slot_sync.unlock();
            if (!restarted) {
                this.slot_sync.lock();
                try {
                    for (int i = 0; i != this.sockets.size(); ++i) {
                        this.sockets.get(i).stop();
                    }
                    if (this.sockets.isEmpty()) {
                        this.reaper.stop();
                    }
                }
                finally {
                    this.slot_sync.unlock();
                }
            }
            if ((cmd = this.term_mailbox.recv(-1L)) == null) {
                throw new IllegalStateException();
            }
            assert (cmd.type() == Command.Type.done);
            this.slot_sync.lock();
            assert (this.sockets.isEmpty());
        }
        this.slot_sync.unlock();
        this.destroy();
    }

    public void set(int option_, int optval_) {
        if (option_ == 2 && optval_ >= 1) {
            this.opt_sync.lock();
            this.max_sockets = optval_;
            this.opt_sync.unlock();
        } else if (option_ == 1 && optval_ >= 0) {
            this.opt_sync.lock();
            this.io_thread_count = optval_;
            this.opt_sync.unlock();
        } else {
            throw new IllegalArgumentException("option = " + option_);
        }
    }

    public int get(int option_) {
        int rc = 0;
        if (option_ == 2) {
            rc = this.max_sockets;
        } else if (option_ == 1) {
            rc = this.io_thread_count;
        } else {
            throw new IllegalArgumentException("option = " + option_);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketBase create_socket(int type_) {
        SocketBase s = null;
        this.slot_sync.lock();
        try {
            int sid;
            if (this.starting) {
                int i;
                this.starting = false;
                this.opt_sync.lock();
                int mazmq = this.max_sockets;
                int ios = this.io_thread_count;
                this.opt_sync.unlock();
                this.slot_count = mazmq + ios + 2;
                this.slots = new Mailbox[this.slot_count];
                this.slots[0] = this.term_mailbox;
                this.reaper = new Reaper(this, 1);
                this.slots[1] = this.reaper.get_mailbox();
                this.reaper.start();
                for (i = 2; i != ios + 2; ++i) {
                    IOThread io_thread = new IOThread(this, i);
                    this.io_threads.add(io_thread);
                    this.slots[i] = io_thread.get_mailbox();
                    io_thread.start();
                }
                for (i = this.slot_count - 1; i >= ios + 2; --i) {
                    this.empty_slots.add(i);
                    this.slots[i] = null;
                }
            }
            if (this.terminating) {
                ZError.errno(156384765);
                SocketBase mazmq = null;
                return mazmq;
            }
            if (this.empty_slots.isEmpty()) {
                ZError.errno(156384819);
                SocketBase mazmq = null;
                return mazmq;
            }
            int slot = this.empty_slots.pollLast();
            s = SocketBase.create(type_, this, slot, sid = max_socket_id.incrementAndGet());
            if (s == null) {
                this.empty_slots.addLast(slot);
                SocketBase socketBase = null;
                return socketBase;
            }
            this.sockets.add(s);
            this.slots[slot] = s.get_mailbox();
        }
        finally {
            this.slot_sync.unlock();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy_socket(SocketBase socket_) {
        this.slot_sync.lock();
        try {
            int tid = socket_.get_tid();
            this.empty_slots.add(tid);
            this.slots[tid].close();
            this.slots[tid] = null;
            this.sockets.remove(socket_);
            if (this.terminating && this.sockets.isEmpty()) {
                this.reaper.stop();
            }
        }
        finally {
            this.slot_sync.unlock();
        }
    }

    public ZObject get_reaper() {
        return this.reaper;
    }

    public void send_command(int tid_, Command command_) {
        this.slots[tid_].send(command_);
    }

    public IOThread choose_io_thread(long affinity_) {
        if (this.io_threads.isEmpty()) {
            return null;
        }
        int min_load = -1;
        IOThread selected_io_thread = null;
        for (int i = 0; i != this.io_threads.size(); ++i) {
            if (affinity_ != 0L && (affinity_ & 1L << i) <= 0L) continue;
            int load = this.io_threads.get(i).get_load();
            if (selected_io_thread != null && load >= min_load) continue;
            min_load = load;
            selected_io_thread = this.io_threads.get(i);
        }
        return selected_io_thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register_endpoint(String addr_, Endpoint endpoint_) {
        this.endpoints_sync.lock();
        Endpoint inserted = null;
        try {
            inserted = this.endpoints.put(addr_, endpoint_);
        }
        finally {
            this.endpoints_sync.unlock();
        }
        if (inserted != null) {
            ZError.errno(48);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister_endpoints(SocketBase socket_) {
        this.endpoints_sync.lock();
        try {
            Iterator<Map.Entry<String, Endpoint>> it = this.endpoints.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Endpoint> e = it.next();
                if (e.getValue().socket != socket_) continue;
                it.remove();
            }
        }
        finally {
            this.endpoints_sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint find_endpoint(String addr_) {
        Endpoint endpoint = null;
        this.endpoints_sync.lock();
        try {
            endpoint = this.endpoints.get(addr_);
            if (endpoint == null) {
                ZError.errno(61);
                Endpoint endpoint2 = new Endpoint(null, new Options());
                return endpoint2;
            }
            endpoint.socket.inc_seqnum();
        }
        finally {
            this.endpoints_sync.unlock();
        }
        return endpoint;
    }

    public static class Endpoint {
        SocketBase socket;
        Options options;

        public Endpoint(SocketBase socket_, Options options_) {
            this.socket = socket_;
            this.options = options_;
        }
    }
}

